/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.minimizer;

import java.util.ArrayList;
import java.util.List;
import net.automatalib.commons.smartcollections.BasicLinkedListEntry;
import net.automatalib.commons.smartcollections.ElementReference;
import net.automatalib.commons.smartcollections.IntrusiveLinkedList;
import net.automatalib.commons.smartcollections.UnorderedCollection;
import net.automatalib.util.minimizer.State;

public final class Block<S, L>
extends BasicLinkedListEntry<Block<S, L>, Block<S, L>> {
    private final UnorderedCollection<State<S, L>> states;
    private ElementReference partitionReference;
    private ElementReference splitterQueueReference;
    private IntrusiveLinkedList<State<S, L>> bucket = new IntrusiveLinkedList();
    private List<UnorderedCollection<State<S, L>>> subBlocks = new ArrayList<UnorderedCollection<State<S, L>>>();
    private int elementsInSubBlocks;
    private UnorderedCollection<State<S, L>> currSubBlock;
    private final int id;

    Block(int id) {
        this.id = id;
        this.states = new UnorderedCollection();
    }

    Block(int id, UnorderedCollection<State<S, L>> states) {
        this.id = id;
        this.states = states;
        for (State state : states) {
            state.setBlock(this);
        }
    }

    void addState(State<S, L> state) {
        ElementReference ref = this.states.referencedAdd(state);
        state.setBlockReference(ref);
        state.setBlock(this);
    }

    UnorderedCollection<State<S, L>> getStates() {
        return this.states;
    }

    IntrusiveLinkedList<State<S, L>> getBucket() {
        return this.bucket;
    }

    boolean addToBucket(State<S, L> state) {
        boolean first = this.bucket.isEmpty();
        this.bucket.pushBack(state);
        return first;
    }

    void createSubBlock() {
        this.currSubBlock = new UnorderedCollection();
        this.subBlocks.add(this.currSubBlock);
    }

    void addToSubBlock(State<S, L> state) {
        this.currSubBlock.referencedAdd(state);
        ++this.elementsInSubBlocks;
    }

    public int size() {
        return this.states.size();
    }

    int getElementsInSubBlocks() {
        return this.elementsInSubBlocks;
    }

    ElementReference getPartitionReference() {
        return this.partitionReference;
    }

    void setPartitionReference(ElementReference partitionReference) {
        this.partitionReference = partitionReference;
    }

    ElementReference getSplitterQueueReference() {
        return this.splitterQueueReference;
    }

    void setSplitterQueueReference(ElementReference splitterQueueReference) {
        this.splitterQueueReference = splitterQueueReference;
    }

    void removeState(ElementReference ref) {
        this.states.remove(ref);
    }

    List<UnorderedCollection<State<S, L>>> getSubBlocks() {
        return this.subBlocks;
    }

    void clearSubBlocks() {
        this.subBlocks.clear();
        this.elementsInSubBlocks = 0;
    }

    public boolean isEmpty() {
        return this.states.isEmpty();
    }

    public boolean isSingleton() {
        return this.states.size() == 1;
    }

    public int getId() {
        return this.id;
    }

    public Block<S, L> getElement() {
        return this;
    }
}

