/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.minimizer;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.automatalib.commons.smartcollections.DefaultLinkedList;
import net.automatalib.commons.smartcollections.ElementReference;
import net.automatalib.commons.smartcollections.IntrusiveLinkedList;
import net.automatalib.commons.smartcollections.UnorderedCollection;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.graphs.UniversalGraph;
import net.automatalib.util.graphs.traversal.GraphTraversal;
import net.automatalib.util.minimizer.Block;
import net.automatalib.util.minimizer.Edge;
import net.automatalib.util.minimizer.HashMapInitialPartitioning;
import net.automatalib.util.minimizer.MinimizationResult;
import net.automatalib.util.minimizer.State;
import net.automatalib.util.minimizer.TransitionLabel;

public class Minimizer<S, L> {
    private static final ThreadLocal<Minimizer<Object, Object>> LOCAL_INSTANCE = new ThreadLocal<Minimizer<Object, Object>>(){

        @Override
        protected Minimizer<Object, Object> initialValue() {
            return new Minimizer<Object, Object>();
        }
    };
    private MutableMapping<S, State<S, L>> stateStorage;
    private UnorderedCollection<Block<S, L>> partition;
    private int numBlocks;
    private final DefaultLinkedList<Block<S, L>> splitters = new DefaultLinkedList();
    private final IntrusiveLinkedList<TransitionLabel<S, L>> letterList = new IntrusiveLinkedList();
    private final IntrusiveLinkedList<State<S, L>> stateList = new IntrusiveLinkedList();
    private final IntrusiveLinkedList<Block<S, L>> splitBlocks = new IntrusiveLinkedList();
    private final IntrusiveLinkedList<Block<S, L>> newBlocks = new IntrusiveLinkedList();
    private final IntrusiveLinkedList<State<S, L>> finalList = new IntrusiveLinkedList();

    public static <S, L> Minimizer<S, L> getLocalInstance() {
        return LOCAL_INSTANCE.get();
    }

    public static <S, L> MinimizationResult<S, L> minimize(UniversalGraph<S, ?, ?, L> graph) {
        return Minimizer.minimize(graph, null);
    }

    public static <S, L> MinimizationResult<S, L> minimize(UniversalGraph<S, ?, ?, L> graph, Collection<? extends S> start) {
        Minimizer<? extends S, L> minimizer = Minimizer.getLocalInstance();
        return minimizer.performMinimization(graph, start);
    }

    @Deprecated
    public Minimizer() {
    }

    public final <E> MinimizationResult<S, L> performMinimization(UniversalGraph<S, E, ?, L> graph) {
        return this.performMinimization(graph, null);
    }

    public final <E> MinimizationResult<S, L> performMinimization(UniversalGraph<S, E, ?, L> graph, Collection<? extends S> initialNodes) {
        Collection<Block<S, L>> initialBlocks = this.initialize(graph, initialNodes);
        this.partition = new UnorderedCollection(initialBlocks.size());
        for (Block<S, L> block : initialBlocks) {
            if (block == null || block.isEmpty()) continue;
            this.addToPartition(block);
            this.addToSplitterQueue(block);
            ++this.numBlocks;
        }
        while (!this.splitters.isEmpty()) {
            Block block = (Block)((Object)this.splitters.choose());
            this.removeFromSplitterQueue(block);
            this.split(block);
            this.updateBlocks();
        }
        MinimizationResult<S, L> result = new MinimizationResult<S, L>(this.stateStorage, this.partition);
        this.stateStorage = null;
        this.partition = null;
        this.numBlocks = 0;
        return result;
    }

    private static <S, L> void updateBlockReferences(Block<S, L> block) {
        UnorderedCollection<State<S, L>> states = block.getStates();
        for (ElementReference ref : states.references()) {
            State state = (State)((Object)states.get(ref));
            state.setBlockReference(ref);
            state.setBlock(block);
        }
    }

    private <E> Collection<Block<S, L>> initialize(UniversalGraph<S, E, ?, L> graph, Collection<? extends S> initialNodes) {
        Iterable<Object> origStates = initialNodes == null || initialNodes.isEmpty() ? graph.getNodes() : GraphTraversal.depthFirstOrder(graph, initialNodes);
        HashMap transitionMap = new HashMap();
        this.stateStorage = graph.createStaticNodeMapping();
        int numStates = 0;
        for (Object origState : origStates) {
            State state = new State(numStates++, origState);
            this.stateStorage.put(origState, state);
            this.stateList.add((Object)state);
        }
        HashMapInitialPartitioning initPartitioning = new HashMapInitialPartitioning(graph);
        for (State state : this.stateList) {
            Object origState = state.getOriginalState();
            Block block = initPartitioning.getBlock(origState);
            block.addState(state);
            for (Object edge : graph.getOutgoingEdges(origState)) {
                Object origTarget = graph.getTarget(edge);
                State target = (State)((Object)this.stateStorage.get(origTarget));
                Object label = graph.getEdgeProperty(edge);
                TransitionLabel transition = (TransitionLabel)((Object)transitionMap.get(label));
                if (transition == null) {
                    transition = new TransitionLabel(label);
                    transitionMap.put(label, transition);
                }
                Edge edgeObj = new Edge(state, target, transition);
                state.addOutgoingEdge(edgeObj);
                target.addIncomingEdge(edgeObj);
            }
        }
        this.stateList.quickClear();
        return initPartitioning.getInitialBlocks();
    }

    private void addToPartition(Block<S, L> block) {
        ElementReference ref = this.partition.referencedAdd(block);
        block.setPartitionReference(ref);
    }

    private void addToSplitterQueue(Block<S, L> block) {
        ElementReference ref = this.splitters.referencedAdd(block);
        block.setSplitterQueueReference(ref);
    }

    private boolean removeFromSplitterQueue(Block<S, L> block) {
        ElementReference ref = block.getSplitterQueueReference();
        if (ref == null) {
            return false;
        }
        this.splitters.remove(ref);
        block.setSplitterQueueReference(null);
        return true;
    }

    private void addAllToSplitterQueue(Collection<Block<S, L>> blocks) {
        for (Block<S, L> block : blocks) {
            this.addToSplitterQueue(block);
        }
    }

    private void addAllButLargest(Collection<Block<S, L>> blocks) {
        Block<S, L> largest = null;
        for (Block<S, L> block : blocks) {
            if (largest == null) {
                largest = block;
                continue;
            }
            if (block.size() > largest.size()) {
                this.addToSplitterQueue(largest);
                largest = block;
                continue;
            }
            this.addToSplitterQueue(block);
        }
    }

    private void updateBlocks() {
        for (Block block : this.splitBlocks) {
            int inSubBlocks = block.getElementsInSubBlocks();
            if (inSubBlocks == 0) continue;
            boolean blockRemains = inSubBlocks < block.size();
            boolean reuseBlock = !blockRemains;
            List subBlocks = block.getSubBlocks();
            if (!blockRemains && subBlocks.size() == 1) {
                block.clearSubBlocks();
                continue;
            }
            Iterator subBlockIt = subBlocks.iterator();
            if (reuseBlock) {
                UnorderedCollection first = subBlockIt.next();
                block.getStates().swap(first);
                Minimizer.updateBlockReferences(block);
            }
            while (subBlockIt.hasNext()) {
                UnorderedCollection subBlockStates = subBlockIt.next();
                if (blockRemains) {
                    for (State state : subBlockStates) {
                        block.removeState(state.getBlockReference());
                    }
                }
                Block subBlock = new Block(this.numBlocks++, subBlockStates);
                Minimizer.updateBlockReferences(subBlock);
                this.newBlocks.add(subBlock);
                this.addToPartition(subBlock);
            }
            this.newBlocks.add((Object)block);
            block.clearSubBlocks();
            if (this.removeFromSplitterQueue(block)) {
                this.addAllToSplitterQueue((Collection<Block<S, L>>)this.newBlocks);
            } else {
                this.addAllButLargest((Collection<Block<S, L>>)this.newBlocks);
            }
            this.newBlocks.clear();
        }
        this.splitBlocks.clear();
    }

    private void split(Block<S, L> splitter) {
        for (State state : splitter.getStates()) {
            for (Edge edge : state.getIncoming()) {
                TransitionLabel transition = edge.getTransitionLabel();
                State newState = edge.getSource();
                if (newState.isSingletonBlock() || !transition.addToSet(newState)) continue;
                this.letterList.add(transition);
            }
        }
        for (TransitionLabel letter : this.letterList) {
            for (State state : letter.getSet()) {
                if (!state.addToSignature(letter)) continue;
                this.stateList.add((Object)state);
                state.setSplitPoint(false);
            }
            letter.clearSet();
        }
        this.letterList.clear();
        for (State state : this.stateList) {
            Block block = state.getBlock();
            if (!block.addToBucket(state)) continue;
            this.splitBlocks.add(block);
        }
        this.stateList.clear();
        for (Block block : this.splitBlocks) {
            this.stateList.concat(block.getBucket());
        }
        int i = 0;
        while (!this.stateList.isEmpty()) {
            for (State state : this.stateList) {
                TransitionLabel letter = state.getSignatureLetter(i);
                if (letter == null) {
                    this.finalList.pushBack((Object)state);
                } else if (letter.addToBucket(state)) {
                    this.letterList.add(letter);
                }
                if (state.getPrev() == null) {
                    state.setSplitPoint(true);
                    continue;
                }
                if (i <= 0 || ((State)state.getPrev()).getSignatureLetter(i - 1) == state.getSignatureLetter(i - 1)) continue;
                state.setSplitPoint(true);
            }
            this.stateList.clear();
            for (TransitionLabel letter : this.letterList) {
                this.stateList.concat(letter.getBucket());
            }
            this.letterList.clear();
            ++i;
        }
        Block prevBlock = null;
        State prev = null;
        for (State state : this.finalList) {
            Block currBlock = state.getBlock();
            if (currBlock != prevBlock) {
                currBlock.createSubBlock();
                prevBlock = currBlock;
            } else if (state.isSplitPoint()) {
                currBlock.createSubBlock();
            }
            currBlock.addToSubBlock(state);
            if (prev != null) {
                prev.reset();
            }
            prev = state;
        }
        if (prev != null) {
            prev.reset();
        }
        this.finalList.clear();
    }
}

