/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.tries;

import net.automatalib.util.tries.SharedSuffixTrieNode;
import net.automatalib.util.tries.SuffixTrie;
import net.automatalib.util.tries.SuffixTrieNode;
import net.automatalib.words.Alphabet;

public class SharedSuffixTrie<I>
extends SuffixTrie<I> {
    private final Alphabet<I> alphabet;

    public SharedSuffixTrie(Alphabet<I> alphabet) {
        super(new SharedSuffixTrieNode());
        this.alphabet = alphabet;
    }

    public SharedSuffixTrie(Alphabet<I> alphabet, boolean graphRepresentable) {
        super(graphRepresentable, new SharedSuffixTrieNode());
        this.alphabet = alphabet;
    }

    @Override
    public SuffixTrieNode<I> add(I symbol, SuffixTrieNode<I> parent) {
        SharedSuffixTrieNode child;
        if (((Object)parent).getClass() != SharedSuffixTrieNode.class) {
            throw new IllegalArgumentException("Invalid suffix trie node");
        }
        int symbolIdx = this.alphabet.getSymbolIndex(symbol);
        SharedSuffixTrieNode sparent = (SharedSuffixTrieNode)parent;
        SharedSuffixTrieNode<I>[] children = sparent.children;
        if (children == null) {
            children = sparent.children = new SharedSuffixTrieNode[this.alphabet.size()];
        } else {
            child = children[symbolIdx];
            if (child != null) {
                return child;
            }
        }
        children[symbolIdx] = child = new SharedSuffixTrieNode<I>(symbol, sparent);
        return child;
    }
}

