/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.tries;

import java.util.List;
import net.automatalib.words.Word;
import net.automatalib.words.WordBuilder;

public class SuffixTrieNode<I>
extends Word<I> {
    private final I symbol;
    private final SuffixTrieNode<I> parent;

    public static <I> void appendSuffix(SuffixTrieNode<I> node, List<? super I> symList) {
        while (node.parent != null) {
            symList.add(node.symbol);
            node = node.parent;
        }
    }

    public static <I> Word<I> toExplicitWord(SuffixTrieNode<I> node) {
        WordBuilder wb = new WordBuilder(node.depth());
        SuffixTrieNode.appendSuffix(node, wb);
        return wb.toWord();
    }

    public static <I> int depth(SuffixTrieNode<I> node) {
        int d = 0;
        while (node.parent != null) {
            ++d;
            node = node.parent;
        }
        return d;
    }

    public static <I> I getSymbol(SuffixTrieNode<I> node, int index) {
        while (index-- > 0) {
            node = node.parent;
        }
        return node.symbol;
    }

    public SuffixTrieNode() {
        this.symbol = null;
        this.parent = null;
    }

    public SuffixTrieNode(I symbol, SuffixTrieNode<I> parent) {
        this.symbol = symbol;
        this.parent = parent;
    }

    public int depth() {
        return SuffixTrieNode.depth(this);
    }

    public I getSymbol() {
        return this.symbol;
    }

    public SuffixTrieNode<I> getParent() {
        return this.parent;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public void appendSuffix(List<? super I> symList) {
        SuffixTrieNode.appendSuffix(this, symList);
    }

    public Word<I> getSuffix() {
        if (this.parent == null) {
            return Word.epsilon();
        }
        WordBuilder wb = new WordBuilder(this.depth());
        this.appendSuffix((List<? super I>)wb);
        return wb.toWord();
    }

    public I getSymbol(int index) {
        return SuffixTrieNode.getSymbol(this, index);
    }

    public int length() {
        return this.depth();
    }

    public Iterator<I> iterator() {
        return new Iterator(this);
    }

    private static final class Iterator<I>
    implements java.util.Iterator<I> {
        private SuffixTrieNode<I> current;

        public Iterator(SuffixTrieNode<I> node) {
            this.current = node;
        }

        @Override
        public boolean hasNext() {
            return !this.current.isRoot();
        }

        @Override
        public I next() {
            Object sym = ((SuffixTrieNode)this.current).symbol;
            this.current = ((SuffixTrieNode)this.current).parent;
            return (I)sym;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

