package net.avalara.avatax.rest.client.enums;

/*
 * AvaTax Software Development Kit for Java JRE based environments
 *
 * (c) 2004-2017 Avalara, Inc.
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * @author     Dustin Welden <dustin.welden@avalara.com>
 * @copyright  2004-2017 Avalara, Inc.
 * @license    https://www.apache.org/licenses/LICENSE-2.0
 * @link       https://github.com/avadev/AvaTax-REST-V2-JRE-SDK
 */

/**
 * Represents the type of service or subscription given to a user
 */
public enum ServiceTypeId {
    /** 
     * None
     */
    None,

    /** 
     * AvaTaxST
     */
    AvaTaxST,

    /** 
     * AvaTaxPro
     */
    AvaTaxPro,

    /** 
     * AvaTaxGlobal
     */
    AvaTaxGlobal,

    /** 
     * AutoAddress
     */
    AutoAddress,

    /** 
     * AutoReturns
     */
    AutoReturns,

    /** 
     * TaxSolver
     */
    TaxSolver,

    /** 
     * AvaTaxCsp
     */
    AvaTaxCsp,

    /** 
     * Twe
     */
    Twe,

    /** 
     * Mrs
     */
    Mrs,

    /** 
     * AvaCert
     */
    AvaCert,

    /** 
     * AuthorizationPartner
     */
    AuthorizationPartner,

    /** 
     * CertCapture
     */
    CertCapture,

    /** 
     * AvaUpc
     */
    AvaUpc,

    /** 
     * AvaCUT
     */
    AvaCUT,

    /** 
     * AvaLandedCost
     */
    AvaLandedCost,

    /** 
     * AvaLodging
     */
    AvaLodging,

    /** 
     * AvaBottle
     */
    AvaBottle,

    /** 
     * MRSComplianceManager
     */
    MRSComplianceManager,

}
    