/*
 * Decompiled with CFR 0.152.
 */
package net.avalara.avatax.rest.client;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;

public class AvaTaxPath {
    private String path;
    private HashMap<String, String> queryParams = new HashMap();

    public AvaTaxPath(String path) {
        this.path = path;
    }

    public void applyField(String fieldName, Object value) {
        if (fieldName.startsWith("$")) {
            this.addQuery(fieldName, value);
        } else {
            this.path = this.path.replace("{" + fieldName + "}", value.toString());
        }
    }

    public void addQuery(String fieldName, Object value) {
        if (value != null) {
            this.queryParams.put(fieldName, value.toString());
        }
    }

    public String toString() {
        if (this.queryParams.size() > 0) {
            this.path = this.path + "?";
            for (String key : this.queryParams.keySet()) {
                try {
                    this.path = String.format("%s%s=%s&", this.path, URLEncoder.encode(key, "UTF-8"), URLEncoder.encode(this.queryParams.get(key), "UTF-8"));
                }
                catch (UnsupportedEncodingException ex) {
                    System.out.println("Could not find encoding UTF-8: ");
                    ex.printStackTrace();
                }
            }
            this.path = this.path.substring(0, this.path.length() - 1);
        }
        return this.path;
    }
}

