/*
 * Decompiled with CFR 0.152.
 */
package net.avalara.avatax.rest.client;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.Future;
import net.avalara.avatax.rest.client.AvaTaxClient;
import net.avalara.avatax.rest.client.AvaTaxClientException;
import net.avalara.avatax.rest.client.enums.AdjustmentReason;
import net.avalara.avatax.rest.client.enums.DocumentType;
import net.avalara.avatax.rest.client.enums.TaxDebugLevel;
import net.avalara.avatax.rest.client.enums.TaxOverrideType;
import net.avalara.avatax.rest.client.enums.TransactionAddressType;
import net.avalara.avatax.rest.client.models.AddressLocationInfo;
import net.avalara.avatax.rest.client.models.AddressesModel;
import net.avalara.avatax.rest.client.models.AdjustTransactionModel;
import net.avalara.avatax.rest.client.models.CreateTransactionModel;
import net.avalara.avatax.rest.client.models.LineItemModel;
import net.avalara.avatax.rest.client.models.TaxOverrideModel;
import net.avalara.avatax.rest.client.models.TransactionModel;

public class TransactionBuilder {
    private CreateTransactionModel model = new CreateTransactionModel();
    private int lineNumber;
    private AvaTaxClient client;

    public TransactionBuilder(AvaTaxClient avaTaxClient, String string, DocumentType documentType, String string2) {
        this.model.setCompanyCode(string);
        this.model.setCustomerCode(string2);
        this.model.setDate(new Date());
        this.model.setType(documentType);
        this.model.setLines(new ArrayList<LineItemModel>());
        this.lineNumber = 1;
        this.client = avaTaxClient;
    }

    public TransactionBuilder withCommit() {
        this.model.setCommit(true);
        return this;
    }

    public TransactionBuilder withDiagnostics() {
        this.model.setDebugLevel(TaxDebugLevel.Diagnostic);
        return this;
    }

    public TransactionBuilder withDiscountAmount(BigDecimal bigDecimal) {
        this.model.setDiscount(bigDecimal);
        return this;
    }

    public TransactionBuilder withItemDiscount(Boolean bl) {
        this.getMostRecentLine("WithItemDiscount").setDiscounted(bl);
        return this;
    }

    public TransactionBuilder withTransactionCode(String string) {
        this.model.setCode(string);
        return this;
    }

    public TransactionBuilder withType(DocumentType documentType) {
        this.model.setType(documentType);
        return this;
    }

    public TransactionBuilder withParameter(String string, String string2) {
        HashMap<String, String> hashMap = this.model.getParameters();
        if (hashMap == null) {
            hashMap = new HashMap();
            this.model.setParameters(hashMap);
        }
        hashMap.put(string, string2);
        return this;
    }

    public TransactionBuilder withLineParameter(String string, String string2) {
        LineItemModel lineItemModel = this.getMostRecentLine("WithLineParameter");
        HashMap<String, String> hashMap = lineItemModel.getParameters();
        if (hashMap == null) {
            hashMap = new HashMap();
            lineItemModel.setParameters(hashMap);
        }
        hashMap.put(string, string2);
        return this;
    }

    public TransactionBuilder withReferenceCode(String string) {
        this.model.setReferenceCode(string);
        return this;
    }

    public TransactionBuilder withDate(Date date) {
        this.model.setDate(date);
        return this;
    }

    public TransactionBuilder withCustomerUsageType(String string) {
        this.model.setCustomerUsageType(string);
        return this;
    }

    public TransactionBuilder withExemptionNo(String string) {
        this.model.setExemptionNo(string);
        return this;
    }

    public TransactionBuilder withCode(String string) {
        this.model.setCode(string);
        return this;
    }

    public TransactionBuilder withAddress(TransactionAddressType transactionAddressType, String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        AddressesModel addressesModel = this.model.getAddresses();
        if (addressesModel == null) {
            addressesModel = new AddressesModel();
            this.model.setAddresses(addressesModel);
        }
        AddressLocationInfo addressLocationInfo = new AddressLocationInfo();
        addressLocationInfo.setLine1(string);
        addressLocationInfo.setLine2(string2);
        addressLocationInfo.setLine3(string3);
        addressLocationInfo.setCity(string4);
        addressLocationInfo.setRegion(string5);
        addressLocationInfo.setPostalCode(string6);
        addressLocationInfo.setCountry(string7);
        if (transactionAddressType == TransactionAddressType.ShipTo) {
            addressesModel.setShipTo(addressLocationInfo);
        } else if (transactionAddressType == TransactionAddressType.ShipFrom) {
            addressesModel.setShipFrom(addressLocationInfo);
        } else if (transactionAddressType == TransactionAddressType.PointOfOrderAcceptance) {
            addressesModel.setPointOfOrderAcceptance(addressLocationInfo);
        } else if (transactionAddressType == TransactionAddressType.PointOfOrderOrigin) {
            addressesModel.setPointOfOrderOrigin(addressLocationInfo);
        } else if (transactionAddressType == TransactionAddressType.SingleLocation) {
            addressesModel.setSingleLocation(addressLocationInfo);
        }
        return this;
    }

    public TransactionBuilder withLatLong(TransactionAddressType transactionAddressType, BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        AddressesModel addressesModel = this.model.getAddresses();
        if (addressesModel == null) {
            addressesModel = new AddressesModel();
            this.model.setAddresses(addressesModel);
        }
        AddressLocationInfo addressLocationInfo = new AddressLocationInfo();
        addressLocationInfo.setLatitude(bigDecimal);
        addressLocationInfo.setLongitude(bigDecimal2);
        if (transactionAddressType == TransactionAddressType.ShipTo) {
            addressesModel.setShipTo(addressLocationInfo);
        } else if (transactionAddressType == TransactionAddressType.ShipFrom) {
            addressesModel.setShipFrom(addressLocationInfo);
        } else if (transactionAddressType == TransactionAddressType.PointOfOrderAcceptance) {
            addressesModel.setPointOfOrderAcceptance(addressLocationInfo);
        } else if (transactionAddressType == TransactionAddressType.PointOfOrderOrigin) {
            addressesModel.setPointOfOrderOrigin(addressLocationInfo);
        } else if (transactionAddressType == TransactionAddressType.SingleLocation) {
            addressesModel.setSingleLocation(addressLocationInfo);
        }
        return this;
    }

    public TransactionBuilder withLineAddress(TransactionAddressType transactionAddressType, String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        LineItemModel lineItemModel = this.getMostRecentLine("WithLineAddress");
        AddressesModel addressesModel = lineItemModel.getAddresses();
        if (addressesModel == null) {
            addressesModel = new AddressesModel();
            lineItemModel.setAddresses(addressesModel);
        }
        AddressLocationInfo addressLocationInfo = new AddressLocationInfo();
        addressLocationInfo.setLine1(string);
        addressLocationInfo.setLine2(string2);
        addressLocationInfo.setLine3(string3);
        addressLocationInfo.setCity(string4);
        addressLocationInfo.setRegion(string5);
        addressLocationInfo.setPostalCode(string6);
        addressLocationInfo.setCountry(string7);
        if (transactionAddressType == TransactionAddressType.ShipTo) {
            addressesModel.setShipTo(addressLocationInfo);
        } else if (transactionAddressType == TransactionAddressType.ShipFrom) {
            addressesModel.setShipFrom(addressLocationInfo);
        } else if (transactionAddressType == TransactionAddressType.PointOfOrderAcceptance) {
            addressesModel.setPointOfOrderAcceptance(addressLocationInfo);
        } else if (transactionAddressType == TransactionAddressType.PointOfOrderOrigin) {
            addressesModel.setPointOfOrderOrigin(addressLocationInfo);
        } else if (transactionAddressType == TransactionAddressType.SingleLocation) {
            addressesModel.setSingleLocation(addressLocationInfo);
        }
        return this;
    }

    public TransactionBuilder withTaxOverride(TaxOverrideType taxOverrideType, String string, BigDecimal bigDecimal, Date date) {
        if (bigDecimal == null) {
            bigDecimal = new BigDecimal(0);
        }
        TaxOverrideModel taxOverrideModel = new TaxOverrideModel();
        taxOverrideModel.setType(taxOverrideType);
        taxOverrideModel.setReason(string);
        taxOverrideModel.setTaxAmount(bigDecimal);
        taxOverrideModel.setTaxDate(date);
        this.model.setTaxOverride(taxOverrideModel);
        return this;
    }

    public TransactionBuilder withLineTaxOverride(TaxOverrideType taxOverrideType, String string, BigDecimal bigDecimal, Date date) throws AvaTaxClientException {
        if (taxOverrideType == TaxOverrideType.TaxDate && date == null) {
            throw new AvaTaxClientException("TaxDate cannot be null with a TaxDate TaxOverrideType.");
        }
        LineItemModel lineItemModel = this.getMostRecentLine("WithLineAddress");
        TaxOverrideModel taxOverrideModel = new TaxOverrideModel();
        taxOverrideModel.setType(taxOverrideType);
        taxOverrideModel.setReason(string);
        taxOverrideModel.setTaxAmount(bigDecimal);
        taxOverrideModel.setTaxDate(date);
        lineItemModel.setTaxOverride(taxOverrideModel);
        return this;
    }

    public TransactionBuilder withLine(String string, BigDecimal bigDecimal, BigDecimal bigDecimal2, String string2) {
        return this.withLine(string, bigDecimal, bigDecimal2, string2, null, null, null, null, null);
    }

    public TransactionBuilder withLine(BigDecimal bigDecimal, BigDecimal bigDecimal2, String string) {
        return this.withLine(bigDecimal, bigDecimal2, string, null, null, null, null, null);
    }

    public TransactionBuilder withLine(String string, BigDecimal bigDecimal, BigDecimal bigDecimal2, String string2, String string3) {
        return this.withLine(string, bigDecimal, bigDecimal2, string2, string3, null, null, null, null);
    }

    public TransactionBuilder withLine(BigDecimal bigDecimal, BigDecimal bigDecimal2, String string, String string2) {
        return this.withLine(bigDecimal, bigDecimal2, string, string2, null, null, null, null);
    }

    public TransactionBuilder withLine(String string, BigDecimal bigDecimal, BigDecimal bigDecimal2, String string2, String string3, String string4) {
        return this.withLine(string, bigDecimal, bigDecimal2, string2, string3, string4, null, null, null);
    }

    public TransactionBuilder withLine(BigDecimal bigDecimal, BigDecimal bigDecimal2, String string, String string2, String string3) {
        return this.withLine(bigDecimal, bigDecimal2, string, string2, string3, null, null, null);
    }

    public TransactionBuilder withLine(String string, BigDecimal bigDecimal, BigDecimal bigDecimal2, String string2, String string3, String string4, String string5, String string6) {
        return this.withLine(string, bigDecimal, bigDecimal2, string2, string3, string4, string5, string6, null);
    }

    public TransactionBuilder withLine(BigDecimal bigDecimal, BigDecimal bigDecimal2, String string, String string2, String string3, String string4, String string5) {
        return this.withLine(bigDecimal, bigDecimal2, string, string2, string3, string4, string5, null);
    }

    public TransactionBuilder withLine(BigDecimal bigDecimal, BigDecimal bigDecimal2, String string, String string2, String string3, String string4, String string5, String string6) {
        return this.withLine(null, bigDecimal, bigDecimal2, string, string2, string3, string4, string5, string6);
    }

    public TransactionBuilder withLine(String string, BigDecimal bigDecimal, BigDecimal bigDecimal2, String string2, String string3, String string4, String string5, String string6, String string7) {
        if (bigDecimal2 == null) {
            bigDecimal2 = BigDecimal.ONE;
        }
        LineItemModel lineItemModel = new LineItemModel();
        lineItemModel.setAmount(bigDecimal);
        lineItemModel.setQuantity(bigDecimal2);
        if (string != null && !string.isEmpty()) {
            lineItemModel.setNumber(string);
        } else {
            lineItemModel.setNumber(Integer.valueOf(this.lineNumber).toString());
        }
        if (string2 != null && !string2.isEmpty()) {
            lineItemModel.setTaxCode(string2);
        } else {
            lineItemModel.setTaxCode("P0000000");
        }
        if (string3 != null && !string3.isEmpty()) {
            lineItemModel.setItemCode(string3);
        }
        if (string4 != null && !string4.isEmpty()) {
            lineItemModel.setDescription(string4);
        }
        if (string5 != null && !string5.isEmpty()) {
            lineItemModel.setRef1(string5);
        }
        if (string6 != null && !string6.isEmpty()) {
            lineItemModel.setRef2(string6);
        }
        if (string7 != null && !string7.isEmpty()) {
            lineItemModel.setCustomerUsageType(string7);
        }
        this.model.getLines().add(lineItemModel);
        ++this.lineNumber;
        return this;
    }

    public TransactionBuilder withSeparateAddressLine(BigDecimal bigDecimal, TransactionAddressType transactionAddressType, String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        return this.withSeparateAddressLineAndQuantity(bigDecimal, BigDecimal.ONE, transactionAddressType, string, string2, string3, string4, string5, string6, string7);
    }

    public TransactionBuilder withSeparateAddressLineAndQuantity(BigDecimal bigDecimal, BigDecimal bigDecimal2, TransactionAddressType transactionAddressType, String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        return this.withSeparateAddressLineQuantityAndItemCode(bigDecimal, bigDecimal2, null, transactionAddressType, string, string2, string3, string4, string5, string6, string7);
    }

    public TransactionBuilder withSeparateAddressLineQuantityAndItemCode(BigDecimal bigDecimal, BigDecimal bigDecimal2, String string, TransactionAddressType transactionAddressType, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        LineItemModel lineItemModel = new LineItemModel();
        lineItemModel.setAmount(bigDecimal);
        lineItemModel.setQuantity(bigDecimal2);
        lineItemModel.setNumber(Integer.valueOf(this.lineNumber).toString());
        if (string != null && !string.isEmpty()) {
            lineItemModel.setItemCode(string);
        }
        AddressesModel addressesModel = new AddressesModel();
        AddressLocationInfo addressLocationInfo = new AddressLocationInfo();
        addressLocationInfo.setLine1(string2);
        addressLocationInfo.setLine2(string3);
        addressLocationInfo.setLine3(string4);
        addressLocationInfo.setCity(string5);
        addressLocationInfo.setRegion(string6);
        addressLocationInfo.setPostalCode(string7);
        addressLocationInfo.setCountry(string8);
        if (transactionAddressType == TransactionAddressType.ShipTo) {
            addressesModel.setShipTo(addressLocationInfo);
        } else if (transactionAddressType == TransactionAddressType.ShipFrom) {
            addressesModel.setShipFrom(addressLocationInfo);
        } else if (transactionAddressType == TransactionAddressType.PointOfOrderAcceptance) {
            addressesModel.setPointOfOrderAcceptance(addressLocationInfo);
        } else if (transactionAddressType == TransactionAddressType.PointOfOrderOrigin) {
            addressesModel.setPointOfOrderOrigin(addressLocationInfo);
        } else if (transactionAddressType == TransactionAddressType.SingleLocation) {
            addressesModel.setSingleLocation(addressLocationInfo);
        }
        lineItemModel.setAddresses(addressesModel);
        this.model.getLines().add(lineItemModel);
        ++this.lineNumber;
        return this;
    }

    public TransactionBuilder withExemptLine(BigDecimal bigDecimal, String string) {
        LineItemModel lineItemModel = new LineItemModel();
        lineItemModel.setAmount(bigDecimal);
        lineItemModel.setQuantity(BigDecimal.ONE);
        lineItemModel.setNumber(Integer.valueOf(this.lineNumber).toString());
        lineItemModel.setExemptionCode(string);
        this.model.getLines().add(lineItemModel);
        ++this.lineNumber;
        return this;
    }

    private LineItemModel getMostRecentLine(String string) {
        if (this.model.getLines().size() <= 0) {
            throw new IllegalStateException("This transaction does not have any lines.");
        }
        return this.model.getLines().get(this.model.getLines().size() - 1);
    }

    public CreateTransactionModel getIntermediaryTransactionModel() {
        return this.model;
    }

    public Future<TransactionModel> CreateAsync() {
        return this.client.createTransactionAsync(null, this.model);
    }

    public TransactionModel Create() throws Exception {
        return this.client.createTransaction(null, this.model);
    }

    public AdjustTransactionModel CreateAdjustmentRequest(String string, AdjustmentReason adjustmentReason) {
        AdjustTransactionModel adjustTransactionModel = new AdjustTransactionModel();
        adjustTransactionModel.setAdjustmentDescription(string);
        adjustTransactionModel.setAdjustmentReason(adjustmentReason);
        adjustTransactionModel.setNewTransaction(this.model);
        return adjustTransactionModel;
    }
}

