/*
 * Decompiled with CFR 0.152.
 */
package net.avalara.avatax.rest.client;

import com.google.gson.reflect.TypeToken;
import java.util.concurrent.Callable;
import net.avalara.avatax.rest.client.AvaTaxClientException;
import net.avalara.avatax.rest.client.AvaTaxConstants;
import net.avalara.avatax.rest.client.AvaTaxPath;
import net.avalara.avatax.rest.client.models.ErrorResult;
import net.avalara.avatax.rest.client.serializer.JsonSerializer;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.util.EntityUtils;

public class RestCall<T>
implements Callable<T> {
    private CloseableHttpClient client;
    private HttpRequestBase request;
    private String appName;
    private String appVersion;
    private String machineName;
    private Object model;
    private TypeToken<T> typeToken;

    private RestCall(String string, String string2, String string3, String string4, String string5, AvaTaxPath avaTaxPath, Object object, TypeToken<T> typeToken, CloseableHttpClient closeableHttpClient) {
        this.client = closeableHttpClient;
        this.appName = string;
        this.appVersion = string2;
        this.machineName = string3;
        this.typeToken = typeToken;
        this.model = object;
        if (string5 == "post") {
            this.request = new HttpPost(string4 + avaTaxPath.toString());
            ((HttpPost)this.request).setEntity((HttpEntity)new StringEntity(JsonSerializer.SerializeObject(object), ContentType.create((String)"application/json", (String)"UTF-8")));
        } else if (string5 == "get") {
            this.request = new HttpGet(string4 + avaTaxPath.toString());
        } else if (string5 == "delete") {
            this.request = new HttpDelete(string4 + avaTaxPath.toString());
        } else if (string5 == "put") {
            this.request = new HttpPut(string4 + avaTaxPath.toString());
            ((HttpPut)this.request).setEntity((HttpEntity)new StringEntity(JsonSerializer.SerializeObject(object), ContentType.create((String)"application/json", (String)"UTF-8")));
        }
        this.buildRequest(this.request);
    }

    public RestCall(String string, String string2, String string3, String string4, String string5, AvaTaxPath avaTaxPath, Object object, TypeToken<T> typeToken) {
        this(string, string2, string3, string4, string5, avaTaxPath, object, typeToken, HttpClients.createDefault());
    }

    public RestCall(String string, String string2, String string3, String string4, String string5, AvaTaxPath avaTaxPath, Object object, TypeToken<T> typeToken, HttpClientBuilder httpClientBuilder) {
        this(string, string2, string3, string4, string5, avaTaxPath, object, typeToken, httpClientBuilder.build());
    }

    public RestCall(String string, String string2, String string3, String string4, String string5, String string6, AvaTaxPath avaTaxPath, Object object, TypeToken<T> typeToken) {
        this(string, string2, string3, string4, string6, avaTaxPath, object, typeToken);
        this.request.setHeader("Authorization", "Basic " + string5);
    }

    public RestCall(String string, String string2, String string3, String string4, String string5, String string6, AvaTaxPath avaTaxPath, Object object, TypeToken<T> typeToken, HttpClientBuilder httpClientBuilder) {
        this(string, string2, string3, string4, string6, avaTaxPath, object, typeToken, httpClientBuilder);
        this.request.setHeader("Authorization", "Basic " + string5);
    }

    public RestCall(String string, String string2, String string3, String string4, String string5, AvaTaxPath avaTaxPath, Object object, TypeToken<T> typeToken, String string6, int n, String string7) {
        this(string, string2, string3, string4, string5, avaTaxPath, object, typeToken, HttpClients.custom().setRoutePlanner((HttpRoutePlanner)new DefaultProxyRoutePlanner(new HttpHost(string6, n, string7))).build());
    }

    public RestCall(String string, String string2, String string3, String string4, String string5, String string6, AvaTaxPath avaTaxPath, Object object, TypeToken<T> typeToken, String string7, int n, String string8) {
        this(string, string2, string3, string4, string6, avaTaxPath, object, typeToken, string7, n, string8);
        this.request.setHeader("Authorization", "Basic " + string5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T call() throws Exception {
        Object object = null;
        try (CloseableHttpResponse closeableHttpResponse = this.client.execute((HttpUriRequest)this.request);){
            HttpEntity httpEntity = closeableHttpResponse.getEntity();
            if (closeableHttpResponse.getStatusLine().getStatusCode() != 200 && closeableHttpResponse.getStatusLine().getStatusCode() != 201) {
                throw new AvaTaxClientException((ErrorResult)JsonSerializer.DeserializeObject(EntityUtils.toString((HttpEntity)httpEntity), ErrorResult.class), this.model);
            }
            if (httpEntity != null) {
                object = ContentType.getOrDefault((HttpEntity)httpEntity).getMimeType().equals("application/json") ? JsonSerializer.DeserializeObject(EntityUtils.toString((HttpEntity)httpEntity), this.typeToken.getType()) : EntityUtils.toString((HttpEntity)httpEntity);
            }
        }
        return (T)object;
    }

    private void buildRequest(HttpRequestBase httpRequestBase) {
        String string = String.format("%s; %s; %s; %s; %s", this.appName, this.appVersion, "JavaRestClient", "18.6.1.215", this.machineName);
        httpRequestBase.setHeader(AvaTaxConstants.XClientHeader, string);
    }
}

