/*
 * Decompiled with CFR 0.152.
 */
package net.avalara.avatax.rest.client;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.Future;
import net.avalara.avatax.rest.client.AvaTaxClient;
import net.avalara.avatax.rest.client.AvaTaxClientException;
import net.avalara.avatax.rest.client.enums.AdjustmentReason;
import net.avalara.avatax.rest.client.enums.DocumentType;
import net.avalara.avatax.rest.client.enums.TaxDebugLevel;
import net.avalara.avatax.rest.client.enums.TaxOverrideType;
import net.avalara.avatax.rest.client.enums.TransactionAddressType;
import net.avalara.avatax.rest.client.models.AddressInfo;
import net.avalara.avatax.rest.client.models.AdjustTransactionModel;
import net.avalara.avatax.rest.client.models.CreateTransactionModel;
import net.avalara.avatax.rest.client.models.LineItemModel;
import net.avalara.avatax.rest.client.models.TaxOverrideModel;
import net.avalara.avatax.rest.client.models.TransactionModel;

public class TransactionBuilder {
    private CreateTransactionModel model = new CreateTransactionModel();
    private int lineNumber;
    private AvaTaxClient client;

    public TransactionBuilder(AvaTaxClient avaTaxClient, String string, DocumentType documentType, String string2) {
        this.model.setCompanyCode(string);
        this.model.setCustomerCode(string2);
        this.model.setDate(new Date());
        this.model.setType(documentType);
        this.model.setLines(new ArrayList<LineItemModel>());
        this.lineNumber = 1;
        this.client = avaTaxClient;
    }

    public TransactionBuilder withCommit() {
        this.model.setCommit(true);
        return this;
    }

    public TransactionBuilder withDiagnostics() {
        this.model.setDebugLevel(TaxDebugLevel.Diagnostic);
        return this;
    }

    public TransactionBuilder withDiscountAmount(BigDecimal bigDecimal) {
        this.model.setDiscount(bigDecimal);
        return this;
    }

    public TransactionBuilder withItemDiscount(Boolean bl) {
        this.getMostRecentLine("WithItemDiscount").setDiscounted(bl);
        return this;
    }

    public TransactionBuilder withTransactionCode(String string) {
        this.model.setCode(string);
        return this;
    }

    public TransactionBuilder withType(DocumentType documentType) {
        this.model.setType(documentType);
        return this;
    }

    public TransactionBuilder withParameter(String string, String string2) {
        HashMap<String, String> hashMap = this.model.getParameters();
        if (hashMap == null) {
            hashMap = new HashMap();
            this.model.setParameters(hashMap);
        }
        hashMap.put(string, string2);
        return this;
    }

    public TransactionBuilder withLineParameter(String string, String string2) {
        LineItemModel lineItemModel = this.getMostRecentLine("WithLineParameter");
        HashMap<String, String> hashMap = lineItemModel.getParameters();
        if (hashMap == null) {
            hashMap = new HashMap();
            lineItemModel.setParameters(hashMap);
        }
        hashMap.put(string, string2);
        return this;
    }

    public TransactionBuilder withAddress(TransactionAddressType transactionAddressType, String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        HashMap<TransactionAddressType, AddressInfo> hashMap = this.model.getAddresses();
        if (hashMap == null) {
            hashMap = new HashMap();
            this.model.setAddresses(hashMap);
        }
        AddressInfo addressInfo = new AddressInfo();
        addressInfo.setLine1(string);
        addressInfo.setLine2(string2);
        addressInfo.setLine3(string3);
        addressInfo.setCity(string4);
        addressInfo.setRegion(string5);
        addressInfo.setPostalCode(string6);
        addressInfo.setCountry(string7);
        hashMap.put(transactionAddressType, addressInfo);
        return this;
    }

    public TransactionBuilder withLatLong(TransactionAddressType transactionAddressType, BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        HashMap<TransactionAddressType, AddressInfo> hashMap = this.model.getAddresses();
        if (hashMap == null) {
            hashMap = new HashMap();
            this.model.setAddresses(hashMap);
        }
        AddressInfo addressInfo = new AddressInfo();
        addressInfo.setLatitude(bigDecimal);
        addressInfo.setLongitude(bigDecimal2);
        hashMap.put(transactionAddressType, addressInfo);
        return this;
    }

    public TransactionBuilder withLineAddress(TransactionAddressType transactionAddressType, String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        LineItemModel lineItemModel = this.getMostRecentLine("WithLineAddress");
        HashMap<TransactionAddressType, AddressInfo> hashMap = lineItemModel.getAddresses();
        if (hashMap == null) {
            hashMap = new HashMap();
            lineItemModel.setAddresses(hashMap);
        }
        AddressInfo addressInfo = new AddressInfo();
        addressInfo.setLine1(string);
        addressInfo.setLine2(string2);
        addressInfo.setLine3(string3);
        addressInfo.setCity(string4);
        addressInfo.setRegion(string5);
        addressInfo.setPostalCode(string6);
        addressInfo.setCountry(string7);
        hashMap.put(transactionAddressType, addressInfo);
        return this;
    }

    public TransactionBuilder withTaxOverride(TaxOverrideType taxOverrideType, String string, BigDecimal bigDecimal, Date date) {
        if (bigDecimal == null) {
            bigDecimal = new BigDecimal(0);
        }
        TaxOverrideModel taxOverrideModel = new TaxOverrideModel();
        taxOverrideModel.setType(taxOverrideType);
        taxOverrideModel.setReason(string);
        taxOverrideModel.setTaxAmount(bigDecimal);
        taxOverrideModel.setTaxDate(date);
        this.model.setTaxOverride(taxOverrideModel);
        return this;
    }

    public TransactionBuilder withLineTaxOverride(TaxOverrideType taxOverrideType, String string, BigDecimal bigDecimal, Date date) throws AvaTaxClientException {
        if (taxOverrideType == TaxOverrideType.TaxDate && date == null) {
            throw new AvaTaxClientException("TaxDate cannot be null with a TaxDate TaxOverrideType.");
        }
        LineItemModel lineItemModel = this.getMostRecentLine("WithLineAddress");
        TaxOverrideModel taxOverrideModel = new TaxOverrideModel();
        taxOverrideModel.setType(taxOverrideType);
        taxOverrideModel.setReason(string);
        taxOverrideModel.setTaxAmount(bigDecimal);
        taxOverrideModel.setTaxDate(date);
        lineItemModel.setTaxOverride(taxOverrideModel);
        return this;
    }

    public TransactionBuilder withLine(BigDecimal bigDecimal, BigDecimal bigDecimal2, String string) {
        if (bigDecimal2 == null) {
            bigDecimal2 = BigDecimal.ONE;
        }
        LineItemModel lineItemModel = new LineItemModel();
        lineItemModel.setAmount(bigDecimal);
        lineItemModel.setQuantity(bigDecimal2);
        lineItemModel.setNumber(Integer.valueOf(this.lineNumber).toString());
        lineItemModel.setTaxCode(string);
        this.model.getLines().add(lineItemModel);
        ++this.lineNumber;
        return this;
    }

    public TransactionBuilder withSeparateAddressLine(BigDecimal bigDecimal, TransactionAddressType transactionAddressType, String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        LineItemModel lineItemModel = new LineItemModel();
        lineItemModel.setAmount(bigDecimal);
        lineItemModel.setQuantity(BigDecimal.ONE);
        lineItemModel.setNumber(Integer.valueOf(this.lineNumber).toString());
        HashMap<TransactionAddressType, AddressInfo> hashMap = new HashMap<TransactionAddressType, AddressInfo>();
        AddressInfo addressInfo = new AddressInfo();
        addressInfo.setLine1(string);
        addressInfo.setLine2(string2);
        addressInfo.setLine3(string3);
        addressInfo.setCity(string4);
        addressInfo.setRegion(string5);
        addressInfo.setPostalCode(string6);
        addressInfo.setCountry(string7);
        hashMap.put(transactionAddressType, addressInfo);
        lineItemModel.setAddresses(hashMap);
        this.model.getLines().add(lineItemModel);
        ++this.lineNumber;
        return this;
    }

    public TransactionBuilder withExemptLine(BigDecimal bigDecimal, String string) {
        LineItemModel lineItemModel = new LineItemModel();
        lineItemModel.setAmount(bigDecimal);
        lineItemModel.setQuantity(BigDecimal.ONE);
        lineItemModel.setNumber(Integer.valueOf(this.lineNumber).toString());
        lineItemModel.setExemptionCode(string);
        this.model.getLines().add(lineItemModel);
        ++this.lineNumber;
        return this;
    }

    private LineItemModel getMostRecentLine(String string) {
        if (this.model.getLines().size() <= 0) {
            throw new IllegalStateException("This transaction does not have any lines.");
        }
        return this.model.getLines().get(this.model.getLines().size() - 1);
    }

    public Future<TransactionModel> CreateAsync() {
        return this.client.createTransactionAsync(this.model);
    }

    public TransactionModel Create() throws Exception {
        return this.client.createTransaction(this.model);
    }

    public AdjustTransactionModel CreateAdjustmentRequest(String string, AdjustmentReason adjustmentReason) {
        AdjustTransactionModel adjustTransactionModel = new AdjustTransactionModel();
        adjustTransactionModel.setAdjustmentDescription(string);
        adjustTransactionModel.setAdjustmentReason(adjustmentReason);
        adjustTransactionModel.setNewTransaction(this.model);
        return adjustTransactionModel;
    }
}

