/*
 * Decompiled with CFR 0.152.
 */
package net.avalara.avatax.rest.client;

import com.google.gson.reflect.TypeToken;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.avalara.avatax.rest.client.AvaTaxConstants;
import net.avalara.avatax.rest.client.AvaTaxPath;
import net.avalara.avatax.rest.client.FetchResult;
import net.avalara.avatax.rest.client.RestCallFactory;
import net.avalara.avatax.rest.client.enums.AvaTaxEnvironment;
import net.avalara.avatax.rest.client.enums.DocumentType;
import net.avalara.avatax.rest.client.enums.PointOfSaleFileType;
import net.avalara.avatax.rest.client.enums.PointOfSalePartnerId;
import net.avalara.avatax.rest.client.enums.ServiceTypeId;
import net.avalara.avatax.rest.client.enums.TextCase;
import net.avalara.avatax.rest.client.models.AccountConfigurationModel;
import net.avalara.avatax.rest.client.models.AccountModel;
import net.avalara.avatax.rest.client.models.ActivateAccountModel;
import net.avalara.avatax.rest.client.models.AddTransactionLineModel;
import net.avalara.avatax.rest.client.models.AddressResolutionModel;
import net.avalara.avatax.rest.client.models.AddressValidationInfo;
import net.avalara.avatax.rest.client.models.AdjustTransactionModel;
import net.avalara.avatax.rest.client.models.ApproveFilingsModel;
import net.avalara.avatax.rest.client.models.AuditTransactionModel;
import net.avalara.avatax.rest.client.models.AvaFileFormModel;
import net.avalara.avatax.rest.client.models.BatchModel;
import net.avalara.avatax.rest.client.models.BulkLockTransactionModel;
import net.avalara.avatax.rest.client.models.BulkLockTransactionResult;
import net.avalara.avatax.rest.client.models.ChangeTransactionCodeModel;
import net.avalara.avatax.rest.client.models.CommitTransactionModel;
import net.avalara.avatax.rest.client.models.CompanyConfigurationModel;
import net.avalara.avatax.rest.client.models.CompanyInitializationModel;
import net.avalara.avatax.rest.client.models.CompanyModel;
import net.avalara.avatax.rest.client.models.ContactModel;
import net.avalara.avatax.rest.client.models.CreateOrAdjustTransactionModel;
import net.avalara.avatax.rest.client.models.CreateTransactionModel;
import net.avalara.avatax.rest.client.models.CycleAddOptionModel;
import net.avalara.avatax.rest.client.models.CycleEditOptionModel;
import net.avalara.avatax.rest.client.models.CycleExpireModel;
import net.avalara.avatax.rest.client.models.EntityUseCodeModel;
import net.avalara.avatax.rest.client.models.ErrorDetail;
import net.avalara.avatax.rest.client.models.FilingAdjustmentModel;
import net.avalara.avatax.rest.client.models.FilingAugmentationModel;
import net.avalara.avatax.rest.client.models.FilingCalendarEditModel;
import net.avalara.avatax.rest.client.models.FilingCalendarModel;
import net.avalara.avatax.rest.client.models.FilingFrequencyModel;
import net.avalara.avatax.rest.client.models.FilingModel;
import net.avalara.avatax.rest.client.models.FilingRequestModel;
import net.avalara.avatax.rest.client.models.FilingsCheckupModel;
import net.avalara.avatax.rest.client.models.FreeTrialRequestModel;
import net.avalara.avatax.rest.client.models.FundingInitiateModel;
import net.avalara.avatax.rest.client.models.FundingStatusModel;
import net.avalara.avatax.rest.client.models.IsoCountryModel;
import net.avalara.avatax.rest.client.models.IsoRegionModel;
import net.avalara.avatax.rest.client.models.ItemModel;
import net.avalara.avatax.rest.client.models.JurisdictionOverrideModel;
import net.avalara.avatax.rest.client.models.LicenseKeyModel;
import net.avalara.avatax.rest.client.models.LocationModel;
import net.avalara.avatax.rest.client.models.LocationQuestionModel;
import net.avalara.avatax.rest.client.models.LocationValidationModel;
import net.avalara.avatax.rest.client.models.LockTransactionModel;
import net.avalara.avatax.rest.client.models.LoginVerificationInputModel;
import net.avalara.avatax.rest.client.models.LoginVerificationOutputModel;
import net.avalara.avatax.rest.client.models.NewAccountModel;
import net.avalara.avatax.rest.client.models.NewAccountRequestModel;
import net.avalara.avatax.rest.client.models.NexusByTaxFormModel;
import net.avalara.avatax.rest.client.models.NexusModel;
import net.avalara.avatax.rest.client.models.NexusTaxTypeGroupModel;
import net.avalara.avatax.rest.client.models.NoticeCommentModel;
import net.avalara.avatax.rest.client.models.NoticeCustomerFundingOptionModel;
import net.avalara.avatax.rest.client.models.NoticeCustomerTypeModel;
import net.avalara.avatax.rest.client.models.NoticeFilingTypeModel;
import net.avalara.avatax.rest.client.models.NoticeFinanceModel;
import net.avalara.avatax.rest.client.models.NoticeModel;
import net.avalara.avatax.rest.client.models.NoticePriorityModel;
import net.avalara.avatax.rest.client.models.NoticeReasonModel;
import net.avalara.avatax.rest.client.models.NoticeResponsibilityDetailModel;
import net.avalara.avatax.rest.client.models.NoticeResponsibilityModel;
import net.avalara.avatax.rest.client.models.NoticeRootCauseDetailModel;
import net.avalara.avatax.rest.client.models.NoticeRootCauseModel;
import net.avalara.avatax.rest.client.models.NoticeStatusModel;
import net.avalara.avatax.rest.client.models.NoticeTypeModel;
import net.avalara.avatax.rest.client.models.ParameterModel;
import net.avalara.avatax.rest.client.models.PasswordChangeModel;
import net.avalara.avatax.rest.client.models.PingResultModel;
import net.avalara.avatax.rest.client.models.PointOfSaleDataRequestModel;
import net.avalara.avatax.rest.client.models.RateTypeModel;
import net.avalara.avatax.rest.client.models.RebuildFilingsModel;
import net.avalara.avatax.rest.client.models.RefundTransactionModel;
import net.avalara.avatax.rest.client.models.RemoveTransactionLineModel;
import net.avalara.avatax.rest.client.models.ResetLicenseKeyModel;
import net.avalara.avatax.rest.client.models.ResourceFileTypeModel;
import net.avalara.avatax.rest.client.models.ResourceFileUploadRequestModel;
import net.avalara.avatax.rest.client.models.SecurityRoleModel;
import net.avalara.avatax.rest.client.models.SetPasswordModel;
import net.avalara.avatax.rest.client.models.SettingModel;
import net.avalara.avatax.rest.client.models.SettleTransactionModel;
import net.avalara.avatax.rest.client.models.SkyscraperStatusModel;
import net.avalara.avatax.rest.client.models.SubscriptionModel;
import net.avalara.avatax.rest.client.models.SubscriptionTypeModel;
import net.avalara.avatax.rest.client.models.TaxAuthorityFormModel;
import net.avalara.avatax.rest.client.models.TaxAuthorityModel;
import net.avalara.avatax.rest.client.models.TaxAuthorityTypeModel;
import net.avalara.avatax.rest.client.models.TaxCodeModel;
import net.avalara.avatax.rest.client.models.TaxCodeTypesModel;
import net.avalara.avatax.rest.client.models.TaxRateModel;
import net.avalara.avatax.rest.client.models.TaxRuleModel;
import net.avalara.avatax.rest.client.models.TaxSubTypeModel;
import net.avalara.avatax.rest.client.models.TaxTypeGroupModel;
import net.avalara.avatax.rest.client.models.TransactionModel;
import net.avalara.avatax.rest.client.models.UPCModel;
import net.avalara.avatax.rest.client.models.UserEntitlementModel;
import net.avalara.avatax.rest.client.models.UserModel;
import net.avalara.avatax.rest.client.models.VerifyTransactionModel;
import net.avalara.avatax.rest.client.models.VoidTransactionModel;
import org.apache.commons.codec.binary.Base64;

public class AvaTaxClient {
    private final ExecutorService threadPool;
    private RestCallFactory restCallFactory;

    private AvaTaxClient() {
        this(null);
    }

    private AvaTaxClient(ExecutorService executorService) {
        this.threadPool = executorService != null ? executorService : Executors.newFixedThreadPool(3);
    }

    public AvaTaxClient(String string, String string2, String string3, AvaTaxEnvironment avaTaxEnvironment) {
        this(string, string2, string3, avaTaxEnvironment == AvaTaxEnvironment.Production ? AvaTaxConstants.Production_Url : AvaTaxConstants.Sandbox_Url);
    }

    public AvaTaxClient(String string, String string2, String string3, String string4) {
        this();
        this.restCallFactory = new RestCallFactory(string, string2, string3, string4);
    }

    public AvaTaxClient(String string, String string2, String string3, AvaTaxEnvironment avaTaxEnvironment, String string4, int n, String string5) {
        this(string, string2, string3, avaTaxEnvironment == AvaTaxEnvironment.Production ? AvaTaxConstants.Production_Url : AvaTaxConstants.Sandbox_Url, string4, n, string5);
    }

    public AvaTaxClient(String string, String string2, String string3, String string4, String string5, int n, String string6) {
        this();
        this.restCallFactory = new RestCallFactory(string, string2, string3, string4, string5, n, string6);
    }

    public AvaTaxClient withSecurity(String string) {
        this.restCallFactory.addSecurityHeader(string);
        return this;
    }

    public AvaTaxClient withSecurity(String string, String string2) {
        String string3 = null;
        try {
            string3 = Base64.encodeBase64String((byte[])(string + ":" + string2).getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println("Could not find encoding for UTF-8.");
            unsupportedEncodingException.printStackTrace();
        }
        return this.withSecurity(string3);
    }

    public Future<LicenseKeyModel> accountResetLicenseKeyAsync(Integer n, ResetLicenseKeyModel resetLicenseKeyModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}/resetlicensekey");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, resetLicenseKeyModel, new TypeToken<LicenseKeyModel>(){}));
    }

    public LicenseKeyModel accountResetLicenseKey(Integer n, ResetLicenseKeyModel resetLicenseKeyModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}/resetlicensekey");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, resetLicenseKeyModel, new TypeToken<LicenseKeyModel>(){}).call();
    }

    public Future<AccountModel> activateAccountAsync(Integer n, ActivateAccountModel activateAccountModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}/activate");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, activateAccountModel, new TypeToken<AccountModel>(){}));
    }

    public AccountModel activateAccount(Integer n, ActivateAccountModel activateAccountModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}/activate");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, activateAccountModel, new TypeToken<AccountModel>(){}).call();
    }

    public Future<AccountModel> getAccountAsync(Integer n, String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}");
        avaTaxPath.applyField("id", n);
        avaTaxPath.addQuery("$include", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<AccountModel>(){}));
    }

    public AccountModel getAccount(Integer n, String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}");
        avaTaxPath.applyField("id", n);
        avaTaxPath.addQuery("$include", string);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<AccountModel>(){}).call();
    }

    public Future<ArrayList<AccountConfigurationModel>> getAccountConfigurationAsync(Integer n) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}/configuration");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ArrayList<AccountConfigurationModel>>(){}));
    }

    public ArrayList<AccountConfigurationModel> getAccountConfiguration(Integer n) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}/configuration");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ArrayList<AccountConfigurationModel>>(){}).call();
    }

    public Future<ArrayList<AccountConfigurationModel>> setAccountConfigurationAsync(Integer n, ArrayList<AccountConfigurationModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}/configuration");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<AccountConfigurationModel>>(){}));
    }

    public ArrayList<AccountConfigurationModel> setAccountConfiguration(Integer n, ArrayList<AccountConfigurationModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}/configuration");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<AccountConfigurationModel>>(){}).call();
    }

    public Future<AddressResolutionModel> resolveAddressAsync(String string, String string2, String string3, String string4, String string5, String string6, String string7, TextCase textCase, BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/addresses/resolve");
        avaTaxPath.addQuery("line1", string);
        avaTaxPath.addQuery("line2", string2);
        avaTaxPath.addQuery("line3", string3);
        avaTaxPath.addQuery("city", string4);
        avaTaxPath.addQuery("region", string5);
        avaTaxPath.addQuery("postalCode", string6);
        avaTaxPath.addQuery("country", string7);
        avaTaxPath.addQuery("textCase", (Object)textCase);
        avaTaxPath.addQuery("latitude", bigDecimal);
        avaTaxPath.addQuery("longitude", bigDecimal2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<AddressResolutionModel>(){}));
    }

    public AddressResolutionModel resolveAddress(String string, String string2, String string3, String string4, String string5, String string6, String string7, TextCase textCase, BigDecimal bigDecimal, BigDecimal bigDecimal2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/addresses/resolve");
        avaTaxPath.addQuery("line1", string);
        avaTaxPath.addQuery("line2", string2);
        avaTaxPath.addQuery("line3", string3);
        avaTaxPath.addQuery("city", string4);
        avaTaxPath.addQuery("region", string5);
        avaTaxPath.addQuery("postalCode", string6);
        avaTaxPath.addQuery("country", string7);
        avaTaxPath.addQuery("textCase", (Object)textCase);
        avaTaxPath.addQuery("latitude", bigDecimal);
        avaTaxPath.addQuery("longitude", bigDecimal2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<AddressResolutionModel>(){}).call();
    }

    public Future<AddressResolutionModel> resolveAddressPostAsync(AddressValidationInfo addressValidationInfo) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/addresses/resolve");
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, addressValidationInfo, new TypeToken<AddressResolutionModel>(){}));
    }

    public AddressResolutionModel resolveAddressPost(AddressValidationInfo addressValidationInfo) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/addresses/resolve");
        return this.restCallFactory.createRestCall("post", avaTaxPath, addressValidationInfo, new TypeToken<AddressResolutionModel>(){}).call();
    }

    public Future<ArrayList<BatchModel>> createBatchesAsync(Integer n, ArrayList<BatchModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/batches");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<BatchModel>>(){}));
    }

    public ArrayList<BatchModel> createBatches(Integer n, ArrayList<BatchModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/batches");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<BatchModel>>(){}).call();
    }

    public Future<ArrayList<ErrorDetail>> deleteBatchAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/batches/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}));
    }

    public ArrayList<ErrorDetail> deleteBatch(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/batches/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}).call();
    }

    public Future<HashMap<String, String>> downloadBatchAsync(Integer n, Integer n2, Integer n3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/batches/{batchId}/files/{id}/attachment");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("batchId", n2);
        avaTaxPath.applyField("id", n3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<HashMap<String, String>>(){}));
    }

    public HashMap<String, String> downloadBatch(Integer n, Integer n2, Integer n3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/batches/{batchId}/files/{id}/attachment");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("batchId", n2);
        avaTaxPath.applyField("id", n3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<HashMap<String, String>>(){}).call();
    }

    public Future<BatchModel> getBatchAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/batches/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<BatchModel>(){}));
    }

    public BatchModel getBatch(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/batches/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<BatchModel>(){}).call();
    }

    public Future<FetchResult<BatchModel>> listBatchesByCompanyAsync(Integer n, String string, String string2, Integer n2, Integer n3, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/batches");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<BatchModel>>(){}));
    }

    public FetchResult<BatchModel> listBatchesByCompany(Integer n, String string, String string2, Integer n2, Integer n3, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/batches");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<BatchModel>>(){}).call();
    }

    public Future<FetchResult<BatchModel>> queryBatchesAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/batches");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<BatchModel>>(){}));
    }

    public FetchResult<BatchModel> queryBatches(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/batches");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<BatchModel>>(){}).call();
    }

    public Future<CompanyModel> companyInitializeAsync(CompanyInitializationModel companyInitializationModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/initialize");
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, companyInitializationModel, new TypeToken<CompanyModel>(){}));
    }

    public CompanyModel companyInitialize(CompanyInitializationModel companyInitializationModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/initialize");
        return this.restCallFactory.createRestCall("post", avaTaxPath, companyInitializationModel, new TypeToken<CompanyModel>(){}).call();
    }

    public Future<ArrayList<CompanyModel>> createCompaniesAsync(ArrayList<CompanyModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies");
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<CompanyModel>>(){}));
    }

    public ArrayList<CompanyModel> createCompanies(ArrayList<CompanyModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies");
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<CompanyModel>>(){}).call();
    }

    public Future<FundingStatusModel> createFundingRequestAsync(Integer n, FundingInitiateModel fundingInitiateModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}/funding/setup");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, fundingInitiateModel, new TypeToken<FundingStatusModel>(){}));
    }

    public FundingStatusModel createFundingRequest(Integer n, FundingInitiateModel fundingInitiateModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}/funding/setup");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, fundingInitiateModel, new TypeToken<FundingStatusModel>(){}).call();
    }

    public Future<ArrayList<ErrorDetail>> deleteCompanyAsync(Integer n) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}));
    }

    public ArrayList<ErrorDetail> deleteCompany(Integer n) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}).call();
    }

    public Future<CompanyModel> getCompanyAsync(Integer n, String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}");
        avaTaxPath.applyField("id", n);
        avaTaxPath.addQuery("$include", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<CompanyModel>(){}));
    }

    public CompanyModel getCompany(Integer n, String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}");
        avaTaxPath.applyField("id", n);
        avaTaxPath.addQuery("$include", string);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<CompanyModel>(){}).call();
    }

    public Future<ArrayList<CompanyConfigurationModel>> getCompanyConfigurationAsync(Integer n) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}/configuration");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ArrayList<CompanyConfigurationModel>>(){}));
    }

    public ArrayList<CompanyConfigurationModel> getCompanyConfiguration(Integer n) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}/configuration");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ArrayList<CompanyConfigurationModel>>(){}).call();
    }

    public Future<ArrayList<FundingStatusModel>> listFundingRequestsByCompanyAsync(Integer n) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}/funding");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ArrayList<FundingStatusModel>>(){}));
    }

    public ArrayList<FundingStatusModel> listFundingRequestsByCompany(Integer n) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}/funding");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ArrayList<FundingStatusModel>>(){}).call();
    }

    public Future<FetchResult<CompanyModel>> queryCompaniesAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies");
        avaTaxPath.addQuery("$include", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CompanyModel>>(){}));
    }

    public FetchResult<CompanyModel> queryCompanies(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies");
        avaTaxPath.addQuery("$include", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CompanyModel>>(){}).call();
    }

    public Future<ArrayList<CompanyConfigurationModel>> setCompanyConfigurationAsync(Integer n, ArrayList<CompanyConfigurationModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}/configuration");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<CompanyConfigurationModel>>(){}));
    }

    public ArrayList<CompanyConfigurationModel> setCompanyConfiguration(Integer n, ArrayList<CompanyConfigurationModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}/configuration");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<CompanyConfigurationModel>>(){}).call();
    }

    public Future<CompanyModel> updateCompanyAsync(Integer n, CompanyModel companyModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, companyModel, new TypeToken<CompanyModel>(){}));
    }

    public CompanyModel updateCompany(Integer n, CompanyModel companyModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("put", avaTaxPath, companyModel, new TypeToken<CompanyModel>(){}).call();
    }

    public Future<ArrayList<ContactModel>> createContactsAsync(Integer n, ArrayList<ContactModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/contacts");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<ContactModel>>(){}));
    }

    public ArrayList<ContactModel> createContacts(Integer n, ArrayList<ContactModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/contacts");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<ContactModel>>(){}).call();
    }

    public Future<ArrayList<ErrorDetail>> deleteContactAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/contacts/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}));
    }

    public ArrayList<ErrorDetail> deleteContact(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/contacts/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}).call();
    }

    public Future<ContactModel> getContactAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/contacts/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ContactModel>(){}));
    }

    public ContactModel getContact(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/contacts/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ContactModel>(){}).call();
    }

    public Future<FetchResult<ContactModel>> listContactsByCompanyAsync(Integer n, String string, String string2, Integer n2, Integer n3, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/contacts");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ContactModel>>(){}));
    }

    public FetchResult<ContactModel> listContactsByCompany(Integer n, String string, String string2, Integer n2, Integer n3, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/contacts");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ContactModel>>(){}).call();
    }

    public Future<FetchResult<ContactModel>> queryContactsAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/contacts");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ContactModel>>(){}));
    }

    public FetchResult<ContactModel> queryContacts(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/contacts");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ContactModel>>(){}).call();
    }

    public Future<ContactModel> updateContactAsync(Integer n, Integer n2, ContactModel contactModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/contacts/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, contactModel, new TypeToken<ContactModel>(){}));
    }

    public ContactModel updateContact(Integer n, Integer n2, ContactModel contactModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/contacts/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("put", avaTaxPath, contactModel, new TypeToken<ContactModel>(){}).call();
    }

    public Future<FetchResult<NexusModel>> definitionsNexusByCountryByRegionGetAsync(String string, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/nexus/{country}/{region}");
        avaTaxPath.applyField("country", string);
        avaTaxPath.applyField("region", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NexusModel>>(){}));
    }

    public FetchResult<NexusModel> definitionsNexusByCountryByRegionGet(String string, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/nexus/{country}/{region}");
        avaTaxPath.applyField("country", string);
        avaTaxPath.applyField("region", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NexusModel>>(){}).call();
    }

    public Future<FetchResult<NexusModel>> definitionsNexusByCountryGetAsync(String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/nexus/{country}");
        avaTaxPath.applyField("country", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NexusModel>>(){}));
    }

    public FetchResult<NexusModel> definitionsNexusByCountryGet(String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/nexus/{country}");
        avaTaxPath.applyField("country", string);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NexusModel>>(){}).call();
    }

    public Future<FetchResult<NexusModel>> definitionsNexusGetAsync() {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/nexus");
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NexusModel>>(){}));
    }

    public FetchResult<NexusModel> definitionsNexusGet() throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/nexus");
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NexusModel>>(){}).call();
    }

    public Future<FetchResult<SkyscraperStatusModel>> getLoginVerifierByFormAsync(String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/filingcalendars/loginverifiers/{form}");
        avaTaxPath.applyField("form", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SkyscraperStatusModel>>(){}));
    }

    public FetchResult<SkyscraperStatusModel> getLoginVerifierByForm(String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/filingcalendars/loginverifiers/{form}");
        avaTaxPath.applyField("form", string);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SkyscraperStatusModel>>(){}).call();
    }

    public Future<FetchResult<AvaFileFormModel>> listAvaFileFormsAsync() {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/avafileforms");
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<AvaFileFormModel>>(){}));
    }

    public FetchResult<AvaFileFormModel> listAvaFileForms() throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/avafileforms");
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<AvaFileFormModel>>(){}).call();
    }

    public Future<FetchResult<IsoCountryModel>> listCountriesAsync() {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/countries");
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<IsoCountryModel>>(){}));
    }

    public FetchResult<IsoCountryModel> listCountries() throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/countries");
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<IsoCountryModel>>(){}).call();
    }

    public Future<FetchResult<EntityUseCodeModel>> listEntityUseCodesAsync() {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/entityusecodes");
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<EntityUseCodeModel>>(){}));
    }

    public FetchResult<EntityUseCodeModel> listEntityUseCodes() throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/entityusecodes");
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<EntityUseCodeModel>>(){}).call();
    }

    public Future<FetchResult<FilingFrequencyModel>> listFilingFrequenciesAsync() {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/filingfrequencies");
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<FilingFrequencyModel>>(){}));
    }

    public FetchResult<FilingFrequencyModel> listFilingFrequencies() throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/filingfrequencies");
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<FilingFrequencyModel>>(){}).call();
    }

    public Future<FetchResult<JurisdictionOverrideModel>> listJurisdictionsByAddressAsync(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/jurisdictionsnearaddress");
        avaTaxPath.addQuery("line1", string);
        avaTaxPath.addQuery("line2", string2);
        avaTaxPath.addQuery("line3", string3);
        avaTaxPath.addQuery("city", string4);
        avaTaxPath.addQuery("region", string5);
        avaTaxPath.addQuery("postalCode", string6);
        avaTaxPath.addQuery("country", string7);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<JurisdictionOverrideModel>>(){}));
    }

    public FetchResult<JurisdictionOverrideModel> listJurisdictionsByAddress(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/jurisdictionsnearaddress");
        avaTaxPath.addQuery("line1", string);
        avaTaxPath.addQuery("line2", string2);
        avaTaxPath.addQuery("line3", string3);
        avaTaxPath.addQuery("city", string4);
        avaTaxPath.addQuery("region", string5);
        avaTaxPath.addQuery("postalCode", string6);
        avaTaxPath.addQuery("country", string7);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<JurisdictionOverrideModel>>(){}).call();
    }

    public Future<FetchResult<LocationQuestionModel>> listLocationQuestionsByAddressAsync(String string, String string2, String string3, String string4, String string5, String string6, String string7, BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/locationquestions");
        avaTaxPath.addQuery("line1", string);
        avaTaxPath.addQuery("line2", string2);
        avaTaxPath.addQuery("line3", string3);
        avaTaxPath.addQuery("city", string4);
        avaTaxPath.addQuery("region", string5);
        avaTaxPath.addQuery("postalCode", string6);
        avaTaxPath.addQuery("country", string7);
        avaTaxPath.addQuery("latitude", bigDecimal);
        avaTaxPath.addQuery("longitude", bigDecimal2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<LocationQuestionModel>>(){}));
    }

    public FetchResult<LocationQuestionModel> listLocationQuestionsByAddress(String string, String string2, String string3, String string4, String string5, String string6, String string7, BigDecimal bigDecimal, BigDecimal bigDecimal2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/locationquestions");
        avaTaxPath.addQuery("line1", string);
        avaTaxPath.addQuery("line2", string2);
        avaTaxPath.addQuery("line3", string3);
        avaTaxPath.addQuery("city", string4);
        avaTaxPath.addQuery("region", string5);
        avaTaxPath.addQuery("postalCode", string6);
        avaTaxPath.addQuery("country", string7);
        avaTaxPath.addQuery("latitude", bigDecimal);
        avaTaxPath.addQuery("longitude", bigDecimal2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<LocationQuestionModel>>(){}).call();
    }

    public Future<FetchResult<SkyscraperStatusModel>> listLoginVerifiersAsync() {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/filingcalendars/loginverifiers");
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SkyscraperStatusModel>>(){}));
    }

    public FetchResult<SkyscraperStatusModel> listLoginVerifiers() throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/filingcalendars/loginverifiers");
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SkyscraperStatusModel>>(){}).call();
    }

    public Future<FetchResult<NexusModel>> listNexusByAddressAsync(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/nexus/byaddress");
        avaTaxPath.addQuery("line1", string);
        avaTaxPath.addQuery("line2", string2);
        avaTaxPath.addQuery("line3", string3);
        avaTaxPath.addQuery("city", string4);
        avaTaxPath.addQuery("region", string5);
        avaTaxPath.addQuery("postalCode", string6);
        avaTaxPath.addQuery("country", string7);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NexusModel>>(){}));
    }

    public FetchResult<NexusModel> listNexusByAddress(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/nexus/byaddress");
        avaTaxPath.addQuery("line1", string);
        avaTaxPath.addQuery("line2", string2);
        avaTaxPath.addQuery("line3", string3);
        avaTaxPath.addQuery("city", string4);
        avaTaxPath.addQuery("region", string5);
        avaTaxPath.addQuery("postalCode", string6);
        avaTaxPath.addQuery("country", string7);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NexusModel>>(){}).call();
    }

    public Future<NexusByTaxFormModel> listNexusByFormCodeAsync(String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/nexus/byform/{formCode}");
        avaTaxPath.applyField("formCode", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<NexusByTaxFormModel>(){}));
    }

    public NexusByTaxFormModel listNexusByFormCode(String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/nexus/byform/{formCode}");
        avaTaxPath.applyField("formCode", string);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<NexusByTaxFormModel>(){}).call();
    }

    public Future<FetchResult<NexusTaxTypeGroupModel>> listNexusTaxTypeGroupsAsync() {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/nexustaxtypegroups");
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NexusTaxTypeGroupModel>>(){}));
    }

    public FetchResult<NexusTaxTypeGroupModel> listNexusTaxTypeGroups() throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/nexustaxtypegroups");
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NexusTaxTypeGroupModel>>(){}).call();
    }

    public Future<FetchResult<NoticeCustomerFundingOptionModel>> listNoticeCustomerFundingOptionsAsync() {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticecustomerfundingoptions");
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeCustomerFundingOptionModel>>(){}));
    }

    public FetchResult<NoticeCustomerFundingOptionModel> listNoticeCustomerFundingOptions() throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticecustomerfundingoptions");
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeCustomerFundingOptionModel>>(){}).call();
    }

    public Future<FetchResult<NoticeCustomerTypeModel>> listNoticeCustomerTypesAsync() {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticecustomertypes");
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeCustomerTypeModel>>(){}));
    }

    public FetchResult<NoticeCustomerTypeModel> listNoticeCustomerTypes() throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticecustomertypes");
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeCustomerTypeModel>>(){}).call();
    }

    public Future<FetchResult<NoticeFilingTypeModel>> listNoticeFilingtypesAsync() {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticefilingtypes");
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeFilingTypeModel>>(){}));
    }

    public FetchResult<NoticeFilingTypeModel> listNoticeFilingtypes() throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticefilingtypes");
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeFilingTypeModel>>(){}).call();
    }

    public Future<FetchResult<NoticePriorityModel>> listNoticePrioritiesAsync() {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticepriorities");
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticePriorityModel>>(){}));
    }

    public FetchResult<NoticePriorityModel> listNoticePriorities() throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticepriorities");
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticePriorityModel>>(){}).call();
    }

    public Future<FetchResult<NoticeReasonModel>> listNoticeReasonsAsync() {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticereasons");
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeReasonModel>>(){}));
    }

    public FetchResult<NoticeReasonModel> listNoticeReasons() throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticereasons");
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeReasonModel>>(){}).call();
    }

    public Future<FetchResult<NoticeResponsibilityModel>> listNoticeResponsibilitiesAsync() {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticeresponsibilities");
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeResponsibilityModel>>(){}));
    }

    public FetchResult<NoticeResponsibilityModel> listNoticeResponsibilities() throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticeresponsibilities");
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeResponsibilityModel>>(){}).call();
    }

    public Future<FetchResult<NoticeRootCauseModel>> listNoticeRootCausesAsync() {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticerootcauses");
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeRootCauseModel>>(){}));
    }

    public FetchResult<NoticeRootCauseModel> listNoticeRootCauses() throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticerootcauses");
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeRootCauseModel>>(){}).call();
    }

    public Future<FetchResult<NoticeStatusModel>> listNoticeStatusesAsync() {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticestatuses");
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeStatusModel>>(){}));
    }

    public FetchResult<NoticeStatusModel> listNoticeStatuses() throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticestatuses");
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeStatusModel>>(){}).call();
    }

    public Future<FetchResult<NoticeTypeModel>> listNoticeTypesAsync() {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticetypes");
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeTypeModel>>(){}));
    }

    public FetchResult<NoticeTypeModel> listNoticeTypes() throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticetypes");
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeTypeModel>>(){}).call();
    }

    public Future<FetchResult<ParameterModel>> listParametersAsync() {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/parameters");
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ParameterModel>>(){}));
    }

    public FetchResult<ParameterModel> listParameters() throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/parameters");
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ParameterModel>>(){}).call();
    }

    public Future<FetchResult<String>> listPermissionsAsync() {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/permissions");
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<String>>(){}));
    }

    public FetchResult<String> listPermissions() throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/permissions");
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<String>>(){}).call();
    }

    public Future<FetchResult<RateTypeModel>> listRateTypesByCountryAsync(String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/countries/{country}/ratetypes");
        avaTaxPath.applyField("country", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<RateTypeModel>>(){}));
    }

    public FetchResult<RateTypeModel> listRateTypesByCountry(String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/countries/{country}/ratetypes");
        avaTaxPath.applyField("country", string);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<RateTypeModel>>(){}).call();
    }

    public Future<FetchResult<IsoRegionModel>> listRegionsAsync() {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/regions");
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<IsoRegionModel>>(){}));
    }

    public FetchResult<IsoRegionModel> listRegions() throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/regions");
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<IsoRegionModel>>(){}).call();
    }

    public Future<FetchResult<IsoRegionModel>> listRegionsByCountryAsync(String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/countries/{country}/regions");
        avaTaxPath.applyField("country", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<IsoRegionModel>>(){}));
    }

    public FetchResult<IsoRegionModel> listRegionsByCountry(String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/countries/{country}/regions");
        avaTaxPath.applyField("country", string);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<IsoRegionModel>>(){}).call();
    }

    public Future<FetchResult<ResourceFileTypeModel>> listResourceFileTypesAsync() {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/resourcefiletypes");
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ResourceFileTypeModel>>(){}));
    }

    public FetchResult<ResourceFileTypeModel> listResourceFileTypes() throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/resourcefiletypes");
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ResourceFileTypeModel>>(){}).call();
    }

    public Future<FetchResult<SecurityRoleModel>> listSecurityRolesAsync() {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/securityroles");
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SecurityRoleModel>>(){}));
    }

    public FetchResult<SecurityRoleModel> listSecurityRoles() throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/securityroles");
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SecurityRoleModel>>(){}).call();
    }

    public Future<FetchResult<SubscriptionTypeModel>> listSubscriptionTypesAsync() {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/subscriptiontypes");
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SubscriptionTypeModel>>(){}));
    }

    public FetchResult<SubscriptionTypeModel> listSubscriptionTypes() throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/subscriptiontypes");
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SubscriptionTypeModel>>(){}).call();
    }

    public Future<FetchResult<TaxAuthorityModel>> listTaxAuthoritiesAsync() {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/taxauthorities");
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxAuthorityModel>>(){}));
    }

    public FetchResult<TaxAuthorityModel> listTaxAuthorities() throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/taxauthorities");
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxAuthorityModel>>(){}).call();
    }

    public Future<FetchResult<TaxAuthorityFormModel>> listTaxAuthorityFormsAsync() {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/taxauthorityforms");
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxAuthorityFormModel>>(){}));
    }

    public FetchResult<TaxAuthorityFormModel> listTaxAuthorityForms() throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/taxauthorityforms");
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxAuthorityFormModel>>(){}).call();
    }

    public Future<FetchResult<TaxAuthorityTypeModel>> listTaxAuthorityTypesAsync() {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/taxauthoritytypes");
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxAuthorityTypeModel>>(){}));
    }

    public FetchResult<TaxAuthorityTypeModel> listTaxAuthorityTypes() throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/taxauthoritytypes");
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxAuthorityTypeModel>>(){}).call();
    }

    public Future<TaxCodeTypesModel> listTaxCodeTypesAsync() {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/taxcodetypes");
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<TaxCodeTypesModel>(){}));
    }

    public TaxCodeTypesModel listTaxCodeTypes() throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/taxcodetypes");
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<TaxCodeTypesModel>(){}).call();
    }

    public Future<FetchResult<TaxCodeModel>> listTaxCodesAsync() {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/taxcodes");
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxCodeModel>>(){}));
    }

    public FetchResult<TaxCodeModel> listTaxCodes() throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/taxcodes");
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxCodeModel>>(){}).call();
    }

    public Future<FetchResult<TaxSubTypeModel>> listTaxSubTypesAsync() {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/taxsubtypes");
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxSubTypeModel>>(){}));
    }

    public FetchResult<TaxSubTypeModel> listTaxSubTypes() throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/taxsubtypes");
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxSubTypeModel>>(){}).call();
    }

    public Future<FetchResult<TaxTypeGroupModel>> listTaxTypeGroupsAsync() {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/taxtypegroups");
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxTypeGroupModel>>(){}));
    }

    public FetchResult<TaxTypeGroupModel> listTaxTypeGroups() throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/taxtypegroups");
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxTypeGroupModel>>(){}).call();
    }

    public Future<FilingCalendarModel> companiesByCompanyIdFilingcalendarsByIdGetAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filingcalendars/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FilingCalendarModel>(){}));
    }

    public FilingCalendarModel companiesByCompanyIdFilingcalendarsByIdGet(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filingcalendars/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FilingCalendarModel>(){}).call();
    }

    public Future<FetchResult<FilingCalendarModel>> companiesByCompanyIdFilingcalendarsGetAsync(Integer n, String string, Integer n2, Integer n3, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filingcalendars");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<FilingCalendarModel>>(){}));
    }

    public FetchResult<FilingCalendarModel> companiesByCompanyIdFilingcalendarsGet(Integer n, String string, Integer n2, Integer n3, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filingcalendars");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<FilingCalendarModel>>(){}).call();
    }

    public Future<FetchResult<FilingRequestModel>> companiesByCompanyIdFilingrequestsGetAsync(Integer n, String string, Integer n2, Integer n3, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filingrequests");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<FilingRequestModel>>(){}));
    }

    public FetchResult<FilingRequestModel> companiesByCompanyIdFilingrequestsGet(Integer n, String string, Integer n2, Integer n3, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filingrequests");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<FilingRequestModel>>(){}).call();
    }

    public Future<ArrayList<CycleAddOptionModel>> cycleSafeAddAsync(Integer n, String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filingcalendars/add/options");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("formCode", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ArrayList<CycleAddOptionModel>>(){}));
    }

    public ArrayList<CycleAddOptionModel> cycleSafeAdd(Integer n, String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filingcalendars/add/options");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("formCode", string);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ArrayList<CycleAddOptionModel>>(){}).call();
    }

    public Future<CycleEditOptionModel> cycleSafeEditAsync(Integer n, Integer n2, ArrayList<FilingCalendarEditModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filingcalendars/{id}/edit/options");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<CycleEditOptionModel>(){}));
    }

    public CycleEditOptionModel cycleSafeEdit(Integer n, Integer n2, ArrayList<FilingCalendarEditModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filingcalendars/{id}/edit/options");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<CycleEditOptionModel>(){}).call();
    }

    public Future<CycleExpireModel> cycleSafeExpirationAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filingcalendars/{id}/cancel/options");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<CycleExpireModel>(){}));
    }

    public CycleExpireModel cycleSafeExpiration(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filingcalendars/{id}/cancel/options");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<CycleExpireModel>(){}).call();
    }

    public Future<ArrayList<ErrorDetail>> deleteFilingCalendarAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filingcalendars/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}));
    }

    public ArrayList<ErrorDetail> deleteFilingCalendar(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filingcalendars/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}).call();
    }

    public Future<FilingCalendarModel> filingCalendarUpdateAsync(Integer n, Integer n2, FilingCalendarModel filingCalendarModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filingcalendars/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, filingCalendarModel, new TypeToken<FilingCalendarModel>(){}));
    }

    public FilingCalendarModel filingCalendarUpdate(Integer n, Integer n2, FilingCalendarModel filingCalendarModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filingcalendars/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("put", avaTaxPath, filingCalendarModel, new TypeToken<FilingCalendarModel>(){}).call();
    }

    public Future<FilingRequestModel> filingRequestsAddAsync(Integer n, ArrayList<FilingRequestModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filingcalendars/add/request");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<FilingRequestModel>(){}));
    }

    public FilingRequestModel filingRequestsAdd(Integer n, ArrayList<FilingRequestModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filingcalendars/add/request");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<FilingRequestModel>(){}).call();
    }

    public Future<FilingRequestModel> filingRequestsApproveAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filingrequests/{id}/approve");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, null, new TypeToken<FilingRequestModel>(){}));
    }

    public FilingRequestModel filingRequestsApprove(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filingrequests/{id}/approve");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("post", avaTaxPath, null, new TypeToken<FilingRequestModel>(){}).call();
    }

    public Future<FilingRequestModel> filingRequestsCancelAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filingrequests/{id}/cancel");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, null, new TypeToken<FilingRequestModel>(){}));
    }

    public FilingRequestModel filingRequestsCancel(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filingrequests/{id}/cancel");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("post", avaTaxPath, null, new TypeToken<FilingRequestModel>(){}).call();
    }

    public Future<FilingRequestModel> filingRequestsNewCancelAsync(Integer n, Integer n2, ArrayList<FilingRequestModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filingcalendars/{id}/cancel/request");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<FilingRequestModel>(){}));
    }

    public FilingRequestModel filingRequestsNewCancel(Integer n, Integer n2, ArrayList<FilingRequestModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filingcalendars/{id}/cancel/request");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<FilingRequestModel>(){}).call();
    }

    public Future<FilingRequestModel> filingRequestsNewEditAsync(Integer n, Integer n2, ArrayList<FilingRequestModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filingcalendars/{id}/edit/request");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<FilingRequestModel>(){}));
    }

    public FilingRequestModel filingRequestsNewEdit(Integer n, Integer n2, ArrayList<FilingRequestModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filingcalendars/{id}/edit/request");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<FilingRequestModel>(){}).call();
    }

    public Future<FilingRequestModel> filingRequestsUpdateAsync(Integer n, Integer n2, FilingRequestModel filingRequestModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filingrequests/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, filingRequestModel, new TypeToken<FilingRequestModel>(){}));
    }

    public FilingRequestModel filingRequestsUpdate(Integer n, Integer n2, FilingRequestModel filingRequestModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filingrequests/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("put", avaTaxPath, filingRequestModel, new TypeToken<FilingRequestModel>(){}).call();
    }

    public Future<FetchResult<FilingCalendarModel>> queryFilingCalendarsAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/filingcalendars");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<FilingCalendarModel>>(){}));
    }

    public FetchResult<FilingCalendarModel> queryFilingCalendars(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/filingcalendars");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<FilingCalendarModel>>(){}).call();
    }

    public Future<FetchResult<FilingRequestModel>> queryFilingRequestsAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/filingrequests");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<FilingRequestModel>>(){}));
    }

    public FetchResult<FilingRequestModel> queryFilingRequests(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/filingrequests");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<FilingRequestModel>>(){}).call();
    }

    public Future<FilingRequestModel> filingRequestsAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filingrequests/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FilingRequestModel>(){}));
    }

    public FilingRequestModel filingRequests(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filingrequests/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FilingRequestModel>(){}).call();
    }

    public Future<LoginVerificationOutputModel> loginVerificationGetAsync(Integer n) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/filingcalendars/credentials/{jobId}");
        avaTaxPath.applyField("jobId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<LoginVerificationOutputModel>(){}));
    }

    public LoginVerificationOutputModel loginVerificationGet(Integer n) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/filingcalendars/credentials/{jobId}");
        avaTaxPath.applyField("jobId", n);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<LoginVerificationOutputModel>(){}).call();
    }

    public Future<LoginVerificationOutputModel> loginVerificationPostAsync(LoginVerificationInputModel loginVerificationInputModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/filingcalendars/credentials/verify");
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, loginVerificationInputModel, new TypeToken<LoginVerificationOutputModel>(){}));
    }

    public LoginVerificationOutputModel loginVerificationPost(LoginVerificationInputModel loginVerificationInputModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/filingcalendars/credentials/verify");
        return this.restCallFactory.createRestCall("post", avaTaxPath, loginVerificationInputModel, new TypeToken<LoginVerificationOutputModel>(){}).call();
    }

    public Future<ArrayList<FilingModel>> approveFilingsAsync(Integer n, Short s, Byte by, ApproveFilingsModel approveFilingsModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filings/{year}/{month}/approve");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("year", s);
        avaTaxPath.applyField("month", by);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, approveFilingsModel, new TypeToken<ArrayList<FilingModel>>(){}));
    }

    public ArrayList<FilingModel> approveFilings(Integer n, Short s, Byte by, ApproveFilingsModel approveFilingsModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filings/{year}/{month}/approve");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("year", s);
        avaTaxPath.applyField("month", by);
        return this.restCallFactory.createRestCall("post", avaTaxPath, approveFilingsModel, new TypeToken<ArrayList<FilingModel>>(){}).call();
    }

    public Future<ArrayList<FilingModel>> approveFilingsCountryAsync(Integer n, Short s, Byte by, String string, ApproveFilingsModel approveFilingsModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filings/{year}/{month}/{country}/approve");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("year", s);
        avaTaxPath.applyField("month", by);
        avaTaxPath.applyField("country", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, approveFilingsModel, new TypeToken<ArrayList<FilingModel>>(){}));
    }

    public ArrayList<FilingModel> approveFilingsCountry(Integer n, Short s, Byte by, String string, ApproveFilingsModel approveFilingsModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filings/{year}/{month}/{country}/approve");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("year", s);
        avaTaxPath.applyField("month", by);
        avaTaxPath.applyField("country", string);
        return this.restCallFactory.createRestCall("post", avaTaxPath, approveFilingsModel, new TypeToken<ArrayList<FilingModel>>(){}).call();
    }

    public Future<ArrayList<FilingModel>> approveFilingsCountryRegionAsync(Integer n, Short s, Byte by, String string, String string2, ApproveFilingsModel approveFilingsModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filings/{year}/{month}/{country}/{region}/approve");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("year", s);
        avaTaxPath.applyField("month", by);
        avaTaxPath.applyField("country", string);
        avaTaxPath.applyField("region", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, approveFilingsModel, new TypeToken<ArrayList<FilingModel>>(){}));
    }

    public ArrayList<FilingModel> approveFilingsCountryRegion(Integer n, Short s, Byte by, String string, String string2, ApproveFilingsModel approveFilingsModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filings/{year}/{month}/{country}/{region}/approve");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("year", s);
        avaTaxPath.applyField("month", by);
        avaTaxPath.applyField("country", string);
        avaTaxPath.applyField("region", string2);
        return this.restCallFactory.createRestCall("post", avaTaxPath, approveFilingsModel, new TypeToken<ArrayList<FilingModel>>(){}).call();
    }

    public Future<ArrayList<FilingAdjustmentModel>> createReturnAdjustmentAsync(Integer n, Short s, Byte by, String string, String string2, String string3, ArrayList<FilingAdjustmentModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filings/{year}/{month}/{country}/{region}/{formCode}/adjust");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("year", s);
        avaTaxPath.applyField("month", by);
        avaTaxPath.applyField("country", string);
        avaTaxPath.applyField("region", string2);
        avaTaxPath.applyField("formCode", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<FilingAdjustmentModel>>(){}));
    }

    public ArrayList<FilingAdjustmentModel> createReturnAdjustment(Integer n, Short s, Byte by, String string, String string2, String string3, ArrayList<FilingAdjustmentModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filings/{year}/{month}/{country}/{region}/{formCode}/adjust");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("year", s);
        avaTaxPath.applyField("month", by);
        avaTaxPath.applyField("country", string);
        avaTaxPath.applyField("region", string2);
        avaTaxPath.applyField("formCode", string3);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<FilingAdjustmentModel>>(){}).call();
    }

    public Future<ArrayList<FilingAugmentationModel>> createReturnAugmentationAsync(Integer n, Short s, Byte by, String string, String string2, String string3, ArrayList<FilingAugmentationModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filings/{year}/{month}/{country}/{region}/{formCode}/augment");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("year", s);
        avaTaxPath.applyField("month", by);
        avaTaxPath.applyField("country", string);
        avaTaxPath.applyField("region", string2);
        avaTaxPath.applyField("formCode", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<FilingAugmentationModel>>(){}));
    }

    public ArrayList<FilingAugmentationModel> createReturnAugmentation(Integer n, Short s, Byte by, String string, String string2, String string3, ArrayList<FilingAugmentationModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filings/{year}/{month}/{country}/{region}/{formCode}/augment");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("year", s);
        avaTaxPath.applyField("month", by);
        avaTaxPath.applyField("country", string);
        avaTaxPath.applyField("region", string2);
        avaTaxPath.applyField("formCode", string3);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<FilingAugmentationModel>>(){}).call();
    }

    public Future<ArrayList<ErrorDetail>> deleteReturnAdjustmentAsync(Integer n, Long l) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filings/adjust/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}));
    }

    public ArrayList<ErrorDetail> deleteReturnAdjustment(Integer n, Long l) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filings/adjust/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", l);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}).call();
    }

    public Future<ArrayList<ErrorDetail>> deleteReturnAugmentationAsync(Integer n, Long l) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filings/augment/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}));
    }

    public ArrayList<ErrorDetail> deleteReturnAugmentation(Integer n, Long l) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filings/augment/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", l);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}).call();
    }

    public Future<FilingsCheckupModel> filingsCheckupReportAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filings/{worksheetId}/checkup");
        avaTaxPath.applyField("worksheetId", n);
        avaTaxPath.applyField("companyId", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FilingsCheckupModel>(){}));
    }

    public FilingsCheckupModel filingsCheckupReport(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filings/{worksheetId}/checkup");
        avaTaxPath.applyField("worksheetId", n);
        avaTaxPath.applyField("companyId", n2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FilingsCheckupModel>(){}).call();
    }

    public Future<FilingsCheckupModel> filingsCheckupReportsAsync(Integer n, Integer n2, Integer n3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filings/{year}/{month}/checkup");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("year", n2);
        avaTaxPath.applyField("month", n3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FilingsCheckupModel>(){}));
    }

    public FilingsCheckupModel filingsCheckupReports(Integer n, Integer n2, Integer n3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filings/{year}/{month}/checkup");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("year", n2);
        avaTaxPath.applyField("month", n3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FilingsCheckupModel>(){}).call();
    }

    public Future<HashMap<String, String>> getFilingAttachmentAsync(Integer n, Long l, Long l2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filings/{filingId}/attachment");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("filingId", l);
        avaTaxPath.addQuery("fileId", l2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<HashMap<String, String>>(){}));
    }

    public HashMap<String, String> getFilingAttachment(Integer n, Long l, Long l2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filings/{filingId}/attachment");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("filingId", l);
        avaTaxPath.addQuery("fileId", l2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<HashMap<String, String>>(){}).call();
    }

    public Future<HashMap<String, String>> getFilingAttachmentsAsync(Integer n, Short s, Byte by) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filings/{year}/{month}/attachments");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("year", s);
        avaTaxPath.applyField("month", by);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<HashMap<String, String>>(){}));
    }

    public HashMap<String, String> getFilingAttachments(Integer n, Short s, Byte by) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filings/{year}/{month}/attachments");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("year", s);
        avaTaxPath.applyField("month", by);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<HashMap<String, String>>(){}).call();
    }

    public Future<HashMap<String, String>> getFilingAttachmentsTraceFileAsync(Integer n, Short s, Byte by) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filings/{year}/{month}/attachments/tracefile");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("year", s);
        avaTaxPath.applyField("month", by);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<HashMap<String, String>>(){}));
    }

    public HashMap<String, String> getFilingAttachmentsTraceFile(Integer n, Short s, Byte by) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filings/{year}/{month}/attachments/tracefile");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("year", s);
        avaTaxPath.applyField("month", by);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<HashMap<String, String>>(){}).call();
    }

    public Future<FetchResult<FilingModel>> getFilingsAsync(Integer n, Short s, Byte by) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filings/{year}/{month}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("year", s);
        avaTaxPath.applyField("month", by);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<FilingModel>>(){}));
    }

    public FetchResult<FilingModel> getFilings(Integer n, Short s, Byte by) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filings/{year}/{month}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("year", s);
        avaTaxPath.applyField("month", by);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<FilingModel>>(){}).call();
    }

    public Future<FetchResult<FilingModel>> getFilingsByCountryAsync(Integer n, Short s, Byte by, String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filings/{year}/{month}/{country}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("year", s);
        avaTaxPath.applyField("month", by);
        avaTaxPath.applyField("country", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<FilingModel>>(){}));
    }

    public FetchResult<FilingModel> getFilingsByCountry(Integer n, Short s, Byte by, String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filings/{year}/{month}/{country}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("year", s);
        avaTaxPath.applyField("month", by);
        avaTaxPath.applyField("country", string);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<FilingModel>>(){}).call();
    }

    public Future<FetchResult<FilingModel>> getFilingsByCountryRegionAsync(Integer n, Short s, Byte by, String string, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filings/{year}/{month}/{country}/{region}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("year", s);
        avaTaxPath.applyField("month", by);
        avaTaxPath.applyField("country", string);
        avaTaxPath.applyField("region", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<FilingModel>>(){}));
    }

    public FetchResult<FilingModel> getFilingsByCountryRegion(Integer n, Short s, Byte by, String string, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filings/{year}/{month}/{country}/{region}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("year", s);
        avaTaxPath.applyField("month", by);
        avaTaxPath.applyField("country", string);
        avaTaxPath.applyField("region", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<FilingModel>>(){}).call();
    }

    public Future<FetchResult<FilingModel>> getFilingsByReturnNameAsync(Integer n, Short s, Byte by, String string, String string2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filings/{year}/{month}/{country}/{region}/{formCode}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("year", s);
        avaTaxPath.applyField("month", by);
        avaTaxPath.applyField("country", string);
        avaTaxPath.applyField("region", string2);
        avaTaxPath.applyField("formCode", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<FilingModel>>(){}));
    }

    public FetchResult<FilingModel> getFilingsByReturnName(Integer n, Short s, Byte by, String string, String string2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filings/{year}/{month}/{country}/{region}/{formCode}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("year", s);
        avaTaxPath.applyField("month", by);
        avaTaxPath.applyField("country", string);
        avaTaxPath.applyField("region", string2);
        avaTaxPath.applyField("formCode", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<FilingModel>>(){}).call();
    }

    public Future<FetchResult<FilingModel>> rebuildFilingsAsync(Integer n, Short s, Byte by, RebuildFilingsModel rebuildFilingsModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filings/{year}/{month}/rebuild");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("year", s);
        avaTaxPath.applyField("month", by);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, rebuildFilingsModel, new TypeToken<FetchResult<FilingModel>>(){}));
    }

    public FetchResult<FilingModel> rebuildFilings(Integer n, Short s, Byte by, RebuildFilingsModel rebuildFilingsModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filings/{year}/{month}/rebuild");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("year", s);
        avaTaxPath.applyField("month", by);
        return this.restCallFactory.createRestCall("post", avaTaxPath, rebuildFilingsModel, new TypeToken<FetchResult<FilingModel>>(){}).call();
    }

    public Future<FetchResult<FilingModel>> rebuildFilingsByCountryAsync(Integer n, Short s, Byte by, String string, RebuildFilingsModel rebuildFilingsModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filings/{year}/{month}/{country}/rebuild");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("year", s);
        avaTaxPath.applyField("month", by);
        avaTaxPath.applyField("country", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, rebuildFilingsModel, new TypeToken<FetchResult<FilingModel>>(){}));
    }

    public FetchResult<FilingModel> rebuildFilingsByCountry(Integer n, Short s, Byte by, String string, RebuildFilingsModel rebuildFilingsModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filings/{year}/{month}/{country}/rebuild");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("year", s);
        avaTaxPath.applyField("month", by);
        avaTaxPath.applyField("country", string);
        return this.restCallFactory.createRestCall("post", avaTaxPath, rebuildFilingsModel, new TypeToken<FetchResult<FilingModel>>(){}).call();
    }

    public Future<FetchResult<FilingModel>> rebuildFilingsByCountryRegionAsync(Integer n, Short s, Byte by, String string, String string2, RebuildFilingsModel rebuildFilingsModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filings/{year}/{month}/{country}/{region}/rebuild");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("year", s);
        avaTaxPath.applyField("month", by);
        avaTaxPath.applyField("country", string);
        avaTaxPath.applyField("region", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, rebuildFilingsModel, new TypeToken<FetchResult<FilingModel>>(){}));
    }

    public FetchResult<FilingModel> rebuildFilingsByCountryRegion(Integer n, Short s, Byte by, String string, String string2, RebuildFilingsModel rebuildFilingsModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filings/{year}/{month}/{country}/{region}/rebuild");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("year", s);
        avaTaxPath.applyField("month", by);
        avaTaxPath.applyField("country", string);
        avaTaxPath.applyField("region", string2);
        return this.restCallFactory.createRestCall("post", avaTaxPath, rebuildFilingsModel, new TypeToken<FetchResult<FilingModel>>(){}).call();
    }

    public Future<FilingAdjustmentModel> updateReturnAdjustmentAsync(Integer n, Long l, FilingAdjustmentModel filingAdjustmentModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filings/adjust/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, filingAdjustmentModel, new TypeToken<FilingAdjustmentModel>(){}));
    }

    public FilingAdjustmentModel updateReturnAdjustment(Integer n, Long l, FilingAdjustmentModel filingAdjustmentModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filings/adjust/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", l);
        return this.restCallFactory.createRestCall("put", avaTaxPath, filingAdjustmentModel, new TypeToken<FilingAdjustmentModel>(){}).call();
    }

    public Future<FilingModel> updateReturnAugmentationAsync(Integer n, Long l, FilingAugmentationModel filingAugmentationModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filings/augment/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, filingAugmentationModel, new TypeToken<FilingModel>(){}));
    }

    public FilingModel updateReturnAugmentation(Integer n, Long l, FilingAugmentationModel filingAugmentationModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filings/augment/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", l);
        return this.restCallFactory.createRestCall("put", avaTaxPath, filingAugmentationModel, new TypeToken<FilingModel>(){}).call();
    }

    public Future<NewAccountModel> requestFreeTrialAsync(FreeTrialRequestModel freeTrialRequestModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/freetrials/request");
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, freeTrialRequestModel, new TypeToken<NewAccountModel>(){}));
    }

    public NewAccountModel requestFreeTrial(FreeTrialRequestModel freeTrialRequestModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/freetrials/request");
        return this.restCallFactory.createRestCall("post", avaTaxPath, freeTrialRequestModel, new TypeToken<NewAccountModel>(){}).call();
    }

    public Future<TaxRateModel> taxRatesByAddressAsync(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/taxrates/byaddress");
        avaTaxPath.addQuery("line1", string);
        avaTaxPath.addQuery("line2", string2);
        avaTaxPath.addQuery("line3", string3);
        avaTaxPath.addQuery("city", string4);
        avaTaxPath.addQuery("region", string5);
        avaTaxPath.addQuery("postalCode", string6);
        avaTaxPath.addQuery("country", string7);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<TaxRateModel>(){}));
    }

    public TaxRateModel taxRatesByAddress(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/taxrates/byaddress");
        avaTaxPath.addQuery("line1", string);
        avaTaxPath.addQuery("line2", string2);
        avaTaxPath.addQuery("line3", string3);
        avaTaxPath.addQuery("city", string4);
        avaTaxPath.addQuery("region", string5);
        avaTaxPath.addQuery("postalCode", string6);
        avaTaxPath.addQuery("country", string7);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<TaxRateModel>(){}).call();
    }

    public Future<TaxRateModel> taxRatesByPostalCodeAsync(String string, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/taxrates/bypostalcode");
        avaTaxPath.addQuery("country", string);
        avaTaxPath.addQuery("postalCode", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<TaxRateModel>(){}));
    }

    public TaxRateModel taxRatesByPostalCode(String string, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/taxrates/bypostalcode");
        avaTaxPath.addQuery("country", string);
        avaTaxPath.addQuery("postalCode", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<TaxRateModel>(){}).call();
    }

    public Future<FundingStatusModel> activateFundingRequestAsync(Long l) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/fundingrequests/{id}/widget");
        avaTaxPath.applyField("id", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FundingStatusModel>(){}));
    }

    public FundingStatusModel activateFundingRequest(Long l) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/fundingrequests/{id}/widget");
        avaTaxPath.applyField("id", l);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FundingStatusModel>(){}).call();
    }

    public Future<FundingStatusModel> fundingRequestStatusAsync(Integer n) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/fundingrequests/{id}");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FundingStatusModel>(){}));
    }

    public FundingStatusModel fundingRequestStatus(Integer n) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/fundingrequests/{id}");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FundingStatusModel>(){}).call();
    }

    public Future<ArrayList<ItemModel>> createItemsAsync(Integer n, ArrayList<ItemModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<ItemModel>>(){}));
    }

    public ArrayList<ItemModel> createItems(Integer n, ArrayList<ItemModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<ItemModel>>(){}).call();
    }

    public Future<ArrayList<ErrorDetail>> deleteItemAsync(Integer n, Long l) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}));
    }

    public ArrayList<ErrorDetail> deleteItem(Integer n, Long l) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", l);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}).call();
    }

    public Future<ItemModel> getItemAsync(Integer n, Long l) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ItemModel>(){}));
    }

    public ItemModel getItem(Integer n, Long l) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", l);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ItemModel>(){}).call();
    }

    public Future<FetchResult<ItemModel>> listItemsByCompanyAsync(Integer n, String string, String string2, Integer n2, Integer n3, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ItemModel>>(){}));
    }

    public FetchResult<ItemModel> listItemsByCompany(Integer n, String string, String string2, Integer n2, Integer n3, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ItemModel>>(){}).call();
    }

    public Future<FetchResult<ItemModel>> queryItemsAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/items");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ItemModel>>(){}));
    }

    public FetchResult<ItemModel> queryItems(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/items");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ItemModel>>(){}).call();
    }

    public Future<ItemModel> updateItemAsync(Integer n, Long l, ItemModel itemModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, itemModel, new TypeToken<ItemModel>(){}));
    }

    public ItemModel updateItem(Integer n, Long l, ItemModel itemModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", l);
        return this.restCallFactory.createRestCall("put", avaTaxPath, itemModel, new TypeToken<ItemModel>(){}).call();
    }

    public Future<ArrayList<JurisdictionOverrideModel>> createJurisdictionOverridesAsync(Integer n, ArrayList<JurisdictionOverrideModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/jurisdictionoverrides");
        avaTaxPath.applyField("accountId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<JurisdictionOverrideModel>>(){}));
    }

    public ArrayList<JurisdictionOverrideModel> createJurisdictionOverrides(Integer n, ArrayList<JurisdictionOverrideModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/jurisdictionoverrides");
        avaTaxPath.applyField("accountId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<JurisdictionOverrideModel>>(){}).call();
    }

    public Future<ArrayList<ErrorDetail>> deleteJurisdictionOverrideAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/jurisdictionoverrides/{id}");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}));
    }

    public ArrayList<ErrorDetail> deleteJurisdictionOverride(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/jurisdictionoverrides/{id}");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}).call();
    }

    public Future<JurisdictionOverrideModel> getJurisdictionOverrideAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/jurisdictionoverrides/{id}");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<JurisdictionOverrideModel>(){}));
    }

    public JurisdictionOverrideModel getJurisdictionOverride(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/jurisdictionoverrides/{id}");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<JurisdictionOverrideModel>(){}).call();
    }

    public Future<FetchResult<JurisdictionOverrideModel>> listJurisdictionOverridesByAccountAsync(Integer n, String string, String string2, Integer n2, Integer n3, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/jurisdictionoverrides");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<JurisdictionOverrideModel>>(){}));
    }

    public FetchResult<JurisdictionOverrideModel> listJurisdictionOverridesByAccount(Integer n, String string, String string2, Integer n2, Integer n3, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/jurisdictionoverrides");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<JurisdictionOverrideModel>>(){}).call();
    }

    public Future<FetchResult<JurisdictionOverrideModel>> queryJurisdictionOverridesAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/jurisdictionoverrides");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<JurisdictionOverrideModel>>(){}));
    }

    public FetchResult<JurisdictionOverrideModel> queryJurisdictionOverrides(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/jurisdictionoverrides");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<JurisdictionOverrideModel>>(){}).call();
    }

    public Future<JurisdictionOverrideModel> updateJurisdictionOverrideAsync(Integer n, Integer n2, JurisdictionOverrideModel jurisdictionOverrideModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/jurisdictionoverrides/{id}");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, jurisdictionOverrideModel, new TypeToken<JurisdictionOverrideModel>(){}));
    }

    public JurisdictionOverrideModel updateJurisdictionOverride(Integer n, Integer n2, JurisdictionOverrideModel jurisdictionOverrideModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/jurisdictionoverrides/{id}");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("put", avaTaxPath, jurisdictionOverrideModel, new TypeToken<JurisdictionOverrideModel>(){}).call();
    }

    public Future<HashMap<String, String>> buildPointOfSaleDataForLocationAsync(Integer n, Integer n2, Date date, PointOfSaleFileType pointOfSaleFileType, PointOfSalePartnerId pointOfSalePartnerId, Boolean bl) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/locations/{id}/pointofsaledata");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        avaTaxPath.addQuery("date", date);
        avaTaxPath.addQuery("format", (Object)pointOfSaleFileType);
        avaTaxPath.addQuery("partnerId", (Object)pointOfSalePartnerId);
        avaTaxPath.addQuery("includeJurisCodes", bl);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<HashMap<String, String>>(){}));
    }

    public HashMap<String, String> buildPointOfSaleDataForLocation(Integer n, Integer n2, Date date, PointOfSaleFileType pointOfSaleFileType, PointOfSalePartnerId pointOfSalePartnerId, Boolean bl) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/locations/{id}/pointofsaledata");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        avaTaxPath.addQuery("date", date);
        avaTaxPath.addQuery("format", (Object)pointOfSaleFileType);
        avaTaxPath.addQuery("partnerId", (Object)pointOfSalePartnerId);
        avaTaxPath.addQuery("includeJurisCodes", bl);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<HashMap<String, String>>(){}).call();
    }

    public Future<ArrayList<LocationModel>> createLocationsAsync(Integer n, ArrayList<LocationModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/locations");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<LocationModel>>(){}));
    }

    public ArrayList<LocationModel> createLocations(Integer n, ArrayList<LocationModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/locations");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<LocationModel>>(){}).call();
    }

    public Future<ArrayList<ErrorDetail>> deleteLocationAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/locations/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}));
    }

    public ArrayList<ErrorDetail> deleteLocation(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/locations/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}).call();
    }

    public Future<LocationModel> getLocationAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/locations/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<LocationModel>(){}));
    }

    public LocationModel getLocation(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/locations/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<LocationModel>(){}).call();
    }

    public Future<FetchResult<LocationModel>> listLocationsByCompanyAsync(Integer n, String string, String string2, Integer n2, Integer n3, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/locations");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<LocationModel>>(){}));
    }

    public FetchResult<LocationModel> listLocationsByCompany(Integer n, String string, String string2, Integer n2, Integer n3, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/locations");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<LocationModel>>(){}).call();
    }

    public Future<FetchResult<LocationModel>> queryLocationsAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/locations");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<LocationModel>>(){}));
    }

    public FetchResult<LocationModel> queryLocations(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/locations");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<LocationModel>>(){}).call();
    }

    public Future<LocationModel> updateLocationAsync(Integer n, Integer n2, LocationModel locationModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/locations/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, locationModel, new TypeToken<LocationModel>(){}));
    }

    public LocationModel updateLocation(Integer n, Integer n2, LocationModel locationModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/locations/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("put", avaTaxPath, locationModel, new TypeToken<LocationModel>(){}).call();
    }

    public Future<LocationValidationModel> validateLocationAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/locations/{id}/validate");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<LocationValidationModel>(){}));
    }

    public LocationValidationModel validateLocation(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/locations/{id}/validate");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<LocationValidationModel>(){}).call();
    }

    public Future<ArrayList<NexusModel>> createNexusAsync(Integer n, ArrayList<NexusModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<NexusModel>>(){}));
    }

    public ArrayList<NexusModel> createNexus(Integer n, ArrayList<NexusModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<NexusModel>>(){}).call();
    }

    public Future<ArrayList<ErrorDetail>> deleteNexusAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}));
    }

    public ArrayList<ErrorDetail> deleteNexus(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}).call();
    }

    public Future<NexusModel> getNexusAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<NexusModel>(){}));
    }

    public NexusModel getNexus(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<NexusModel>(){}).call();
    }

    public Future<NexusByTaxFormModel> getNexusByFormCodeAsync(Integer n, String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus/byform/{formCode}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("formCode", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<NexusByTaxFormModel>(){}));
    }

    public NexusByTaxFormModel getNexusByFormCode(Integer n, String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus/byform/{formCode}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("formCode", string);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<NexusByTaxFormModel>(){}).call();
    }

    public Future<FetchResult<NexusModel>> listNexusByCompanyAsync(Integer n, String string, String string2, Integer n2, Integer n3, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NexusModel>>(){}));
    }

    public FetchResult<NexusModel> listNexusByCompany(Integer n, String string, String string2, Integer n2, Integer n3, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NexusModel>>(){}).call();
    }

    public Future<FetchResult<NexusModel>> queryNexusAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/nexus");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NexusModel>>(){}));
    }

    public FetchResult<NexusModel> queryNexus(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/nexus");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NexusModel>>(){}).call();
    }

    public Future<NexusModel> updateNexusAsync(Integer n, Integer n2, NexusModel nexusModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, nexusModel, new TypeToken<NexusModel>(){}));
    }

    public NexusModel updateNexus(Integer n, Integer n2, NexusModel nexusModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("put", avaTaxPath, nexusModel, new TypeToken<NexusModel>(){}).call();
    }

    public Future<ArrayList<NoticeCommentModel>> createNoticeCommentAsync(Integer n, Integer n2, ArrayList<NoticeCommentModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/notices/{id}/comments");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<NoticeCommentModel>>(){}));
    }

    public ArrayList<NoticeCommentModel> createNoticeComment(Integer n, Integer n2, ArrayList<NoticeCommentModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/notices/{id}/comments");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<NoticeCommentModel>>(){}).call();
    }

    public Future<ArrayList<NoticeFinanceModel>> createNoticeFinanceDetailsAsync(Integer n, Integer n2, ArrayList<NoticeFinanceModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/notices/{id}/financedetails");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<NoticeFinanceModel>>(){}));
    }

    public ArrayList<NoticeFinanceModel> createNoticeFinanceDetails(Integer n, Integer n2, ArrayList<NoticeFinanceModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/notices/{id}/financedetails");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<NoticeFinanceModel>>(){}).call();
    }

    public Future<ArrayList<NoticeResponsibilityDetailModel>> createNoticeResponsibilitiesAsync(Integer n, Integer n2, ArrayList<NoticeResponsibilityDetailModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/notices/{id}/responsibilities");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<NoticeResponsibilityDetailModel>>(){}));
    }

    public ArrayList<NoticeResponsibilityDetailModel> createNoticeResponsibilities(Integer n, Integer n2, ArrayList<NoticeResponsibilityDetailModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/notices/{id}/responsibilities");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<NoticeResponsibilityDetailModel>>(){}).call();
    }

    public Future<ArrayList<NoticeRootCauseDetailModel>> createNoticeRootCausesAsync(Integer n, Integer n2, ArrayList<NoticeRootCauseDetailModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/notices/{id}/rootcauses");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<NoticeRootCauseDetailModel>>(){}));
    }

    public ArrayList<NoticeRootCauseDetailModel> createNoticeRootCauses(Integer n, Integer n2, ArrayList<NoticeRootCauseDetailModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/notices/{id}/rootcauses");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<NoticeRootCauseDetailModel>>(){}).call();
    }

    public Future<ArrayList<NoticeModel>> createNoticesAsync(Integer n, ArrayList<NoticeModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/notices");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<NoticeModel>>(){}));
    }

    public ArrayList<NoticeModel> createNotices(Integer n, ArrayList<NoticeModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/notices");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<NoticeModel>>(){}).call();
    }

    public Future<ArrayList<ErrorDetail>> deleteNoticeAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/notices/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}));
    }

    public ArrayList<ErrorDetail> deleteNotice(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/notices/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}).call();
    }

    public Future<HashMap<String, String>> downloadNoticeAttachmentAsync(Integer n, Long l) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/notices/files/{id}/attachment");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<HashMap<String, String>>(){}));
    }

    public HashMap<String, String> downloadNoticeAttachment(Integer n, Long l) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/notices/files/{id}/attachment");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", l);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<HashMap<String, String>>(){}).call();
    }

    public Future<NoticeModel> getNoticeAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/notices/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<NoticeModel>(){}));
    }

    public NoticeModel getNotice(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/notices/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<NoticeModel>(){}).call();
    }

    public Future<FetchResult<NoticeCommentModel>> getNoticeCommentsAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/notices/{id}/comments");
        avaTaxPath.applyField("id", n);
        avaTaxPath.applyField("companyId", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeCommentModel>>(){}));
    }

    public FetchResult<NoticeCommentModel> getNoticeComments(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/notices/{id}/comments");
        avaTaxPath.applyField("id", n);
        avaTaxPath.applyField("companyId", n2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeCommentModel>>(){}).call();
    }

    public Future<FetchResult<NoticeFinanceModel>> getNoticeFinanceDetailsAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/notices/{id}/financedetails");
        avaTaxPath.applyField("id", n);
        avaTaxPath.applyField("companyId", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeFinanceModel>>(){}));
    }

    public FetchResult<NoticeFinanceModel> getNoticeFinanceDetails(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/notices/{id}/financedetails");
        avaTaxPath.applyField("id", n);
        avaTaxPath.applyField("companyId", n2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeFinanceModel>>(){}).call();
    }

    public Future<FetchResult<NoticeResponsibilityDetailModel>> getNoticeResponsibilitiesAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/notices/{id}/responsibilities");
        avaTaxPath.applyField("id", n);
        avaTaxPath.applyField("companyId", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeResponsibilityDetailModel>>(){}));
    }

    public FetchResult<NoticeResponsibilityDetailModel> getNoticeResponsibilities(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/notices/{id}/responsibilities");
        avaTaxPath.applyField("id", n);
        avaTaxPath.applyField("companyId", n2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeResponsibilityDetailModel>>(){}).call();
    }

    public Future<FetchResult<NoticeRootCauseDetailModel>> getNoticeRootCausesAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/notices/{id}/rootcauses");
        avaTaxPath.applyField("id", n);
        avaTaxPath.applyField("companyId", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeRootCauseDetailModel>>(){}));
    }

    public FetchResult<NoticeRootCauseDetailModel> getNoticeRootCauses(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/notices/{id}/rootcauses");
        avaTaxPath.applyField("id", n);
        avaTaxPath.applyField("companyId", n2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeRootCauseDetailModel>>(){}).call();
    }

    public Future<FetchResult<NoticeModel>> listNoticesByCompanyAsync(Integer n, String string, String string2, Integer n2, Integer n3, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/notices");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeModel>>(){}));
    }

    public FetchResult<NoticeModel> listNoticesByCompany(Integer n, String string, String string2, Integer n2, Integer n3, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/notices");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeModel>>(){}).call();
    }

    public Future<FetchResult<NoticeModel>> queryNoticesAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/notices");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeModel>>(){}));
    }

    public FetchResult<NoticeModel> queryNotices(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/notices");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeModel>>(){}).call();
    }

    public Future<NoticeModel> updateNoticeAsync(Integer n, Integer n2, NoticeModel noticeModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/notices/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, noticeModel, new TypeToken<NoticeModel>(){}));
    }

    public NoticeModel updateNotice(Integer n, Integer n2, NoticeModel noticeModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/notices/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("put", avaTaxPath, noticeModel, new TypeToken<NoticeModel>(){}).call();
    }

    public Future<String> uploadAttachmentAsync(Integer n, ResourceFileUploadRequestModel resourceFileUploadRequestModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/notices/files/attachment");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, resourceFileUploadRequestModel, new TypeToken<String>(){}));
    }

    public String uploadAttachment(Integer n, ResourceFileUploadRequestModel resourceFileUploadRequestModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/notices/files/attachment");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, resourceFileUploadRequestModel, new TypeToken<String>(){}).call();
    }

    public Future<NewAccountModel> requestNewAccountAsync(NewAccountRequestModel newAccountRequestModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/request");
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, newAccountRequestModel, new TypeToken<NewAccountModel>(){}));
    }

    public NewAccountModel requestNewAccount(NewAccountRequestModel newAccountRequestModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/request");
        return this.restCallFactory.createRestCall("post", avaTaxPath, newAccountRequestModel, new TypeToken<NewAccountModel>(){}).call();
    }

    public Future<HashMap<String, String>> buildPointOfSaleDataFileAsync(PointOfSaleDataRequestModel pointOfSaleDataRequestModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/pointofsaledata/build");
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, pointOfSaleDataRequestModel, new TypeToken<HashMap<String, String>>(){}));
    }

    public HashMap<String, String> buildPointOfSaleDataFile(PointOfSaleDataRequestModel pointOfSaleDataRequestModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/pointofsaledata/build");
        return this.restCallFactory.createRestCall("post", avaTaxPath, pointOfSaleDataRequestModel, new TypeToken<HashMap<String, String>>(){}).call();
    }

    public Future<String> changePasswordAsync(PasswordChangeModel passwordChangeModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/passwords");
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, passwordChangeModel, new TypeToken<String>(){}));
    }

    public String changePassword(PasswordChangeModel passwordChangeModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/passwords");
        return this.restCallFactory.createRestCall("put", avaTaxPath, passwordChangeModel, new TypeToken<String>(){}).call();
    }

    public Future<AccountModel> createAccountAsync(AccountModel accountModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts");
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, accountModel, new TypeToken<AccountModel>(){}));
    }

    public AccountModel createAccount(AccountModel accountModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts");
        return this.restCallFactory.createRestCall("post", avaTaxPath, accountModel, new TypeToken<AccountModel>(){}).call();
    }

    public Future<ArrayList<SubscriptionModel>> createSubscriptionsAsync(Integer n, ArrayList<SubscriptionModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/subscriptions");
        avaTaxPath.applyField("accountId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<SubscriptionModel>>(){}));
    }

    public ArrayList<SubscriptionModel> createSubscriptions(Integer n, ArrayList<SubscriptionModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/subscriptions");
        avaTaxPath.applyField("accountId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<SubscriptionModel>>(){}).call();
    }

    public Future<ArrayList<UserModel>> createUsersAsync(Integer n, ArrayList<UserModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/users");
        avaTaxPath.applyField("accountId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<UserModel>>(){}));
    }

    public ArrayList<UserModel> createUsers(Integer n, ArrayList<UserModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/users");
        avaTaxPath.applyField("accountId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<UserModel>>(){}).call();
    }

    public Future<ArrayList<ErrorDetail>> deleteAccountAsync(Integer n) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}));
    }

    public ArrayList<ErrorDetail> deleteAccount(Integer n) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}).call();
    }

    public Future<ArrayList<ErrorDetail>> deleteSubscriptionAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/subscriptions/{id}");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}));
    }

    public ArrayList<ErrorDetail> deleteSubscription(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/subscriptions/{id}");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}).call();
    }

    public Future<ArrayList<ErrorDetail>> deleteUserAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/users/{id}");
        avaTaxPath.applyField("id", n);
        avaTaxPath.applyField("accountId", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}));
    }

    public ArrayList<ErrorDetail> deleteUser(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/users/{id}");
        avaTaxPath.applyField("id", n);
        avaTaxPath.applyField("accountId", n2);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}).call();
    }

    public Future<FetchResult<AccountModel>> queryAccountsAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts");
        avaTaxPath.addQuery("$include", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<AccountModel>>(){}));
    }

    public FetchResult<AccountModel> queryAccounts(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts");
        avaTaxPath.addQuery("$include", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<AccountModel>>(){}).call();
    }

    public Future<String> resetPasswordAsync(Integer n, SetPasswordModel setPasswordModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/passwords/{userId}/reset");
        avaTaxPath.applyField("userId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, setPasswordModel, new TypeToken<String>(){}));
    }

    public String resetPassword(Integer n, SetPasswordModel setPasswordModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/passwords/{userId}/reset");
        avaTaxPath.applyField("userId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, setPasswordModel, new TypeToken<String>(){}).call();
    }

    public Future<AccountModel> updateAccountAsync(Integer n, AccountModel accountModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, accountModel, new TypeToken<AccountModel>(){}));
    }

    public AccountModel updateAccount(Integer n, AccountModel accountModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("put", avaTaxPath, accountModel, new TypeToken<AccountModel>(){}).call();
    }

    public Future<SubscriptionModel> updateSubscriptionAsync(Integer n, Integer n2, SubscriptionModel subscriptionModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/subscriptions/{id}");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, subscriptionModel, new TypeToken<SubscriptionModel>(){}));
    }

    public SubscriptionModel updateSubscription(Integer n, Integer n2, SubscriptionModel subscriptionModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/subscriptions/{id}");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("put", avaTaxPath, subscriptionModel, new TypeToken<SubscriptionModel>(){}).call();
    }

    public Future<ArrayList<SettingModel>> createSettingsAsync(Integer n, ArrayList<SettingModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/settings");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<SettingModel>>(){}));
    }

    public ArrayList<SettingModel> createSettings(Integer n, ArrayList<SettingModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/settings");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<SettingModel>>(){}).call();
    }

    public Future<ArrayList<ErrorDetail>> deleteSettingAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/settings/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}));
    }

    public ArrayList<ErrorDetail> deleteSetting(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/settings/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}).call();
    }

    public Future<SettingModel> getSettingAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/settings/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<SettingModel>(){}));
    }

    public SettingModel getSetting(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/settings/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<SettingModel>(){}).call();
    }

    public Future<FetchResult<SettingModel>> listSettingsByCompanyAsync(Integer n, String string, String string2, Integer n2, Integer n3, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/settings");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SettingModel>>(){}));
    }

    public FetchResult<SettingModel> listSettingsByCompany(Integer n, String string, String string2, Integer n2, Integer n3, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/settings");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SettingModel>>(){}).call();
    }

    public Future<FetchResult<SettingModel>> querySettingsAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/settings");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SettingModel>>(){}));
    }

    public FetchResult<SettingModel> querySettings(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/settings");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SettingModel>>(){}).call();
    }

    public Future<SettingModel> updateSettingAsync(Integer n, Integer n2, SettingModel settingModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/settings/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, settingModel, new TypeToken<SettingModel>(){}));
    }

    public SettingModel updateSetting(Integer n, Integer n2, SettingModel settingModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/settings/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("put", avaTaxPath, settingModel, new TypeToken<SettingModel>(){}).call();
    }

    public Future<SubscriptionModel> getSubscriptionAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/subscriptions/{id}");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<SubscriptionModel>(){}));
    }

    public SubscriptionModel getSubscription(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/subscriptions/{id}");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<SubscriptionModel>(){}).call();
    }

    public Future<FetchResult<SubscriptionModel>> listSubscriptionsByAccountAsync(Integer n, String string, Integer n2, Integer n3, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/subscriptions");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SubscriptionModel>>(){}));
    }

    public FetchResult<SubscriptionModel> listSubscriptionsByAccount(Integer n, String string, Integer n2, Integer n3, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/subscriptions");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SubscriptionModel>>(){}).call();
    }

    public Future<FetchResult<SubscriptionModel>> querySubscriptionsAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/subscriptions");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SubscriptionModel>>(){}));
    }

    public FetchResult<SubscriptionModel> querySubscriptions(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/subscriptions");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SubscriptionModel>>(){}).call();
    }

    public Future<ArrayList<TaxCodeModel>> createTaxCodesAsync(Integer n, ArrayList<TaxCodeModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxcodes");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<TaxCodeModel>>(){}));
    }

    public ArrayList<TaxCodeModel> createTaxCodes(Integer n, ArrayList<TaxCodeModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxcodes");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<TaxCodeModel>>(){}).call();
    }

    public Future<ArrayList<ErrorDetail>> deleteTaxCodeAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxcodes/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}));
    }

    public ArrayList<ErrorDetail> deleteTaxCode(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxcodes/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}).call();
    }

    public Future<TaxCodeModel> getTaxCodeAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxcodes/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<TaxCodeModel>(){}));
    }

    public TaxCodeModel getTaxCode(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxcodes/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<TaxCodeModel>(){}).call();
    }

    public Future<FetchResult<TaxCodeModel>> listTaxCodesByCompanyAsync(Integer n, String string, String string2, Integer n2, Integer n3, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxcodes");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxCodeModel>>(){}));
    }

    public FetchResult<TaxCodeModel> listTaxCodesByCompany(Integer n, String string, String string2, Integer n2, Integer n3, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxcodes");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxCodeModel>>(){}).call();
    }

    public Future<FetchResult<TaxCodeModel>> queryTaxCodesAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/taxcodes");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxCodeModel>>(){}));
    }

    public FetchResult<TaxCodeModel> queryTaxCodes(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/taxcodes");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxCodeModel>>(){}).call();
    }

    public Future<TaxCodeModel> updateTaxCodeAsync(Integer n, Integer n2, TaxCodeModel taxCodeModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxcodes/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, taxCodeModel, new TypeToken<TaxCodeModel>(){}));
    }

    public TaxCodeModel updateTaxCode(Integer n, Integer n2, TaxCodeModel taxCodeModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxcodes/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("put", avaTaxPath, taxCodeModel, new TypeToken<TaxCodeModel>(){}).call();
    }

    public Future<ArrayList<TaxRuleModel>> createTaxRulesAsync(Integer n, ArrayList<TaxRuleModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxrules");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<TaxRuleModel>>(){}));
    }

    public ArrayList<TaxRuleModel> createTaxRules(Integer n, ArrayList<TaxRuleModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxrules");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<TaxRuleModel>>(){}).call();
    }

    public Future<ArrayList<ErrorDetail>> deleteTaxRuleAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxrules/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}));
    }

    public ArrayList<ErrorDetail> deleteTaxRule(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxrules/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}).call();
    }

    public Future<TaxRuleModel> getTaxRuleAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxrules/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<TaxRuleModel>(){}));
    }

    public TaxRuleModel getTaxRule(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxrules/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<TaxRuleModel>(){}).call();
    }

    public Future<FetchResult<TaxRuleModel>> listTaxRulesAsync(Integer n, String string, String string2, Integer n2, Integer n3, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxrules");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxRuleModel>>(){}));
    }

    public FetchResult<TaxRuleModel> listTaxRules(Integer n, String string, String string2, Integer n2, Integer n3, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxrules");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxRuleModel>>(){}).call();
    }

    public Future<FetchResult<TaxRuleModel>> queryTaxRulesAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/taxrules");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxRuleModel>>(){}));
    }

    public FetchResult<TaxRuleModel> queryTaxRules(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/taxrules");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxRuleModel>>(){}).call();
    }

    public Future<TaxRuleModel> updateTaxRuleAsync(Integer n, Integer n2, TaxRuleModel taxRuleModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxrules/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, taxRuleModel, new TypeToken<TaxRuleModel>(){}));
    }

    public TaxRuleModel updateTaxRule(Integer n, Integer n2, TaxRuleModel taxRuleModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxrules/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("put", avaTaxPath, taxRuleModel, new TypeToken<TaxRuleModel>(){}).call();
    }

    public Future<TransactionModel> addLinesAsync(String string, AddTransactionLineModel addTransactionLineModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/transactions/lines/add");
        avaTaxPath.addQuery("$include", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, addTransactionLineModel, new TypeToken<TransactionModel>(){}));
    }

    public TransactionModel addLines(String string, AddTransactionLineModel addTransactionLineModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/transactions/lines/add");
        avaTaxPath.addQuery("$include", string);
        return this.restCallFactory.createRestCall("post", avaTaxPath, addTransactionLineModel, new TypeToken<TransactionModel>(){}).call();
    }

    public Future<TransactionModel> adjustTransactionAsync(String string, String string2, AdjustTransactionModel adjustTransactionModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/adjust");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, adjustTransactionModel, new TypeToken<TransactionModel>(){}));
    }

    public TransactionModel adjustTransaction(String string, String string2, AdjustTransactionModel adjustTransactionModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/adjust");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        return this.restCallFactory.createRestCall("post", avaTaxPath, adjustTransactionModel, new TypeToken<TransactionModel>(){}).call();
    }

    public Future<AuditTransactionModel> auditTransactionAsync(String string, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/audit");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<AuditTransactionModel>(){}));
    }

    public AuditTransactionModel auditTransaction(String string, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/audit");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<AuditTransactionModel>(){}).call();
    }

    public Future<AuditTransactionModel> auditTransactionWithTypeAsync(String string, String string2, DocumentType documentType) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/types/{documentType}/audit");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.applyField("documentType", (Object)documentType);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<AuditTransactionModel>(){}));
    }

    public AuditTransactionModel auditTransactionWithType(String string, String string2, DocumentType documentType) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/types/{documentType}/audit");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.applyField("documentType", (Object)documentType);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<AuditTransactionModel>(){}).call();
    }

    public Future<BulkLockTransactionResult> bulkLockTransactionAsync(BulkLockTransactionModel bulkLockTransactionModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/lock");
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, bulkLockTransactionModel, new TypeToken<BulkLockTransactionResult>(){}));
    }

    public BulkLockTransactionResult bulkLockTransaction(BulkLockTransactionModel bulkLockTransactionModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/lock");
        return this.restCallFactory.createRestCall("post", avaTaxPath, bulkLockTransactionModel, new TypeToken<BulkLockTransactionResult>(){}).call();
    }

    public Future<TransactionModel> changeTransactionCodeAsync(String string, String string2, ChangeTransactionCodeModel changeTransactionCodeModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/changecode");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, changeTransactionCodeModel, new TypeToken<TransactionModel>(){}));
    }

    public TransactionModel changeTransactionCode(String string, String string2, ChangeTransactionCodeModel changeTransactionCodeModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/changecode");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        return this.restCallFactory.createRestCall("post", avaTaxPath, changeTransactionCodeModel, new TypeToken<TransactionModel>(){}).call();
    }

    public Future<TransactionModel> commitTransactionAsync(String string, String string2, CommitTransactionModel commitTransactionModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/commit");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, commitTransactionModel, new TypeToken<TransactionModel>(){}));
    }

    public TransactionModel commitTransaction(String string, String string2, CommitTransactionModel commitTransactionModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/commit");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        return this.restCallFactory.createRestCall("post", avaTaxPath, commitTransactionModel, new TypeToken<TransactionModel>(){}).call();
    }

    public Future<TransactionModel> createOrAdjustTransactionAsync(String string, CreateOrAdjustTransactionModel createOrAdjustTransactionModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/createoradjust");
        avaTaxPath.addQuery("$include", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, createOrAdjustTransactionModel, new TypeToken<TransactionModel>(){}));
    }

    public TransactionModel createOrAdjustTransaction(String string, CreateOrAdjustTransactionModel createOrAdjustTransactionModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/createoradjust");
        avaTaxPath.addQuery("$include", string);
        return this.restCallFactory.createRestCall("post", avaTaxPath, createOrAdjustTransactionModel, new TypeToken<TransactionModel>(){}).call();
    }

    public Future<TransactionModel> createTransactionAsync(String string, CreateTransactionModel createTransactionModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/create");
        avaTaxPath.addQuery("$include", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, createTransactionModel, new TypeToken<TransactionModel>(){}));
    }

    public TransactionModel createTransaction(String string, CreateTransactionModel createTransactionModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/create");
        avaTaxPath.addQuery("$include", string);
        return this.restCallFactory.createRestCall("post", avaTaxPath, createTransactionModel, new TypeToken<TransactionModel>(){}).call();
    }

    public Future<TransactionModel> deleteLinesAsync(String string, RemoveTransactionLineModel removeTransactionLineModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/transactions/lines/delete");
        avaTaxPath.addQuery("$include", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, removeTransactionLineModel, new TypeToken<TransactionModel>(){}));
    }

    public TransactionModel deleteLines(String string, RemoveTransactionLineModel removeTransactionLineModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/transactions/lines/delete");
        avaTaxPath.addQuery("$include", string);
        return this.restCallFactory.createRestCall("post", avaTaxPath, removeTransactionLineModel, new TypeToken<TransactionModel>(){}).call();
    }

    public Future<TransactionModel> getTransactionByCodeAsync(String string, String string2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("$include", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<TransactionModel>(){}));
    }

    public TransactionModel getTransactionByCode(String string, String string2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("$include", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<TransactionModel>(){}).call();
    }

    public Future<TransactionModel> getTransactionByCodeAndTypeAsync(String string, String string2, DocumentType documentType, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/types/{documentType}");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.applyField("documentType", (Object)documentType);
        avaTaxPath.addQuery("$include", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<TransactionModel>(){}));
    }

    public TransactionModel getTransactionByCodeAndType(String string, String string2, DocumentType documentType, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/types/{documentType}");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.applyField("documentType", (Object)documentType);
        avaTaxPath.addQuery("$include", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<TransactionModel>(){}).call();
    }

    public Future<TransactionModel> getTransactionByIdAsync(Long l, String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/{id}");
        avaTaxPath.applyField("id", l);
        avaTaxPath.addQuery("$include", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<TransactionModel>(){}));
    }

    public TransactionModel getTransactionById(Long l, String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/{id}");
        avaTaxPath.applyField("id", l);
        avaTaxPath.addQuery("$include", string);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<TransactionModel>(){}).call();
    }

    public Future<FetchResult<TransactionModel>> listTransactionsByCompanyAsync(String string, String string2, String string3, Integer n, Integer n2, String string4) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$filter", string3);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string4);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TransactionModel>>(){}));
    }

    public FetchResult<TransactionModel> listTransactionsByCompany(String string, String string2, String string3, Integer n, Integer n2, String string4) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$filter", string3);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string4);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TransactionModel>>(){}).call();
    }

    public Future<TransactionModel> lockTransactionAsync(String string, String string2, LockTransactionModel lockTransactionModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/lock");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, lockTransactionModel, new TypeToken<TransactionModel>(){}));
    }

    public TransactionModel lockTransaction(String string, String string2, LockTransactionModel lockTransactionModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/lock");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        return this.restCallFactory.createRestCall("post", avaTaxPath, lockTransactionModel, new TypeToken<TransactionModel>(){}).call();
    }

    public Future<TransactionModel> refundTransactionAsync(String string, String string2, String string3, RefundTransactionModel refundTransactionModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/refund");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("$include", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, refundTransactionModel, new TypeToken<TransactionModel>(){}));
    }

    public TransactionModel refundTransaction(String string, String string2, String string3, RefundTransactionModel refundTransactionModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/refund");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("$include", string3);
        return this.restCallFactory.createRestCall("post", avaTaxPath, refundTransactionModel, new TypeToken<TransactionModel>(){}).call();
    }

    public Future<TransactionModel> settleTransactionAsync(String string, String string2, SettleTransactionModel settleTransactionModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/settle");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, settleTransactionModel, new TypeToken<TransactionModel>(){}));
    }

    public TransactionModel settleTransaction(String string, String string2, SettleTransactionModel settleTransactionModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/settle");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        return this.restCallFactory.createRestCall("post", avaTaxPath, settleTransactionModel, new TypeToken<TransactionModel>(){}).call();
    }

    public Future<TransactionModel> verifyTransactionAsync(String string, String string2, VerifyTransactionModel verifyTransactionModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/verify");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, verifyTransactionModel, new TypeToken<TransactionModel>(){}));
    }

    public TransactionModel verifyTransaction(String string, String string2, VerifyTransactionModel verifyTransactionModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/verify");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        return this.restCallFactory.createRestCall("post", avaTaxPath, verifyTransactionModel, new TypeToken<TransactionModel>(){}).call();
    }

    public Future<TransactionModel> voidTransactionAsync(String string, String string2, VoidTransactionModel voidTransactionModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/void");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, voidTransactionModel, new TypeToken<TransactionModel>(){}));
    }

    public TransactionModel voidTransaction(String string, String string2, VoidTransactionModel voidTransactionModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/void");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        return this.restCallFactory.createRestCall("post", avaTaxPath, voidTransactionModel, new TypeToken<TransactionModel>(){}).call();
    }

    public Future<ArrayList<UPCModel>> createUPCsAsync(Integer n, ArrayList<UPCModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/upcs");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<UPCModel>>(){}));
    }

    public ArrayList<UPCModel> createUPCs(Integer n, ArrayList<UPCModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/upcs");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<UPCModel>>(){}).call();
    }

    public Future<ArrayList<ErrorDetail>> deleteUPCAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/upcs/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}));
    }

    public ArrayList<ErrorDetail> deleteUPC(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/upcs/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}).call();
    }

    public Future<UPCModel> getUPCAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/upcs/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<UPCModel>(){}));
    }

    public UPCModel getUPC(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/upcs/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<UPCModel>(){}).call();
    }

    public Future<FetchResult<UPCModel>> listUPCsByCompanyAsync(Integer n, String string, String string2, Integer n2, Integer n3, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/upcs");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<UPCModel>>(){}));
    }

    public FetchResult<UPCModel> listUPCsByCompany(Integer n, String string, String string2, Integer n2, Integer n3, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/upcs");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<UPCModel>>(){}).call();
    }

    public Future<FetchResult<UPCModel>> queryUPCsAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/upcs");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<UPCModel>>(){}));
    }

    public FetchResult<UPCModel> queryUPCs(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/upcs");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<UPCModel>>(){}).call();
    }

    public Future<UPCModel> updateUPCAsync(Integer n, Integer n2, UPCModel uPCModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/upcs/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, uPCModel, new TypeToken<UPCModel>(){}));
    }

    public UPCModel updateUPC(Integer n, Integer n2, UPCModel uPCModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/upcs/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("put", avaTaxPath, uPCModel, new TypeToken<UPCModel>(){}).call();
    }

    public Future<UserModel> getUserAsync(Integer n, Integer n2, String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/users/{id}");
        avaTaxPath.applyField("id", n);
        avaTaxPath.applyField("accountId", n2);
        avaTaxPath.addQuery("$include", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<UserModel>(){}));
    }

    public UserModel getUser(Integer n, Integer n2, String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/users/{id}");
        avaTaxPath.applyField("id", n);
        avaTaxPath.applyField("accountId", n2);
        avaTaxPath.addQuery("$include", string);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<UserModel>(){}).call();
    }

    public Future<UserEntitlementModel> getUserEntitlementsAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/users/{id}/entitlements");
        avaTaxPath.applyField("id", n);
        avaTaxPath.applyField("accountId", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<UserEntitlementModel>(){}));
    }

    public UserEntitlementModel getUserEntitlements(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/users/{id}/entitlements");
        avaTaxPath.applyField("id", n);
        avaTaxPath.applyField("accountId", n2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<UserEntitlementModel>(){}).call();
    }

    public Future<FetchResult<UserModel>> listUsersByAccountAsync(Integer n, String string, String string2, Integer n2, Integer n3, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/users");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.addQuery("$include", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<UserModel>>(){}));
    }

    public FetchResult<UserModel> listUsersByAccount(Integer n, String string, String string2, Integer n2, Integer n3, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/users");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.addQuery("$include", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<UserModel>>(){}).call();
    }

    public Future<FetchResult<UserModel>> queryUsersAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/users");
        avaTaxPath.addQuery("$include", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<UserModel>>(){}));
    }

    public FetchResult<UserModel> queryUsers(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/users");
        avaTaxPath.addQuery("$include", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<UserModel>>(){}).call();
    }

    public Future<UserModel> updateUserAsync(Integer n, Integer n2, UserModel userModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/users/{id}");
        avaTaxPath.applyField("id", n);
        avaTaxPath.applyField("accountId", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, userModel, new TypeToken<UserModel>(){}));
    }

    public UserModel updateUser(Integer n, Integer n2, UserModel userModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/users/{id}");
        avaTaxPath.applyField("id", n);
        avaTaxPath.applyField("accountId", n2);
        return this.restCallFactory.createRestCall("put", avaTaxPath, userModel, new TypeToken<UserModel>(){}).call();
    }

    public Future<SubscriptionModel> getMySubscriptionAsync(ServiceTypeId serviceTypeId) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/utilities/subscriptions/{serviceTypeId}");
        avaTaxPath.applyField("serviceTypeId", (Object)serviceTypeId);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<SubscriptionModel>(){}));
    }

    public SubscriptionModel getMySubscription(ServiceTypeId serviceTypeId) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/utilities/subscriptions/{serviceTypeId}");
        avaTaxPath.applyField("serviceTypeId", (Object)serviceTypeId);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<SubscriptionModel>(){}).call();
    }

    public Future<FetchResult<SubscriptionModel>> listMySubscriptionsAsync() {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/utilities/subscriptions");
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SubscriptionModel>>(){}));
    }

    public FetchResult<SubscriptionModel> listMySubscriptions() throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/utilities/subscriptions");
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SubscriptionModel>>(){}).call();
    }

    public Future<PingResultModel> pingAsync() {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/utilities/ping");
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<PingResultModel>(){}));
    }

    public PingResultModel ping() throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/utilities/ping");
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<PingResultModel>(){}).call();
    }
}

