/*
 * Decompiled with CFR 0.152.
 */
package net.avalara.avatax.rest.client;

import com.google.gson.reflect.TypeToken;
import net.avalara.avatax.rest.client.AvaTaxPath;
import net.avalara.avatax.rest.client.RestCall;

public class RestCallFactory {
    private String appName;
    private String appVersion;
    private String machineName;
    private String environmentUrl;
    private String header;
    private String proxyHost;
    private int proxyPort;
    private String proxySchema;

    public RestCallFactory(String appName, String appVersion, String machineName, String environmentUrl) {
        this.appName = appName;
        this.appVersion = appVersion;
        this.machineName = machineName;
        this.environmentUrl = environmentUrl;
    }

    public RestCallFactory(String appName, String appVersion, String machineName, String environmentUrl, String proxyHost, int proxyPort, String proxySchema) {
        this(appName, appVersion, machineName, environmentUrl);
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.proxySchema = proxySchema;
    }

    public <T> RestCall<T> createRestCall(String method, AvaTaxPath path, Object model, TypeToken<T> typeToken) {
        if (this.header != null) {
            if (this.proxyHost == null) {
                return new RestCall<T>(this.appName, this.appVersion, this.machineName, this.environmentUrl, this.header, method, path, model, typeToken);
            }
            return new RestCall<T>(this.appName, this.appVersion, this.machineName, this.environmentUrl, this.header, method, path, model, typeToken, this.proxyHost, this.proxyPort, this.proxySchema);
        }
        if (this.proxyHost == null) {
            return new RestCall<T>(this.appName, this.appVersion, this.machineName, this.environmentUrl, method, path, model, typeToken);
        }
        return new RestCall<T>(this.appName, this.appVersion, this.machineName, this.environmentUrl, method, path, model, typeToken, this.proxyHost, this.proxyPort, this.proxySchema);
    }

    public void addSecurityHeader(String header) {
        this.header = header;
    }
}

