/*
 * Decompiled with CFR 0.152.
 */
package net.avalara.avatax.rest.client;

import com.google.gson.reflect.TypeToken;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.avalara.avatax.rest.client.AvaTaxConstants;
import net.avalara.avatax.rest.client.AvaTaxPath;
import net.avalara.avatax.rest.client.FetchResult;
import net.avalara.avatax.rest.client.RestCallFactory;
import net.avalara.avatax.rest.client.enums.AvaTaxEnvironment;
import net.avalara.avatax.rest.client.enums.CertificatePreviewType;
import net.avalara.avatax.rest.client.enums.DocumentType;
import net.avalara.avatax.rest.client.enums.FilingFrequencyId;
import net.avalara.avatax.rest.client.enums.FilingStatusId;
import net.avalara.avatax.rest.client.enums.PointOfSaleFileType;
import net.avalara.avatax.rest.client.enums.PointOfSalePartnerId;
import net.avalara.avatax.rest.client.enums.TextCase;
import net.avalara.avatax.rest.client.models.AccountConfigurationModel;
import net.avalara.avatax.rest.client.models.AccountLicenseKeyModel;
import net.avalara.avatax.rest.client.models.AccountModel;
import net.avalara.avatax.rest.client.models.ActivateAccountModel;
import net.avalara.avatax.rest.client.models.AddTransactionLineModel;
import net.avalara.avatax.rest.client.models.AddressResolutionModel;
import net.avalara.avatax.rest.client.models.AddressValidationInfo;
import net.avalara.avatax.rest.client.models.AdjustMultiDocumentModel;
import net.avalara.avatax.rest.client.models.AdjustTransactionModel;
import net.avalara.avatax.rest.client.models.AdvancedRuleLookupFileModel;
import net.avalara.avatax.rest.client.models.AuditModel;
import net.avalara.avatax.rest.client.models.AuditMultiDocumentModel;
import net.avalara.avatax.rest.client.models.AuditTransactionModel;
import net.avalara.avatax.rest.client.models.AvaFileFormModel;
import net.avalara.avatax.rest.client.models.BatchModel;
import net.avalara.avatax.rest.client.models.BulkLockTransactionModel;
import net.avalara.avatax.rest.client.models.BulkLockTransactionResult;
import net.avalara.avatax.rest.client.models.CertExpressInvitationModel;
import net.avalara.avatax.rest.client.models.CertExpressInvitationStatusModel;
import net.avalara.avatax.rest.client.models.CertificateAttributeModel;
import net.avalara.avatax.rest.client.models.CertificateModel;
import net.avalara.avatax.rest.client.models.ChangeTransactionCodeModel;
import net.avalara.avatax.rest.client.models.CommitMultiDocumentModel;
import net.avalara.avatax.rest.client.models.CommitTransactionModel;
import net.avalara.avatax.rest.client.models.CommunicationsTSPairModel;
import net.avalara.avatax.rest.client.models.CommunicationsTransactionTypeModel;
import net.avalara.avatax.rest.client.models.CompanyConfigurationModel;
import net.avalara.avatax.rest.client.models.CompanyDistanceThresholdModel;
import net.avalara.avatax.rest.client.models.CompanyInitializationModel;
import net.avalara.avatax.rest.client.models.CompanyModel;
import net.avalara.avatax.rest.client.models.CompanyReturnSettingModel;
import net.avalara.avatax.rest.client.models.ContactModel;
import net.avalara.avatax.rest.client.models.CoverLetterModel;
import net.avalara.avatax.rest.client.models.CreateCertExpressInvitationModel;
import net.avalara.avatax.rest.client.models.CreateMultiDocumentModel;
import net.avalara.avatax.rest.client.models.CreateOrAdjustTransactionModel;
import net.avalara.avatax.rest.client.models.CreateTransactionBatchRequestModel;
import net.avalara.avatax.rest.client.models.CreateTransactionBatchResponseModel;
import net.avalara.avatax.rest.client.models.CreateTransactionModel;
import net.avalara.avatax.rest.client.models.CurrencyModel;
import net.avalara.avatax.rest.client.models.CustomerAttributeModel;
import net.avalara.avatax.rest.client.models.CustomerModel;
import net.avalara.avatax.rest.client.models.DataSourceModel;
import net.avalara.avatax.rest.client.models.DeclareNexusByAddressModel;
import net.avalara.avatax.rest.client.models.EntityUseCodeModel;
import net.avalara.avatax.rest.client.models.ErrorDetail;
import net.avalara.avatax.rest.client.models.ExemptionReasonModel;
import net.avalara.avatax.rest.client.models.ExemptionStatusModel;
import net.avalara.avatax.rest.client.models.ExportDocumentLineModel;
import net.avalara.avatax.rest.client.models.ExposureZoneModel;
import net.avalara.avatax.rest.client.models.FiledReturnModel;
import net.avalara.avatax.rest.client.models.FilingFrequencyModel;
import net.avalara.avatax.rest.client.models.FilingStatusChangeModel;
import net.avalara.avatax.rest.client.models.FirmClientLinkageInputModel;
import net.avalara.avatax.rest.client.models.FirmClientLinkageOutputModel;
import net.avalara.avatax.rest.client.models.FormMasterModel;
import net.avalara.avatax.rest.client.models.FreeTrialRequestModel;
import net.avalara.avatax.rest.client.models.FundingConfigurationModel;
import net.avalara.avatax.rest.client.models.FundingInitiateModel;
import net.avalara.avatax.rest.client.models.FundingStatusModel;
import net.avalara.avatax.rest.client.models.HsCodeModel;
import net.avalara.avatax.rest.client.models.IsoCountryModel;
import net.avalara.avatax.rest.client.models.IsoRegionModel;
import net.avalara.avatax.rest.client.models.ItemClassificationInputModel;
import net.avalara.avatax.rest.client.models.ItemClassificationOutputModel;
import net.avalara.avatax.rest.client.models.ItemModel;
import net.avalara.avatax.rest.client.models.ItemParameterModel;
import net.avalara.avatax.rest.client.models.JurisdictionModel;
import net.avalara.avatax.rest.client.models.JurisdictionOverrideModel;
import net.avalara.avatax.rest.client.models.LicenseKeyModel;
import net.avalara.avatax.rest.client.models.LinkCertificatesModel;
import net.avalara.avatax.rest.client.models.LinkCustomersModel;
import net.avalara.avatax.rest.client.models.LocationModel;
import net.avalara.avatax.rest.client.models.LocationQuestionModel;
import net.avalara.avatax.rest.client.models.LocationValidationModel;
import net.avalara.avatax.rest.client.models.LockTransactionModel;
import net.avalara.avatax.rest.client.models.MarketplaceLocationModel;
import net.avalara.avatax.rest.client.models.MrsCompanyModel;
import net.avalara.avatax.rest.client.models.MultiDocumentModel;
import net.avalara.avatax.rest.client.models.NewAccountModel;
import net.avalara.avatax.rest.client.models.NewAccountRequestModel;
import net.avalara.avatax.rest.client.models.NewFirmClientAccountRequestModel;
import net.avalara.avatax.rest.client.models.NexusByAddressModel;
import net.avalara.avatax.rest.client.models.NexusByTaxFormModel;
import net.avalara.avatax.rest.client.models.NexusModel;
import net.avalara.avatax.rest.client.models.NexusTaxTypeGroupModel;
import net.avalara.avatax.rest.client.models.NoticeCustomerFundingOptionModel;
import net.avalara.avatax.rest.client.models.NoticeCustomerTypeModel;
import net.avalara.avatax.rest.client.models.NoticeFilingTypeModel;
import net.avalara.avatax.rest.client.models.NoticePriorityModel;
import net.avalara.avatax.rest.client.models.NoticeReasonModel;
import net.avalara.avatax.rest.client.models.NoticeResponsibilityModel;
import net.avalara.avatax.rest.client.models.NoticeRootCauseModel;
import net.avalara.avatax.rest.client.models.NoticeStatusModel;
import net.avalara.avatax.rest.client.models.NoticeTypeModel;
import net.avalara.avatax.rest.client.models.NotificationModel;
import net.avalara.avatax.rest.client.models.OfferModel;
import net.avalara.avatax.rest.client.models.ParameterModel;
import net.avalara.avatax.rest.client.models.ParameterUsageModel;
import net.avalara.avatax.rest.client.models.PasswordChangeModel;
import net.avalara.avatax.rest.client.models.PingResultModel;
import net.avalara.avatax.rest.client.models.PointOfSaleDataRequestModel;
import net.avalara.avatax.rest.client.models.PostalCodeModel;
import net.avalara.avatax.rest.client.models.PreferredProgramModel;
import net.avalara.avatax.rest.client.models.ProductClassificationSystemModel;
import net.avalara.avatax.rest.client.models.ProvisionStatusModel;
import net.avalara.avatax.rest.client.models.RateTypeModel;
import net.avalara.avatax.rest.client.models.RefundTransactionModel;
import net.avalara.avatax.rest.client.models.RemoveTransactionLineModel;
import net.avalara.avatax.rest.client.models.ReportModel;
import net.avalara.avatax.rest.client.models.ResetLicenseKeyModel;
import net.avalara.avatax.rest.client.models.ResourceFileTypeModel;
import net.avalara.avatax.rest.client.models.SecurityRoleModel;
import net.avalara.avatax.rest.client.models.SetPasswordModel;
import net.avalara.avatax.rest.client.models.SettingModel;
import net.avalara.avatax.rest.client.models.SettleTransactionModel;
import net.avalara.avatax.rest.client.models.SkyscraperStatusModel;
import net.avalara.avatax.rest.client.models.SubscriptionModel;
import net.avalara.avatax.rest.client.models.SubscriptionTypeModel;
import net.avalara.avatax.rest.client.models.SyncItemsRequestModel;
import net.avalara.avatax.rest.client.models.SyncItemsResponseModel;
import net.avalara.avatax.rest.client.models.TaxAuthorityFormModel;
import net.avalara.avatax.rest.client.models.TaxAuthorityModel;
import net.avalara.avatax.rest.client.models.TaxAuthorityTypeModel;
import net.avalara.avatax.rest.client.models.TaxCodeModel;
import net.avalara.avatax.rest.client.models.TaxCodeTypesModel;
import net.avalara.avatax.rest.client.models.TaxRateModel;
import net.avalara.avatax.rest.client.models.TaxRuleModel;
import net.avalara.avatax.rest.client.models.TaxSubTypeModel;
import net.avalara.avatax.rest.client.models.TaxTypeGroupModel;
import net.avalara.avatax.rest.client.models.TransactionModel;
import net.avalara.avatax.rest.client.models.TransactionReferenceFieldModel;
import net.avalara.avatax.rest.client.models.UPCModel;
import net.avalara.avatax.rest.client.models.UomModel;
import net.avalara.avatax.rest.client.models.UserEntitlementModel;
import net.avalara.avatax.rest.client.models.UserModel;
import net.avalara.avatax.rest.client.models.VerifyMultiDocumentModel;
import net.avalara.avatax.rest.client.models.VerifyTransactionModel;
import net.avalara.avatax.rest.client.models.VoidTransactionModel;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.impl.client.HttpClientBuilder;

public class AvaTaxClient {
    private final ExecutorService threadPool;
    private RestCallFactory restCallFactory;

    private AvaTaxClient() {
        this(null);
    }

    private AvaTaxClient(ExecutorService executorService) {
        this.threadPool = executorService != null ? executorService : Executors.newFixedThreadPool(3);
    }

    public AvaTaxClient(String string, String string2, String string3, AvaTaxEnvironment avaTaxEnvironment) {
        this(string, string2, string3, avaTaxEnvironment, null);
    }

    public AvaTaxClient(String string, String string2, String string3, String string4) {
        this();
        this.restCallFactory = new RestCallFactory(string, string2, string3, string4);
    }

    public AvaTaxClient(String string, String string2, String string3, AvaTaxEnvironment avaTaxEnvironment, String string4, int n, String string5) {
        this(string, string2, string3, avaTaxEnvironment, string4, n, string5, null);
    }

    public AvaTaxClient(String string, String string2, String string3, String string4, String string5, int n, String string6) {
        this();
        this.restCallFactory = new RestCallFactory(string, string2, string3, string4, string5, n, string6);
    }

    public AvaTaxClient(String string, String string2, String string3, AvaTaxEnvironment avaTaxEnvironment, ExecutorService executorService) {
        this(string, string2, string3, avaTaxEnvironment == AvaTaxEnvironment.Production ? AvaTaxConstants.Production_Url : AvaTaxConstants.Sandbox_Url, executorService);
    }

    public AvaTaxClient(String string, String string2, String string3, AvaTaxEnvironment avaTaxEnvironment, ExecutorService executorService, HttpClientBuilder httpClientBuilder) {
        this(string, string2, string3, avaTaxEnvironment == AvaTaxEnvironment.Production ? AvaTaxConstants.Production_Url : AvaTaxConstants.Sandbox_Url, executorService, httpClientBuilder);
    }

    public AvaTaxClient(String string, String string2, String string3, String string4, ExecutorService executorService) {
        this(executorService);
        this.restCallFactory = new RestCallFactory(string, string2, string3, string4);
    }

    public AvaTaxClient(String string, String string2, String string3, String string4, ExecutorService executorService, HttpClientBuilder httpClientBuilder) {
        this(executorService);
        this.restCallFactory = new RestCallFactory(string, string2, string3, string4, httpClientBuilder);
    }

    public AvaTaxClient(String string, String string2, String string3, AvaTaxEnvironment avaTaxEnvironment, String string4, int n, String string5, ExecutorService executorService) {
        this(string, string2, string3, avaTaxEnvironment == AvaTaxEnvironment.Production ? AvaTaxConstants.Production_Url : AvaTaxConstants.Sandbox_Url, string4, n, string5, executorService);
    }

    public AvaTaxClient(String string, String string2, String string3, String string4, String string5, int n, String string6, ExecutorService executorService) {
        this(executorService);
        this.restCallFactory = new RestCallFactory(string, string2, string3, string4, string5, n, string6);
    }

    public AvaTaxClient withSecurity(String string) {
        this.restCallFactory.addSecurityHeader(string);
        return this;
    }

    public AvaTaxClient withSecurity(String string, String string2) {
        String string3 = null;
        try {
            string3 = Base64.encodeBase64String((byte[])(string + ":" + string2).getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println("Could not find encoding for UTF-8.");
            unsupportedEncodingException.printStackTrace();
        }
        return this.withSecurity(string3);
    }

    public LicenseKeyModel accountResetLicenseKey(Integer n, ResetLicenseKeyModel resetLicenseKeyModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}/resetlicensekey");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, resetLicenseKeyModel, new TypeToken<LicenseKeyModel>(){}).call();
    }

    public Future<LicenseKeyModel> accountResetLicenseKeyAsync(Integer n, ResetLicenseKeyModel resetLicenseKeyModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}/resetlicensekey");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, resetLicenseKeyModel, new TypeToken<LicenseKeyModel>(){}));
    }

    public AccountModel activateAccount(Integer n, ActivateAccountModel activateAccountModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}/activate");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, activateAccountModel, new TypeToken<AccountModel>(){}).call();
    }

    public Future<AccountModel> activateAccountAsync(Integer n, ActivateAccountModel activateAccountModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}/activate");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, activateAccountModel, new TypeToken<AccountModel>(){}));
    }

    public FetchResult<AuditModel> auditAccount(Integer n, Date date, Date date2, Integer n2, Integer n3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}/audit");
        avaTaxPath.applyField("id", n);
        avaTaxPath.addQuery("start", date);
        avaTaxPath.addQuery("end", date2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<AuditModel>>(){}).call();
    }

    public Future<FetchResult<AuditModel>> auditAccountAsync(Integer n, Date date, Date date2, Integer n2, Integer n3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}/audit");
        avaTaxPath.applyField("id", n);
        avaTaxPath.addQuery("start", date);
        avaTaxPath.addQuery("end", date2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<AuditModel>>(){}));
    }

    public LicenseKeyModel createLicenseKey(Integer n, AccountLicenseKeyModel accountLicenseKeyModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}/licensekey");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, accountLicenseKeyModel, new TypeToken<LicenseKeyModel>(){}).call();
    }

    public Future<LicenseKeyModel> createLicenseKeyAsync(Integer n, AccountLicenseKeyModel accountLicenseKeyModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}/licensekey");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, accountLicenseKeyModel, new TypeToken<LicenseKeyModel>(){}));
    }

    public ArrayList<ErrorDetail> deleteLicenseKey(Integer n, String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}/licensekey/{licensekeyname}");
        avaTaxPath.applyField("id", n);
        avaTaxPath.applyField("licensekeyname", string);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}).call();
    }

    public Future<ArrayList<ErrorDetail>> deleteLicenseKeyAsync(Integer n, String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}/licensekey/{licensekeyname}");
        avaTaxPath.applyField("id", n);
        avaTaxPath.applyField("licensekeyname", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}));
    }

    public AccountModel getAccount(Integer n, String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}");
        avaTaxPath.applyField("id", n);
        avaTaxPath.addQuery("$include", string);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<AccountModel>(){}).call();
    }

    public Future<AccountModel> getAccountAsync(Integer n, String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}");
        avaTaxPath.applyField("id", n);
        avaTaxPath.addQuery("$include", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<AccountModel>(){}));
    }

    public ArrayList<AccountConfigurationModel> getAccountConfiguration(Integer n) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}/configuration");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ArrayList<AccountConfigurationModel>>(){}).call();
    }

    public Future<ArrayList<AccountConfigurationModel>> getAccountConfigurationAsync(Integer n) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}/configuration");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ArrayList<AccountConfigurationModel>>(){}));
    }

    public AccountLicenseKeyModel getLicenseKey(Integer n, String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}/licensekey/{licensekeyname}");
        avaTaxPath.applyField("id", n);
        avaTaxPath.applyField("licensekeyname", string);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<AccountLicenseKeyModel>(){}).call();
    }

    public Future<AccountLicenseKeyModel> getLicenseKeyAsync(Integer n, String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}/licensekey/{licensekeyname}");
        avaTaxPath.applyField("id", n);
        avaTaxPath.applyField("licensekeyname", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<AccountLicenseKeyModel>(){}));
    }

    public ArrayList<AccountLicenseKeyModel> getLicenseKeys(Integer n) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}/licensekeys");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ArrayList<AccountLicenseKeyModel>>(){}).call();
    }

    public Future<ArrayList<AccountLicenseKeyModel>> getLicenseKeysAsync(Integer n) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}/licensekeys");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ArrayList<AccountLicenseKeyModel>>(){}));
    }

    public FetchResult<AccountModel> queryAccounts(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts");
        avaTaxPath.addQuery("$include", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<AccountModel>>(){}).call();
    }

    public Future<FetchResult<AccountModel>> queryAccountsAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts");
        avaTaxPath.addQuery("$include", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<AccountModel>>(){}));
    }

    public ArrayList<AccountConfigurationModel> setAccountConfiguration(Integer n, ArrayList<AccountConfigurationModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}/configuration");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<AccountConfigurationModel>>(){}).call();
    }

    public Future<ArrayList<AccountConfigurationModel>> setAccountConfigurationAsync(Integer n, ArrayList<AccountConfigurationModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}/configuration");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<AccountConfigurationModel>>(){}));
    }

    public AddressResolutionModel resolveAddress(String string, String string2, String string3, String string4, String string5, String string6, String string7, TextCase textCase) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/addresses/resolve");
        avaTaxPath.addQuery("line1", string);
        avaTaxPath.addQuery("line2", string2);
        avaTaxPath.addQuery("line3", string3);
        avaTaxPath.addQuery("city", string4);
        avaTaxPath.addQuery("region", string5);
        avaTaxPath.addQuery("postalCode", string6);
        avaTaxPath.addQuery("country", string7);
        avaTaxPath.addQuery("textCase", (Object)textCase);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<AddressResolutionModel>(){}).call();
    }

    public Future<AddressResolutionModel> resolveAddressAsync(String string, String string2, String string3, String string4, String string5, String string6, String string7, TextCase textCase) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/addresses/resolve");
        avaTaxPath.addQuery("line1", string);
        avaTaxPath.addQuery("line2", string2);
        avaTaxPath.addQuery("line3", string3);
        avaTaxPath.addQuery("city", string4);
        avaTaxPath.addQuery("region", string5);
        avaTaxPath.addQuery("postalCode", string6);
        avaTaxPath.addQuery("country", string7);
        avaTaxPath.addQuery("textCase", (Object)textCase);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<AddressResolutionModel>(){}));
    }

    public AddressResolutionModel resolveAddressPost(AddressValidationInfo addressValidationInfo) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/addresses/resolve");
        return this.restCallFactory.createRestCall("post", avaTaxPath, addressValidationInfo, new TypeToken<AddressResolutionModel>(){}).call();
    }

    public Future<AddressResolutionModel> resolveAddressPostAsync(AddressValidationInfo addressValidationInfo) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/addresses/resolve");
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, addressValidationInfo, new TypeToken<AddressResolutionModel>(){}));
    }

    public AdvancedRuleLookupFileModel createCompanyLookupFile(Integer n, Integer n2, AdvancedRuleLookupFileModel advancedRuleLookupFileModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/advancedrules/accounts/{accountId}/companies/{companyId}/lookupFiles");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.applyField("companyId", n2);
        return this.restCallFactory.createRestCall("post", avaTaxPath, advancedRuleLookupFileModel, new TypeToken<AdvancedRuleLookupFileModel>(){}).call();
    }

    public Future<AdvancedRuleLookupFileModel> createCompanyLookupFileAsync(Integer n, Integer n2, AdvancedRuleLookupFileModel advancedRuleLookupFileModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/advancedrules/accounts/{accountId}/companies/{companyId}/lookupFiles");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.applyField("companyId", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, advancedRuleLookupFileModel, new TypeToken<AdvancedRuleLookupFileModel>(){}));
    }

    public ArrayList<ErrorDetail> deleteLookupFile(Integer n, String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/advancedrules/accounts/{accountId}/lookupFiles/{id}");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.applyField("id", string);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}).call();
    }

    public Future<ArrayList<ErrorDetail>> deleteLookupFileAsync(Integer n, String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/advancedrules/accounts/{accountId}/lookupFiles/{id}");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.applyField("id", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}));
    }

    public AdvancedRuleLookupFileModel getAuditRecords(Integer n, String string, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/advancedrules/audits/accounts/{accountId}/from/{fromDate}/to/{toDate}");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.applyField("fromDate", string);
        avaTaxPath.applyField("toDate", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<AdvancedRuleLookupFileModel>(){}).call();
    }

    public Future<AdvancedRuleLookupFileModel> getAuditRecordsAsync(Integer n, String string, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/advancedrules/audits/accounts/{accountId}/from/{fromDate}/to/{toDate}");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.applyField("fromDate", string);
        avaTaxPath.applyField("toDate", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<AdvancedRuleLookupFileModel>(){}));
    }

    public FetchResult<AdvancedRuleLookupFileModel> getCompanyLookupFiles(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/advancedrules/accounts/{accountId}/companies/{companyId}/lookupFiles");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.applyField("companyId", n2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<AdvancedRuleLookupFileModel>>(){}).call();
    }

    public Future<FetchResult<AdvancedRuleLookupFileModel>> getCompanyLookupFilesAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/advancedrules/accounts/{accountId}/companies/{companyId}/lookupFiles");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.applyField("companyId", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<AdvancedRuleLookupFileModel>>(){}));
    }

    public AdvancedRuleLookupFileModel getLookupFile(Integer n, String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/advancedrules/accounts/{accountId}/lookupFiles/{id}");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.applyField("id", string);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<AdvancedRuleLookupFileModel>(){}).call();
    }

    public Future<AdvancedRuleLookupFileModel> getLookupFileAsync(Integer n, String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/advancedrules/accounts/{accountId}/lookupFiles/{id}");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.applyField("id", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<AdvancedRuleLookupFileModel>(){}));
    }

    public AdvancedRuleLookupFileModel updateLookupFile(Integer n, String string, AdvancedRuleLookupFileModel advancedRuleLookupFileModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/advancedrules/accounts/{accountId}/lookupFiles/{id}");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.applyField("id", string);
        return this.restCallFactory.createRestCall("put", avaTaxPath, advancedRuleLookupFileModel, new TypeToken<AdvancedRuleLookupFileModel>(){}).call();
    }

    public Future<AdvancedRuleLookupFileModel> updateLookupFileAsync(Integer n, String string, AdvancedRuleLookupFileModel advancedRuleLookupFileModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/advancedrules/accounts/{accountId}/lookupFiles/{id}");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.applyField("id", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, advancedRuleLookupFileModel, new TypeToken<AdvancedRuleLookupFileModel>(){}));
    }

    public ArrayList<AvaFileFormModel> createAvaFileForms(ArrayList<AvaFileFormModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/avafileforms");
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<AvaFileFormModel>>(){}).call();
    }

    public Future<ArrayList<AvaFileFormModel>> createAvaFileFormsAsync(ArrayList<AvaFileFormModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/avafileforms");
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<AvaFileFormModel>>(){}));
    }

    public ArrayList<ErrorDetail> deleteAvaFileForm(Integer n) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/avafileforms/{id}");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}).call();
    }

    public Future<ArrayList<ErrorDetail>> deleteAvaFileFormAsync(Integer n) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/avafileforms/{id}");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}));
    }

    public AvaFileFormModel getAvaFileForm(Integer n) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/avafileforms/{id}");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<AvaFileFormModel>(){}).call();
    }

    public Future<AvaFileFormModel> getAvaFileFormAsync(Integer n) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/avafileforms/{id}");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<AvaFileFormModel>(){}));
    }

    public FetchResult<AvaFileFormModel> queryAvaFileForms(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/avafileforms");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<AvaFileFormModel>>(){}).call();
    }

    public Future<FetchResult<AvaFileFormModel>> queryAvaFileFormsAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/avafileforms");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<AvaFileFormModel>>(){}));
    }

    public AvaFileFormModel updateAvaFileForm(Integer n, AvaFileFormModel avaFileFormModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/avafileforms/{id}");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("put", avaTaxPath, avaFileFormModel, new TypeToken<AvaFileFormModel>(){}).call();
    }

    public Future<AvaFileFormModel> updateAvaFileFormAsync(Integer n, AvaFileFormModel avaFileFormModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/avafileforms/{id}");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, avaFileFormModel, new TypeToken<AvaFileFormModel>(){}));
    }

    public BatchModel cancelBatch(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/batches/{id}/cancel");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("post", avaTaxPath, null, new TypeToken<BatchModel>(){}).call();
    }

    public Future<BatchModel> cancelBatchAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/batches/{id}/cancel");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, null, new TypeToken<BatchModel>(){}));
    }

    public ArrayList<BatchModel> createBatches(Integer n, ArrayList<BatchModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/batches");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<BatchModel>>(){}).call();
    }

    public Future<ArrayList<BatchModel>> createBatchesAsync(Integer n, ArrayList<BatchModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/batches");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<BatchModel>>(){}));
    }

    public CreateTransactionBatchResponseModel createTransactionBatch(Integer n, CreateTransactionBatchRequestModel createTransactionBatchRequestModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/batches/transactions");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, createTransactionBatchRequestModel, new TypeToken<CreateTransactionBatchResponseModel>(){}).call();
    }

    public Future<CreateTransactionBatchResponseModel> createTransactionBatchAsync(Integer n, CreateTransactionBatchRequestModel createTransactionBatchRequestModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/batches/transactions");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, createTransactionBatchRequestModel, new TypeToken<CreateTransactionBatchResponseModel>(){}));
    }

    public ArrayList<ErrorDetail> deleteBatch(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/batches/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}).call();
    }

    public Future<ArrayList<ErrorDetail>> deleteBatchAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/batches/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}));
    }

    public String downloadBatch(Integer n, Integer n2, Integer n3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/batches/{batchId}/files/{id}/attachment");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("batchId", n2);
        avaTaxPath.applyField("id", n3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<String>(){}).call();
    }

    public Future<String> downloadBatchAsync(Integer n, Integer n2, Integer n3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/batches/{batchId}/files/{id}/attachment");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("batchId", n2);
        avaTaxPath.applyField("id", n3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<String>(){}));
    }

    public BatchModel getBatch(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/batches/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<BatchModel>(){}).call();
    }

    public Future<BatchModel> getBatchAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/batches/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<BatchModel>(){}));
    }

    public FetchResult<BatchModel> listBatchesByCompany(Integer n, String string, String string2, Integer n2, Integer n3, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/batches");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<BatchModel>>(){}).call();
    }

    public Future<FetchResult<BatchModel>> listBatchesByCompanyAsync(Integer n, String string, String string2, Integer n2, Integer n3, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/batches");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<BatchModel>>(){}));
    }

    public FetchResult<BatchModel> queryBatches(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/batches");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<BatchModel>>(){}).call();
    }

    public Future<FetchResult<BatchModel>> queryBatchesAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/batches");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<BatchModel>>(){}));
    }

    public ArrayList<CertExpressInvitationStatusModel> createCertExpressInvitation(Integer n, String string, ArrayList<CreateCertExpressInvitationModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers/{customerCode}/certexpressinvites");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("customerCode", string);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<CertExpressInvitationStatusModel>>(){}).call();
    }

    public Future<ArrayList<CertExpressInvitationStatusModel>> createCertExpressInvitationAsync(Integer n, String string, ArrayList<CreateCertExpressInvitationModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers/{customerCode}/certexpressinvites");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("customerCode", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<CertExpressInvitationStatusModel>>(){}));
    }

    public CertExpressInvitationModel getCertExpressInvitation(Integer n, String string, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers/{customerCode}/certexpressinvites/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("customerCode", string);
        avaTaxPath.applyField("id", n2);
        avaTaxPath.addQuery("$include", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<CertExpressInvitationModel>(){}).call();
    }

    public Future<CertExpressInvitationModel> getCertExpressInvitationAsync(Integer n, String string, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers/{customerCode}/certexpressinvites/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("customerCode", string);
        avaTaxPath.applyField("id", n2);
        avaTaxPath.addQuery("$include", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<CertExpressInvitationModel>(){}));
    }

    public FetchResult<CertExpressInvitationModel> listCertExpressInvitations(Integer n, String string, String string2, Integer n2, Integer n3, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certexpressinvites");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$include", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CertExpressInvitationModel>>(){}).call();
    }

    public Future<FetchResult<CertExpressInvitationModel>> listCertExpressInvitationsAsync(Integer n, String string, String string2, Integer n2, Integer n3, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certexpressinvites");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$include", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CertExpressInvitationModel>>(){}));
    }

    public ArrayList<CertificateModel> createCertificates(Integer n, Boolean bl, ArrayList<CertificateModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$preValidatedExemptionReason", bl);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<CertificateModel>>(){}).call();
    }

    public Future<ArrayList<CertificateModel>> createCertificatesAsync(Integer n, Boolean bl, ArrayList<CertificateModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$preValidatedExemptionReason", bl);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<CertificateModel>>(){}));
    }

    public ArrayList<ErrorDetail> deleteCertificate(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}).call();
    }

    public Future<ArrayList<ErrorDetail>> deleteCertificateAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}));
    }

    public String downloadCertificateImage(Integer n, Integer n2, Integer n3, CertificatePreviewType certificatePreviewType) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates/{id}/attachment");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        avaTaxPath.addQuery("$page", n3);
        avaTaxPath.addQuery("$type", (Object)certificatePreviewType);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<String>(){}).call();
    }

    public Future<String> downloadCertificateImageAsync(Integer n, Integer n2, Integer n3, CertificatePreviewType certificatePreviewType) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates/{id}/attachment");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        avaTaxPath.addQuery("$page", n3);
        avaTaxPath.addQuery("$type", (Object)certificatePreviewType);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<String>(){}));
    }

    public CertificateModel getCertificate(Integer n, Integer n2, String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        avaTaxPath.addQuery("$include", string);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<CertificateModel>(){}).call();
    }

    public Future<CertificateModel> getCertificateAsync(Integer n, Integer n2, String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        avaTaxPath.addQuery("$include", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<CertificateModel>(){}));
    }

    public ProvisionStatusModel getCertificateSetup(Integer n) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates/setup");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ProvisionStatusModel>(){}).call();
    }

    public Future<ProvisionStatusModel> getCertificateSetupAsync(Integer n) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates/setup");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ProvisionStatusModel>(){}));
    }

    public FetchResult<CertificateAttributeModel> linkAttributesToCertificate(Integer n, Integer n2, ArrayList<CertificateAttributeModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates/{id}/attributes/link");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<FetchResult<CertificateAttributeModel>>(){}).call();
    }

    public Future<FetchResult<CertificateAttributeModel>> linkAttributesToCertificateAsync(Integer n, Integer n2, ArrayList<CertificateAttributeModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates/{id}/attributes/link");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<FetchResult<CertificateAttributeModel>>(){}));
    }

    public FetchResult<CustomerModel> linkCustomersToCertificate(Integer n, Integer n2, LinkCustomersModel linkCustomersModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates/{id}/customers/link");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("post", avaTaxPath, linkCustomersModel, new TypeToken<FetchResult<CustomerModel>>(){}).call();
    }

    public Future<FetchResult<CustomerModel>> linkCustomersToCertificateAsync(Integer n, Integer n2, LinkCustomersModel linkCustomersModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates/{id}/customers/link");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, linkCustomersModel, new TypeToken<FetchResult<CustomerModel>>(){}));
    }

    public FetchResult<CertificateAttributeModel> listAttributesForCertificate(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates/{id}/attributes");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CertificateAttributeModel>>(){}).call();
    }

    public Future<FetchResult<CertificateAttributeModel>> listAttributesForCertificateAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates/{id}/attributes");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CertificateAttributeModel>>(){}));
    }

    public FetchResult<CustomerModel> listCustomersForCertificate(Integer n, Integer n2, String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates/{id}/customers");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        avaTaxPath.addQuery("$include", string);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CustomerModel>>(){}).call();
    }

    public Future<FetchResult<CustomerModel>> listCustomersForCertificateAsync(Integer n, Integer n2, String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates/{id}/customers");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        avaTaxPath.addQuery("$include", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CustomerModel>>(){}));
    }

    public FetchResult<CertificateModel> queryCertificates(Integer n, String string, String string2, Integer n2, Integer n3, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$include", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CertificateModel>>(){}).call();
    }

    public Future<FetchResult<CertificateModel>> queryCertificatesAsync(Integer n, String string, String string2, Integer n2, Integer n3, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$include", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CertificateModel>>(){}));
    }

    public ProvisionStatusModel requestCertificateSetup(Integer n) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates/setup");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, null, new TypeToken<ProvisionStatusModel>(){}).call();
    }

    public Future<ProvisionStatusModel> requestCertificateSetupAsync(Integer n) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates/setup");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, null, new TypeToken<ProvisionStatusModel>(){}));
    }

    public FetchResult<CertificateAttributeModel> unlinkAttributesFromCertificate(Integer n, Integer n2, ArrayList<CertificateAttributeModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates/{id}/attributes/unlink");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<FetchResult<CertificateAttributeModel>>(){}).call();
    }

    public Future<FetchResult<CertificateAttributeModel>> unlinkAttributesFromCertificateAsync(Integer n, Integer n2, ArrayList<CertificateAttributeModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates/{id}/attributes/unlink");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<FetchResult<CertificateAttributeModel>>(){}));
    }

    public FetchResult<CustomerModel> unlinkCustomersFromCertificate(Integer n, Integer n2, LinkCustomersModel linkCustomersModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates/{id}/customers/unlink");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("post", avaTaxPath, linkCustomersModel, new TypeToken<FetchResult<CustomerModel>>(){}).call();
    }

    public Future<FetchResult<CustomerModel>> unlinkCustomersFromCertificateAsync(Integer n, Integer n2, LinkCustomersModel linkCustomersModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates/{id}/customers/unlink");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, linkCustomersModel, new TypeToken<FetchResult<CustomerModel>>(){}));
    }

    public CertificateModel updateCertificate(Integer n, Integer n2, CertificateModel certificateModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("put", avaTaxPath, certificateModel, new TypeToken<CertificateModel>(){}).call();
    }

    public Future<CertificateModel> updateCertificateAsync(Integer n, Integer n2, CertificateModel certificateModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, certificateModel, new TypeToken<CertificateModel>(){}));
    }

    public String uploadCertificateImage(Integer n, Integer n2, String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates/{id}/attachment");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("post", avaTaxPath, null, new TypeToken<String>(){}).call();
    }

    public Future<String> uploadCertificateImageAsync(Integer n, Integer n2, String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates/{id}/attachment");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, null, new TypeToken<String>(){}));
    }

    public String certifyIntegration(Integer n) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}/certify");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<String>(){}).call();
    }

    public Future<String> certifyIntegrationAsync(Integer n) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}/certify");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<String>(){}));
    }

    public String changeFilingStatus(Integer n, FilingStatusChangeModel filingStatusChangeModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}/filingstatus");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, filingStatusChangeModel, new TypeToken<String>(){}).call();
    }

    public Future<String> changeFilingStatusAsync(Integer n, FilingStatusChangeModel filingStatusChangeModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}/filingstatus");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, filingStatusChangeModel, new TypeToken<String>(){}));
    }

    public CompanyModel companyInitialize(CompanyInitializationModel companyInitializationModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/initialize");
        return this.restCallFactory.createRestCall("post", avaTaxPath, companyInitializationModel, new TypeToken<CompanyModel>(){}).call();
    }

    public Future<CompanyModel> companyInitializeAsync(CompanyInitializationModel companyInitializationModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/initialize");
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, companyInitializationModel, new TypeToken<CompanyModel>(){}));
    }

    public ArrayList<CompanyModel> createCompanies(ArrayList<CompanyModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies");
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<CompanyModel>>(){}).call();
    }

    public Future<ArrayList<CompanyModel>> createCompaniesAsync(ArrayList<CompanyModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies");
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<CompanyModel>>(){}));
    }

    public FundingStatusModel createFundingRequest(Integer n, FundingInitiateModel fundingInitiateModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}/funding/setup");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, fundingInitiateModel, new TypeToken<FundingStatusModel>(){}).call();
    }

    public Future<FundingStatusModel> createFundingRequestAsync(Integer n, FundingInitiateModel fundingInitiateModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}/funding/setup");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, fundingInitiateModel, new TypeToken<FundingStatusModel>(){}));
    }

    public ArrayList<ErrorDetail> deleteCompany(Integer n) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}).call();
    }

    public Future<ArrayList<ErrorDetail>> deleteCompanyAsync(Integer n) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}));
    }

    public FundingConfigurationModel fundingConfigurationByCompany(Integer n) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/funding/configuration");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FundingConfigurationModel>(){}).call();
    }

    public Future<FundingConfigurationModel> fundingConfigurationByCompanyAsync(Integer n) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/funding/configuration");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FundingConfigurationModel>(){}));
    }

    public ArrayList<FundingConfigurationModel> fundingConfigurationsByCompanyAndCurrency(Integer n, String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/funding/configurations");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("currency", string);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ArrayList<FundingConfigurationModel>>(){}).call();
    }

    public Future<ArrayList<FundingConfigurationModel>> fundingConfigurationsByCompanyAndCurrencyAsync(Integer n, String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/funding/configurations");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("currency", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ArrayList<FundingConfigurationModel>>(){}));
    }

    public CompanyModel getCompany(Integer n, String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}");
        avaTaxPath.applyField("id", n);
        avaTaxPath.addQuery("$include", string);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<CompanyModel>(){}).call();
    }

    public Future<CompanyModel> getCompanyAsync(Integer n, String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}");
        avaTaxPath.applyField("id", n);
        avaTaxPath.addQuery("$include", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<CompanyModel>(){}));
    }

    public ArrayList<CompanyConfigurationModel> getCompanyConfiguration(Integer n) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}/configuration");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ArrayList<CompanyConfigurationModel>>(){}).call();
    }

    public Future<ArrayList<CompanyConfigurationModel>> getCompanyConfigurationAsync(Integer n) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}/configuration");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ArrayList<CompanyConfigurationModel>>(){}));
    }

    public String getFilingStatus(Integer n) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}/filingstatus");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<String>(){}).call();
    }

    public Future<String> getFilingStatusAsync(Integer n) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}/filingstatus");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<String>(){}));
    }

    public ArrayList<FundingStatusModel> listFundingRequestsByCompany(Integer n) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}/funding");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ArrayList<FundingStatusModel>>(){}).call();
    }

    public Future<ArrayList<FundingStatusModel>> listFundingRequestsByCompanyAsync(Integer n) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}/funding");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ArrayList<FundingStatusModel>>(){}));
    }

    public FetchResult<MrsCompanyModel> listMrsCompanies() throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/mrs");
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<MrsCompanyModel>>(){}).call();
    }

    public Future<FetchResult<MrsCompanyModel>> listMrsCompaniesAsync() {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/mrs");
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<MrsCompanyModel>>(){}));
    }

    public FetchResult<CompanyModel> queryCompanies(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies");
        avaTaxPath.addQuery("$include", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CompanyModel>>(){}).call();
    }

    public Future<FetchResult<CompanyModel>> queryCompaniesAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies");
        avaTaxPath.addQuery("$include", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CompanyModel>>(){}));
    }

    public ArrayList<CompanyConfigurationModel> setCompanyConfiguration(Integer n, ArrayList<CompanyConfigurationModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}/configuration");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<CompanyConfigurationModel>>(){}).call();
    }

    public Future<ArrayList<CompanyConfigurationModel>> setCompanyConfigurationAsync(Integer n, ArrayList<CompanyConfigurationModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}/configuration");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<CompanyConfigurationModel>>(){}));
    }

    public CompanyModel updateCompany(Integer n, CompanyModel companyModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("put", avaTaxPath, companyModel, new TypeToken<CompanyModel>(){}).call();
    }

    public Future<CompanyModel> updateCompanyAsync(Integer n, CompanyModel companyModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, companyModel, new TypeToken<CompanyModel>(){}));
    }

    public FetchResult<TransactionModel> tagTransaction(Integer n, ArrayList<TransactionReferenceFieldModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/transactions/tag");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("put", avaTaxPath, arrayList, new TypeToken<FetchResult<TransactionModel>>(){}).call();
    }

    public Future<FetchResult<TransactionModel>> tagTransactionAsync(Integer n, ArrayList<TransactionReferenceFieldModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/transactions/tag");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, arrayList, new TypeToken<FetchResult<TransactionModel>>(){}));
    }

    public ArrayList<ContactModel> createContacts(Integer n, ArrayList<ContactModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/contacts");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<ContactModel>>(){}).call();
    }

    public Future<ArrayList<ContactModel>> createContactsAsync(Integer n, ArrayList<ContactModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/contacts");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<ContactModel>>(){}));
    }

    public ArrayList<ErrorDetail> deleteContact(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/contacts/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}).call();
    }

    public Future<ArrayList<ErrorDetail>> deleteContactAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/contacts/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}));
    }

    public ContactModel getContact(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/contacts/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ContactModel>(){}).call();
    }

    public Future<ContactModel> getContactAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/contacts/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ContactModel>(){}));
    }

    public FetchResult<ContactModel> listContactsByCompany(Integer n, String string, Integer n2, Integer n3, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/contacts");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ContactModel>>(){}).call();
    }

    public Future<FetchResult<ContactModel>> listContactsByCompanyAsync(Integer n, String string, Integer n2, Integer n3, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/contacts");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ContactModel>>(){}));
    }

    public FetchResult<ContactModel> queryContacts(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/contacts");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ContactModel>>(){}).call();
    }

    public Future<FetchResult<ContactModel>> queryContactsAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/contacts");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ContactModel>>(){}));
    }

    public ContactModel updateContact(Integer n, Integer n2, ContactModel contactModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/contacts/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("put", avaTaxPath, contactModel, new TypeToken<ContactModel>(){}).call();
    }

    public Future<ContactModel> updateContactAsync(Integer n, Integer n2, ContactModel contactModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/contacts/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, contactModel, new TypeToken<ContactModel>(){}));
    }

    public ArrayList<CustomerModel> createCustomers(Integer n, ArrayList<CustomerModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<CustomerModel>>(){}).call();
    }

    public Future<ArrayList<CustomerModel>> createCustomersAsync(Integer n, ArrayList<CustomerModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<CustomerModel>>(){}));
    }

    public CustomerModel deleteCustomer(Integer n, String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers/{customerCode}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("customerCode", string);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<CustomerModel>(){}).call();
    }

    public Future<CustomerModel> deleteCustomerAsync(Integer n, String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers/{customerCode}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("customerCode", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<CustomerModel>(){}));
    }

    public CustomerModel getCustomer(Integer n, String string, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers/{customerCode}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("customerCode", string);
        avaTaxPath.addQuery("$include", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<CustomerModel>(){}).call();
    }

    public Future<CustomerModel> getCustomerAsync(Integer n, String string, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers/{customerCode}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("customerCode", string);
        avaTaxPath.addQuery("$include", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<CustomerModel>(){}));
    }

    public FetchResult<CustomerAttributeModel> linkAttributesToCustomer(Integer n, String string, ArrayList<CustomerAttributeModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers/{customerCode}/attributes/link");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("customerCode", string);
        return this.restCallFactory.createRestCall("put", avaTaxPath, arrayList, new TypeToken<FetchResult<CustomerAttributeModel>>(){}).call();
    }

    public Future<FetchResult<CustomerAttributeModel>> linkAttributesToCustomerAsync(Integer n, String string, ArrayList<CustomerAttributeModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers/{customerCode}/attributes/link");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("customerCode", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, arrayList, new TypeToken<FetchResult<CustomerAttributeModel>>(){}));
    }

    public FetchResult<CertificateModel> linkCertificatesToCustomer(Integer n, String string, LinkCertificatesModel linkCertificatesModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers/{customerCode}/certificates/link");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("customerCode", string);
        return this.restCallFactory.createRestCall("post", avaTaxPath, linkCertificatesModel, new TypeToken<FetchResult<CertificateModel>>(){}).call();
    }

    public Future<FetchResult<CertificateModel>> linkCertificatesToCustomerAsync(Integer n, String string, LinkCertificatesModel linkCertificatesModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers/{customerCode}/certificates/link");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("customerCode", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, linkCertificatesModel, new TypeToken<FetchResult<CertificateModel>>(){}));
    }

    public CustomerModel linkShipToCustomersToBillCustomer(Integer n, String string, LinkCustomersModel linkCustomersModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers/billto/{code}/shipto/link");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("code", string);
        return this.restCallFactory.createRestCall("post", avaTaxPath, linkCustomersModel, new TypeToken<CustomerModel>(){}).call();
    }

    public Future<CustomerModel> linkShipToCustomersToBillCustomerAsync(Integer n, String string, LinkCustomersModel linkCustomersModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers/billto/{code}/shipto/link");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("code", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, linkCustomersModel, new TypeToken<CustomerModel>(){}));
    }

    public FetchResult<CustomerAttributeModel> listAttributesForCustomer(Integer n, String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers/{customerCode}/attributes");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("customerCode", string);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CustomerAttributeModel>>(){}).call();
    }

    public Future<FetchResult<CustomerAttributeModel>> listAttributesForCustomerAsync(Integer n, String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers/{customerCode}/attributes");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("customerCode", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CustomerAttributeModel>>(){}));
    }

    public FetchResult<CertificateModel> listCertificatesForCustomer(Integer n, String string, String string2, String string3, Integer n2, Integer n3, String string4) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers/{customerCode}/certificates");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("customerCode", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$filter", string3);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string4);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CertificateModel>>(){}).call();
    }

    public Future<FetchResult<CertificateModel>> listCertificatesForCustomerAsync(Integer n, String string, String string2, String string3, Integer n2, Integer n3, String string4) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers/{customerCode}/certificates");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("customerCode", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$filter", string3);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string4);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CertificateModel>>(){}));
    }

    public ExemptionStatusModel listValidCertificatesForCustomer(Integer n, String string, String string2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers/{customerCode}/certificates/{country}/{region}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("customerCode", string);
        avaTaxPath.applyField("country", string2);
        avaTaxPath.applyField("region", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ExemptionStatusModel>(){}).call();
    }

    public Future<ExemptionStatusModel> listValidCertificatesForCustomerAsync(Integer n, String string, String string2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers/{customerCode}/certificates/{country}/{region}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("customerCode", string);
        avaTaxPath.applyField("country", string2);
        avaTaxPath.applyField("region", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ExemptionStatusModel>(){}));
    }

    public FetchResult<CustomerModel> queryCustomers(Integer n, String string, String string2, Integer n2, Integer n3, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$include", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CustomerModel>>(){}).call();
    }

    public Future<FetchResult<CustomerModel>> queryCustomersAsync(Integer n, String string, String string2, Integer n2, Integer n3, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$include", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CustomerModel>>(){}));
    }

    public FetchResult<CustomerAttributeModel> unlinkAttributesFromCustomer(Integer n, String string, ArrayList<CustomerAttributeModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers/{customerCode}/attributes/unlink");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("customerCode", string);
        return this.restCallFactory.createRestCall("put", avaTaxPath, arrayList, new TypeToken<FetchResult<CustomerAttributeModel>>(){}).call();
    }

    public Future<FetchResult<CustomerAttributeModel>> unlinkAttributesFromCustomerAsync(Integer n, String string, ArrayList<CustomerAttributeModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers/{customerCode}/attributes/unlink");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("customerCode", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, arrayList, new TypeToken<FetchResult<CustomerAttributeModel>>(){}));
    }

    public FetchResult<CertificateModel> unlinkCertificatesFromCustomer(Integer n, String string, LinkCertificatesModel linkCertificatesModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers/{customerCode}/certificates/unlink");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("customerCode", string);
        return this.restCallFactory.createRestCall("post", avaTaxPath, linkCertificatesModel, new TypeToken<FetchResult<CertificateModel>>(){}).call();
    }

    public Future<FetchResult<CertificateModel>> unlinkCertificatesFromCustomerAsync(Integer n, String string, LinkCertificatesModel linkCertificatesModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers/{customerCode}/certificates/unlink");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("customerCode", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, linkCertificatesModel, new TypeToken<FetchResult<CertificateModel>>(){}));
    }

    public CustomerModel updateCustomer(Integer n, String string, CustomerModel customerModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers/{customerCode}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("customerCode", string);
        return this.restCallFactory.createRestCall("put", avaTaxPath, customerModel, new TypeToken<CustomerModel>(){}).call();
    }

    public Future<CustomerModel> updateCustomerAsync(Integer n, String string, CustomerModel customerModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers/{customerCode}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("customerCode", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, customerModel, new TypeToken<CustomerModel>(){}));
    }

    public ArrayList<DataSourceModel> createDataSources(Integer n, ArrayList<DataSourceModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/datasources");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<DataSourceModel>>(){}).call();
    }

    public Future<ArrayList<DataSourceModel>> createDataSourcesAsync(Integer n, ArrayList<DataSourceModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/datasources");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<DataSourceModel>>(){}));
    }

    public ArrayList<ErrorDetail> deleteDataSource(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/datasources/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}).call();
    }

    public Future<ArrayList<ErrorDetail>> deleteDataSourceAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/datasources/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}));
    }

    public DataSourceModel getDataSourceById(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/datasources/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<DataSourceModel>(){}).call();
    }

    public Future<DataSourceModel> getDataSourceByIdAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/datasources/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<DataSourceModel>(){}));
    }

    public FetchResult<DataSourceModel> listDataSources(Integer n, String string, Integer n2, Integer n3, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/datasources");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<DataSourceModel>>(){}).call();
    }

    public Future<FetchResult<DataSourceModel>> listDataSourcesAsync(Integer n, String string, Integer n2, Integer n3, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/datasources");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<DataSourceModel>>(){}));
    }

    public FetchResult<DataSourceModel> queryDataSources(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/datasources");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<DataSourceModel>>(){}).call();
    }

    public Future<FetchResult<DataSourceModel>> queryDataSourcesAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/datasources");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<DataSourceModel>>(){}));
    }

    public DataSourceModel updateDataSource(Integer n, Integer n2, DataSourceModel dataSourceModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/datasources/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("put", avaTaxPath, dataSourceModel, new TypeToken<DataSourceModel>(){}).call();
    }

    public Future<DataSourceModel> updateDataSourceAsync(Integer n, Integer n2, DataSourceModel dataSourceModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/datasources/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, dataSourceModel, new TypeToken<DataSourceModel>(){}));
    }

    public FetchResult<HsCodeModel> getCrossBorderCode(String string, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/crossborder/{country}/{hsCode}/hierarchy");
        avaTaxPath.applyField("country", string);
        avaTaxPath.applyField("hsCode", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<HsCodeModel>>(){}).call();
    }

    public Future<FetchResult<HsCodeModel>> getCrossBorderCodeAsync(String string, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/crossborder/{country}/{hsCode}/hierarchy");
        avaTaxPath.applyField("country", string);
        avaTaxPath.applyField("hsCode", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<HsCodeModel>>(){}));
    }

    public FetchResult<SkyscraperStatusModel> getLoginVerifierByForm(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/filingcalendars/loginverifiers/{form}");
        avaTaxPath.applyField("form", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SkyscraperStatusModel>>(){}).call();
    }

    public Future<FetchResult<SkyscraperStatusModel>> getLoginVerifierByFormAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/filingcalendars/loginverifiers/{form}");
        avaTaxPath.applyField("form", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SkyscraperStatusModel>>(){}));
    }

    public FetchResult<AvaFileFormModel> listAvaFileForms(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/avafileforms");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<AvaFileFormModel>>(){}).call();
    }

    public Future<FetchResult<AvaFileFormModel>> listAvaFileFormsAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/avafileforms");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<AvaFileFormModel>>(){}));
    }

    public FetchResult<CertificateAttributeModel> listCertificateAttributes(Integer n, String string, Integer n2, Integer n3, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/certificateattributes");
        avaTaxPath.addQuery("companyid", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CertificateAttributeModel>>(){}).call();
    }

    public Future<FetchResult<CertificateAttributeModel>> listCertificateAttributesAsync(Integer n, String string, Integer n2, Integer n3, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/certificateattributes");
        avaTaxPath.addQuery("companyid", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CertificateAttributeModel>>(){}));
    }

    public FetchResult<ExemptionReasonModel> listCertificateExemptReasons(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/certificateexemptreasons");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ExemptionReasonModel>>(){}).call();
    }

    public Future<FetchResult<ExemptionReasonModel>> listCertificateExemptReasonsAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/certificateexemptreasons");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ExemptionReasonModel>>(){}));
    }

    public FetchResult<ExposureZoneModel> listCertificateExposureZones(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/certificateexposurezones");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ExposureZoneModel>>(){}).call();
    }

    public Future<FetchResult<ExposureZoneModel>> listCertificateExposureZonesAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/certificateexposurezones");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ExposureZoneModel>>(){}));
    }

    public FetchResult<CommunicationsTSPairModel> listCommunicationsServiceTypes(Integer n, String string, Integer n2, Integer n3, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/communications/transactiontypes/{id}/servicetypes");
        avaTaxPath.applyField("id", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CommunicationsTSPairModel>>(){}).call();
    }

    public Future<FetchResult<CommunicationsTSPairModel>> listCommunicationsServiceTypesAsync(Integer n, String string, Integer n2, Integer n3, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/communications/transactiontypes/{id}/servicetypes");
        avaTaxPath.applyField("id", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CommunicationsTSPairModel>>(){}));
    }

    public FetchResult<CommunicationsTransactionTypeModel> listCommunicationsTransactionTypes(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/communications/transactiontypes");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CommunicationsTransactionTypeModel>>(){}).call();
    }

    public Future<FetchResult<CommunicationsTransactionTypeModel>> listCommunicationsTransactionTypesAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/communications/transactiontypes");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CommunicationsTransactionTypeModel>>(){}));
    }

    public FetchResult<CommunicationsTSPairModel> listCommunicationsTSPairs(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/communications/tspairs");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CommunicationsTSPairModel>>(){}).call();
    }

    public Future<FetchResult<CommunicationsTSPairModel>> listCommunicationsTSPairsAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/communications/tspairs");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CommunicationsTSPairModel>>(){}));
    }

    public FetchResult<IsoCountryModel> listCountries(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/countries");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<IsoCountryModel>>(){}).call();
    }

    public Future<FetchResult<IsoCountryModel>> listCountriesAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/countries");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<IsoCountryModel>>(){}));
    }

    public FetchResult<CoverLetterModel> listCoverLetters(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/coverletters");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CoverLetterModel>>(){}).call();
    }

    public Future<FetchResult<CoverLetterModel>> listCoverLettersAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/coverletters");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CoverLetterModel>>(){}));
    }

    public FetchResult<HsCodeModel> listCrossBorderCodes(String string, String string2, String string3, Integer n, Integer n2, String string4) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/crossborder/{country}/{hsCode}");
        avaTaxPath.applyField("country", string);
        avaTaxPath.applyField("hsCode", string2);
        avaTaxPath.addQuery("$filter", string3);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string4);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<HsCodeModel>>(){}).call();
    }

    public Future<FetchResult<HsCodeModel>> listCrossBorderCodesAsync(String string, String string2, String string3, Integer n, Integer n2, String string4) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/crossborder/{country}/{hsCode}");
        avaTaxPath.applyField("country", string);
        avaTaxPath.applyField("hsCode", string2);
        avaTaxPath.addQuery("$filter", string3);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string4);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<HsCodeModel>>(){}));
    }

    public FetchResult<HsCodeModel> listCrossBorderSections() throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/crossborder/sections");
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<HsCodeModel>>(){}).call();
    }

    public Future<FetchResult<HsCodeModel>> listCrossBorderSectionsAsync() {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/crossborder/sections");
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<HsCodeModel>>(){}));
    }

    public FetchResult<CurrencyModel> listCurrencies(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/currencies");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CurrencyModel>>(){}).call();
    }

    public Future<FetchResult<CurrencyModel>> listCurrenciesAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/currencies");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CurrencyModel>>(){}));
    }

    public FetchResult<EntityUseCodeModel> listEntityUseCodes(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/entityusecodes");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<EntityUseCodeModel>>(){}).call();
    }

    public Future<FetchResult<EntityUseCodeModel>> listEntityUseCodesAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/entityusecodes");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<EntityUseCodeModel>>(){}));
    }

    public FetchResult<FilingFrequencyModel> listFilingFrequencies(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/filingfrequencies");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<FilingFrequencyModel>>(){}).call();
    }

    public Future<FetchResult<FilingFrequencyModel>> listFilingFrequenciesAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/filingfrequencies");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<FilingFrequencyModel>>(){}));
    }

    public FetchResult<JurisdictionModel> listJurisdictions(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/jurisdictions");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<JurisdictionModel>>(){}).call();
    }

    public Future<FetchResult<JurisdictionModel>> listJurisdictionsAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/jurisdictions");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<JurisdictionModel>>(){}));
    }

    public FetchResult<JurisdictionOverrideModel> listJurisdictionsByAddress(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, Integer n, Integer n2, String string9) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/jurisdictionsnearaddress");
        avaTaxPath.addQuery("line1", string);
        avaTaxPath.addQuery("line2", string2);
        avaTaxPath.addQuery("line3", string3);
        avaTaxPath.addQuery("city", string4);
        avaTaxPath.addQuery("region", string5);
        avaTaxPath.addQuery("postalCode", string6);
        avaTaxPath.addQuery("country", string7);
        avaTaxPath.addQuery("$filter", string8);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string9);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<JurisdictionOverrideModel>>(){}).call();
    }

    public Future<FetchResult<JurisdictionOverrideModel>> listJurisdictionsByAddressAsync(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, Integer n, Integer n2, String string9) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/jurisdictionsnearaddress");
        avaTaxPath.addQuery("line1", string);
        avaTaxPath.addQuery("line2", string2);
        avaTaxPath.addQuery("line3", string3);
        avaTaxPath.addQuery("city", string4);
        avaTaxPath.addQuery("region", string5);
        avaTaxPath.addQuery("postalCode", string6);
        avaTaxPath.addQuery("country", string7);
        avaTaxPath.addQuery("$filter", string8);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string9);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<JurisdictionOverrideModel>>(){}));
    }

    public FetchResult<LocationQuestionModel> listLocationQuestionsByAddress(String string, String string2, String string3, String string4, String string5, String string6, String string7, BigDecimal bigDecimal, BigDecimal bigDecimal2, String string8, Integer n, Integer n2, String string9) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/locationquestions");
        avaTaxPath.addQuery("line1", string);
        avaTaxPath.addQuery("line2", string2);
        avaTaxPath.addQuery("line3", string3);
        avaTaxPath.addQuery("city", string4);
        avaTaxPath.addQuery("region", string5);
        avaTaxPath.addQuery("postalCode", string6);
        avaTaxPath.addQuery("country", string7);
        avaTaxPath.addQuery("latitude", bigDecimal);
        avaTaxPath.addQuery("longitude", bigDecimal2);
        avaTaxPath.addQuery("$filter", string8);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string9);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<LocationQuestionModel>>(){}).call();
    }

    public Future<FetchResult<LocationQuestionModel>> listLocationQuestionsByAddressAsync(String string, String string2, String string3, String string4, String string5, String string6, String string7, BigDecimal bigDecimal, BigDecimal bigDecimal2, String string8, Integer n, Integer n2, String string9) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/locationquestions");
        avaTaxPath.addQuery("line1", string);
        avaTaxPath.addQuery("line2", string2);
        avaTaxPath.addQuery("line3", string3);
        avaTaxPath.addQuery("city", string4);
        avaTaxPath.addQuery("region", string5);
        avaTaxPath.addQuery("postalCode", string6);
        avaTaxPath.addQuery("country", string7);
        avaTaxPath.addQuery("latitude", bigDecimal);
        avaTaxPath.addQuery("longitude", bigDecimal2);
        avaTaxPath.addQuery("$filter", string8);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string9);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<LocationQuestionModel>>(){}));
    }

    public FetchResult<SkyscraperStatusModel> listLoginVerifiers(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/filingcalendars/loginverifiers");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SkyscraperStatusModel>>(){}).call();
    }

    public Future<FetchResult<SkyscraperStatusModel>> listLoginVerifiersAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/filingcalendars/loginverifiers");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SkyscraperStatusModel>>(){}));
    }

    public FetchResult<MarketplaceLocationModel> listMarketplaceLocations(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/marketplacelocations");
        avaTaxPath.addQuery("marketplaceId", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<MarketplaceLocationModel>>(){}).call();
    }

    public Future<FetchResult<MarketplaceLocationModel>> listMarketplaceLocationsAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/marketplacelocations");
        avaTaxPath.addQuery("marketplaceId", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<MarketplaceLocationModel>>(){}));
    }

    public FetchResult<NexusModel> listNexus(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/nexus");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NexusModel>>(){}).call();
    }

    public Future<FetchResult<NexusModel>> listNexusAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/nexus");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NexusModel>>(){}));
    }

    public FetchResult<NexusModel> listNexusByAddress(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, Integer n, Integer n2, String string9) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/nexus/byaddress");
        avaTaxPath.addQuery("line1", string);
        avaTaxPath.addQuery("line2", string2);
        avaTaxPath.addQuery("line3", string3);
        avaTaxPath.addQuery("city", string4);
        avaTaxPath.addQuery("region", string5);
        avaTaxPath.addQuery("postalCode", string6);
        avaTaxPath.addQuery("country", string7);
        avaTaxPath.addQuery("$filter", string8);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string9);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NexusModel>>(){}).call();
    }

    public Future<FetchResult<NexusModel>> listNexusByAddressAsync(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, Integer n, Integer n2, String string9) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/nexus/byaddress");
        avaTaxPath.addQuery("line1", string);
        avaTaxPath.addQuery("line2", string2);
        avaTaxPath.addQuery("line3", string3);
        avaTaxPath.addQuery("city", string4);
        avaTaxPath.addQuery("region", string5);
        avaTaxPath.addQuery("postalCode", string6);
        avaTaxPath.addQuery("country", string7);
        avaTaxPath.addQuery("$filter", string8);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string9);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NexusModel>>(){}));
    }

    public FetchResult<NexusModel> listNexusByCountry(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/nexus/{country}");
        avaTaxPath.applyField("country", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NexusModel>>(){}).call();
    }

    public Future<FetchResult<NexusModel>> listNexusByCountryAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/nexus/{country}");
        avaTaxPath.applyField("country", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NexusModel>>(){}));
    }

    public FetchResult<NexusModel> listNexusByCountryAndRegion(String string, String string2, String string3, Integer n, Integer n2, String string4) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/nexus/{country}/{region}");
        avaTaxPath.applyField("country", string);
        avaTaxPath.applyField("region", string2);
        avaTaxPath.addQuery("$filter", string3);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string4);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NexusModel>>(){}).call();
    }

    public Future<FetchResult<NexusModel>> listNexusByCountryAndRegionAsync(String string, String string2, String string3, Integer n, Integer n2, String string4) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/nexus/{country}/{region}");
        avaTaxPath.applyField("country", string);
        avaTaxPath.applyField("region", string2);
        avaTaxPath.addQuery("$filter", string3);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string4);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NexusModel>>(){}));
    }

    public NexusByTaxFormModel listNexusByFormCode(String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/nexus/byform/{formCode}");
        avaTaxPath.applyField("formCode", string);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<NexusByTaxFormModel>(){}).call();
    }

    public Future<NexusByTaxFormModel> listNexusByFormCodeAsync(String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/nexus/byform/{formCode}");
        avaTaxPath.applyField("formCode", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<NexusByTaxFormModel>(){}));
    }

    public FetchResult<NexusTaxTypeGroupModel> listNexusTaxTypeGroups(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/nexustaxtypegroups");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NexusTaxTypeGroupModel>>(){}).call();
    }

    public Future<FetchResult<NexusTaxTypeGroupModel>> listNexusTaxTypeGroupsAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/nexustaxtypegroups");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NexusTaxTypeGroupModel>>(){}));
    }

    public FetchResult<NoticeCustomerFundingOptionModel> listNoticeCustomerFundingOptions(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticecustomerfundingoptions");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeCustomerFundingOptionModel>>(){}).call();
    }

    public Future<FetchResult<NoticeCustomerFundingOptionModel>> listNoticeCustomerFundingOptionsAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticecustomerfundingoptions");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeCustomerFundingOptionModel>>(){}));
    }

    public FetchResult<NoticeCustomerTypeModel> listNoticeCustomerTypes(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticecustomertypes");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeCustomerTypeModel>>(){}).call();
    }

    public Future<FetchResult<NoticeCustomerTypeModel>> listNoticeCustomerTypesAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticecustomertypes");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeCustomerTypeModel>>(){}));
    }

    public FetchResult<NoticeFilingTypeModel> listNoticeFilingtypes(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticefilingtypes");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeFilingTypeModel>>(){}).call();
    }

    public Future<FetchResult<NoticeFilingTypeModel>> listNoticeFilingtypesAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticefilingtypes");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeFilingTypeModel>>(){}));
    }

    public FetchResult<NoticePriorityModel> listNoticePriorities(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticepriorities");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticePriorityModel>>(){}).call();
    }

    public Future<FetchResult<NoticePriorityModel>> listNoticePrioritiesAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticepriorities");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticePriorityModel>>(){}));
    }

    public FetchResult<NoticeReasonModel> listNoticeReasons(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticereasons");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeReasonModel>>(){}).call();
    }

    public Future<FetchResult<NoticeReasonModel>> listNoticeReasonsAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticereasons");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeReasonModel>>(){}));
    }

    public FetchResult<NoticeResponsibilityModel> listNoticeResponsibilities(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticeresponsibilities");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeResponsibilityModel>>(){}).call();
    }

    public Future<FetchResult<NoticeResponsibilityModel>> listNoticeResponsibilitiesAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticeresponsibilities");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeResponsibilityModel>>(){}));
    }

    public FetchResult<NoticeRootCauseModel> listNoticeRootCauses(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticerootcauses");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeRootCauseModel>>(){}).call();
    }

    public Future<FetchResult<NoticeRootCauseModel>> listNoticeRootCausesAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticerootcauses");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeRootCauseModel>>(){}));
    }

    public FetchResult<NoticeStatusModel> listNoticeStatuses(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticestatuses");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeStatusModel>>(){}).call();
    }

    public Future<FetchResult<NoticeStatusModel>> listNoticeStatusesAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticestatuses");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeStatusModel>>(){}));
    }

    public FetchResult<NoticeTypeModel> listNoticeTypes(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticetypes");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeTypeModel>>(){}).call();
    }

    public Future<FetchResult<NoticeTypeModel>> listNoticeTypesAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticetypes");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeTypeModel>>(){}));
    }

    public FetchResult<ParameterModel> listParameters(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/parameters");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ParameterModel>>(){}).call();
    }

    public Future<FetchResult<ParameterModel>> listParametersAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/parameters");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ParameterModel>>(){}));
    }

    public FetchResult<ParameterModel> listParametersByItem(String string, String string2, String string3, Integer n, Integer n2, String string4) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/parameters/byitem/{companyCode}/{itemCode}");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("itemCode", string2);
        avaTaxPath.addQuery("$filter", string3);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string4);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ParameterModel>>(){}).call();
    }

    public Future<FetchResult<ParameterModel>> listParametersByItemAsync(String string, String string2, String string3, Integer n, Integer n2, String string4) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/parameters/byitem/{companyCode}/{itemCode}");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("itemCode", string2);
        avaTaxPath.addQuery("$filter", string3);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string4);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ParameterModel>>(){}));
    }

    public FetchResult<ParameterUsageModel> listParametersUsage(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/parametersusage");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ParameterUsageModel>>(){}).call();
    }

    public Future<FetchResult<ParameterUsageModel>> listParametersUsageAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/parametersusage");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ParameterUsageModel>>(){}));
    }

    public FetchResult<String> listPermissions(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/permissions");
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<String>>(){}).call();
    }

    public Future<FetchResult<String>> listPermissionsAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/permissions");
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<String>>(){}));
    }

    public FetchResult<PostalCodeModel> listPostalCodes(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/postalcodes");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<PostalCodeModel>>(){}).call();
    }

    public Future<FetchResult<PostalCodeModel>> listPostalCodesAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/postalcodes");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<PostalCodeModel>>(){}));
    }

    public FetchResult<PreferredProgramModel> listPreferredPrograms(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/preferredprograms");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<PreferredProgramModel>>(){}).call();
    }

    public Future<FetchResult<PreferredProgramModel>> listPreferredProgramsAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/preferredprograms");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<PreferredProgramModel>>(){}));
    }

    public FetchResult<ProductClassificationSystemModel> listProductClassificationSystems(String string, Integer n, Integer n2, String string2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/productclassificationsystems");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        avaTaxPath.addQuery("$countryCode", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ProductClassificationSystemModel>>(){}).call();
    }

    public Future<FetchResult<ProductClassificationSystemModel>> listProductClassificationSystemsAsync(String string, Integer n, Integer n2, String string2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/productclassificationsystems");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        avaTaxPath.addQuery("$countryCode", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ProductClassificationSystemModel>>(){}));
    }

    public FetchResult<ProductClassificationSystemModel> listProductClassificationSystemsByCompany(String string, String string2, Integer n, Integer n2, String string3, String string4) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/productclassificationsystems/bycompany/{companyCode}");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        avaTaxPath.addQuery("$countryCode", string4);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ProductClassificationSystemModel>>(){}).call();
    }

    public Future<FetchResult<ProductClassificationSystemModel>> listProductClassificationSystemsByCompanyAsync(String string, String string2, Integer n, Integer n2, String string3, String string4) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/productclassificationsystems/bycompany/{companyCode}");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        avaTaxPath.addQuery("$countryCode", string4);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ProductClassificationSystemModel>>(){}));
    }

    public FetchResult<RateTypeModel> listRateTypesByCountry(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/countries/{country}/ratetypes");
        avaTaxPath.applyField("country", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<RateTypeModel>>(){}).call();
    }

    public Future<FetchResult<RateTypeModel>> listRateTypesByCountryAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/countries/{country}/ratetypes");
        avaTaxPath.applyField("country", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<RateTypeModel>>(){}));
    }

    public FetchResult<IsoRegionModel> listRegions(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/regions");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<IsoRegionModel>>(){}).call();
    }

    public Future<FetchResult<IsoRegionModel>> listRegionsAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/regions");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<IsoRegionModel>>(){}));
    }

    public FetchResult<IsoRegionModel> listRegionsByCountry(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/countries/{country}/regions");
        avaTaxPath.applyField("country", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<IsoRegionModel>>(){}).call();
    }

    public Future<FetchResult<IsoRegionModel>> listRegionsByCountryAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/countries/{country}/regions");
        avaTaxPath.applyField("country", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<IsoRegionModel>>(){}));
    }

    public FetchResult<ResourceFileTypeModel> listResourceFileTypes(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/resourcefiletypes");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ResourceFileTypeModel>>(){}).call();
    }

    public Future<FetchResult<ResourceFileTypeModel>> listResourceFileTypesAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/resourcefiletypes");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ResourceFileTypeModel>>(){}));
    }

    public FetchResult<SecurityRoleModel> listSecurityRoles(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/securityroles");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SecurityRoleModel>>(){}).call();
    }

    public Future<FetchResult<SecurityRoleModel>> listSecurityRolesAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/securityroles");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SecurityRoleModel>>(){}));
    }

    public FetchResult<SubscriptionTypeModel> listSubscriptionTypes(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/subscriptiontypes");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SubscriptionTypeModel>>(){}).call();
    }

    public Future<FetchResult<SubscriptionTypeModel>> listSubscriptionTypesAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/subscriptiontypes");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SubscriptionTypeModel>>(){}));
    }

    public FetchResult<TaxAuthorityModel> listTaxAuthorities(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/taxauthorities");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxAuthorityModel>>(){}).call();
    }

    public Future<FetchResult<TaxAuthorityModel>> listTaxAuthoritiesAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/taxauthorities");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxAuthorityModel>>(){}));
    }

    public FetchResult<TaxAuthorityFormModel> listTaxAuthorityForms(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/taxauthorityforms");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxAuthorityFormModel>>(){}).call();
    }

    public Future<FetchResult<TaxAuthorityFormModel>> listTaxAuthorityFormsAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/taxauthorityforms");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxAuthorityFormModel>>(){}));
    }

    public FetchResult<TaxAuthorityTypeModel> listTaxAuthorityTypes(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/taxauthoritytypes");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxAuthorityTypeModel>>(){}).call();
    }

    public Future<FetchResult<TaxAuthorityTypeModel>> listTaxAuthorityTypesAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/taxauthoritytypes");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxAuthorityTypeModel>>(){}));
    }

    public FetchResult<TaxCodeModel> listTaxCodes(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/taxcodes");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxCodeModel>>(){}).call();
    }

    public Future<FetchResult<TaxCodeModel>> listTaxCodesAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/taxcodes");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxCodeModel>>(){}));
    }

    public TaxCodeTypesModel listTaxCodeTypes(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/taxcodetypes");
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<TaxCodeTypesModel>(){}).call();
    }

    public Future<TaxCodeTypesModel> listTaxCodeTypesAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/taxcodetypes");
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<TaxCodeTypesModel>(){}));
    }

    public FetchResult<FormMasterModel> listTaxForms(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/taxforms");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<FormMasterModel>>(){}).call();
    }

    public Future<FetchResult<FormMasterModel>> listTaxFormsAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/taxforms");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<FormMasterModel>>(){}));
    }

    public FetchResult<TaxSubTypeModel> listTaxSubTypes(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/taxsubtypes");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxSubTypeModel>>(){}).call();
    }

    public Future<FetchResult<TaxSubTypeModel>> listTaxSubTypesAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/taxsubtypes");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxSubTypeModel>>(){}));
    }

    public FetchResult<TaxTypeGroupModel> listTaxTypeGroups(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/taxtypegroups");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxTypeGroupModel>>(){}).call();
    }

    public Future<FetchResult<TaxTypeGroupModel>> listTaxTypeGroupsAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/taxtypegroups");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxTypeGroupModel>>(){}));
    }

    public FetchResult<UomModel> listUnitOfMeasurement(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/unitofmeasurements");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<UomModel>>(){}).call();
    }

    public Future<FetchResult<UomModel>> listUnitOfMeasurementAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/unitofmeasurements");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<UomModel>>(){}));
    }

    public ArrayList<CompanyDistanceThresholdModel> createDistanceThreshold(Integer n, ArrayList<CompanyDistanceThresholdModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/distancethresholds");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<CompanyDistanceThresholdModel>>(){}).call();
    }

    public Future<ArrayList<CompanyDistanceThresholdModel>> createDistanceThresholdAsync(Integer n, ArrayList<CompanyDistanceThresholdModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/distancethresholds");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<CompanyDistanceThresholdModel>>(){}));
    }

    public ArrayList<ErrorDetail> deleteDistanceThreshold(Integer n, Long l) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/distancethresholds/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", l);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}).call();
    }

    public Future<ArrayList<ErrorDetail>> deleteDistanceThresholdAsync(Integer n, Long l) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/distancethresholds/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}));
    }

    public CompanyDistanceThresholdModel getDistanceThreshold(Integer n, Long l) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/distancethresholds/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", l);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<CompanyDistanceThresholdModel>(){}).call();
    }

    public Future<CompanyDistanceThresholdModel> getDistanceThresholdAsync(Integer n, Long l) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/distancethresholds/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<CompanyDistanceThresholdModel>(){}));
    }

    public FetchResult<CompanyDistanceThresholdModel> listDistanceThresholds(Integer n, String string, String string2, Integer n2, Integer n3, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/distancethresholds");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CompanyDistanceThresholdModel>>(){}).call();
    }

    public Future<FetchResult<CompanyDistanceThresholdModel>> listDistanceThresholdsAsync(Integer n, String string, String string2, Integer n2, Integer n3, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/distancethresholds");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CompanyDistanceThresholdModel>>(){}));
    }

    public FetchResult<CompanyDistanceThresholdModel> queryDistanceThresholds(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/distancethresholds");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CompanyDistanceThresholdModel>>(){}).call();
    }

    public Future<FetchResult<CompanyDistanceThresholdModel>> queryDistanceThresholdsAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/distancethresholds");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CompanyDistanceThresholdModel>>(){}));
    }

    public CompanyDistanceThresholdModel updateDistanceThreshold(Integer n, Long l, CompanyDistanceThresholdModel companyDistanceThresholdModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/distancethresholds/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", l);
        return this.restCallFactory.createRestCall("put", avaTaxPath, companyDistanceThresholdModel, new TypeToken<CompanyDistanceThresholdModel>(){}).call();
    }

    public Future<CompanyDistanceThresholdModel> updateDistanceThresholdAsync(Integer n, Long l, CompanyDistanceThresholdModel companyDistanceThresholdModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/distancethresholds/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, companyDistanceThresholdModel, new TypeToken<CompanyDistanceThresholdModel>(){}));
    }

    public ArrayList<CompanyReturnSettingModel> deleteCompanyReturnSettings(Integer n, Integer n2, Long l) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filingcalendars/{filingCalendarId}/setting/{companyReturnSettingId}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("filingCalendarId", n2);
        avaTaxPath.applyField("companyReturnSettingId", l);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<CompanyReturnSettingModel>>(){}).call();
    }

    public Future<ArrayList<CompanyReturnSettingModel>> deleteCompanyReturnSettingsAsync(Integer n, Integer n2, Long l) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filingcalendars/{filingCalendarId}/setting/{companyReturnSettingId}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("filingCalendarId", n2);
        avaTaxPath.applyField("companyReturnSettingId", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<CompanyReturnSettingModel>>(){}));
    }

    public FetchResult<FiledReturnModel> getFiledReturns(Integer n, Integer n2, Integer n3, FilingFrequencyId filingFrequencyId, FilingStatusId filingStatusId, String string, String string2, Long l, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filings/returns/filed");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("endPeriodMonth", n2);
        avaTaxPath.addQuery("endPeriodYear", n3);
        avaTaxPath.addQuery("frequency", (Object)filingFrequencyId);
        avaTaxPath.addQuery("status", (Object)filingStatusId);
        avaTaxPath.addQuery("country", string);
        avaTaxPath.addQuery("region", string2);
        avaTaxPath.addQuery("filingCalendarId", l);
        avaTaxPath.addQuery("taxformCode", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<FiledReturnModel>>(){}).call();
    }

    public Future<FetchResult<FiledReturnModel>> getFiledReturnsAsync(Integer n, Integer n2, Integer n3, FilingFrequencyId filingFrequencyId, FilingStatusId filingStatusId, String string, String string2, Long l, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/filings/returns/filed");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("endPeriodMonth", n2);
        avaTaxPath.addQuery("endPeriodYear", n3);
        avaTaxPath.addQuery("frequency", (Object)filingFrequencyId);
        avaTaxPath.addQuery("status", (Object)filingStatusId);
        avaTaxPath.addQuery("country", string);
        avaTaxPath.addQuery("region", string2);
        avaTaxPath.addQuery("filingCalendarId", l);
        avaTaxPath.addQuery("taxformCode", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<FiledReturnModel>>(){}));
    }

    public FirmClientLinkageOutputModel approveFirmClientLinkage(Integer n) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/firmclientlinkages/{id}/approve");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, null, new TypeToken<FirmClientLinkageOutputModel>(){}).call();
    }

    public Future<FirmClientLinkageOutputModel> approveFirmClientLinkageAsync(Integer n) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/firmclientlinkages/{id}/approve");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, null, new TypeToken<FirmClientLinkageOutputModel>(){}));
    }

    public FirmClientLinkageOutputModel createAndLinkNewFirmClientAccount(NewFirmClientAccountRequestModel newFirmClientAccountRequestModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/firmclientlinkages/createandlinkclient");
        return this.restCallFactory.createRestCall("post", avaTaxPath, newFirmClientAccountRequestModel, new TypeToken<FirmClientLinkageOutputModel>(){}).call();
    }

    public Future<FirmClientLinkageOutputModel> createAndLinkNewFirmClientAccountAsync(NewFirmClientAccountRequestModel newFirmClientAccountRequestModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/firmclientlinkages/createandlinkclient");
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, newFirmClientAccountRequestModel, new TypeToken<FirmClientLinkageOutputModel>(){}));
    }

    public FirmClientLinkageOutputModel createFirmClientLinkage(FirmClientLinkageInputModel firmClientLinkageInputModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/firmclientlinkages");
        return this.restCallFactory.createRestCall("post", avaTaxPath, firmClientLinkageInputModel, new TypeToken<FirmClientLinkageOutputModel>(){}).call();
    }

    public Future<FirmClientLinkageOutputModel> createFirmClientLinkageAsync(FirmClientLinkageInputModel firmClientLinkageInputModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/firmclientlinkages");
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, firmClientLinkageInputModel, new TypeToken<FirmClientLinkageOutputModel>(){}));
    }

    public ArrayList<ErrorDetail> deleteFirmClientLinkage(Integer n) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/firmclientlinkages/{id}");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}).call();
    }

    public Future<ArrayList<ErrorDetail>> deleteFirmClientLinkageAsync(Integer n) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/firmclientlinkages/{id}");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}));
    }

    public FirmClientLinkageOutputModel getFirmClientLinkage(Integer n) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/firmclientlinkages/{id}");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FirmClientLinkageOutputModel>(){}).call();
    }

    public Future<FirmClientLinkageOutputModel> getFirmClientLinkageAsync(Integer n) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/firmclientlinkages/{id}");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FirmClientLinkageOutputModel>(){}));
    }

    public FetchResult<FirmClientLinkageOutputModel> listFirmClientLinkage(String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/firmclientlinkages");
        avaTaxPath.addQuery("$filter", string);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<FirmClientLinkageOutputModel>>(){}).call();
    }

    public Future<FetchResult<FirmClientLinkageOutputModel>> listFirmClientLinkageAsync(String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/firmclientlinkages");
        avaTaxPath.addQuery("$filter", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<FirmClientLinkageOutputModel>>(){}));
    }

    public FirmClientLinkageOutputModel rejectFirmClientLinkage(Integer n) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/firmclientlinkages/{id}/reject");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, null, new TypeToken<FirmClientLinkageOutputModel>(){}).call();
    }

    public Future<FirmClientLinkageOutputModel> rejectFirmClientLinkageAsync(Integer n) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/firmclientlinkages/{id}/reject");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, null, new TypeToken<FirmClientLinkageOutputModel>(){}));
    }

    public FirmClientLinkageOutputModel resetFirmClientLinkage(Integer n) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/firmclientlinkages/{id}/reset");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, null, new TypeToken<FirmClientLinkageOutputModel>(){}).call();
    }

    public Future<FirmClientLinkageOutputModel> resetFirmClientLinkageAsync(Integer n) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/firmclientlinkages/{id}/reset");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, null, new TypeToken<FirmClientLinkageOutputModel>(){}));
    }

    public FirmClientLinkageOutputModel revokeFirmClientLinkage(Integer n) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/firmclientlinkages/{id}/revoke");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, null, new TypeToken<FirmClientLinkageOutputModel>(){}).call();
    }

    public Future<FirmClientLinkageOutputModel> revokeFirmClientLinkageAsync(Integer n) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/firmclientlinkages/{id}/revoke");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, null, new TypeToken<FirmClientLinkageOutputModel>(){}));
    }

    public NewAccountModel requestFreeTrial(FreeTrialRequestModel freeTrialRequestModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/freetrials/request");
        return this.restCallFactory.createRestCall("post", avaTaxPath, freeTrialRequestModel, new TypeToken<NewAccountModel>(){}).call();
    }

    public Future<NewAccountModel> requestFreeTrialAsync(FreeTrialRequestModel freeTrialRequestModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/freetrials/request");
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, freeTrialRequestModel, new TypeToken<NewAccountModel>(){}));
    }

    public TaxRateModel taxRatesByAddress(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/taxrates/byaddress");
        avaTaxPath.addQuery("line1", string);
        avaTaxPath.addQuery("line2", string2);
        avaTaxPath.addQuery("line3", string3);
        avaTaxPath.addQuery("city", string4);
        avaTaxPath.addQuery("region", string5);
        avaTaxPath.addQuery("postalCode", string6);
        avaTaxPath.addQuery("country", string7);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<TaxRateModel>(){}).call();
    }

    public Future<TaxRateModel> taxRatesByAddressAsync(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/taxrates/byaddress");
        avaTaxPath.addQuery("line1", string);
        avaTaxPath.addQuery("line2", string2);
        avaTaxPath.addQuery("line3", string3);
        avaTaxPath.addQuery("city", string4);
        avaTaxPath.addQuery("region", string5);
        avaTaxPath.addQuery("postalCode", string6);
        avaTaxPath.addQuery("country", string7);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<TaxRateModel>(){}));
    }

    public TaxRateModel taxRatesByPostalCode(String string, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/taxrates/bypostalcode");
        avaTaxPath.addQuery("country", string);
        avaTaxPath.addQuery("postalCode", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<TaxRateModel>(){}).call();
    }

    public Future<TaxRateModel> taxRatesByPostalCodeAsync(String string, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/taxrates/bypostalcode");
        avaTaxPath.addQuery("country", string);
        avaTaxPath.addQuery("postalCode", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<TaxRateModel>(){}));
    }

    public FundingStatusModel activateFundingRequest(Long l) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/fundingrequests/{id}/widget");
        avaTaxPath.applyField("id", l);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FundingStatusModel>(){}).call();
    }

    public Future<FundingStatusModel> activateFundingRequestAsync(Long l) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/fundingrequests/{id}/widget");
        avaTaxPath.applyField("id", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FundingStatusModel>(){}));
    }

    public FundingStatusModel fundingRequestStatus(Integer n) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/fundingrequests/{id}");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FundingStatusModel>(){}).call();
    }

    public Future<FundingStatusModel> fundingRequestStatusAsync(Integer n) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/fundingrequests/{id}");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FundingStatusModel>(){}));
    }

    public ArrayList<ErrorDetail> batchDeleteItemClassifications(Integer n, Long l) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/classifications");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}).call();
    }

    public Future<ArrayList<ErrorDetail>> batchDeleteItemClassificationsAsync(Integer n, Long l) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/classifications");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}));
    }

    public ArrayList<ErrorDetail> batchDeleteItemParameters(Integer n, Long l) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/parameters");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}).call();
    }

    public Future<ArrayList<ErrorDetail>> batchDeleteItemParametersAsync(Integer n, Long l) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/parameters");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}));
    }

    public ArrayList<ItemClassificationOutputModel> createItemClassifications(Integer n, Long l, ArrayList<ItemClassificationInputModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/classifications");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<ItemClassificationOutputModel>>(){}).call();
    }

    public Future<ArrayList<ItemClassificationOutputModel>> createItemClassificationsAsync(Integer n, Long l, ArrayList<ItemClassificationInputModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/classifications");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<ItemClassificationOutputModel>>(){}));
    }

    public ArrayList<ItemParameterModel> createItemParameters(Integer n, Long l, ArrayList<ItemParameterModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/parameters");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<ItemParameterModel>>(){}).call();
    }

    public Future<ArrayList<ItemParameterModel>> createItemParametersAsync(Integer n, Long l, ArrayList<ItemParameterModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/parameters");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<ItemParameterModel>>(){}));
    }

    public ArrayList<ItemModel> createItems(Integer n, ArrayList<ItemModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<ItemModel>>(){}).call();
    }

    public Future<ArrayList<ItemModel>> createItemsAsync(Integer n, ArrayList<ItemModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<ItemModel>>(){}));
    }

    public ArrayList<ErrorDetail> deleteItem(Integer n, Long l) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", l);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}).call();
    }

    public Future<ArrayList<ErrorDetail>> deleteItemAsync(Integer n, Long l) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}));
    }

    public ArrayList<ErrorDetail> deleteItemClassification(Integer n, Long l, Long l2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/classifications/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        avaTaxPath.applyField("id", l2);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}).call();
    }

    public Future<ArrayList<ErrorDetail>> deleteItemClassificationAsync(Integer n, Long l, Long l2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/classifications/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        avaTaxPath.applyField("id", l2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}));
    }

    public ArrayList<ErrorDetail> deleteItemParameter(Integer n, Long l, Long l2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/parameters/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        avaTaxPath.applyField("id", l2);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}).call();
    }

    public Future<ArrayList<ErrorDetail>> deleteItemParameterAsync(Integer n, Long l, Long l2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/parameters/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        avaTaxPath.applyField("id", l2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}));
    }

    public ItemModel getItem(Integer n, Long l, String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", l);
        avaTaxPath.addQuery("$include", string);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ItemModel>(){}).call();
    }

    public Future<ItemModel> getItemAsync(Integer n, Long l, String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", l);
        avaTaxPath.addQuery("$include", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ItemModel>(){}));
    }

    public ItemClassificationOutputModel getItemClassification(Integer n, Long l, Long l2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/classifications/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        avaTaxPath.applyField("id", l2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ItemClassificationOutputModel>(){}).call();
    }

    public Future<ItemClassificationOutputModel> getItemClassificationAsync(Integer n, Long l, Long l2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/classifications/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        avaTaxPath.applyField("id", l2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ItemClassificationOutputModel>(){}));
    }

    public ItemParameterModel getItemParameter(Integer n, Long l, Long l2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/parameters/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        avaTaxPath.applyField("id", l2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ItemParameterModel>(){}).call();
    }

    public Future<ItemParameterModel> getItemParameterAsync(Integer n, Long l, Long l2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/parameters/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        avaTaxPath.applyField("id", l2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ItemParameterModel>(){}));
    }

    public FetchResult<ItemClassificationOutputModel> listItemClassifications(Integer n, Long l, String string, Integer n2, Integer n3, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/classifications");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ItemClassificationOutputModel>>(){}).call();
    }

    public Future<FetchResult<ItemClassificationOutputModel>> listItemClassificationsAsync(Integer n, Long l, String string, Integer n2, Integer n3, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/classifications");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ItemClassificationOutputModel>>(){}));
    }

    public FetchResult<ItemParameterModel> listItemParameters(Integer n, Long l, String string, Integer n2, Integer n3, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/parameters");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ItemParameterModel>>(){}).call();
    }

    public Future<FetchResult<ItemParameterModel>> listItemParametersAsync(Integer n, Long l, String string, Integer n2, Integer n3, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/parameters");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ItemParameterModel>>(){}));
    }

    public FetchResult<ItemModel> listItemsByCompany(Integer n, String string, String string2, Integer n2, Integer n3, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ItemModel>>(){}).call();
    }

    public Future<FetchResult<ItemModel>> listItemsByCompanyAsync(Integer n, String string, String string2, Integer n2, Integer n3, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ItemModel>>(){}));
    }

    public FetchResult<ItemModel> queryItems(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/items");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ItemModel>>(){}).call();
    }

    public Future<FetchResult<ItemModel>> queryItemsAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/items");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ItemModel>>(){}));
    }

    public SyncItemsResponseModel syncItems(Integer n, SyncItemsRequestModel syncItemsRequestModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/sync");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, syncItemsRequestModel, new TypeToken<SyncItemsResponseModel>(){}).call();
    }

    public Future<SyncItemsResponseModel> syncItemsAsync(Integer n, SyncItemsRequestModel syncItemsRequestModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/sync");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, syncItemsRequestModel, new TypeToken<SyncItemsResponseModel>(){}));
    }

    public ItemModel updateItem(Integer n, Long l, ItemModel itemModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", l);
        return this.restCallFactory.createRestCall("put", avaTaxPath, itemModel, new TypeToken<ItemModel>(){}).call();
    }

    public Future<ItemModel> updateItemAsync(Integer n, Long l, ItemModel itemModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, itemModel, new TypeToken<ItemModel>(){}));
    }

    public ItemClassificationOutputModel updateItemClassification(Integer n, Long l, Long l2, ItemClassificationInputModel itemClassificationInputModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/classifications/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        avaTaxPath.applyField("id", l2);
        return this.restCallFactory.createRestCall("put", avaTaxPath, itemClassificationInputModel, new TypeToken<ItemClassificationOutputModel>(){}).call();
    }

    public Future<ItemClassificationOutputModel> updateItemClassificationAsync(Integer n, Long l, Long l2, ItemClassificationInputModel itemClassificationInputModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/classifications/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        avaTaxPath.applyField("id", l2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, itemClassificationInputModel, new TypeToken<ItemClassificationOutputModel>(){}));
    }

    public ItemParameterModel updateItemParameter(Integer n, Long l, Long l2, ItemParameterModel itemParameterModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/parameters/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        avaTaxPath.applyField("id", l2);
        return this.restCallFactory.createRestCall("put", avaTaxPath, itemParameterModel, new TypeToken<ItemParameterModel>(){}).call();
    }

    public Future<ItemParameterModel> updateItemParameterAsync(Integer n, Long l, Long l2, ItemParameterModel itemParameterModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/parameters/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        avaTaxPath.applyField("id", l2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, itemParameterModel, new TypeToken<ItemParameterModel>(){}));
    }

    public ArrayList<JurisdictionOverrideModel> createJurisdictionOverrides(Integer n, ArrayList<JurisdictionOverrideModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/jurisdictionoverrides");
        avaTaxPath.applyField("accountId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<JurisdictionOverrideModel>>(){}).call();
    }

    public Future<ArrayList<JurisdictionOverrideModel>> createJurisdictionOverridesAsync(Integer n, ArrayList<JurisdictionOverrideModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/jurisdictionoverrides");
        avaTaxPath.applyField("accountId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<JurisdictionOverrideModel>>(){}));
    }

    public ArrayList<ErrorDetail> deleteJurisdictionOverride(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/jurisdictionoverrides/{id}");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}).call();
    }

    public Future<ArrayList<ErrorDetail>> deleteJurisdictionOverrideAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/jurisdictionoverrides/{id}");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}));
    }

    public JurisdictionOverrideModel getJurisdictionOverride(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/jurisdictionoverrides/{id}");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<JurisdictionOverrideModel>(){}).call();
    }

    public Future<JurisdictionOverrideModel> getJurisdictionOverrideAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/jurisdictionoverrides/{id}");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<JurisdictionOverrideModel>(){}));
    }

    public FetchResult<JurisdictionOverrideModel> listJurisdictionOverridesByAccount(Integer n, String string, String string2, Integer n2, Integer n3, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/jurisdictionoverrides");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<JurisdictionOverrideModel>>(){}).call();
    }

    public Future<FetchResult<JurisdictionOverrideModel>> listJurisdictionOverridesByAccountAsync(Integer n, String string, String string2, Integer n2, Integer n3, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/jurisdictionoverrides");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<JurisdictionOverrideModel>>(){}));
    }

    public FetchResult<JurisdictionOverrideModel> queryJurisdictionOverrides(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/jurisdictionoverrides");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<JurisdictionOverrideModel>>(){}).call();
    }

    public Future<FetchResult<JurisdictionOverrideModel>> queryJurisdictionOverridesAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/jurisdictionoverrides");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<JurisdictionOverrideModel>>(){}));
    }

    public JurisdictionOverrideModel updateJurisdictionOverride(Integer n, Integer n2, JurisdictionOverrideModel jurisdictionOverrideModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/jurisdictionoverrides/{id}");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("put", avaTaxPath, jurisdictionOverrideModel, new TypeToken<JurisdictionOverrideModel>(){}).call();
    }

    public Future<JurisdictionOverrideModel> updateJurisdictionOverrideAsync(Integer n, Integer n2, JurisdictionOverrideModel jurisdictionOverrideModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/jurisdictionoverrides/{id}");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, jurisdictionOverrideModel, new TypeToken<JurisdictionOverrideModel>(){}));
    }

    public ArrayList<LocationModel> createLocations(Integer n, ArrayList<LocationModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/locations");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<LocationModel>>(){}).call();
    }

    public Future<ArrayList<LocationModel>> createLocationsAsync(Integer n, ArrayList<LocationModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/locations");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<LocationModel>>(){}));
    }

    public ArrayList<ErrorDetail> deleteLocation(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/locations/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}).call();
    }

    public Future<ArrayList<ErrorDetail>> deleteLocationAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/locations/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}));
    }

    public LocationModel getLocation(Integer n, Integer n2, String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/locations/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        avaTaxPath.addQuery("$include", string);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<LocationModel>(){}).call();
    }

    public Future<LocationModel> getLocationAsync(Integer n, Integer n2, String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/locations/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        avaTaxPath.addQuery("$include", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<LocationModel>(){}));
    }

    public FetchResult<LocationModel> listLocationsByCompany(Integer n, String string, String string2, Integer n2, Integer n3, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/locations");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<LocationModel>>(){}).call();
    }

    public Future<FetchResult<LocationModel>> listLocationsByCompanyAsync(Integer n, String string, String string2, Integer n2, Integer n3, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/locations");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<LocationModel>>(){}));
    }

    public FetchResult<LocationModel> queryLocations(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/locations");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<LocationModel>>(){}).call();
    }

    public Future<FetchResult<LocationModel>> queryLocationsAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/locations");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<LocationModel>>(){}));
    }

    public LocationModel updateLocation(Integer n, Integer n2, LocationModel locationModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/locations/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("put", avaTaxPath, locationModel, new TypeToken<LocationModel>(){}).call();
    }

    public Future<LocationModel> updateLocationAsync(Integer n, Integer n2, LocationModel locationModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/locations/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, locationModel, new TypeToken<LocationModel>(){}));
    }

    public LocationValidationModel validateLocation(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/locations/{id}/validate");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<LocationValidationModel>(){}).call();
    }

    public Future<LocationValidationModel> validateLocationAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/locations/{id}/validate");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<LocationValidationModel>(){}));
    }

    public MultiDocumentModel adjustMultiDocumentTransaction(String string, DocumentType documentType, String string2, AdjustMultiDocumentModel adjustMultiDocumentModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/multidocument/{code}/type/{type}/adjust");
        avaTaxPath.applyField("code", string);
        avaTaxPath.applyField("type", (Object)documentType);
        avaTaxPath.addQuery("include", string2);
        return this.restCallFactory.createRestCall("post", avaTaxPath, adjustMultiDocumentModel, new TypeToken<MultiDocumentModel>(){}).call();
    }

    public Future<MultiDocumentModel> adjustMultiDocumentTransactionAsync(String string, DocumentType documentType, String string2, AdjustMultiDocumentModel adjustMultiDocumentModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/multidocument/{code}/type/{type}/adjust");
        avaTaxPath.applyField("code", string);
        avaTaxPath.applyField("type", (Object)documentType);
        avaTaxPath.addQuery("include", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, adjustMultiDocumentModel, new TypeToken<MultiDocumentModel>(){}));
    }

    public AuditMultiDocumentModel auditMultiDocumentTransaction(String string, DocumentType documentType) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/multidocument/{code}/type/{type}/audit");
        avaTaxPath.applyField("code", string);
        avaTaxPath.applyField("type", (Object)documentType);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<AuditMultiDocumentModel>(){}).call();
    }

    public Future<AuditMultiDocumentModel> auditMultiDocumentTransactionAsync(String string, DocumentType documentType) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/multidocument/{code}/type/{type}/audit");
        avaTaxPath.applyField("code", string);
        avaTaxPath.applyField("type", (Object)documentType);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<AuditMultiDocumentModel>(){}));
    }

    public MultiDocumentModel commitMultiDocumentTransaction(CommitMultiDocumentModel commitMultiDocumentModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/multidocument/commit");
        return this.restCallFactory.createRestCall("post", avaTaxPath, commitMultiDocumentModel, new TypeToken<MultiDocumentModel>(){}).call();
    }

    public Future<MultiDocumentModel> commitMultiDocumentTransactionAsync(CommitMultiDocumentModel commitMultiDocumentModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/multidocument/commit");
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, commitMultiDocumentModel, new TypeToken<MultiDocumentModel>(){}));
    }

    public MultiDocumentModel createMultiDocumentTransaction(String string, CreateMultiDocumentModel createMultiDocumentModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/multidocument");
        avaTaxPath.addQuery("$include", string);
        return this.restCallFactory.createRestCall("post", avaTaxPath, createMultiDocumentModel, new TypeToken<MultiDocumentModel>(){}).call();
    }

    public Future<MultiDocumentModel> createMultiDocumentTransactionAsync(String string, CreateMultiDocumentModel createMultiDocumentModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/multidocument");
        avaTaxPath.addQuery("$include", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, createMultiDocumentModel, new TypeToken<MultiDocumentModel>(){}));
    }

    public MultiDocumentModel getMultiDocumentTransactionByCodeAndType(String string, DocumentType documentType, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/multidocument/{code}/type/{type}");
        avaTaxPath.applyField("code", string);
        avaTaxPath.applyField("type", (Object)documentType);
        avaTaxPath.addQuery("$include", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<MultiDocumentModel>(){}).call();
    }

    public Future<MultiDocumentModel> getMultiDocumentTransactionByCodeAndTypeAsync(String string, DocumentType documentType, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/multidocument/{code}/type/{type}");
        avaTaxPath.applyField("code", string);
        avaTaxPath.applyField("type", (Object)documentType);
        avaTaxPath.addQuery("$include", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<MultiDocumentModel>(){}));
    }

    public MultiDocumentModel getMultiDocumentTransactionById(Long l, String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/multidocument/{id}");
        avaTaxPath.applyField("id", l);
        avaTaxPath.addQuery("$include", string);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<MultiDocumentModel>(){}).call();
    }

    public Future<MultiDocumentModel> getMultiDocumentTransactionByIdAsync(Long l, String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/multidocument/{id}");
        avaTaxPath.applyField("id", l);
        avaTaxPath.addQuery("$include", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<MultiDocumentModel>(){}));
    }

    public FetchResult<MultiDocumentModel> listMultiDocumentTransactions(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/multidocument");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<MultiDocumentModel>>(){}).call();
    }

    public Future<FetchResult<MultiDocumentModel>> listMultiDocumentTransactionsAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/multidocument");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<MultiDocumentModel>>(){}));
    }

    public MultiDocumentModel refundMultiDocumentTransaction(String string, DocumentType documentType, String string2, RefundTransactionModel refundTransactionModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/multidocument/{code}/type/{type}/refund");
        avaTaxPath.applyField("code", string);
        avaTaxPath.applyField("type", (Object)documentType);
        avaTaxPath.addQuery("$include", string2);
        return this.restCallFactory.createRestCall("post", avaTaxPath, refundTransactionModel, new TypeToken<MultiDocumentModel>(){}).call();
    }

    public Future<MultiDocumentModel> refundMultiDocumentTransactionAsync(String string, DocumentType documentType, String string2, RefundTransactionModel refundTransactionModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/multidocument/{code}/type/{type}/refund");
        avaTaxPath.applyField("code", string);
        avaTaxPath.applyField("type", (Object)documentType);
        avaTaxPath.addQuery("$include", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, refundTransactionModel, new TypeToken<MultiDocumentModel>(){}));
    }

    public MultiDocumentModel verifyMultiDocumentTransaction(VerifyMultiDocumentModel verifyMultiDocumentModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/multidocument/verify");
        return this.restCallFactory.createRestCall("post", avaTaxPath, verifyMultiDocumentModel, new TypeToken<MultiDocumentModel>(){}).call();
    }

    public Future<MultiDocumentModel> verifyMultiDocumentTransactionAsync(VerifyMultiDocumentModel verifyMultiDocumentModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/multidocument/verify");
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, verifyMultiDocumentModel, new TypeToken<MultiDocumentModel>(){}));
    }

    public MultiDocumentModel voidMultiDocumentTransaction(String string, DocumentType documentType, VoidTransactionModel voidTransactionModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/multidocument/{code}/type/{type}/void");
        avaTaxPath.applyField("code", string);
        avaTaxPath.applyField("type", (Object)documentType);
        return this.restCallFactory.createRestCall("post", avaTaxPath, voidTransactionModel, new TypeToken<MultiDocumentModel>(){}).call();
    }

    public Future<MultiDocumentModel> voidMultiDocumentTransactionAsync(String string, DocumentType documentType, VoidTransactionModel voidTransactionModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/multidocument/{code}/type/{type}/void");
        avaTaxPath.applyField("code", string);
        avaTaxPath.applyField("type", (Object)documentType);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, voidTransactionModel, new TypeToken<MultiDocumentModel>(){}));
    }

    public ArrayList<NexusModel> createNexus(Integer n, ArrayList<NexusModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<NexusModel>>(){}).call();
    }

    public Future<ArrayList<NexusModel>> createNexusAsync(Integer n, ArrayList<NexusModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<NexusModel>>(){}));
    }

    public ArrayList<NexusByAddressModel> declareNexusByAddress(Integer n, ArrayList<DeclareNexusByAddressModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus/byaddress");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<NexusByAddressModel>>(){}).call();
    }

    public Future<ArrayList<NexusByAddressModel>> declareNexusByAddressAsync(Integer n, ArrayList<DeclareNexusByAddressModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus/byaddress");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<NexusByAddressModel>>(){}));
    }

    public ArrayList<ErrorDetail> deleteNexus(Integer n, Integer n2, Boolean bl) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        avaTaxPath.addQuery("cascadeDelete", bl);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}).call();
    }

    public Future<ArrayList<ErrorDetail>> deleteNexusAsync(Integer n, Integer n2, Boolean bl) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        avaTaxPath.addQuery("cascadeDelete", bl);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}));
    }

    public NexusModel getNexus(Integer n, Integer n2, String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        avaTaxPath.addQuery("$include", string);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<NexusModel>(){}).call();
    }

    public Future<NexusModel> getNexusAsync(Integer n, Integer n2, String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        avaTaxPath.addQuery("$include", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<NexusModel>(){}));
    }

    public NexusByTaxFormModel getNexusByFormCode(Integer n, String string, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus/byform/{formCode}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("formCode", string);
        avaTaxPath.addQuery("$include", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<NexusByTaxFormModel>(){}).call();
    }

    public Future<NexusByTaxFormModel> getNexusByFormCodeAsync(Integer n, String string, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus/byform/{formCode}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("formCode", string);
        avaTaxPath.addQuery("$include", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<NexusByTaxFormModel>(){}));
    }

    public FetchResult<NexusModel> listNexusByCompany(Integer n, String string, String string2, Integer n2, Integer n3, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NexusModel>>(){}).call();
    }

    public Future<FetchResult<NexusModel>> listNexusByCompanyAsync(Integer n, String string, String string2, Integer n2, Integer n3, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NexusModel>>(){}));
    }

    public FetchResult<NexusModel> queryNexus(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/nexus");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NexusModel>>(){}).call();
    }

    public Future<FetchResult<NexusModel>> queryNexusAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/nexus");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NexusModel>>(){}));
    }

    public NexusModel updateNexus(Integer n, Integer n2, NexusModel nexusModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("put", avaTaxPath, nexusModel, new TypeToken<NexusModel>(){}).call();
    }

    public Future<NexusModel> updateNexusAsync(Integer n, Integer n2, NexusModel nexusModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, nexusModel, new TypeToken<NexusModel>(){}));
    }

    public NotificationModel dismissNotification(Long l) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/notifications/{id}/dismiss");
        avaTaxPath.applyField("id", l);
        return this.restCallFactory.createRestCall("put", avaTaxPath, null, new TypeToken<NotificationModel>(){}).call();
    }

    public Future<NotificationModel> dismissNotificationAsync(Long l) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/notifications/{id}/dismiss");
        avaTaxPath.applyField("id", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, null, new TypeToken<NotificationModel>(){}));
    }

    public NotificationModel getNotification(Long l) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/notifications/{id}");
        avaTaxPath.applyField("id", l);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<NotificationModel>(){}).call();
    }

    public Future<NotificationModel> getNotificationAsync(Long l) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/notifications/{id}");
        avaTaxPath.applyField("id", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<NotificationModel>(){}));
    }

    public FetchResult<NotificationModel> listNotifications(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/notifications");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NotificationModel>>(){}).call();
    }

    public Future<FetchResult<NotificationModel>> listNotificationsAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/notifications");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NotificationModel>>(){}));
    }

    public NewAccountModel requestNewAccount(NewAccountRequestModel newAccountRequestModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/request");
        return this.restCallFactory.createRestCall("post", avaTaxPath, newAccountRequestModel, new TypeToken<NewAccountModel>(){}).call();
    }

    public Future<NewAccountModel> requestNewAccountAsync(NewAccountRequestModel newAccountRequestModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/request");
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, newAccountRequestModel, new TypeToken<NewAccountModel>(){}));
    }

    public OfferModel requestNewEntitlement(Integer n, String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}/entitlements/{offer}");
        avaTaxPath.applyField("id", n);
        avaTaxPath.applyField("offer", string);
        return this.restCallFactory.createRestCall("post", avaTaxPath, null, new TypeToken<OfferModel>(){}).call();
    }

    public Future<OfferModel> requestNewEntitlementAsync(Integer n, String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}/entitlements/{offer}");
        avaTaxPath.applyField("id", n);
        avaTaxPath.applyField("offer", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, null, new TypeToken<OfferModel>(){}));
    }

    public ArrayList<AccountModel> createAccount(AccountModel accountModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts");
        return this.restCallFactory.createRestCall("post", avaTaxPath, accountModel, new TypeToken<ArrayList<AccountModel>>(){}).call();
    }

    public Future<ArrayList<AccountModel>> createAccountAsync(AccountModel accountModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts");
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, accountModel, new TypeToken<ArrayList<AccountModel>>(){}));
    }

    public ArrayList<NotificationModel> createNotifications(ArrayList<NotificationModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/notifications");
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<NotificationModel>>(){}).call();
    }

    public Future<ArrayList<NotificationModel>> createNotificationsAsync(ArrayList<NotificationModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/notifications");
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<NotificationModel>>(){}));
    }

    public ArrayList<SubscriptionModel> createSubscriptions(Integer n, ArrayList<SubscriptionModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/subscriptions");
        avaTaxPath.applyField("accountId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<SubscriptionModel>>(){}).call();
    }

    public Future<ArrayList<SubscriptionModel>> createSubscriptionsAsync(Integer n, ArrayList<SubscriptionModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/subscriptions");
        avaTaxPath.applyField("accountId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<SubscriptionModel>>(){}));
    }

    public ArrayList<ErrorDetail> deleteAccount(Integer n) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}).call();
    }

    public Future<ArrayList<ErrorDetail>> deleteAccountAsync(Integer n) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}));
    }

    public ArrayList<ErrorDetail> deleteNotification(Long l) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/notifications/{id}");
        avaTaxPath.applyField("id", l);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}).call();
    }

    public Future<ArrayList<ErrorDetail>> deleteNotificationAsync(Long l) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/notifications/{id}");
        avaTaxPath.applyField("id", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}));
    }

    public ArrayList<ErrorDetail> deleteSubscription(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/subscriptions/{id}");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}).call();
    }

    public Future<ArrayList<ErrorDetail>> deleteSubscriptionAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/subscriptions/{id}");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}));
    }

    public String resetPassword(Integer n, Boolean bl, SetPasswordModel setPasswordModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/passwords/{userId}/reset");
        avaTaxPath.applyField("userId", n);
        avaTaxPath.addQuery("unmigrateFromAi", bl);
        return this.restCallFactory.createRestCall("post", avaTaxPath, setPasswordModel, new TypeToken<String>(){}).call();
    }

    public Future<String> resetPasswordAsync(Integer n, Boolean bl, SetPasswordModel setPasswordModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/passwords/{userId}/reset");
        avaTaxPath.applyField("userId", n);
        avaTaxPath.addQuery("unmigrateFromAi", bl);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, setPasswordModel, new TypeToken<String>(){}));
    }

    public AccountModel updateAccount(Integer n, AccountModel accountModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("put", avaTaxPath, accountModel, new TypeToken<AccountModel>(){}).call();
    }

    public Future<AccountModel> updateAccountAsync(Integer n, AccountModel accountModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, accountModel, new TypeToken<AccountModel>(){}));
    }

    public NotificationModel updateNotification(Long l, NotificationModel notificationModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/notifications/{id}");
        avaTaxPath.applyField("id", l);
        return this.restCallFactory.createRestCall("put", avaTaxPath, notificationModel, new TypeToken<NotificationModel>(){}).call();
    }

    public Future<NotificationModel> updateNotificationAsync(Long l, NotificationModel notificationModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/notifications/{id}");
        avaTaxPath.applyField("id", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, notificationModel, new TypeToken<NotificationModel>(){}));
    }

    public SubscriptionModel updateSubscription(Integer n, Integer n2, SubscriptionModel subscriptionModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/subscriptions/{id}");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("put", avaTaxPath, subscriptionModel, new TypeToken<SubscriptionModel>(){}).call();
    }

    public Future<SubscriptionModel> updateSubscriptionAsync(Integer n, Integer n2, SubscriptionModel subscriptionModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/subscriptions/{id}");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, subscriptionModel, new TypeToken<SubscriptionModel>(){}));
    }

    public String downloadReport(Long l) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/reports/{id}/attachment");
        avaTaxPath.applyField("id", l);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<String>(){}).call();
    }

    public Future<String> downloadReportAsync(Long l) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/reports/{id}/attachment");
        avaTaxPath.applyField("id", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<String>(){}));
    }

    public ReportModel getReport(Long l) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/reports/{id}");
        avaTaxPath.applyField("id", l);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ReportModel>(){}).call();
    }

    public Future<ReportModel> getReportAsync(Long l) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/reports/{id}");
        avaTaxPath.applyField("id", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ReportModel>(){}));
    }

    public ArrayList<ReportModel> initiateExportDocumentLineReport(Integer n, ExportDocumentLineModel exportDocumentLineModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/reports/exportdocumentline/initiate");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, exportDocumentLineModel, new TypeToken<ArrayList<ReportModel>>(){}).call();
    }

    public Future<ArrayList<ReportModel>> initiateExportDocumentLineReportAsync(Integer n, ExportDocumentLineModel exportDocumentLineModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/reports/exportdocumentline/initiate");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, exportDocumentLineModel, new TypeToken<ArrayList<ReportModel>>(){}));
    }

    public FetchResult<ReportModel> listReports(Integer n, String string, Integer n2, Integer n3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/reports");
        avaTaxPath.addQuery("companyId", n);
        avaTaxPath.addQuery("pageKey", string);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$top", n3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ReportModel>>(){}).call();
    }

    public Future<FetchResult<ReportModel>> listReportsAsync(Integer n, String string, Integer n2, Integer n3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/reports");
        avaTaxPath.addQuery("companyId", n);
        avaTaxPath.addQuery("pageKey", string);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$top", n3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ReportModel>>(){}));
    }

    public ArrayList<SettingModel> createSettings(Integer n, ArrayList<SettingModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/settings");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<SettingModel>>(){}).call();
    }

    public Future<ArrayList<SettingModel>> createSettingsAsync(Integer n, ArrayList<SettingModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/settings");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<SettingModel>>(){}));
    }

    public ArrayList<ErrorDetail> deleteSetting(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/settings/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}).call();
    }

    public Future<ArrayList<ErrorDetail>> deleteSettingAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/settings/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}));
    }

    public SettingModel getSetting(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/settings/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<SettingModel>(){}).call();
    }

    public Future<SettingModel> getSettingAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/settings/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<SettingModel>(){}));
    }

    public FetchResult<SettingModel> listSettingsByCompany(Integer n, String string, String string2, Integer n2, Integer n3, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/settings");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SettingModel>>(){}).call();
    }

    public Future<FetchResult<SettingModel>> listSettingsByCompanyAsync(Integer n, String string, String string2, Integer n2, Integer n3, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/settings");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SettingModel>>(){}));
    }

    public FetchResult<SettingModel> querySettings(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/settings");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SettingModel>>(){}).call();
    }

    public Future<FetchResult<SettingModel>> querySettingsAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/settings");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SettingModel>>(){}));
    }

    public SettingModel updateSetting(Integer n, Integer n2, SettingModel settingModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/settings/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("put", avaTaxPath, settingModel, new TypeToken<SettingModel>(){}).call();
    }

    public Future<SettingModel> updateSettingAsync(Integer n, Integer n2, SettingModel settingModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/settings/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, settingModel, new TypeToken<SettingModel>(){}));
    }

    public SubscriptionModel getSubscription(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/subscriptions/{id}");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<SubscriptionModel>(){}).call();
    }

    public Future<SubscriptionModel> getSubscriptionAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/subscriptions/{id}");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<SubscriptionModel>(){}));
    }

    public FetchResult<SubscriptionModel> listSubscriptionsByAccount(Integer n, String string, Integer n2, Integer n3, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/subscriptions");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SubscriptionModel>>(){}).call();
    }

    public Future<FetchResult<SubscriptionModel>> listSubscriptionsByAccountAsync(Integer n, String string, Integer n2, Integer n3, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/subscriptions");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SubscriptionModel>>(){}));
    }

    public FetchResult<SubscriptionModel> querySubscriptions(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/subscriptions");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SubscriptionModel>>(){}).call();
    }

    public Future<FetchResult<SubscriptionModel>> querySubscriptionsAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/subscriptions");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SubscriptionModel>>(){}));
    }

    public ArrayList<TaxCodeModel> createTaxCodes(Integer n, ArrayList<TaxCodeModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxcodes");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<TaxCodeModel>>(){}).call();
    }

    public Future<ArrayList<TaxCodeModel>> createTaxCodesAsync(Integer n, ArrayList<TaxCodeModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxcodes");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<TaxCodeModel>>(){}));
    }

    public ArrayList<ErrorDetail> deleteTaxCode(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxcodes/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}).call();
    }

    public Future<ArrayList<ErrorDetail>> deleteTaxCodeAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxcodes/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}));
    }

    public TaxCodeModel getTaxCode(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxcodes/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<TaxCodeModel>(){}).call();
    }

    public Future<TaxCodeModel> getTaxCodeAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxcodes/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<TaxCodeModel>(){}));
    }

    public FetchResult<TaxCodeModel> listTaxCodesByCompany(Integer n, String string, String string2, Integer n2, Integer n3, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxcodes");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxCodeModel>>(){}).call();
    }

    public Future<FetchResult<TaxCodeModel>> listTaxCodesByCompanyAsync(Integer n, String string, String string2, Integer n2, Integer n3, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxcodes");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxCodeModel>>(){}));
    }

    public FetchResult<TaxCodeModel> queryTaxCodes(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/taxcodes");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxCodeModel>>(){}).call();
    }

    public Future<FetchResult<TaxCodeModel>> queryTaxCodesAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/taxcodes");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxCodeModel>>(){}));
    }

    public TaxCodeModel updateTaxCode(Integer n, Integer n2, TaxCodeModel taxCodeModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxcodes/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("put", avaTaxPath, taxCodeModel, new TypeToken<TaxCodeModel>(){}).call();
    }

    public Future<TaxCodeModel> updateTaxCodeAsync(Integer n, Integer n2, TaxCodeModel taxCodeModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxcodes/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, taxCodeModel, new TypeToken<TaxCodeModel>(){}));
    }

    public String buildTaxContentFile(PointOfSaleDataRequestModel pointOfSaleDataRequestModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/pointofsaledata/build");
        return this.restCallFactory.createRestCall("post", avaTaxPath, pointOfSaleDataRequestModel, new TypeToken<String>(){}).call();
    }

    public Future<String> buildTaxContentFileAsync(PointOfSaleDataRequestModel pointOfSaleDataRequestModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/pointofsaledata/build");
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, pointOfSaleDataRequestModel, new TypeToken<String>(){}));
    }

    public String buildTaxContentFileForLocation(Integer n, Integer n2, Date date, PointOfSaleFileType pointOfSaleFileType, PointOfSalePartnerId pointOfSalePartnerId, Boolean bl) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/locations/{id}/pointofsaledata");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        avaTaxPath.addQuery("date", date);
        avaTaxPath.addQuery("format", (Object)pointOfSaleFileType);
        avaTaxPath.addQuery("partnerId", (Object)pointOfSalePartnerId);
        avaTaxPath.addQuery("includeJurisCodes", bl);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<String>(){}).call();
    }

    public Future<String> buildTaxContentFileForLocationAsync(Integer n, Integer n2, Date date, PointOfSaleFileType pointOfSaleFileType, PointOfSalePartnerId pointOfSalePartnerId, Boolean bl) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/locations/{id}/pointofsaledata");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        avaTaxPath.addQuery("date", date);
        avaTaxPath.addQuery("format", (Object)pointOfSaleFileType);
        avaTaxPath.addQuery("partnerId", (Object)pointOfSalePartnerId);
        avaTaxPath.addQuery("includeJurisCodes", bl);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<String>(){}));
    }

    public String downloadTaxRatesByZipCode(Date date, String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/taxratesbyzipcode/download/{date}");
        avaTaxPath.applyField("date", date);
        avaTaxPath.addQuery("region", string);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<String>(){}).call();
    }

    public Future<String> downloadTaxRatesByZipCodeAsync(Date date, String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/taxratesbyzipcode/download/{date}");
        avaTaxPath.applyField("date", date);
        avaTaxPath.addQuery("region", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<String>(){}));
    }

    public ArrayList<TaxRuleModel> createTaxRules(Integer n, ArrayList<TaxRuleModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxrules");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<TaxRuleModel>>(){}).call();
    }

    public Future<ArrayList<TaxRuleModel>> createTaxRulesAsync(Integer n, ArrayList<TaxRuleModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxrules");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<TaxRuleModel>>(){}));
    }

    public ArrayList<ErrorDetail> deleteTaxRule(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxrules/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}).call();
    }

    public Future<ArrayList<ErrorDetail>> deleteTaxRuleAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxrules/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}));
    }

    public TaxRuleModel getTaxRule(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxrules/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<TaxRuleModel>(){}).call();
    }

    public Future<TaxRuleModel> getTaxRuleAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxrules/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<TaxRuleModel>(){}));
    }

    public FetchResult<TaxRuleModel> listTaxRules(Integer n, String string, String string2, Integer n2, Integer n3, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxrules");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxRuleModel>>(){}).call();
    }

    public Future<FetchResult<TaxRuleModel>> listTaxRulesAsync(Integer n, String string, String string2, Integer n2, Integer n3, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxrules");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxRuleModel>>(){}));
    }

    public FetchResult<TaxRuleModel> queryTaxRules(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/taxrules");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxRuleModel>>(){}).call();
    }

    public Future<FetchResult<TaxRuleModel>> queryTaxRulesAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/taxrules");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxRuleModel>>(){}));
    }

    public TaxRuleModel updateTaxRule(Integer n, Integer n2, TaxRuleModel taxRuleModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxrules/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("put", avaTaxPath, taxRuleModel, new TypeToken<TaxRuleModel>(){}).call();
    }

    public Future<TaxRuleModel> updateTaxRuleAsync(Integer n, Integer n2, TaxRuleModel taxRuleModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxrules/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, taxRuleModel, new TypeToken<TaxRuleModel>(){}));
    }

    public TransactionModel addLines(String string, AddTransactionLineModel addTransactionLineModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/transactions/lines/add");
        avaTaxPath.addQuery("$include", string);
        return this.restCallFactory.createRestCall("post", avaTaxPath, addTransactionLineModel, new TypeToken<TransactionModel>(){}).call();
    }

    public Future<TransactionModel> addLinesAsync(String string, AddTransactionLineModel addTransactionLineModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/transactions/lines/add");
        avaTaxPath.addQuery("$include", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, addTransactionLineModel, new TypeToken<TransactionModel>(){}));
    }

    public TransactionModel adjustTransaction(String string, String string2, DocumentType documentType, String string3, AdjustTransactionModel adjustTransactionModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/adjust");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", (Object)documentType);
        avaTaxPath.addQuery("$include", string3);
        return this.restCallFactory.createRestCall("post", avaTaxPath, adjustTransactionModel, new TypeToken<TransactionModel>(){}).call();
    }

    public Future<TransactionModel> adjustTransactionAsync(String string, String string2, DocumentType documentType, String string3, AdjustTransactionModel adjustTransactionModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/adjust");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", (Object)documentType);
        avaTaxPath.addQuery("$include", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, adjustTransactionModel, new TypeToken<TransactionModel>(){}));
    }

    public AuditTransactionModel auditTransaction(String string, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/audit");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<AuditTransactionModel>(){}).call();
    }

    public Future<AuditTransactionModel> auditTransactionAsync(String string, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/audit");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<AuditTransactionModel>(){}));
    }

    public AuditTransactionModel auditTransactionWithType(String string, String string2, DocumentType documentType) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/types/{documentType}/audit");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.applyField("documentType", (Object)documentType);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<AuditTransactionModel>(){}).call();
    }

    public Future<AuditTransactionModel> auditTransactionWithTypeAsync(String string, String string2, DocumentType documentType) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/types/{documentType}/audit");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.applyField("documentType", (Object)documentType);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<AuditTransactionModel>(){}));
    }

    public BulkLockTransactionResult bulkLockTransaction(BulkLockTransactionModel bulkLockTransactionModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/lock");
        return this.restCallFactory.createRestCall("post", avaTaxPath, bulkLockTransactionModel, new TypeToken<BulkLockTransactionResult>(){}).call();
    }

    public Future<BulkLockTransactionResult> bulkLockTransactionAsync(BulkLockTransactionModel bulkLockTransactionModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/lock");
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, bulkLockTransactionModel, new TypeToken<BulkLockTransactionResult>(){}));
    }

    public TransactionModel changeTransactionCode(String string, String string2, DocumentType documentType, String string3, ChangeTransactionCodeModel changeTransactionCodeModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/changecode");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", (Object)documentType);
        avaTaxPath.addQuery("$include", string3);
        return this.restCallFactory.createRestCall("post", avaTaxPath, changeTransactionCodeModel, new TypeToken<TransactionModel>(){}).call();
    }

    public Future<TransactionModel> changeTransactionCodeAsync(String string, String string2, DocumentType documentType, String string3, ChangeTransactionCodeModel changeTransactionCodeModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/changecode");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", (Object)documentType);
        avaTaxPath.addQuery("$include", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, changeTransactionCodeModel, new TypeToken<TransactionModel>(){}));
    }

    public TransactionModel commitTransaction(String string, String string2, DocumentType documentType, String string3, CommitTransactionModel commitTransactionModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/commit");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", (Object)documentType);
        avaTaxPath.addQuery("$include", string3);
        return this.restCallFactory.createRestCall("post", avaTaxPath, commitTransactionModel, new TypeToken<TransactionModel>(){}).call();
    }

    public Future<TransactionModel> commitTransactionAsync(String string, String string2, DocumentType documentType, String string3, CommitTransactionModel commitTransactionModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/commit");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", (Object)documentType);
        avaTaxPath.addQuery("$include", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, commitTransactionModel, new TypeToken<TransactionModel>(){}));
    }

    public TransactionModel createOrAdjustTransaction(String string, CreateOrAdjustTransactionModel createOrAdjustTransactionModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/createoradjust");
        avaTaxPath.addQuery("$include", string);
        return this.restCallFactory.createRestCall("post", avaTaxPath, createOrAdjustTransactionModel, new TypeToken<TransactionModel>(){}).call();
    }

    public Future<TransactionModel> createOrAdjustTransactionAsync(String string, CreateOrAdjustTransactionModel createOrAdjustTransactionModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/createoradjust");
        avaTaxPath.addQuery("$include", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, createOrAdjustTransactionModel, new TypeToken<TransactionModel>(){}));
    }

    public TransactionModel createTransaction(String string, CreateTransactionModel createTransactionModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/create");
        avaTaxPath.addQuery("$include", string);
        return this.restCallFactory.createRestCall("post", avaTaxPath, createTransactionModel, new TypeToken<TransactionModel>(){}).call();
    }

    public Future<TransactionModel> createTransactionAsync(String string, CreateTransactionModel createTransactionModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/create");
        avaTaxPath.addQuery("$include", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, createTransactionModel, new TypeToken<TransactionModel>(){}));
    }

    public TransactionModel deleteLines(String string, RemoveTransactionLineModel removeTransactionLineModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/transactions/lines/delete");
        avaTaxPath.addQuery("$include", string);
        return this.restCallFactory.createRestCall("post", avaTaxPath, removeTransactionLineModel, new TypeToken<TransactionModel>(){}).call();
    }

    public Future<TransactionModel> deleteLinesAsync(String string, RemoveTransactionLineModel removeTransactionLineModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/transactions/lines/delete");
        avaTaxPath.addQuery("$include", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, removeTransactionLineModel, new TypeToken<TransactionModel>(){}));
    }

    public TransactionModel getTransactionByCode(String string, String string2, DocumentType documentType, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", (Object)documentType);
        avaTaxPath.addQuery("$include", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<TransactionModel>(){}).call();
    }

    public Future<TransactionModel> getTransactionByCodeAsync(String string, String string2, DocumentType documentType, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", (Object)documentType);
        avaTaxPath.addQuery("$include", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<TransactionModel>(){}));
    }

    public TransactionModel getTransactionByCodeAndType(String string, String string2, DocumentType documentType, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/types/{documentType}");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.applyField("documentType", (Object)documentType);
        avaTaxPath.addQuery("$include", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<TransactionModel>(){}).call();
    }

    public Future<TransactionModel> getTransactionByCodeAndTypeAsync(String string, String string2, DocumentType documentType, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/types/{documentType}");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.applyField("documentType", (Object)documentType);
        avaTaxPath.addQuery("$include", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<TransactionModel>(){}));
    }

    public TransactionModel getTransactionById(Long l, String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/{id}");
        avaTaxPath.applyField("id", l);
        avaTaxPath.addQuery("$include", string);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<TransactionModel>(){}).call();
    }

    public Future<TransactionModel> getTransactionByIdAsync(Long l, String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/{id}");
        avaTaxPath.applyField("id", l);
        avaTaxPath.addQuery("$include", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<TransactionModel>(){}));
    }

    public FetchResult<TransactionModel> listTransactionsByCompany(String string, Integer n, String string2, String string3, Integer n2, Integer n3, String string4) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.addQuery("dataSourceId", n);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$filter", string3);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string4);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TransactionModel>>(){}).call();
    }

    public Future<FetchResult<TransactionModel>> listTransactionsByCompanyAsync(String string, Integer n, String string2, String string3, Integer n2, Integer n3, String string4) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.addQuery("dataSourceId", n);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$filter", string3);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string4);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TransactionModel>>(){}));
    }

    public TransactionModel lockTransaction(String string, String string2, DocumentType documentType, String string3, LockTransactionModel lockTransactionModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/lock");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", (Object)documentType);
        avaTaxPath.addQuery("$include", string3);
        return this.restCallFactory.createRestCall("post", avaTaxPath, lockTransactionModel, new TypeToken<TransactionModel>(){}).call();
    }

    public Future<TransactionModel> lockTransactionAsync(String string, String string2, DocumentType documentType, String string3, LockTransactionModel lockTransactionModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/lock");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", (Object)documentType);
        avaTaxPath.addQuery("$include", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, lockTransactionModel, new TypeToken<TransactionModel>(){}));
    }

    public TransactionModel refundTransaction(String string, String string2, String string3, DocumentType documentType, Boolean bl, RefundTransactionModel refundTransactionModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/refund");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("$include", string3);
        avaTaxPath.addQuery("documentType", (Object)documentType);
        avaTaxPath.addQuery("useTaxDateOverride", bl);
        return this.restCallFactory.createRestCall("post", avaTaxPath, refundTransactionModel, new TypeToken<TransactionModel>(){}).call();
    }

    public Future<TransactionModel> refundTransactionAsync(String string, String string2, String string3, DocumentType documentType, Boolean bl, RefundTransactionModel refundTransactionModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/refund");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("$include", string3);
        avaTaxPath.addQuery("documentType", (Object)documentType);
        avaTaxPath.addQuery("useTaxDateOverride", bl);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, refundTransactionModel, new TypeToken<TransactionModel>(){}));
    }

    public TransactionModel settleTransaction(String string, String string2, DocumentType documentType, String string3, SettleTransactionModel settleTransactionModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/settle");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", (Object)documentType);
        avaTaxPath.addQuery("$include", string3);
        return this.restCallFactory.createRestCall("post", avaTaxPath, settleTransactionModel, new TypeToken<TransactionModel>(){}).call();
    }

    public Future<TransactionModel> settleTransactionAsync(String string, String string2, DocumentType documentType, String string3, SettleTransactionModel settleTransactionModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/settle");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", (Object)documentType);
        avaTaxPath.addQuery("$include", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, settleTransactionModel, new TypeToken<TransactionModel>(){}));
    }

    public TransactionModel uncommitTransaction(String string, String string2, DocumentType documentType, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/uncommit");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", (Object)documentType);
        avaTaxPath.addQuery("$include", string3);
        return this.restCallFactory.createRestCall("post", avaTaxPath, null, new TypeToken<TransactionModel>(){}).call();
    }

    public Future<TransactionModel> uncommitTransactionAsync(String string, String string2, DocumentType documentType, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/uncommit");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", (Object)documentType);
        avaTaxPath.addQuery("$include", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, null, new TypeToken<TransactionModel>(){}));
    }

    public TransactionModel unvoidTransaction(String string, String string2, DocumentType documentType, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/unvoid");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", (Object)documentType);
        avaTaxPath.addQuery("$include", string3);
        return this.restCallFactory.createRestCall("post", avaTaxPath, null, new TypeToken<TransactionModel>(){}).call();
    }

    public Future<TransactionModel> unvoidTransactionAsync(String string, String string2, DocumentType documentType, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/unvoid");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", (Object)documentType);
        avaTaxPath.addQuery("$include", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, null, new TypeToken<TransactionModel>(){}));
    }

    public TransactionModel verifyTransaction(String string, String string2, DocumentType documentType, String string3, VerifyTransactionModel verifyTransactionModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/verify");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", (Object)documentType);
        avaTaxPath.addQuery("$include", string3);
        return this.restCallFactory.createRestCall("post", avaTaxPath, verifyTransactionModel, new TypeToken<TransactionModel>(){}).call();
    }

    public Future<TransactionModel> verifyTransactionAsync(String string, String string2, DocumentType documentType, String string3, VerifyTransactionModel verifyTransactionModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/verify");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", (Object)documentType);
        avaTaxPath.addQuery("$include", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, verifyTransactionModel, new TypeToken<TransactionModel>(){}));
    }

    public TransactionModel voidTransaction(String string, String string2, DocumentType documentType, String string3, VoidTransactionModel voidTransactionModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/void");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", (Object)documentType);
        avaTaxPath.addQuery("$include", string3);
        return this.restCallFactory.createRestCall("post", avaTaxPath, voidTransactionModel, new TypeToken<TransactionModel>(){}).call();
    }

    public Future<TransactionModel> voidTransactionAsync(String string, String string2, DocumentType documentType, String string3, VoidTransactionModel voidTransactionModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/void");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", (Object)documentType);
        avaTaxPath.addQuery("$include", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, voidTransactionModel, new TypeToken<TransactionModel>(){}));
    }

    public ArrayList<UPCModel> createUPCs(Integer n, ArrayList<UPCModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/upcs");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<UPCModel>>(){}).call();
    }

    public Future<ArrayList<UPCModel>> createUPCsAsync(Integer n, ArrayList<UPCModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/upcs");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<UPCModel>>(){}));
    }

    public ArrayList<ErrorDetail> deleteUPC(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/upcs/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}).call();
    }

    public Future<ArrayList<ErrorDetail>> deleteUPCAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/upcs/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}));
    }

    public UPCModel getUPC(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/upcs/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<UPCModel>(){}).call();
    }

    public Future<UPCModel> getUPCAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/upcs/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<UPCModel>(){}));
    }

    public FetchResult<UPCModel> listUPCsByCompany(Integer n, String string, String string2, Integer n2, Integer n3, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/upcs");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<UPCModel>>(){}).call();
    }

    public Future<FetchResult<UPCModel>> listUPCsByCompanyAsync(Integer n, String string, String string2, Integer n2, Integer n3, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/upcs");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<UPCModel>>(){}));
    }

    public FetchResult<UPCModel> queryUPCs(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/upcs");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<UPCModel>>(){}).call();
    }

    public Future<FetchResult<UPCModel>> queryUPCsAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/upcs");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<UPCModel>>(){}));
    }

    public UPCModel updateUPC(Integer n, Integer n2, UPCModel uPCModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/upcs/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("put", avaTaxPath, uPCModel, new TypeToken<UPCModel>(){}).call();
    }

    public Future<UPCModel> updateUPCAsync(Integer n, Integer n2, UPCModel uPCModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/upcs/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, uPCModel, new TypeToken<UPCModel>(){}));
    }

    public String changePassword(PasswordChangeModel passwordChangeModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/passwords");
        return this.restCallFactory.createRestCall("put", avaTaxPath, passwordChangeModel, new TypeToken<String>(){}).call();
    }

    public Future<String> changePasswordAsync(PasswordChangeModel passwordChangeModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/passwords");
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, passwordChangeModel, new TypeToken<String>(){}));
    }

    public ArrayList<UserModel> createUsers(Integer n, ArrayList<UserModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/users");
        avaTaxPath.applyField("accountId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<UserModel>>(){}).call();
    }

    public Future<ArrayList<UserModel>> createUsersAsync(Integer n, ArrayList<UserModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/users");
        avaTaxPath.applyField("accountId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<UserModel>>(){}));
    }

    public ArrayList<ErrorDetail> deleteUser(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/users/{id}");
        avaTaxPath.applyField("id", n);
        avaTaxPath.applyField("accountId", n2);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}).call();
    }

    public Future<ArrayList<ErrorDetail>> deleteUserAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/users/{id}");
        avaTaxPath.applyField("id", n);
        avaTaxPath.applyField("accountId", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}));
    }

    public UserModel getUser(Integer n, Integer n2, String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/users/{id}");
        avaTaxPath.applyField("id", n);
        avaTaxPath.applyField("accountId", n2);
        avaTaxPath.addQuery("$include", string);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<UserModel>(){}).call();
    }

    public Future<UserModel> getUserAsync(Integer n, Integer n2, String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/users/{id}");
        avaTaxPath.applyField("id", n);
        avaTaxPath.applyField("accountId", n2);
        avaTaxPath.addQuery("$include", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<UserModel>(){}));
    }

    public UserEntitlementModel getUserEntitlements(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/users/{id}/entitlements");
        avaTaxPath.applyField("id", n);
        avaTaxPath.applyField("accountId", n2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<UserEntitlementModel>(){}).call();
    }

    public Future<UserEntitlementModel> getUserEntitlementsAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/users/{id}/entitlements");
        avaTaxPath.applyField("id", n);
        avaTaxPath.applyField("accountId", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<UserEntitlementModel>(){}));
    }

    public FetchResult<UserModel> listUsersByAccount(Integer n, String string, String string2, Integer n2, Integer n3, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/users");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.addQuery("$include", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<UserModel>>(){}).call();
    }

    public Future<FetchResult<UserModel>> listUsersByAccountAsync(Integer n, String string, String string2, Integer n2, Integer n3, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/users");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.addQuery("$include", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<UserModel>>(){}));
    }

    public FetchResult<UserModel> queryUsers(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/users");
        avaTaxPath.addQuery("$include", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<UserModel>>(){}).call();
    }

    public Future<FetchResult<UserModel>> queryUsersAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/users");
        avaTaxPath.addQuery("$include", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<UserModel>>(){}));
    }

    public UserModel updateUser(Integer n, Integer n2, UserModel userModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/users/{id}");
        avaTaxPath.applyField("id", n);
        avaTaxPath.applyField("accountId", n2);
        return this.restCallFactory.createRestCall("put", avaTaxPath, userModel, new TypeToken<UserModel>(){}).call();
    }

    public Future<UserModel> updateUserAsync(Integer n, Integer n2, UserModel userModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/users/{id}");
        avaTaxPath.applyField("id", n);
        avaTaxPath.applyField("accountId", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, userModel, new TypeToken<UserModel>(){}));
    }

    public SubscriptionModel getMySubscription(String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/utilities/subscriptions/{serviceTypeId}");
        avaTaxPath.applyField("serviceTypeId", string);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<SubscriptionModel>(){}).call();
    }

    public Future<SubscriptionModel> getMySubscriptionAsync(String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/utilities/subscriptions/{serviceTypeId}");
        avaTaxPath.applyField("serviceTypeId", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<SubscriptionModel>(){}));
    }

    public FetchResult<SubscriptionModel> listMySubscriptions() throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/utilities/subscriptions");
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SubscriptionModel>>(){}).call();
    }

    public Future<FetchResult<SubscriptionModel>> listMySubscriptionsAsync() {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/utilities/subscriptions");
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SubscriptionModel>>(){}));
    }

    public PingResultModel ping() throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/utilities/ping");
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<PingResultModel>(){}).call();
    }

    public Future<PingResultModel> pingAsync() {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/utilities/ping");
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<PingResultModel>(){}));
    }
}

