package net.avalara.avatax.rest.client.enums;
import java.util.HashMap;

/*
 * AvaTax Software Development Kit for Java JRE based environments
 *
 * (c) 2004-2018 Avalara, Inc.
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * @author     Dustin Welden <dustin.welden@avalara.com>
 * @copyright  2004-2018 Avalara, Inc.
 * @license    https://www.apache.org/licenses/LICENSE-2.0
 * @link       https://github.com/avadev/AvaTax-REST-V2-JRE-SDK
 * Swagger name: AvaTaxClient
 */

/**
 * 
 */
public enum FilingFrequencyId {
    /** 
     * 
     */
    Monthly(1),

    /** 
     * 
     */
    Quarterly(2),

    /** 
     * 
     */
    SemiAnnually(3),

    /** 
     * 
     */
    Annually(4),

    /** 
     * 
     */
    Bimonthly(5),

    /** 
     * 
     */
    Occasional(6),

    /** 
     * 
     */
    InverseQuarterly(7),

    /** 
     * 
     */
    Weekly(8);

    private int value;
	private static HashMap map = new HashMap<>();
	
	private FilingFrequencyId(int value) {
		this.value = value;
	}
	
	static {
		for (FilingFrequencyId enumName : FilingFrequencyId.values()) {
			map.put(enumName.value, enumName);
		}
	}
	
	public static FilingFrequencyId valueOf(int intValue) {
		return (FilingFrequencyId) map.get(intValue);
	}
	
	public int getValue() {
		return value;
	}
}
