package net.avalara.avatax.rest.client.enums;
import java.util.HashMap;

/*
 * AvaTax Software Development Kit for Java JRE based environments
 *
 * (c) 2004-2018 Avalara, Inc.
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * @author     Dustin Welden <dustin.welden@avalara.com>
 * @copyright  2004-2018 Avalara, Inc.
 * @license    https://www.apache.org/licenses/LICENSE-2.0
 * @link       https://github.com/avadev/AvaTax-REST-V2-JRE-SDK
 * Swagger name: AvaTaxBeverageClient
 */

/**
 * 
 */
public enum FailureCodes {
    /** 
     * 
     */
    BelowLegalDrinkingAge(0),

    /** 
     * 
     */
    ShippingProhibitedToAddress(1),

    /** 
     * 
     */
    MissingRequiredLicense(2),

    /** 
     * 
     */
    VolumeLimitExceeded(3),

    /** 
     * 
     */
    InvalidFieldValue(4),

    /** 
     * 
     */
    MissingRequiredField(5),

    /** 
     * 
     */
    InvalidFieldType(6),

    /** 
     * 
     */
    InvalidFormat(7),

    /** 
     * 
     */
    InvalidDate(8),

    /** 
     * 
     */
    AlcoholContentLimitExceeded(9);

    private int value;
	private static HashMap map = new HashMap<>();
	
	private FailureCodes(int value) {
		this.value = value;
	}
	
	static {
		for (FailureCodes enumName : FailureCodes.values()) {
			map.put(enumName.value, enumName);
		}
	}
	
	public static FailureCodes valueOf(int intValue) {
		return (FailureCodes) map.get(intValue);
	}
	
	public int getValue() {
		return value;
	}
}
