package net.avalara.avatax.rest.client;
import net.avalara.avatax.rest.client.enums.AvaTaxEnvironment;
import net.avalara.avatax.rest.client.enums.DocumentType;
import net.avalara.avatax.rest.client.enums.TaxOverrideType;
import net.avalara.avatax.rest.client.enums.TransactionAddressType;
import net.avalara.avatax.rest.client.models.PingResultModel;
import net.avalara.avatax.rest.client.models.TransactionModel;

import java.text.SimpleDateFormat;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class Test {

    public static void main(String[] args ){
        System.out.println("hello");
//        ExecutorService es = Executors.newFixedThreadPool(3);
        AvaTaxClient client= new  AvaTaxClient("Test", "1.0", "Test", AvaTaxEnvironment.Sandbox);
        client.withSecurity("demo.compliance-verification","sxgv7KK4HX*B7vY@");
        try {
            Future<PingResultModel> f =client.pingAsync();
            PingResultModel model=f.get();
            System.out.println(model.toString());
            Future<PingResultModel> f2 =client.pingAsync();
            PingResultModel model2=f2.get();
            System.out.println(model2.toString());
            Future<Void> f1 =client.deregisterShipmentAsync("DEFAULT","063e1af4-11d3-4489-b8ba-ae1149758df4",null);
            f1.get();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        try {
            SimpleDateFormat dateFormat = new java.text.SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            TransactionModel model = new TransactionBuilder(client, "DEFAULT", DocumentType.SalesOrder, "1")
                    .withAddress(TransactionAddressType.ShipTo, "100 RAVINE LN", "", "", "BAINBRIDGE ISLAND", "WA", "98110", "US")
                    .withAddress(TransactionAddressType.ShipFrom, "100 RAVINE LN", "", "", "BAINBRIDGE ISLAND", "WA", "98110", "US")
                    .withAddress(TransactionAddressType.PointOfOrderAcceptance, "100 RAVINE LN", "", "", "BAINBRIDGE ISLAND", "WA", "98110", "US")
                    .withCode("DOCCODE")
                    .withDate(dateFormat.parse("2017-03-02T10:40:18"))
                    .withTaxOverride(TaxOverrideType.TaxDate, "TaxDate", java.math.BigDecimal.valueOf(0), dateFormat.parse("2023-02-16T00:00:00"))
                    .withLine(java.math.BigDecimal.valueOf(10), java.math.BigDecimal.valueOf(1), "P0000000")
                   .Create();
            System.out.println(model);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
//        es.shutdown();
        System.out.println("completed");
    }
}