/*
 * Decompiled with CFR 0.152.
 */
package net.avalara.avatax.rest.client;

import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import net.avalara.avatax.rest.client.AvaTaxClientException;
import net.avalara.avatax.rest.client.AvaTaxConstants;
import net.avalara.avatax.rest.client.AvaTaxPath;
import net.avalara.avatax.rest.client.LogObject;
import net.avalara.avatax.rest.client.enums.ErrorTargetCode;
import net.avalara.avatax.rest.client.models.ErrorDetail;
import net.avalara.avatax.rest.client.models.ErrorInfo;
import net.avalara.avatax.rest.client.models.ErrorResult;
import net.avalara.avatax.rest.client.serializer.JsonSerializer;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.Configurable;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestCall<T>
implements Callable<T> {
    private final Logger logger = LoggerFactory.getLogger(RestCall.class);
    private CloseableHttpClient client;
    private HttpRequestBase request;
    private String appName;
    private String appVersion;
    private String machineName;
    private Object model;
    private TypeToken<T> typeToken;

    private RestCall(String string, String string2, String string3, String string4, String string5, AvaTaxPath avaTaxPath, Object object, TypeToken<T> typeToken, CloseableHttpClient closeableHttpClient) {
        this.client = closeableHttpClient;
        this.appName = string;
        this.appVersion = string2;
        this.machineName = string3;
        this.typeToken = typeToken;
        this.model = object;
        if (string5 == "post") {
            this.request = new HttpPost(string4 + avaTaxPath.toString());
            ((HttpPost)this.request).setEntity((HttpEntity)new StringEntity(JsonSerializer.SerializeObject(object), ContentType.create((String)"application/json", (String)"UTF-8")));
        } else if (string5 == "get") {
            this.request = new HttpGet(string4 + avaTaxPath.toString());
        } else if (string5 == "delete") {
            this.request = new HttpDelete(string4 + avaTaxPath.toString());
        } else if (string5 == "put") {
            this.request = new HttpPut(string4 + avaTaxPath.toString());
            ((HttpPut)this.request).setEntity((HttpEntity)new StringEntity(JsonSerializer.SerializeObject(object), ContentType.create((String)"application/json", (String)"UTF-8")));
        }
        this.buildRequest(this.request, "", avaTaxPath.getHeaders());
    }

    private RestCall(String string, String string2, String string3, String string4, String string5, AvaTaxPath avaTaxPath, Object object, TypeToken<T> typeToken, CloseableHttpClient closeableHttpClient, String string6) {
        this.client = closeableHttpClient;
        this.appName = string;
        this.appVersion = string2;
        this.machineName = string3;
        this.typeToken = typeToken;
        this.model = object;
        if (string5 == "post") {
            this.request = new HttpPost(string4 + avaTaxPath.toString());
            ((HttpPost)this.request).setEntity((HttpEntity)new StringEntity(JsonSerializer.SerializeObject(object), ContentType.create((String)"application/json", (String)"UTF-8")));
        } else if (string5 == "get") {
            this.request = new HttpGet(string4 + avaTaxPath.toString());
        } else if (string5 == "delete") {
            this.request = new HttpDelete(string4 + avaTaxPath.toString());
        } else if (string5 == "put") {
            this.request = new HttpPut(string4 + avaTaxPath.toString());
            ((HttpPut)this.request).setEntity((HttpEntity)new StringEntity(JsonSerializer.SerializeObject(object), ContentType.create((String)"application/json", (String)"UTF-8")));
        }
        this.buildRequest(this.request, string6, avaTaxPath.getHeaders());
    }

    public RestCall(String string, String string2, String string3, String string4, String string5, AvaTaxPath avaTaxPath, Object object, TypeToken<T> typeToken) {
        this(string, string2, string3, string4, string5, avaTaxPath, object, typeToken, HttpClients.createDefault());
    }

    public RestCall(String string, String string2, String string3, String string4, String string5, AvaTaxPath avaTaxPath, Object object, TypeToken<T> typeToken, HttpClientBuilder httpClientBuilder) {
        this(string, string2, string3, string4, string5, avaTaxPath, object, typeToken, httpClientBuilder.build());
    }

    public RestCall(String string, String string2, String string3, String string4, String string5, String string6, AvaTaxPath avaTaxPath, Object object, TypeToken<T> typeToken) {
        this(string, string2, string3, string4, string6, avaTaxPath, object, typeToken);
        this.request.setHeader("Authorization", "Basic " + string5);
    }

    public RestCall(String string, String string2, String string3, String string4, String string5, String string6, AvaTaxPath avaTaxPath, Object object, TypeToken<T> typeToken, HttpClientBuilder httpClientBuilder) {
        this(string, string2, string3, string4, string6, avaTaxPath, object, typeToken, httpClientBuilder);
        this.request.setHeader("Authorization", "Basic " + string5);
    }

    public RestCall(String string, String string2, String string3, String string4, String string5, AvaTaxPath avaTaxPath, Object object, TypeToken<T> typeToken, String string6, int n, String string7) {
        this(string, string2, string3, string4, string5, avaTaxPath, object, typeToken, HttpClients.custom().setRoutePlanner((HttpRoutePlanner)new DefaultProxyRoutePlanner(new HttpHost(string6, n, string7))).build());
    }

    public RestCall(String string, String string2, String string3, String string4, String string5, String string6, AvaTaxPath avaTaxPath, Object object, TypeToken<T> typeToken, String string7, int n, String string8) {
        this(string, string2, string3, string4, string6, avaTaxPath, object, typeToken, string7, n, string8);
        this.request.setHeader("Authorization", "Basic " + string5);
    }

    public RestCall(String string, String string2, String string3, String string4, String string5, AvaTaxPath avaTaxPath, Object object, TypeToken<T> typeToken, String string6) {
        this(string, string2, string3, string4, string5, avaTaxPath, object, typeToken, HttpClients.createDefault(), string6);
    }

    public RestCall(String string, String string2, String string3, String string4, String string5, AvaTaxPath avaTaxPath, Object object, TypeToken<T> typeToken, HttpClientBuilder httpClientBuilder, String string6) {
        this(string, string2, string3, string4, string5, avaTaxPath, object, typeToken, httpClientBuilder.build(), string6);
    }

    public RestCall(String string, String string2, String string3, String string4, String string5, String string6, AvaTaxPath avaTaxPath, Object object, TypeToken<T> typeToken, String string7) {
        this(string, string2, string3, string4, string6, avaTaxPath, object, typeToken, string7);
        this.request.setHeader("Authorization", "Basic " + string5);
    }

    public RestCall(String string, String string2, String string3, String string4, String string5, String string6, AvaTaxPath avaTaxPath, Object object, TypeToken<T> typeToken, HttpClientBuilder httpClientBuilder, String string7) {
        this(string, string2, string3, string4, string6, avaTaxPath, object, typeToken, httpClientBuilder, string7);
        this.request.setHeader("Authorization", "Basic " + string5);
    }

    public RestCall(String string, String string2, String string3, String string4, String string5, AvaTaxPath avaTaxPath, Object object, TypeToken<T> typeToken, String string6, int n, String string7, String string8) {
        this(string, string2, string3, string4, string5, avaTaxPath, object, typeToken, HttpClients.custom().setRoutePlanner((HttpRoutePlanner)new DefaultProxyRoutePlanner(new HttpHost(string6, n, string7))).build(), string8);
    }

    public RestCall(String string, String string2, String string3, String string4, String string5, String string6, AvaTaxPath avaTaxPath, Object object, TypeToken<T> typeToken, String string7, int n, String string8, String string9) {
        this(string, string2, string3, string4, string6, avaTaxPath, object, typeToken, string7, n, string8, string9);
        this.request.setHeader("Authorization", "Basic " + string5);
    }

    @Override
    public T call() throws Exception {
        LogObject logObject = new LogObject();
        logObject.populateRequestInfo(this.request);
        long l = System.currentTimeMillis();
        Object object = null;
        String string = null;
        CloseableHttpResponse closeableHttpResponse = null;
        try {
            closeableHttpResponse = this.client.execute((HttpUriRequest)this.request);
            HttpEntity httpEntity = closeableHttpResponse.getEntity();
            if (httpEntity != null) {
                string = EntityUtils.toString((HttpEntity)httpEntity);
            }
            if (closeableHttpResponse.getStatusLine().getStatusCode() / 100 != 2) {
                logObject.populateErrorInfo(string, closeableHttpResponse, l);
                throw new AvaTaxClientException((ErrorResult)JsonSerializer.DeserializeObject(string, ErrorResult.class), this.model);
            }
            if (string != null) {
                object = ContentType.getOrDefault((HttpEntity)httpEntity).getMimeType().equals("application/json") && !Objects.equals(this.typeToken.getType(), String.class) ? JsonSerializer.DeserializeObject(string, this.typeToken.getType()) : string;
            }
            logObject.populateResponseInfo(closeableHttpResponse, string, l);
        }
        catch (JsonParseException jsonParseException) {
            logObject.populateErrorInfo(jsonParseException.getMessage(), closeableHttpResponse, l);
            ErrorResult errorResult = new ErrorResult();
            int n = closeableHttpResponse.getStatusLine().getStatusCode();
            ArrayList<ErrorDetail> arrayList = new ArrayList<ErrorDetail>();
            ErrorDetail errorDetail = new ErrorDetail();
            errorDetail.setDescription(string);
            arrayList.add(errorDetail);
            ErrorInfo errorInfo = new ErrorInfo();
            errorInfo.setMessage("The server returned " + n + " but the response is in an unexpected format. See details for the complete response.");
            errorInfo.setTarget(ErrorTargetCode.Unknown);
            errorInfo.setDetails(arrayList);
            errorResult.setError(errorInfo);
            throw new AvaTaxClientException(errorResult, this.model);
        }
        catch (Exception exception) {
            logObject.populateErrorInfo(exception.getMessage(), closeableHttpResponse, l);
            throw exception;
        }
        finally {
            this.logInfo(logObject);
            closeableHttpResponse.close();
        }
        return (T)object;
    }

    private void logInfo(LogObject logObject) {
        if (logObject.getStatusCode() != null && logObject.getStatusCode() < 400) {
            this.logger.info(JsonSerializer.SerializeObject(logObject));
        } else {
            this.logger.error(JsonSerializer.SerializeObject(logObject));
        }
    }

    private void buildRequest(HttpRequestBase httpRequestBase, String string, HashMap<String, String> hashMap) {
        this.addTimeOutIfRequired(httpRequestBase);
        String string2 = String.format("%s; %s; %s; %s; %s", this.appName, this.appVersion, "JavaRestClient", string, this.machineName);
        httpRequestBase.setHeader(AvaTaxConstants.XClientHeader, string2);
        if (hashMap != null && !hashMap.isEmpty()) {
            for (Map.Entry<String, String> entry : hashMap.entrySet()) {
                httpRequestBase.setHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    private void addTimeOutIfRequired(HttpRequestBase httpRequestBase) {
        RequestConfig requestConfig = this.getUserConfig();
        if (this.isTimeOutMissing(requestConfig)) {
            this.addTimeOut(httpRequestBase, requestConfig);
        }
    }

    private boolean isTimeOutMissing(RequestConfig requestConfig) {
        if (requestConfig == null) {
            return true;
        }
        return requestConfig.getConnectionRequestTimeout() == -1 || requestConfig.getConnectTimeout() == -1 || requestConfig.getSocketTimeout() == -1;
    }

    private void addTimeOut(HttpRequestBase httpRequestBase, RequestConfig requestConfig) {
        RequestConfig.Builder builder;
        int n = 120000;
        if (requestConfig != null) {
            builder = RequestConfig.copy((RequestConfig)requestConfig);
            if (requestConfig.getConnectionRequestTimeout() == -1) {
                builder.setConnectionRequestTimeout(n);
            }
            if (requestConfig.getConnectTimeout() == -1) {
                builder.setConnectTimeout(n);
            }
            if (requestConfig.getSocketTimeout() == -1) {
                builder.setSocketTimeout(n);
            }
        } else {
            builder = RequestConfig.custom().setSocketTimeout(n).setConnectTimeout(n).setConnectionRequestTimeout(n);
        }
        RequestConfig requestConfig2 = builder.build();
        httpRequestBase.setConfig(requestConfig2);
    }

    private RequestConfig getUserConfig() {
        if (this.client instanceof Configurable) {
            Configurable configurable = (Configurable)this.client;
            return configurable.getConfig();
        }
        return null;
    }
}

