/*
 * Decompiled with CFR 0.152.
 */
package net.avalara.avatax.rest.client;

import com.google.gson.reflect.TypeToken;
import java.io.Closeable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.avalara.avatax.rest.client.AvaTaxConstants;
import net.avalara.avatax.rest.client.AvaTaxPath;
import net.avalara.avatax.rest.client.FetchResult;
import net.avalara.avatax.rest.client.RestCallFactory;
import net.avalara.avatax.rest.client.enums.AvaTaxEnvironment;
import net.avalara.avatax.rest.client.enums.CertificatePreviewType;
import net.avalara.avatax.rest.client.enums.DocumentType;
import net.avalara.avatax.rest.client.enums.POABusinessUnit;
import net.avalara.avatax.rest.client.enums.POASubscriptionType;
import net.avalara.avatax.rest.client.enums.PointOfSaleFileType;
import net.avalara.avatax.rest.client.enums.PointOfSalePartnerId;
import net.avalara.avatax.rest.client.enums.StackAggregationOption;
import net.avalara.avatax.rest.client.enums.TextCase;
import net.avalara.avatax.rest.client.enums.UserDefinedFieldType;
import net.avalara.avatax.rest.client.models.ACHEntryDetailModel;
import net.avalara.avatax.rest.client.models.APConfigSettingRequestModel;
import net.avalara.avatax.rest.client.models.APConfigSettingSuccessResponseModel;
import net.avalara.avatax.rest.client.models.AccountConfigurationModel;
import net.avalara.avatax.rest.client.models.AccountLicenseKeyModel;
import net.avalara.avatax.rest.client.models.AccountModel;
import net.avalara.avatax.rest.client.models.ActivateAccountModel;
import net.avalara.avatax.rest.client.models.AddTransactionLineModel;
import net.avalara.avatax.rest.client.models.AddressResolutionModel;
import net.avalara.avatax.rest.client.models.AddressValidationInfo;
import net.avalara.avatax.rest.client.models.AdjustMultiDocumentModel;
import net.avalara.avatax.rest.client.models.AdjustTransactionModel;
import net.avalara.avatax.rest.client.models.AgeVerifyRequest;
import net.avalara.avatax.rest.client.models.AgeVerifyResult;
import net.avalara.avatax.rest.client.models.AssociatedObjectDeletedErrorDetailsModel;
import net.avalara.avatax.rest.client.models.AuditModel;
import net.avalara.avatax.rest.client.models.AuditMultiDocumentModel;
import net.avalara.avatax.rest.client.models.AuditTransactionModel;
import net.avalara.avatax.rest.client.models.AvaFileFormModel;
import net.avalara.avatax.rest.client.models.BatchModel;
import net.avalara.avatax.rest.client.models.BulkLockTransactionModel;
import net.avalara.avatax.rest.client.models.BulkLockTransactionResult;
import net.avalara.avatax.rest.client.models.CertExpressInvitationModel;
import net.avalara.avatax.rest.client.models.CertExpressInvitationStatusModel;
import net.avalara.avatax.rest.client.models.CertificateAttributeModel;
import net.avalara.avatax.rest.client.models.CertificateModel;
import net.avalara.avatax.rest.client.models.ChangeTransactionCodeModel;
import net.avalara.avatax.rest.client.models.ClassificationParameterUsageMapModel;
import net.avalara.avatax.rest.client.models.CommitMultiDocumentModel;
import net.avalara.avatax.rest.client.models.CommitTransactionModel;
import net.avalara.avatax.rest.client.models.CommunicationCertificateResponse;
import net.avalara.avatax.rest.client.models.CommunicationCertificateResponsePage;
import net.avalara.avatax.rest.client.models.CommunicationsTSPairModel;
import net.avalara.avatax.rest.client.models.CommunicationsTransactionTypeModel;
import net.avalara.avatax.rest.client.models.CompanyConfigurationModel;
import net.avalara.avatax.rest.client.models.CompanyDistanceThresholdModel;
import net.avalara.avatax.rest.client.models.CompanyInitializationModel;
import net.avalara.avatax.rest.client.models.CompanyModel;
import net.avalara.avatax.rest.client.models.CompanyParameterDetailModel;
import net.avalara.avatax.rest.client.models.CompanyUserDefinedFieldModel;
import net.avalara.avatax.rest.client.models.ComplianceRateOptionModel;
import net.avalara.avatax.rest.client.models.ComplianceStateConfigModel;
import net.avalara.avatax.rest.client.models.ContactModel;
import net.avalara.avatax.rest.client.models.CostCenterBulkUploadInputModel;
import net.avalara.avatax.rest.client.models.CostCenterBulkUploadOutputModel;
import net.avalara.avatax.rest.client.models.CostCenterRequestModel;
import net.avalara.avatax.rest.client.models.CostCenterSuccessResponseModel;
import net.avalara.avatax.rest.client.models.CountryCoefficientsEntity;
import net.avalara.avatax.rest.client.models.CountryCoefficientsRequestEntity;
import net.avalara.avatax.rest.client.models.CountryCoefficientsResponseModel;
import net.avalara.avatax.rest.client.models.CoverLetterModel;
import net.avalara.avatax.rest.client.models.CreateCertExpressInvitationModel;
import net.avalara.avatax.rest.client.models.CreateECommerceTokenInputModel;
import net.avalara.avatax.rest.client.models.CreateMultiDocumentModel;
import net.avalara.avatax.rest.client.models.CreateNoticeResponsibilityTypeModel;
import net.avalara.avatax.rest.client.models.CreateNoticeRootCauseTypeModel;
import net.avalara.avatax.rest.client.models.CreateOrAdjustTransactionModel;
import net.avalara.avatax.rest.client.models.CreateTransactionBatchRequestModel;
import net.avalara.avatax.rest.client.models.CreateTransactionBatchResponseModel;
import net.avalara.avatax.rest.client.models.CreateTransactionModel;
import net.avalara.avatax.rest.client.models.CurrencyModel;
import net.avalara.avatax.rest.client.models.CustomerAttributeModel;
import net.avalara.avatax.rest.client.models.CustomerModel;
import net.avalara.avatax.rest.client.models.DataSourceModel;
import net.avalara.avatax.rest.client.models.DcvCreationResponse;
import net.avalara.avatax.rest.client.models.DcvViewModel;
import net.avalara.avatax.rest.client.models.DeclareNexusByAddressModel;
import net.avalara.avatax.rest.client.models.DomainNameViewModel;
import net.avalara.avatax.rest.client.models.ECommerceTokenOutputModel;
import net.avalara.avatax.rest.client.models.EntityUseCodeModel;
import net.avalara.avatax.rest.client.models.ErrorDetail;
import net.avalara.avatax.rest.client.models.EventDeleteMessageModel;
import net.avalara.avatax.rest.client.models.EventMessageResponse;
import net.avalara.avatax.rest.client.models.ExemptionReasonModel;
import net.avalara.avatax.rest.client.models.ExemptionStatusModel;
import net.avalara.avatax.rest.client.models.ExportDocumentLineModel;
import net.avalara.avatax.rest.client.models.ExposureZoneModel;
import net.avalara.avatax.rest.client.models.FilingFrequencyModel;
import net.avalara.avatax.rest.client.models.FilingStatusChangeModel;
import net.avalara.avatax.rest.client.models.FilterModel;
import net.avalara.avatax.rest.client.models.FirmClientLinkageInputModel;
import net.avalara.avatax.rest.client.models.FirmClientLinkageOutputModel;
import net.avalara.avatax.rest.client.models.FormMasterModel;
import net.avalara.avatax.rest.client.models.FundingConfigurationModel;
import net.avalara.avatax.rest.client.models.FundingInitiateModel;
import net.avalara.avatax.rest.client.models.FundingStatusModel;
import net.avalara.avatax.rest.client.models.GLAccountBulkUploadInputModel;
import net.avalara.avatax.rest.client.models.GLAccountBulkUploadOutputModel;
import net.avalara.avatax.rest.client.models.GLAccountRequestModel;
import net.avalara.avatax.rest.client.models.GLAccountSuccessResponseModel;
import net.avalara.avatax.rest.client.models.GetBatchesResult;
import net.avalara.avatax.rest.client.models.HsCodeModel;
import net.avalara.avatax.rest.client.models.IsoCountryModel;
import net.avalara.avatax.rest.client.models.IsoRegionModel;
import net.avalara.avatax.rest.client.models.ItemBulkUploadInputModel;
import net.avalara.avatax.rest.client.models.ItemBulkUploadOutputModel;
import net.avalara.avatax.rest.client.models.ItemCatalogueInputModel;
import net.avalara.avatax.rest.client.models.ItemCatalogueOutputModel;
import net.avalara.avatax.rest.client.models.ItemClassificationInputModel;
import net.avalara.avatax.rest.client.models.ItemClassificationOutputModel;
import net.avalara.avatax.rest.client.models.ItemModel;
import net.avalara.avatax.rest.client.models.ItemParameterModel;
import net.avalara.avatax.rest.client.models.ItemPremiumClassificationOutputModel;
import net.avalara.avatax.rest.client.models.ItemRestrictionOutputModel;
import net.avalara.avatax.rest.client.models.ItemStatusModel;
import net.avalara.avatax.rest.client.models.ItemTagDetailInputModel;
import net.avalara.avatax.rest.client.models.ItemTagDetailOutputModel;
import net.avalara.avatax.rest.client.models.ItemTaxCodeClassificationRequestInputModel;
import net.avalara.avatax.rest.client.models.ItemTaxCodeClassificationRequestOutputModel;
import net.avalara.avatax.rest.client.models.ItemTaxCodeRecommendationStatusModel;
import net.avalara.avatax.rest.client.models.JurisNameModel;
import net.avalara.avatax.rest.client.models.JurisdictionHierarchyModel;
import net.avalara.avatax.rest.client.models.JurisdictionModel;
import net.avalara.avatax.rest.client.models.JurisdictionOverrideModel;
import net.avalara.avatax.rest.client.models.JurisdictionRateTypeTaxTypeMappingModel;
import net.avalara.avatax.rest.client.models.LicenseKeyModel;
import net.avalara.avatax.rest.client.models.LinkCertificatesModel;
import net.avalara.avatax.rest.client.models.LinkCustomersModel;
import net.avalara.avatax.rest.client.models.LocationModel;
import net.avalara.avatax.rest.client.models.LocationParameterModel;
import net.avalara.avatax.rest.client.models.LocationQuestionModel;
import net.avalara.avatax.rest.client.models.LocationValidationModel;
import net.avalara.avatax.rest.client.models.LockTransactionModel;
import net.avalara.avatax.rest.client.models.MarketplaceLocationModel;
import net.avalara.avatax.rest.client.models.MarketplaceModel;
import net.avalara.avatax.rest.client.models.MrsCompanyModel;
import net.avalara.avatax.rest.client.models.MultiDocumentModel;
import net.avalara.avatax.rest.client.models.NewAccountModel;
import net.avalara.avatax.rest.client.models.NewAccountRequestModel;
import net.avalara.avatax.rest.client.models.NewFirmClientAccountRequestModel;
import net.avalara.avatax.rest.client.models.NexusByAddressModel;
import net.avalara.avatax.rest.client.models.NexusByTaxFormModel;
import net.avalara.avatax.rest.client.models.NexusModel;
import net.avalara.avatax.rest.client.models.NexusParameterDetailModel;
import net.avalara.avatax.rest.client.models.NexusTaxTypeGroupModel;
import net.avalara.avatax.rest.client.models.NoticeCustomerFundingOptionModel;
import net.avalara.avatax.rest.client.models.NoticeCustomerTypeModel;
import net.avalara.avatax.rest.client.models.NoticeFilingTypeModel;
import net.avalara.avatax.rest.client.models.NoticePriorityModel;
import net.avalara.avatax.rest.client.models.NoticeReasonModel;
import net.avalara.avatax.rest.client.models.NoticeResponsibilityModel;
import net.avalara.avatax.rest.client.models.NoticeRootCauseModel;
import net.avalara.avatax.rest.client.models.NoticeStatusModel;
import net.avalara.avatax.rest.client.models.NoticeTypeModel;
import net.avalara.avatax.rest.client.models.NotificationModel;
import net.avalara.avatax.rest.client.models.ObjectDeletedErrorModel;
import net.avalara.avatax.rest.client.models.OfferModel;
import net.avalara.avatax.rest.client.models.ParameterModel;
import net.avalara.avatax.rest.client.models.ParameterUsageModel;
import net.avalara.avatax.rest.client.models.PasswordChangeModel;
import net.avalara.avatax.rest.client.models.PingResultModel;
import net.avalara.avatax.rest.client.models.PointOfSaleDataRequestModel;
import net.avalara.avatax.rest.client.models.PostalCodeModel;
import net.avalara.avatax.rest.client.models.PreferredProgramModel;
import net.avalara.avatax.rest.client.models.ProductClassificationSystemModel;
import net.avalara.avatax.rest.client.models.ProvisionStatusModel;
import net.avalara.avatax.rest.client.models.RateTypeModel;
import net.avalara.avatax.rest.client.models.RateTypesModel;
import net.avalara.avatax.rest.client.models.RefreshECommerceTokenInputModel;
import net.avalara.avatax.rest.client.models.RefundTransactionModel;
import net.avalara.avatax.rest.client.models.RemoveTransactionLineModel;
import net.avalara.avatax.rest.client.models.ReportCodeOptionModel;
import net.avalara.avatax.rest.client.models.ReportModel;
import net.avalara.avatax.rest.client.models.ResetLicenseKeyModel;
import net.avalara.avatax.rest.client.models.ReturnsParameterUsageModel;
import net.avalara.avatax.rest.client.models.SecurityRoleModel;
import net.avalara.avatax.rest.client.models.SetPasswordModel;
import net.avalara.avatax.rest.client.models.SettingModel;
import net.avalara.avatax.rest.client.models.SettleTransactionModel;
import net.avalara.avatax.rest.client.models.ShippingVerifyResult;
import net.avalara.avatax.rest.client.models.SkyscraperStatusModel;
import net.avalara.avatax.rest.client.models.StoreAgeVerifyRequest;
import net.avalara.avatax.rest.client.models.StoreIfVerifiedResult;
import net.avalara.avatax.rest.client.models.SubscriptionModel;
import net.avalara.avatax.rest.client.models.SubscriptionTypeModel;
import net.avalara.avatax.rest.client.models.SyncItemsRequestModel;
import net.avalara.avatax.rest.client.models.SyncItemsResponseModel;
import net.avalara.avatax.rest.client.models.TagsModel;
import net.avalara.avatax.rest.client.models.TaxAuthorityFormModel;
import net.avalara.avatax.rest.client.models.TaxAuthorityModel;
import net.avalara.avatax.rest.client.models.TaxAuthorityTypeModel;
import net.avalara.avatax.rest.client.models.TaxCodeModel;
import net.avalara.avatax.rest.client.models.TaxCodeRecommendationOutputModel;
import net.avalara.avatax.rest.client.models.TaxCodeTypesModel;
import net.avalara.avatax.rest.client.models.TaxProfileErrorResponseModel;
import net.avalara.avatax.rest.client.models.TaxRateModel;
import net.avalara.avatax.rest.client.models.TaxRuleModel;
import net.avalara.avatax.rest.client.models.TaxSubTypeModel;
import net.avalara.avatax.rest.client.models.TaxTypeGroupModel;
import net.avalara.avatax.rest.client.models.TaxTypeMappingModel;
import net.avalara.avatax.rest.client.models.TaxTypeModel;
import net.avalara.avatax.rest.client.models.TransactionModel;
import net.avalara.avatax.rest.client.models.UPCModel;
import net.avalara.avatax.rest.client.models.UnitOfBasisModel;
import net.avalara.avatax.rest.client.models.UomModel;
import net.avalara.avatax.rest.client.models.UserEntitlementModel;
import net.avalara.avatax.rest.client.models.UserModel;
import net.avalara.avatax.rest.client.models.VarianceRequestModel;
import net.avalara.avatax.rest.client.models.VarianceResponseModel;
import net.avalara.avatax.rest.client.models.VerifyMultiDocumentModel;
import net.avalara.avatax.rest.client.models.VerifyTransactionModel;
import net.avalara.avatax.rest.client.models.VoidTransactionModel;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.impl.client.HttpClientBuilder;

public class AvaTaxClient
implements Closeable {
    private final ExecutorService threadPool;
    private RestCallFactory restCallFactory;

    private AvaTaxClient() {
        this(null);
    }

    private AvaTaxClient(ExecutorService executorService) {
        this.threadPool = executorService != null ? executorService : Executors.newFixedThreadPool(3);
    }

    public AvaTaxClient(String string, String string2, String string3, AvaTaxEnvironment avaTaxEnvironment) {
        this(string, string2, string3, avaTaxEnvironment, null);
    }

    public AvaTaxClient(String string, String string2, String string3, String string4) {
        this();
        this.restCallFactory = new RestCallFactory(string, string2, string3, string4);
    }

    public AvaTaxClient(String string, String string2, String string3, AvaTaxEnvironment avaTaxEnvironment, String string4, int n, String string5) {
        this(string, string2, string3, avaTaxEnvironment, string4, n, string5, null);
    }

    public AvaTaxClient(String string, String string2, String string3, String string4, String string5, int n, String string6) {
        this();
        this.restCallFactory = new RestCallFactory(string, string2, string3, string4, string5, n, string6);
    }

    public AvaTaxClient(String string, String string2, String string3, AvaTaxEnvironment avaTaxEnvironment, ExecutorService executorService) {
        this(string, string2, string3, avaTaxEnvironment == AvaTaxEnvironment.Production ? AvaTaxConstants.Production_Url : AvaTaxConstants.Sandbox_Url, executorService);
    }

    public AvaTaxClient(String string, String string2, String string3, AvaTaxEnvironment avaTaxEnvironment, ExecutorService executorService, HttpClientBuilder httpClientBuilder) {
        this(string, string2, string3, avaTaxEnvironment == AvaTaxEnvironment.Production ? AvaTaxConstants.Production_Url : AvaTaxConstants.Sandbox_Url, executorService, httpClientBuilder);
    }

    public AvaTaxClient(String string, String string2, String string3, String string4, ExecutorService executorService) {
        this(executorService);
        this.restCallFactory = new RestCallFactory(string, string2, string3, string4);
    }

    public AvaTaxClient(String string, String string2, String string3, String string4, ExecutorService executorService, HttpClientBuilder httpClientBuilder) {
        this(executorService);
        this.restCallFactory = new RestCallFactory(string, string2, string3, string4, httpClientBuilder);
    }

    public AvaTaxClient(String string, String string2, String string3, AvaTaxEnvironment avaTaxEnvironment, String string4, int n, String string5, ExecutorService executorService) {
        this(string, string2, string3, avaTaxEnvironment == AvaTaxEnvironment.Production ? AvaTaxConstants.Production_Url : AvaTaxConstants.Sandbox_Url, string4, n, string5, executorService);
    }

    public AvaTaxClient(String string, String string2, String string3, String string4, String string5, int n, String string6, ExecutorService executorService) {
        this(executorService);
        this.restCallFactory = new RestCallFactory(string, string2, string3, string4, string5, n, string6);
    }

    public AvaTaxClient withSecurity(String string) {
        this.restCallFactory.addSecurityHeader(string);
        return this;
    }

    public AvaTaxClient withSecurity(String string, String string2) {
        String string3 = null;
        try {
            string3 = Base64.encodeBase64String((byte[])(string + ":" + string2).getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println("Could not find encoding for UTF-8.");
            unsupportedEncodingException.printStackTrace();
        }
        return this.withSecurity(string3);
    }

    @Override
    public void close() throws IOException {
        this.threadPool.shutdown();
        try {
            if (!this.threadPool.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.threadPool.shutdownNow();
                if (!this.threadPool.awaitTermination(60L, TimeUnit.SECONDS)) {
                    System.err.println("Pool did not terminate");
                }
            }
        }
        catch (InterruptedException interruptedException) {
            this.threadPool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public Void deregisterShipment(String string, String string2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/shipment/registration");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", string3);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<Void>(){}, "").call();
    }

    public Future<Void> deregisterShipmentAsync(String string, String string2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/shipment/registration");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<Void>(){}, ""));
    }

    public Void registerShipment(String string, String string2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/shipment/registration");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", string3);
        return this.restCallFactory.createRestCall("put", avaTaxPath, null, new TypeToken<Void>(){}, "").call();
    }

    public Future<Void> registerShipmentAsync(String string, String string2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/shipment/registration");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, null, new TypeToken<Void>(){}, ""));
    }

    public ShippingVerifyResult registerShipmentIfCompliant(String string, String string2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/shipment/registerIfCompliant");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", string3);
        return this.restCallFactory.createRestCall("put", avaTaxPath, null, new TypeToken<ShippingVerifyResult>(){}, "").call();
    }

    public Future<ShippingVerifyResult> registerShipmentIfCompliantAsync(String string, String string2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/shipment/registerIfCompliant");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, null, new TypeToken<ShippingVerifyResult>(){}, ""));
    }

    public ShippingVerifyResult verifyShipment(String string, String string2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/shipment/verify");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ShippingVerifyResult>(){}, "").call();
    }

    public Future<ShippingVerifyResult> verifyShipmentAsync(String string, String string2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/shipment/verify");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ShippingVerifyResult>(){}, ""));
    }

    public LicenseKeyModel accountResetLicenseKey(Integer n, ResetLicenseKeyModel resetLicenseKeyModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}/resetlicensekey");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, resetLicenseKeyModel, new TypeToken<LicenseKeyModel>(){}, "24.8.2").call();
    }

    public Future<LicenseKeyModel> accountResetLicenseKeyAsync(Integer n, ResetLicenseKeyModel resetLicenseKeyModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}/resetlicensekey");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, resetLicenseKeyModel, new TypeToken<LicenseKeyModel>(){}, "24.8.2"));
    }

    public AccountModel activateAccount(Integer n, ActivateAccountModel activateAccountModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}/activate");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, activateAccountModel, new TypeToken<AccountModel>(){}, "24.8.2").call();
    }

    public Future<AccountModel> activateAccountAsync(Integer n, ActivateAccountModel activateAccountModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}/activate");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, activateAccountModel, new TypeToken<AccountModel>(){}, "24.8.2"));
    }

    public FetchResult<AuditModel> auditAccount(Integer n, Date date, Date date2, Integer n2, Integer n3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}/audit");
        avaTaxPath.applyField("id", n);
        avaTaxPath.addQuery("start", date);
        avaTaxPath.addQuery("end", date2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<AuditModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<AuditModel>> auditAccountAsync(Integer n, Date date, Date date2, Integer n2, Integer n3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}/audit");
        avaTaxPath.applyField("id", n);
        avaTaxPath.addQuery("start", date);
        avaTaxPath.addQuery("end", date2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<AuditModel>>(){}, "24.8.2"));
    }

    public LicenseKeyModel createLicenseKey(Integer n, AccountLicenseKeyModel accountLicenseKeyModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}/licensekey");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, accountLicenseKeyModel, new TypeToken<LicenseKeyModel>(){}, "24.8.2").call();
    }

    public Future<LicenseKeyModel> createLicenseKeyAsync(Integer n, AccountLicenseKeyModel accountLicenseKeyModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}/licensekey");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, accountLicenseKeyModel, new TypeToken<LicenseKeyModel>(){}, "24.8.2"));
    }

    public ArrayList<ErrorDetail> deleteLicenseKey(Integer n, String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}/licensekey/{licensekeyname}");
        avaTaxPath.applyField("id", n);
        avaTaxPath.applyField("licensekeyname", string);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<ErrorDetail>> deleteLicenseKeyAsync(Integer n, String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}/licensekey/{licensekeyname}");
        avaTaxPath.applyField("id", n);
        avaTaxPath.applyField("licensekeyname", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2"));
    }

    public AccountModel getAccount(Integer n, String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}");
        avaTaxPath.applyField("id", n);
        avaTaxPath.addQuery("$include", string);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<AccountModel>(){}, "24.8.2").call();
    }

    public Future<AccountModel> getAccountAsync(Integer n, String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}");
        avaTaxPath.applyField("id", n);
        avaTaxPath.addQuery("$include", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<AccountModel>(){}, "24.8.2"));
    }

    public ArrayList<AccountConfigurationModel> getAccountConfiguration(Integer n) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}/configuration");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ArrayList<AccountConfigurationModel>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<AccountConfigurationModel>> getAccountConfigurationAsync(Integer n) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}/configuration");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ArrayList<AccountConfigurationModel>>(){}, "24.8.2"));
    }

    public AccountLicenseKeyModel getLicenseKey(Integer n, String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}/licensekey/{licensekeyname}");
        avaTaxPath.applyField("id", n);
        avaTaxPath.applyField("licensekeyname", string);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<AccountLicenseKeyModel>(){}, "24.8.2").call();
    }

    public Future<AccountLicenseKeyModel> getLicenseKeyAsync(Integer n, String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}/licensekey/{licensekeyname}");
        avaTaxPath.applyField("id", n);
        avaTaxPath.applyField("licensekeyname", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<AccountLicenseKeyModel>(){}, "24.8.2"));
    }

    public ArrayList<AccountLicenseKeyModel> getLicenseKeys(Integer n) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}/licensekeys");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ArrayList<AccountLicenseKeyModel>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<AccountLicenseKeyModel>> getLicenseKeysAsync(Integer n) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}/licensekeys");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ArrayList<AccountLicenseKeyModel>>(){}, "24.8.2"));
    }

    public FetchResult<MrsCompanyModel> listMrsAccounts() throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/mrs");
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<MrsCompanyModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<MrsCompanyModel>> listMrsAccountsAsync() {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/mrs");
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<MrsCompanyModel>>(){}, "24.8.2"));
    }

    public FetchResult<AccountModel> queryAccounts(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts");
        avaTaxPath.addQuery("$include", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<AccountModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<AccountModel>> queryAccountsAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts");
        avaTaxPath.addQuery("$include", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<AccountModel>>(){}, "24.8.2"));
    }

    public ArrayList<AccountConfigurationModel> setAccountConfiguration(Integer n, ArrayList<AccountConfigurationModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}/configuration");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<AccountConfigurationModel>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<AccountConfigurationModel>> setAccountConfigurationAsync(Integer n, ArrayList<AccountConfigurationModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}/configuration");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<AccountConfigurationModel>>(){}, "24.8.2"));
    }

    public AddressResolutionModel resolveAddress(String string, String string2, String string3, String string4, String string5, String string6, String string7, TextCase textCase) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/addresses/resolve");
        avaTaxPath.addQuery("line1", string);
        avaTaxPath.addQuery("line2", string2);
        avaTaxPath.addQuery("line3", string3);
        avaTaxPath.addQuery("city", string4);
        avaTaxPath.addQuery("region", string5);
        avaTaxPath.addQuery("postalCode", string6);
        avaTaxPath.addQuery("country", string7);
        avaTaxPath.addQuery("textCase", (Object)textCase);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<AddressResolutionModel>(){}, "24.8.2").call();
    }

    public Future<AddressResolutionModel> resolveAddressAsync(String string, String string2, String string3, String string4, String string5, String string6, String string7, TextCase textCase) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/addresses/resolve");
        avaTaxPath.addQuery("line1", string);
        avaTaxPath.addQuery("line2", string2);
        avaTaxPath.addQuery("line3", string3);
        avaTaxPath.addQuery("city", string4);
        avaTaxPath.addQuery("region", string5);
        avaTaxPath.addQuery("postalCode", string6);
        avaTaxPath.addQuery("country", string7);
        avaTaxPath.addQuery("textCase", (Object)textCase);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<AddressResolutionModel>(){}, "24.8.2"));
    }

    public AddressResolutionModel resolveAddressPost(AddressValidationInfo addressValidationInfo) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/addresses/resolve");
        return this.restCallFactory.createRestCall("post", avaTaxPath, addressValidationInfo, new TypeToken<AddressResolutionModel>(){}, "24.8.2").call();
    }

    public Future<AddressResolutionModel> resolveAddressPostAsync(AddressValidationInfo addressValidationInfo) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/addresses/resolve");
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, addressValidationInfo, new TypeToken<AddressResolutionModel>(){}, "24.8.2"));
    }

    public APConfigSettingSuccessResponseModel createAPConfigSetting(Integer n, APConfigSettingRequestModel aPConfigSettingRequestModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyid}/apconfigsetting");
        avaTaxPath.applyField("companyid", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, aPConfigSettingRequestModel, new TypeToken<APConfigSettingSuccessResponseModel>(){}, "24.8.2").call();
    }

    public Future<APConfigSettingSuccessResponseModel> createAPConfigSettingAsync(Integer n, APConfigSettingRequestModel aPConfigSettingRequestModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyid}/apconfigsetting");
        avaTaxPath.applyField("companyid", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, aPConfigSettingRequestModel, new TypeToken<APConfigSettingSuccessResponseModel>(){}, "24.8.2"));
    }

    public FetchResult<APConfigSettingSuccessResponseModel> getAPConfigSettingByCompany(Integer n, String string, String string2, Integer n2, Integer n3, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyid}/apconfigsetting");
        avaTaxPath.applyField("companyid", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<APConfigSettingSuccessResponseModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<APConfigSettingSuccessResponseModel>> getAPConfigSettingByCompanyAsync(Integer n, String string, String string2, Integer n2, Integer n3, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyid}/apconfigsetting");
        avaTaxPath.applyField("companyid", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<APConfigSettingSuccessResponseModel>>(){}, "24.8.2"));
    }

    public FetchResult<APConfigSettingSuccessResponseModel> queryAPConfigSetting(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/apconfigsetting");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<APConfigSettingSuccessResponseModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<APConfigSettingSuccessResponseModel>> queryAPConfigSettingAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/apconfigsetting");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<APConfigSettingSuccessResponseModel>>(){}, "24.8.2"));
    }

    public APConfigSettingSuccessResponseModel updateAPConfigSetting(Integer n, APConfigSettingRequestModel aPConfigSettingRequestModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyid}/apconfigsetting");
        avaTaxPath.applyField("companyid", n);
        return this.restCallFactory.createRestCall("put", avaTaxPath, aPConfigSettingRequestModel, new TypeToken<APConfigSettingSuccessResponseModel>(){}, "24.8.2").call();
    }

    public Future<APConfigSettingSuccessResponseModel> updateAPConfigSettingAsync(Integer n, APConfigSettingRequestModel aPConfigSettingRequestModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyid}/apconfigsetting");
        avaTaxPath.applyField("companyid", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, aPConfigSettingRequestModel, new TypeToken<APConfigSettingSuccessResponseModel>(){}, "24.8.2"));
    }

    public ArrayList<AvaFileFormModel> createAvaFileForms(ArrayList<AvaFileFormModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/avafileforms");
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<AvaFileFormModel>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<AvaFileFormModel>> createAvaFileFormsAsync(ArrayList<AvaFileFormModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/avafileforms");
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<AvaFileFormModel>>(){}, "24.8.2"));
    }

    public ArrayList<ErrorDetail> deleteAvaFileForm(Integer n) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/avafileforms/{id}");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<ErrorDetail>> deleteAvaFileFormAsync(Integer n) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/avafileforms/{id}");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2"));
    }

    public AvaFileFormModel getAvaFileForm(Integer n) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/avafileforms/{id}");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<AvaFileFormModel>(){}, "24.8.2").call();
    }

    public Future<AvaFileFormModel> getAvaFileFormAsync(Integer n) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/avafileforms/{id}");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<AvaFileFormModel>(){}, "24.8.2"));
    }

    public FetchResult<AvaFileFormModel> queryAvaFileForms(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/avafileforms");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<AvaFileFormModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<AvaFileFormModel>> queryAvaFileFormsAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/avafileforms");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<AvaFileFormModel>>(){}, "24.8.2"));
    }

    public AvaFileFormModel updateAvaFileForm(Integer n, AvaFileFormModel avaFileFormModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/avafileforms/{id}");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("put", avaTaxPath, avaFileFormModel, new TypeToken<AvaFileFormModel>(){}, "24.8.2").call();
    }

    public Future<AvaFileFormModel> updateAvaFileFormAsync(Integer n, AvaFileFormModel avaFileFormModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/avafileforms/{id}");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, avaFileFormModel, new TypeToken<AvaFileFormModel>(){}, "24.8.2"));
    }

    public BatchModel cancelBatch(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/batches/{id}/cancel");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("post", avaTaxPath, null, new TypeToken<BatchModel>(){}, "24.8.2").call();
    }

    public Future<BatchModel> cancelBatchAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/batches/{id}/cancel");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, null, new TypeToken<BatchModel>(){}, "24.8.2"));
    }

    public ArrayList<BatchModel> createBatches(Integer n, ArrayList<BatchModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/batches");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<BatchModel>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<BatchModel>> createBatchesAsync(Integer n, ArrayList<BatchModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/batches");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<BatchModel>>(){}, "24.8.2"));
    }

    public CreateTransactionBatchResponseModel createTransactionBatch(Integer n, CreateTransactionBatchRequestModel createTransactionBatchRequestModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/batches/transactions");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, createTransactionBatchRequestModel, new TypeToken<CreateTransactionBatchResponseModel>(){}, "24.8.2").call();
    }

    public Future<CreateTransactionBatchResponseModel> createTransactionBatchAsync(Integer n, CreateTransactionBatchRequestModel createTransactionBatchRequestModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/batches/transactions");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, createTransactionBatchRequestModel, new TypeToken<CreateTransactionBatchResponseModel>(){}, "24.8.2"));
    }

    public ArrayList<ErrorDetail> deleteBatch(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/batches/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<ErrorDetail>> deleteBatchAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/batches/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2"));
    }

    public String downloadBatch(Integer n, Integer n2, Integer n3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/batches/{batchId}/files/{id}/attachment");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("batchId", n2);
        avaTaxPath.applyField("id", n3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<String>(){}, "24.8.2").call();
    }

    public Future<String> downloadBatchAsync(Integer n, Integer n2, Integer n3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/batches/{batchId}/files/{id}/attachment");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("batchId", n2);
        avaTaxPath.applyField("id", n3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<String>(){}, "24.8.2"));
    }

    public BatchModel getBatch(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/batches/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<BatchModel>(){}, "24.8.2").call();
    }

    public Future<BatchModel> getBatchAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/batches/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<BatchModel>(){}, "24.8.2"));
    }

    public FetchResult<BatchModel> listBatchesByCompany(Integer n, String string, String string2, Integer n2, Integer n3, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/batches");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<BatchModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<BatchModel>> listBatchesByCompanyAsync(Integer n, String string, String string2, Integer n2, Integer n3, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/batches");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<BatchModel>>(){}, "24.8.2"));
    }

    public FetchResult<BatchModel> queryBatches(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/batches");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<BatchModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<BatchModel>> queryBatchesAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/batches");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<BatchModel>>(){}, "24.8.2"));
    }

    public ArrayList<CertExpressInvitationStatusModel> createCertExpressInvitation(Integer n, String string, ArrayList<CreateCertExpressInvitationModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers/{customerCode}/certexpressinvites");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("customerCode", string);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<CertExpressInvitationStatusModel>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<CertExpressInvitationStatusModel>> createCertExpressInvitationAsync(Integer n, String string, ArrayList<CreateCertExpressInvitationModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers/{customerCode}/certexpressinvites");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("customerCode", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<CertExpressInvitationStatusModel>>(){}, "24.8.2"));
    }

    public CertExpressInvitationModel getCertExpressInvitation(Integer n, String string, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers/{customerCode}/certexpressinvites/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("customerCode", string);
        avaTaxPath.applyField("id", n2);
        avaTaxPath.addQuery("$include", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<CertExpressInvitationModel>(){}, "24.8.2").call();
    }

    public Future<CertExpressInvitationModel> getCertExpressInvitationAsync(Integer n, String string, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers/{customerCode}/certexpressinvites/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("customerCode", string);
        avaTaxPath.applyField("id", n2);
        avaTaxPath.addQuery("$include", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<CertExpressInvitationModel>(){}, "24.8.2"));
    }

    public FetchResult<CertExpressInvitationModel> listCertExpressInvitations(Integer n, String string, String string2, Integer n2, Integer n3, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certexpressinvites");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$include", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CertExpressInvitationModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<CertExpressInvitationModel>> listCertExpressInvitationsAsync(Integer n, String string, String string2, Integer n2, Integer n3, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certexpressinvites");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$include", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CertExpressInvitationModel>>(){}, "24.8.2"));
    }

    public ArrayList<CertificateModel> createCertificates(Integer n, Boolean bl, ArrayList<CertificateModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$preValidatedExemptionReason", bl);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<CertificateModel>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<CertificateModel>> createCertificatesAsync(Integer n, Boolean bl, ArrayList<CertificateModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$preValidatedExemptionReason", bl);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<CertificateModel>>(){}, "24.8.2"));
    }

    public ArrayList<ErrorDetail> deleteCertificate(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<ErrorDetail>> deleteCertificateAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2"));
    }

    public String downloadCertificateImage(Integer n, Integer n2, Integer n3, CertificatePreviewType certificatePreviewType) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates/{id}/attachment");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        avaTaxPath.addQuery("$page", n3);
        avaTaxPath.addQuery("$type", (Object)certificatePreviewType);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<String>(){}, "24.8.2").call();
    }

    public Future<String> downloadCertificateImageAsync(Integer n, Integer n2, Integer n3, CertificatePreviewType certificatePreviewType) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates/{id}/attachment");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        avaTaxPath.addQuery("$page", n3);
        avaTaxPath.addQuery("$type", (Object)certificatePreviewType);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<String>(){}, "24.8.2"));
    }

    public CertificateModel getCertificate(Integer n, Integer n2, String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        avaTaxPath.addQuery("$include", string);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<CertificateModel>(){}, "24.8.2").call();
    }

    public Future<CertificateModel> getCertificateAsync(Integer n, Integer n2, String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        avaTaxPath.addQuery("$include", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<CertificateModel>(){}, "24.8.2"));
    }

    public ProvisionStatusModel getCertificateSetup(Integer n) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates/setup");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ProvisionStatusModel>(){}, "24.8.2").call();
    }

    public Future<ProvisionStatusModel> getCertificateSetupAsync(Integer n) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates/setup");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ProvisionStatusModel>(){}, "24.8.2"));
    }

    public FetchResult<CertificateAttributeModel> linkAttributesToCertificate(Integer n, Integer n2, ArrayList<CertificateAttributeModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates/{id}/attributes/link");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<FetchResult<CertificateAttributeModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<CertificateAttributeModel>> linkAttributesToCertificateAsync(Integer n, Integer n2, ArrayList<CertificateAttributeModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates/{id}/attributes/link");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<FetchResult<CertificateAttributeModel>>(){}, "24.8.2"));
    }

    public FetchResult<CustomerModel> linkCustomersToCertificate(Integer n, Integer n2, LinkCustomersModel linkCustomersModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates/{id}/customers/link");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("post", avaTaxPath, linkCustomersModel, new TypeToken<FetchResult<CustomerModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<CustomerModel>> linkCustomersToCertificateAsync(Integer n, Integer n2, LinkCustomersModel linkCustomersModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates/{id}/customers/link");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, linkCustomersModel, new TypeToken<FetchResult<CustomerModel>>(){}, "24.8.2"));
    }

    public FetchResult<CertificateAttributeModel> listAttributesForCertificate(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates/{id}/attributes");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CertificateAttributeModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<CertificateAttributeModel>> listAttributesForCertificateAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates/{id}/attributes");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CertificateAttributeModel>>(){}, "24.8.2"));
    }

    public FetchResult<CustomerModel> listCustomersForCertificate(Integer n, Integer n2, String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates/{id}/customers");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        avaTaxPath.addQuery("$include", string);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CustomerModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<CustomerModel>> listCustomersForCertificateAsync(Integer n, Integer n2, String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates/{id}/customers");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        avaTaxPath.addQuery("$include", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CustomerModel>>(){}, "24.8.2"));
    }

    public FetchResult<CertificateModel> queryCertificates(Integer n, String string, String string2, Integer n2, Integer n3, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$include", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CertificateModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<CertificateModel>> queryCertificatesAsync(Integer n, String string, String string2, Integer n2, Integer n3, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$include", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CertificateModel>>(){}, "24.8.2"));
    }

    public ProvisionStatusModel requestCertificateSetup(Integer n) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates/setup");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, null, new TypeToken<ProvisionStatusModel>(){}, "24.8.2").call();
    }

    public Future<ProvisionStatusModel> requestCertificateSetupAsync(Integer n) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates/setup");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, null, new TypeToken<ProvisionStatusModel>(){}, "24.8.2"));
    }

    public FetchResult<CertificateAttributeModel> unlinkAttributesFromCertificate(Integer n, Integer n2, ArrayList<CertificateAttributeModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates/{id}/attributes/unlink");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<FetchResult<CertificateAttributeModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<CertificateAttributeModel>> unlinkAttributesFromCertificateAsync(Integer n, Integer n2, ArrayList<CertificateAttributeModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates/{id}/attributes/unlink");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<FetchResult<CertificateAttributeModel>>(){}, "24.8.2"));
    }

    public FetchResult<CustomerModel> unlinkCustomersFromCertificate(Integer n, Integer n2, LinkCustomersModel linkCustomersModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates/{id}/customers/unlink");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("post", avaTaxPath, linkCustomersModel, new TypeToken<FetchResult<CustomerModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<CustomerModel>> unlinkCustomersFromCertificateAsync(Integer n, Integer n2, LinkCustomersModel linkCustomersModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates/{id}/customers/unlink");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, linkCustomersModel, new TypeToken<FetchResult<CustomerModel>>(){}, "24.8.2"));
    }

    public CertificateModel updateCertificate(Integer n, Integer n2, CertificateModel certificateModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("put", avaTaxPath, certificateModel, new TypeToken<CertificateModel>(){}, "24.8.2").call();
    }

    public Future<CertificateModel> updateCertificateAsync(Integer n, Integer n2, CertificateModel certificateModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, certificateModel, new TypeToken<CertificateModel>(){}, "24.8.2"));
    }

    public String uploadCertificateImage(Integer n, Integer n2, String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates/{id}/attachment");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("post", avaTaxPath, null, new TypeToken<String>(){}, "24.8.2").call();
    }

    public Future<String> uploadCertificateImageAsync(Integer n, Integer n2, String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/certificates/{id}/attachment");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, null, new TypeToken<String>(){}, "24.8.2"));
    }

    public CommunicationCertificateResponse getCommunicationCertificate(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/companies/{companyId}/communication-certificates/{certificateId}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("certificateId", n2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<CommunicationCertificateResponse>(){}, "24.8.2").call();
    }

    public Future<CommunicationCertificateResponse> getCommunicationCertificateAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/companies/{companyId}/communication-certificates/{certificateId}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("certificateId", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<CommunicationCertificateResponse>(){}, "24.8.2"));
    }

    public CommunicationCertificateResponsePage listCommunicationCertificates(String string, Integer n, Integer n2, String string2, Integer n3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/companies/{companyId}/communication-certificates");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        avaTaxPath.applyField("companyId", n3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<CommunicationCertificateResponsePage>(){}, "24.8.2").call();
    }

    public Future<CommunicationCertificateResponsePage> listCommunicationCertificatesAsync(String string, Integer n, Integer n2, String string2, Integer n3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/companies/{companyId}/communication-certificates");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        avaTaxPath.applyField("companyId", n3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<CommunicationCertificateResponsePage>(){}, "24.8.2"));
    }

    public String certifyIntegration(Integer n) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}/certify");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<String>(){}, "24.8.2").call();
    }

    public Future<String> certifyIntegrationAsync(Integer n) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}/certify");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<String>(){}, "24.8.2"));
    }

    public String changeFilingStatus(Integer n, FilingStatusChangeModel filingStatusChangeModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}/filingstatus");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, filingStatusChangeModel, new TypeToken<String>(){}, "24.8.2").call();
    }

    public Future<String> changeFilingStatusAsync(Integer n, FilingStatusChangeModel filingStatusChangeModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}/filingstatus");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, filingStatusChangeModel, new TypeToken<String>(){}, "24.8.2"));
    }

    public CompanyModel companyInitialize(CompanyInitializationModel companyInitializationModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/initialize");
        return this.restCallFactory.createRestCall("post", avaTaxPath, companyInitializationModel, new TypeToken<CompanyModel>(){}, "24.8.2").call();
    }

    public Future<CompanyModel> companyInitializeAsync(CompanyInitializationModel companyInitializationModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/initialize");
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, companyInitializationModel, new TypeToken<CompanyModel>(){}, "24.8.2"));
    }

    public ArrayList<CompanyModel> createCompanies(ArrayList<CompanyModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies");
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<CompanyModel>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<CompanyModel>> createCompaniesAsync(ArrayList<CompanyModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies");
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<CompanyModel>>(){}, "24.8.2"));
    }

    public ArrayList<CompanyParameterDetailModel> createCompanyParameters(Integer n, ArrayList<CompanyParameterDetailModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/parameters");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<CompanyParameterDetailModel>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<CompanyParameterDetailModel>> createCompanyParametersAsync(Integer n, ArrayList<CompanyParameterDetailModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/parameters");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<CompanyParameterDetailModel>>(){}, "24.8.2"));
    }

    public FundingStatusModel createFundingRequest(Integer n, POABusinessUnit pOABusinessUnit, POASubscriptionType pOASubscriptionType, FundingInitiateModel fundingInitiateModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}/funding/setup");
        avaTaxPath.applyField("id", n);
        avaTaxPath.addQuery("businessUnit", (Object)pOABusinessUnit);
        avaTaxPath.addQuery("subscriptionType", (Object)pOASubscriptionType);
        return this.restCallFactory.createRestCall("post", avaTaxPath, fundingInitiateModel, new TypeToken<FundingStatusModel>(){}, "24.8.2").call();
    }

    public Future<FundingStatusModel> createFundingRequestAsync(Integer n, POABusinessUnit pOABusinessUnit, POASubscriptionType pOASubscriptionType, FundingInitiateModel fundingInitiateModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}/funding/setup");
        avaTaxPath.applyField("id", n);
        avaTaxPath.addQuery("businessUnit", (Object)pOABusinessUnit);
        avaTaxPath.addQuery("subscriptionType", (Object)pOASubscriptionType);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, fundingInitiateModel, new TypeToken<FundingStatusModel>(){}, "24.8.2"));
    }

    public ArrayList<ErrorDetail> deleteCompany(Integer n) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<ErrorDetail>> deleteCompanyAsync(Integer n) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2"));
    }

    public ArrayList<ErrorDetail> deleteCompanyParameter(Integer n, Long l) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/parameters/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", l);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<ErrorDetail>> deleteCompanyParameterAsync(Integer n, Long l) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/parameters/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2"));
    }

    public FundingConfigurationModel fundingConfigurationByCompany(Integer n) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/funding/configuration");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FundingConfigurationModel>(){}, "24.8.2").call();
    }

    public Future<FundingConfigurationModel> fundingConfigurationByCompanyAsync(Integer n) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/funding/configuration");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FundingConfigurationModel>(){}, "24.8.2"));
    }

    public ArrayList<FundingConfigurationModel> fundingConfigurationsByCompanyAndCurrency(Integer n, String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/funding/configurations");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("currency", string);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ArrayList<FundingConfigurationModel>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<FundingConfigurationModel>> fundingConfigurationsByCompanyAndCurrencyAsync(Integer n, String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/funding/configurations");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("currency", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ArrayList<FundingConfigurationModel>>(){}, "24.8.2"));
    }

    public CompanyModel getCompany(Integer n, String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}");
        avaTaxPath.applyField("id", n);
        avaTaxPath.addQuery("$include", string);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<CompanyModel>(){}, "24.8.2").call();
    }

    public Future<CompanyModel> getCompanyAsync(Integer n, String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}");
        avaTaxPath.applyField("id", n);
        avaTaxPath.addQuery("$include", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<CompanyModel>(){}, "24.8.2"));
    }

    public ArrayList<CompanyConfigurationModel> getCompanyConfiguration(Integer n) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}/configuration");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ArrayList<CompanyConfigurationModel>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<CompanyConfigurationModel>> getCompanyConfigurationAsync(Integer n) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}/configuration");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ArrayList<CompanyConfigurationModel>>(){}, "24.8.2"));
    }

    public CompanyParameterDetailModel getCompanyParameterDetail(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/parameters/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<CompanyParameterDetailModel>(){}, "24.8.2").call();
    }

    public Future<CompanyParameterDetailModel> getCompanyParameterDetailAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/parameters/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<CompanyParameterDetailModel>(){}, "24.8.2"));
    }

    public String getFilingStatus(Integer n) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}/filingstatus");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<String>(){}, "24.8.2").call();
    }

    public Future<String> getFilingStatusAsync(Integer n) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}/filingstatus");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<String>(){}, "24.8.2"));
    }

    public ArrayList<ACHEntryDetailModel> listACHEntryDetailsForCompany(Integer n, Integer n2, Integer n3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}/paymentdetails/{periodyear}/{periodmonth}");
        avaTaxPath.applyField("id", n);
        avaTaxPath.applyField("periodyear", n2);
        avaTaxPath.applyField("periodmonth", n3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ArrayList<ACHEntryDetailModel>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<ACHEntryDetailModel>> listACHEntryDetailsForCompanyAsync(Integer n, Integer n2, Integer n3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}/paymentdetails/{periodyear}/{periodmonth}");
        avaTaxPath.applyField("id", n);
        avaTaxPath.applyField("periodyear", n2);
        avaTaxPath.applyField("periodmonth", n3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ArrayList<ACHEntryDetailModel>>(){}, "24.8.2"));
    }

    public FetchResult<CompanyParameterDetailModel> listCompanyParameterDetails(Integer n, String string, Integer n2, Integer n3, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/parameters");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CompanyParameterDetailModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<CompanyParameterDetailModel>> listCompanyParameterDetailsAsync(Integer n, String string, Integer n2, Integer n3, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/parameters");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CompanyParameterDetailModel>>(){}, "24.8.2"));
    }

    public ArrayList<FundingStatusModel> listFundingRequestsByCompany(Integer n) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}/funding");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ArrayList<FundingStatusModel>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<FundingStatusModel>> listFundingRequestsByCompanyAsync(Integer n) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}/funding");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ArrayList<FundingStatusModel>>(){}, "24.8.2"));
    }

    public FetchResult<MrsCompanyModel> listMrsCompanies() throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/mrs");
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<MrsCompanyModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<MrsCompanyModel>> listMrsCompaniesAsync() {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/mrs");
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<MrsCompanyModel>>(){}, "24.8.2"));
    }

    public FetchResult<CompanyModel> queryCompanies(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies");
        avaTaxPath.addQuery("$include", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CompanyModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<CompanyModel>> queryCompaniesAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies");
        avaTaxPath.addQuery("$include", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CompanyModel>>(){}, "24.8.2"));
    }

    public ArrayList<CompanyConfigurationModel> setCompanyConfiguration(Integer n, ArrayList<CompanyConfigurationModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}/configuration");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<CompanyConfigurationModel>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<CompanyConfigurationModel>> setCompanyConfigurationAsync(Integer n, ArrayList<CompanyConfigurationModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}/configuration");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<CompanyConfigurationModel>>(){}, "24.8.2"));
    }

    public CompanyModel updateCompany(Integer n, CompanyModel companyModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("put", avaTaxPath, companyModel, new TypeToken<CompanyModel>(){}, "24.8.2").call();
    }

    public Future<CompanyModel> updateCompanyAsync(Integer n, CompanyModel companyModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{id}");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, companyModel, new TypeToken<CompanyModel>(){}, "24.8.2"));
    }

    public CompanyParameterDetailModel updateCompanyParameterDetail(Integer n, Long l, CompanyParameterDetailModel companyParameterDetailModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/parameters/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", l);
        return this.restCallFactory.createRestCall("put", avaTaxPath, companyParameterDetailModel, new TypeToken<CompanyParameterDetailModel>(){}, "24.8.2").call();
    }

    public Future<CompanyParameterDetailModel> updateCompanyParameterDetailAsync(Integer n, Long l, CompanyParameterDetailModel companyParameterDetailModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/parameters/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, companyParameterDetailModel, new TypeToken<CompanyParameterDetailModel>(){}, "24.8.2"));
    }

    public FetchResult<JurisNameModel> queryJurisNames(String string, String string2, Date date, Date date2, String string3, Integer n, Integer n2, String string4) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/compliance/jurisnames/{country}/{region}");
        avaTaxPath.applyField("country", string);
        avaTaxPath.applyField("region", string2);
        avaTaxPath.addQuery("effectiveDate", date);
        avaTaxPath.addQuery("endDate", date2);
        avaTaxPath.addQuery("$filter", string3);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string4);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<JurisNameModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<JurisNameModel>> queryJurisNamesAsync(String string, String string2, Date date, Date date2, String string3, Integer n, Integer n2, String string4) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/compliance/jurisnames/{country}/{region}");
        avaTaxPath.applyField("country", string);
        avaTaxPath.applyField("region", string2);
        avaTaxPath.addQuery("effectiveDate", date);
        avaTaxPath.addQuery("endDate", date2);
        avaTaxPath.addQuery("$filter", string3);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string4);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<JurisNameModel>>(){}, "24.8.2"));
    }

    public FetchResult<ComplianceRateOptionModel> queryRateOptions(String string, String string2, Date date, Date date2, StackAggregationOption stackAggregationOption, Integer n, Integer n2, String string3, String string4) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/compliance/rateOptions/{country}/{region}");
        avaTaxPath.applyField("country", string);
        avaTaxPath.applyField("region", string2);
        avaTaxPath.addQuery("effectiveDate", date);
        avaTaxPath.addQuery("endDate", date2);
        avaTaxPath.addQuery("aggregationOption", (Object)stackAggregationOption);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$filter", string3);
        avaTaxPath.addQuery("$orderBy", string4);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ComplianceRateOptionModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<ComplianceRateOptionModel>> queryRateOptionsAsync(String string, String string2, Date date, Date date2, StackAggregationOption stackAggregationOption, Integer n, Integer n2, String string3, String string4) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/compliance/rateOptions/{country}/{region}");
        avaTaxPath.applyField("country", string);
        avaTaxPath.applyField("region", string2);
        avaTaxPath.addQuery("effectiveDate", date);
        avaTaxPath.addQuery("endDate", date2);
        avaTaxPath.addQuery("aggregationOption", (Object)stackAggregationOption);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$filter", string3);
        avaTaxPath.addQuery("$orderBy", string4);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ComplianceRateOptionModel>>(){}, "24.8.2"));
    }

    public FetchResult<ComplianceStateConfigModel> queryStateConfig(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/compliance/stateconfig");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ComplianceStateConfigModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<ComplianceStateConfigModel>> queryStateConfigAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/compliance/stateconfig");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ComplianceStateConfigModel>>(){}, "24.8.2"));
    }

    public FetchResult<ReportCodeOptionModel> queryStateReportingCodes(String string, String string2, Date date, Date date2, String string3, Integer n, Integer n2, String string4) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/compliance/stateReportingCodes/{country}/{region}");
        avaTaxPath.applyField("country", string);
        avaTaxPath.applyField("region", string2);
        avaTaxPath.addQuery("effectiveDate", date);
        avaTaxPath.addQuery("endDate", date2);
        avaTaxPath.addQuery("$filter", string3);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string4);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ReportCodeOptionModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<ReportCodeOptionModel>> queryStateReportingCodesAsync(String string, String string2, Date date, Date date2, String string3, Integer n, Integer n2, String string4) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/compliance/stateReportingCodes/{country}/{region}");
        avaTaxPath.applyField("country", string);
        avaTaxPath.applyField("region", string2);
        avaTaxPath.addQuery("effectiveDate", date);
        avaTaxPath.addQuery("endDate", date2);
        avaTaxPath.addQuery("$filter", string3);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string4);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ReportCodeOptionModel>>(){}, "24.8.2"));
    }

    public FetchResult<TaxTypeMappingModel> queryTaxTypeMappings(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/compliance/taxtypemappings");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxTypeMappingModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<TaxTypeMappingModel>> queryTaxTypeMappingsAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/compliance/taxtypemappings");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxTypeMappingModel>>(){}, "24.8.2"));
    }

    public ArrayList<ContactModel> createContacts(Integer n, ArrayList<ContactModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/contacts");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<ContactModel>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<ContactModel>> createContactsAsync(Integer n, ArrayList<ContactModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/contacts");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<ContactModel>>(){}, "24.8.2"));
    }

    public ArrayList<ErrorDetail> deleteContact(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/contacts/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<ErrorDetail>> deleteContactAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/contacts/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2"));
    }

    public ContactModel getContact(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/contacts/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ContactModel>(){}, "24.8.2").call();
    }

    public Future<ContactModel> getContactAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/contacts/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ContactModel>(){}, "24.8.2"));
    }

    public FetchResult<ContactModel> listContactsByCompany(Integer n, String string, Integer n2, Integer n3, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/contacts");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ContactModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<ContactModel>> listContactsByCompanyAsync(Integer n, String string, Integer n2, Integer n3, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/contacts");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ContactModel>>(){}, "24.8.2"));
    }

    public FetchResult<ContactModel> queryContacts(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/contacts");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ContactModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<ContactModel>> queryContactsAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/contacts");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ContactModel>>(){}, "24.8.2"));
    }

    public ContactModel updateContact(Integer n, Integer n2, ContactModel contactModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/contacts/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("put", avaTaxPath, contactModel, new TypeToken<ContactModel>(){}, "24.8.2").call();
    }

    public Future<ContactModel> updateContactAsync(Integer n, Integer n2, ContactModel contactModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/contacts/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, contactModel, new TypeToken<ContactModel>(){}, "24.8.2"));
    }

    public CostCenterBulkUploadOutputModel bulkUploadCostCenters(Integer n, CostCenterBulkUploadInputModel costCenterBulkUploadInputModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyid}/costcenters/$upload");
        avaTaxPath.applyField("companyid", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, costCenterBulkUploadInputModel, new TypeToken<CostCenterBulkUploadOutputModel>(){}, "24.8.2").call();
    }

    public Future<CostCenterBulkUploadOutputModel> bulkUploadCostCentersAsync(Integer n, CostCenterBulkUploadInputModel costCenterBulkUploadInputModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyid}/costcenters/$upload");
        avaTaxPath.applyField("companyid", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, costCenterBulkUploadInputModel, new TypeToken<CostCenterBulkUploadOutputModel>(){}, "24.8.2"));
    }

    public CostCenterSuccessResponseModel createCostCenter(Integer n, CostCenterRequestModel costCenterRequestModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyid}/costcenters");
        avaTaxPath.applyField("companyid", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, costCenterRequestModel, new TypeToken<CostCenterSuccessResponseModel>(){}, "24.8.2").call();
    }

    public Future<CostCenterSuccessResponseModel> createCostCenterAsync(Integer n, CostCenterRequestModel costCenterRequestModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyid}/costcenters");
        avaTaxPath.applyField("companyid", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, costCenterRequestModel, new TypeToken<CostCenterSuccessResponseModel>(){}, "24.8.2"));
    }

    public TaxProfileErrorResponseModel deleteCostCenter(Integer n, Long l) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyid}/costcenters/{costcenterid}");
        avaTaxPath.applyField("companyid", n);
        avaTaxPath.applyField("costcenterid", l);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<TaxProfileErrorResponseModel>(){}, "24.8.2").call();
    }

    public Future<TaxProfileErrorResponseModel> deleteCostCenterAsync(Integer n, Long l) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyid}/costcenters/{costcenterid}");
        avaTaxPath.applyField("companyid", n);
        avaTaxPath.applyField("costcenterid", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<TaxProfileErrorResponseModel>(){}, "24.8.2"));
    }

    public CostCenterSuccessResponseModel getCostCenterById(Integer n, Long l) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyid}/costcenters/{costcenterid}");
        avaTaxPath.applyField("companyid", n);
        avaTaxPath.applyField("costcenterid", l);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<CostCenterSuccessResponseModel>(){}, "24.8.2").call();
    }

    public Future<CostCenterSuccessResponseModel> getCostCenterByIdAsync(Integer n, Long l) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyid}/costcenters/{costcenterid}");
        avaTaxPath.applyField("companyid", n);
        avaTaxPath.applyField("costcenterid", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<CostCenterSuccessResponseModel>(){}, "24.8.2"));
    }

    public FetchResult<CostCenterSuccessResponseModel> listCostCentersByCompany(Integer n, String string, String string2, Integer n2, Integer n3, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyid}/costcenters");
        avaTaxPath.applyField("companyid", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CostCenterSuccessResponseModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<CostCenterSuccessResponseModel>> listCostCentersByCompanyAsync(Integer n, String string, String string2, Integer n2, Integer n3, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyid}/costcenters");
        avaTaxPath.applyField("companyid", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CostCenterSuccessResponseModel>>(){}, "24.8.2"));
    }

    public FetchResult<CostCenterSuccessResponseModel> queryCostCenters(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/costcenters");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CostCenterSuccessResponseModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<CostCenterSuccessResponseModel>> queryCostCentersAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/costcenters");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CostCenterSuccessResponseModel>>(){}, "24.8.2"));
    }

    public CostCenterSuccessResponseModel updateCostCenter(Integer n, Long l, CostCenterRequestModel costCenterRequestModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyid}/costcenters/{costcenterid}");
        avaTaxPath.applyField("companyid", n);
        avaTaxPath.applyField("costcenterid", l);
        return this.restCallFactory.createRestCall("put", avaTaxPath, costCenterRequestModel, new TypeToken<CostCenterSuccessResponseModel>(){}, "24.8.2").call();
    }

    public Future<CostCenterSuccessResponseModel> updateCostCenterAsync(Integer n, Long l, CostCenterRequestModel costCenterRequestModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyid}/costcenters/{costcenterid}");
        avaTaxPath.applyField("companyid", n);
        avaTaxPath.applyField("costcenterid", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, costCenterRequestModel, new TypeToken<CostCenterSuccessResponseModel>(){}, "24.8.2"));
    }

    public ArrayList<CustomerModel> createCustomers(Integer n, ArrayList<CustomerModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<CustomerModel>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<CustomerModel>> createCustomersAsync(Integer n, ArrayList<CustomerModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<CustomerModel>>(){}, "24.8.2"));
    }

    public Void deleteCustomer(Integer n, String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers/{customerCode}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("customerCode", string);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<Void>(){}, "24.8.2").call();
    }

    public Future<Void> deleteCustomerAsync(Integer n, String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers/{customerCode}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("customerCode", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<Void>(){}, "24.8.2"));
    }

    public CustomerModel getCustomer(Integer n, String string, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers/{customerCode}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("customerCode", string);
        avaTaxPath.addQuery("$include", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<CustomerModel>(){}, "24.8.2").call();
    }

    public Future<CustomerModel> getCustomerAsync(Integer n, String string, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers/{customerCode}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("customerCode", string);
        avaTaxPath.addQuery("$include", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<CustomerModel>(){}, "24.8.2"));
    }

    public FetchResult<CustomerAttributeModel> linkAttributesToCustomer(Integer n, String string, ArrayList<CustomerAttributeModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers/{customerCode}/attributes/link");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("customerCode", string);
        return this.restCallFactory.createRestCall("put", avaTaxPath, arrayList, new TypeToken<FetchResult<CustomerAttributeModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<CustomerAttributeModel>> linkAttributesToCustomerAsync(Integer n, String string, ArrayList<CustomerAttributeModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers/{customerCode}/attributes/link");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("customerCode", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, arrayList, new TypeToken<FetchResult<CustomerAttributeModel>>(){}, "24.8.2"));
    }

    public FetchResult<CertificateModel> linkCertificatesToCustomer(Integer n, String string, LinkCertificatesModel linkCertificatesModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers/{customerCode}/certificates/link");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("customerCode", string);
        return this.restCallFactory.createRestCall("post", avaTaxPath, linkCertificatesModel, new TypeToken<FetchResult<CertificateModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<CertificateModel>> linkCertificatesToCustomerAsync(Integer n, String string, LinkCertificatesModel linkCertificatesModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers/{customerCode}/certificates/link");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("customerCode", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, linkCertificatesModel, new TypeToken<FetchResult<CertificateModel>>(){}, "24.8.2"));
    }

    public CustomerModel linkShipToCustomersToBillCustomer(Integer n, String string, LinkCustomersModel linkCustomersModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers/billto/{code}/shipto/link");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("code", string);
        return this.restCallFactory.createRestCall("post", avaTaxPath, linkCustomersModel, new TypeToken<CustomerModel>(){}, "24.8.2").call();
    }

    public Future<CustomerModel> linkShipToCustomersToBillCustomerAsync(Integer n, String string, LinkCustomersModel linkCustomersModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers/billto/{code}/shipto/link");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("code", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, linkCustomersModel, new TypeToken<CustomerModel>(){}, "24.8.2"));
    }

    public FetchResult<CustomerAttributeModel> listAttributesForCustomer(Integer n, String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers/{customerCode}/attributes");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("customerCode", string);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CustomerAttributeModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<CustomerAttributeModel>> listAttributesForCustomerAsync(Integer n, String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers/{customerCode}/attributes");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("customerCode", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CustomerAttributeModel>>(){}, "24.8.2"));
    }

    public FetchResult<CertificateModel> listCertificatesForCustomer(Integer n, String string, String string2, String string3, Integer n2, Integer n3, String string4) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers/{customerCode}/certificates");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("customerCode", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$filter", string3);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string4);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CertificateModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<CertificateModel>> listCertificatesForCustomerAsync(Integer n, String string, String string2, String string3, Integer n2, Integer n3, String string4) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers/{customerCode}/certificates");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("customerCode", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$filter", string3);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string4);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CertificateModel>>(){}, "24.8.2"));
    }

    public ExemptionStatusModel listValidCertificatesForCustomer(Integer n, String string, String string2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers/{customerCode}/certificates/{country}/{region}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("customerCode", string);
        avaTaxPath.applyField("country", string2);
        avaTaxPath.applyField("region", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ExemptionStatusModel>(){}, "24.8.2").call();
    }

    public Future<ExemptionStatusModel> listValidCertificatesForCustomerAsync(Integer n, String string, String string2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers/{customerCode}/certificates/{country}/{region}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("customerCode", string);
        avaTaxPath.applyField("country", string2);
        avaTaxPath.applyField("region", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ExemptionStatusModel>(){}, "24.8.2"));
    }

    public FetchResult<CustomerModel> queryCustomers(Integer n, String string, String string2, Integer n2, Integer n3, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$include", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CustomerModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<CustomerModel>> queryCustomersAsync(Integer n, String string, String string2, Integer n2, Integer n3, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$include", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CustomerModel>>(){}, "24.8.2"));
    }

    public FetchResult<CustomerAttributeModel> unlinkAttributesFromCustomer(Integer n, String string, ArrayList<CustomerAttributeModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers/{customerCode}/attributes/unlink");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("customerCode", string);
        return this.restCallFactory.createRestCall("put", avaTaxPath, arrayList, new TypeToken<FetchResult<CustomerAttributeModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<CustomerAttributeModel>> unlinkAttributesFromCustomerAsync(Integer n, String string, ArrayList<CustomerAttributeModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers/{customerCode}/attributes/unlink");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("customerCode", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, arrayList, new TypeToken<FetchResult<CustomerAttributeModel>>(){}, "24.8.2"));
    }

    public FetchResult<CertificateModel> unlinkCertificatesFromCustomer(Integer n, String string, LinkCertificatesModel linkCertificatesModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers/{customerCode}/certificates/unlink");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("customerCode", string);
        return this.restCallFactory.createRestCall("post", avaTaxPath, linkCertificatesModel, new TypeToken<FetchResult<CertificateModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<CertificateModel>> unlinkCertificatesFromCustomerAsync(Integer n, String string, LinkCertificatesModel linkCertificatesModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers/{customerCode}/certificates/unlink");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("customerCode", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, linkCertificatesModel, new TypeToken<FetchResult<CertificateModel>>(){}, "24.8.2"));
    }

    public CustomerModel updateCustomer(Integer n, String string, CustomerModel customerModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers/{customerCode}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("customerCode", string);
        return this.restCallFactory.createRestCall("put", avaTaxPath, customerModel, new TypeToken<CustomerModel>(){}, "24.8.2").call();
    }

    public Future<CustomerModel> updateCustomerAsync(Integer n, String string, CustomerModel customerModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/customers/{customerCode}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("customerCode", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, customerModel, new TypeToken<CustomerModel>(){}, "24.8.2"));
    }

    public ArrayList<DataSourceModel> createDataSources(Integer n, ArrayList<DataSourceModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/datasources");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<DataSourceModel>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<DataSourceModel>> createDataSourcesAsync(Integer n, ArrayList<DataSourceModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/datasources");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<DataSourceModel>>(){}, "24.8.2"));
    }

    public ArrayList<ErrorDetail> deleteDataSource(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/datasources/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<ErrorDetail>> deleteDataSourceAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/datasources/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2"));
    }

    public DataSourceModel getDataSourceById(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/datasources/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<DataSourceModel>(){}, "24.8.2").call();
    }

    public Future<DataSourceModel> getDataSourceByIdAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/datasources/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<DataSourceModel>(){}, "24.8.2"));
    }

    public FetchResult<DataSourceModel> listDataSources(Integer n, String string, Integer n2, Integer n3, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/datasources");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<DataSourceModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<DataSourceModel>> listDataSourcesAsync(Integer n, String string, Integer n2, Integer n3, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/datasources");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<DataSourceModel>>(){}, "24.8.2"));
    }

    public FetchResult<DataSourceModel> queryDataSources(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/datasources");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<DataSourceModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<DataSourceModel>> queryDataSourcesAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/datasources");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<DataSourceModel>>(){}, "24.8.2"));
    }

    public DataSourceModel updateDataSource(Integer n, Integer n2, DataSourceModel dataSourceModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/datasources/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("put", avaTaxPath, dataSourceModel, new TypeToken<DataSourceModel>(){}, "24.8.2").call();
    }

    public Future<DataSourceModel> updateDataSourceAsync(Integer n, Integer n2, DataSourceModel dataSourceModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/datasources/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, dataSourceModel, new TypeToken<DataSourceModel>(){}, "24.8.2"));
    }

    public FetchResult<HsCodeModel> getCrossBorderCode(String string, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/crossborder/{country}/{hsCode}/hierarchy");
        avaTaxPath.applyField("country", string);
        avaTaxPath.applyField("hsCode", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<HsCodeModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<HsCodeModel>> getCrossBorderCodeAsync(String string, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/crossborder/{country}/{hsCode}/hierarchy");
        avaTaxPath.applyField("country", string);
        avaTaxPath.applyField("hsCode", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<HsCodeModel>>(){}, "24.8.2"));
    }

    public FetchResult<SkyscraperStatusModel> getLoginVerifierByForm(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/filingcalendars/loginverifiers/{form}");
        avaTaxPath.applyField("form", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SkyscraperStatusModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<SkyscraperStatusModel>> getLoginVerifierByFormAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/filingcalendars/loginverifiers/{form}");
        avaTaxPath.applyField("form", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SkyscraperStatusModel>>(){}, "24.8.2"));
    }

    public FetchResult<MarketplaceModel> listAllMarketplaceLocations(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/listallmarketplacelocations");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<MarketplaceModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<MarketplaceModel>> listAllMarketplaceLocationsAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/listallmarketplacelocations");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<MarketplaceModel>>(){}, "24.8.2"));
    }

    public FetchResult<AvaFileFormModel> listAvaFileForms(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/avafileforms");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<AvaFileFormModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<AvaFileFormModel>> listAvaFileFormsAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/avafileforms");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<AvaFileFormModel>>(){}, "24.8.2"));
    }

    public FetchResult<CertificateAttributeModel> listCertificateAttributes(Integer n, String string, Integer n2, Integer n3, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/certificateattributes");
        avaTaxPath.addQuery("companyid", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CertificateAttributeModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<CertificateAttributeModel>> listCertificateAttributesAsync(Integer n, String string, Integer n2, Integer n3, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/certificateattributes");
        avaTaxPath.addQuery("companyid", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CertificateAttributeModel>>(){}, "24.8.2"));
    }

    public FetchResult<ExemptionReasonModel> listCertificateExemptReasons(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/certificateexemptreasons");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ExemptionReasonModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<ExemptionReasonModel>> listCertificateExemptReasonsAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/certificateexemptreasons");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ExemptionReasonModel>>(){}, "24.8.2"));
    }

    public FetchResult<ExposureZoneModel> listCertificateExposureZones(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/certificateexposurezones");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ExposureZoneModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<ExposureZoneModel>> listCertificateExposureZonesAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/certificateexposurezones");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ExposureZoneModel>>(){}, "24.8.2"));
    }

    public FetchResult<ClassificationParameterUsageMapModel> listClassificationParametersUsage(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/classification/parametersusage");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ClassificationParameterUsageMapModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<ClassificationParameterUsageMapModel>> listClassificationParametersUsageAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/classification/parametersusage");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ClassificationParameterUsageMapModel>>(){}, "24.8.2"));
    }

    public FetchResult<CommunicationsTSPairModel> listCommunicationsServiceTypes(Integer n, String string, Integer n2, Integer n3, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/communications/transactiontypes/{id}/servicetypes");
        avaTaxPath.applyField("id", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CommunicationsTSPairModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<CommunicationsTSPairModel>> listCommunicationsServiceTypesAsync(Integer n, String string, Integer n2, Integer n3, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/communications/transactiontypes/{id}/servicetypes");
        avaTaxPath.applyField("id", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CommunicationsTSPairModel>>(){}, "24.8.2"));
    }

    public FetchResult<CommunicationsTransactionTypeModel> listCommunicationsTransactionTypes(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/communications/transactiontypes");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CommunicationsTransactionTypeModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<CommunicationsTransactionTypeModel>> listCommunicationsTransactionTypesAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/communications/transactiontypes");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CommunicationsTransactionTypeModel>>(){}, "24.8.2"));
    }

    public FetchResult<CommunicationsTSPairModel> listCommunicationsTSPairs(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/communications/tspairs");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CommunicationsTSPairModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<CommunicationsTSPairModel>> listCommunicationsTSPairsAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/communications/tspairs");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CommunicationsTSPairModel>>(){}, "24.8.2"));
    }

    public FetchResult<IsoCountryModel> listCountries(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/countries");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<IsoCountryModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<IsoCountryModel>> listCountriesAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/countries");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<IsoCountryModel>>(){}, "24.8.2"));
    }

    public FetchResult<CoverLetterModel> listCoverLetters(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/coverletters");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CoverLetterModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<CoverLetterModel>> listCoverLettersAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/coverletters");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CoverLetterModel>>(){}, "24.8.2"));
    }

    public FetchResult<HsCodeModel> listCrossBorderCodes(String string, String string2, String string3, Integer n, Integer n2, String string4) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/crossborder/{country}/{hsCode}");
        avaTaxPath.applyField("country", string);
        avaTaxPath.applyField("hsCode", string2);
        avaTaxPath.addQuery("$filter", string3);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string4);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<HsCodeModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<HsCodeModel>> listCrossBorderCodesAsync(String string, String string2, String string3, Integer n, Integer n2, String string4) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/crossborder/{country}/{hsCode}");
        avaTaxPath.applyField("country", string);
        avaTaxPath.applyField("hsCode", string2);
        avaTaxPath.addQuery("$filter", string3);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string4);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<HsCodeModel>>(){}, "24.8.2"));
    }

    public FetchResult<HsCodeModel> listCrossBorderSections() throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/crossborder/sections");
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<HsCodeModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<HsCodeModel>> listCrossBorderSectionsAsync() {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/crossborder/sections");
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<HsCodeModel>>(){}, "24.8.2"));
    }

    public FetchResult<CurrencyModel> listCurrencies(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/currencies");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CurrencyModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<CurrencyModel>> listCurrenciesAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/currencies");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CurrencyModel>>(){}, "24.8.2"));
    }

    public FetchResult<EntityUseCodeModel> listEntityUseCodes(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/entityusecodes");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<EntityUseCodeModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<EntityUseCodeModel>> listEntityUseCodesAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/entityusecodes");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<EntityUseCodeModel>>(){}, "24.8.2"));
    }

    public FetchResult<FilingFrequencyModel> listFilingFrequencies(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/filingfrequencies");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<FilingFrequencyModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<FilingFrequencyModel>> listFilingFrequenciesAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/filingfrequencies");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<FilingFrequencyModel>>(){}, "24.8.2"));
    }

    public ArrayList<ItemTaxCodeRecommendationStatusModel> listItemsRecommendationsStatus() throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/items/recommendationstatus");
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ArrayList<ItemTaxCodeRecommendationStatusModel>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<ItemTaxCodeRecommendationStatusModel>> listItemsRecommendationsStatusAsync() {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/items/recommendationstatus");
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ArrayList<ItemTaxCodeRecommendationStatusModel>>(){}, "24.8.2"));
    }

    public ArrayList<ItemStatusModel> listItemsStatus() throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/items/status");
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ArrayList<ItemStatusModel>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<ItemStatusModel>> listItemsStatusAsync() {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/items/status");
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ArrayList<ItemStatusModel>>(){}, "24.8.2"));
    }

    public FetchResult<JurisdictionModel> listJurisdictions(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/jurisdictions");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<JurisdictionModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<JurisdictionModel>> listJurisdictionsAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/jurisdictions");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<JurisdictionModel>>(){}, "24.8.2"));
    }

    public FetchResult<JurisdictionOverrideModel> listJurisdictionsByAddress(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, Integer n, Integer n2, String string9) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/jurisdictionsnearaddress");
        avaTaxPath.addQuery("line1", string);
        avaTaxPath.addQuery("line2", string2);
        avaTaxPath.addQuery("line3", string3);
        avaTaxPath.addQuery("city", string4);
        avaTaxPath.addQuery("region", string5);
        avaTaxPath.addQuery("postalCode", string6);
        avaTaxPath.addQuery("country", string7);
        avaTaxPath.addQuery("$filter", string8);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string9);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<JurisdictionOverrideModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<JurisdictionOverrideModel>> listJurisdictionsByAddressAsync(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, Integer n, Integer n2, String string9) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/jurisdictionsnearaddress");
        avaTaxPath.addQuery("line1", string);
        avaTaxPath.addQuery("line2", string2);
        avaTaxPath.addQuery("line3", string3);
        avaTaxPath.addQuery("city", string4);
        avaTaxPath.addQuery("region", string5);
        avaTaxPath.addQuery("postalCode", string6);
        avaTaxPath.addQuery("country", string7);
        avaTaxPath.addQuery("$filter", string8);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string9);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<JurisdictionOverrideModel>>(){}, "24.8.2"));
    }

    public FetchResult<JurisdictionRateTypeTaxTypeMappingModel> listJurisdictionsByRateTypeTaxTypeMapping(String string, String string2, String string3, Integer n, String string4, String string5, Integer n2, Integer n3, String string6) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/jurisdictions/countries/{country}/taxtypes/{taxTypeId}/taxsubtypes/{taxSubTypeId}");
        avaTaxPath.applyField("country", string);
        avaTaxPath.applyField("taxTypeId", string2);
        avaTaxPath.applyField("taxSubTypeId", string3);
        avaTaxPath.addQuery("rateTypeId", n);
        avaTaxPath.addQuery("region", string4);
        avaTaxPath.addQuery("$filter", string5);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string6);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<JurisdictionRateTypeTaxTypeMappingModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<JurisdictionRateTypeTaxTypeMappingModel>> listJurisdictionsByRateTypeTaxTypeMappingAsync(String string, String string2, String string3, Integer n, String string4, String string5, Integer n2, Integer n3, String string6) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/jurisdictions/countries/{country}/taxtypes/{taxTypeId}/taxsubtypes/{taxSubTypeId}");
        avaTaxPath.applyField("country", string);
        avaTaxPath.applyField("taxTypeId", string2);
        avaTaxPath.applyField("taxSubTypeId", string3);
        avaTaxPath.addQuery("rateTypeId", n);
        avaTaxPath.addQuery("region", string4);
        avaTaxPath.addQuery("$filter", string5);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string6);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<JurisdictionRateTypeTaxTypeMappingModel>>(){}, "24.8.2"));
    }

    public FetchResult<JurisdictionHierarchyModel> listJurisdictionsHierarchy(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/jurisdictions/hierarchy");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<JurisdictionHierarchyModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<JurisdictionHierarchyModel>> listJurisdictionsHierarchyAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/jurisdictions/hierarchy");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<JurisdictionHierarchyModel>>(){}, "24.8.2"));
    }

    public ArrayList<String> listJurisdictionTypesByRateTypeTaxTypeMapping(String string, String string2, String string3, String string4) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/jurisdictionTypes/countries/{country}/taxtypes/{taxTypeId}/taxsubtypes/{taxSubTypeId}");
        avaTaxPath.applyField("country", string);
        avaTaxPath.applyField("taxTypeId", string2);
        avaTaxPath.applyField("taxSubTypeId", string3);
        avaTaxPath.addQuery("rateTypeId", string4);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ArrayList<String>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<String>> listJurisdictionTypesByRateTypeTaxTypeMappingAsync(String string, String string2, String string3, String string4) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/jurisdictionTypes/countries/{country}/taxtypes/{taxTypeId}/taxsubtypes/{taxSubTypeId}");
        avaTaxPath.applyField("country", string);
        avaTaxPath.applyField("taxTypeId", string2);
        avaTaxPath.applyField("taxSubTypeId", string3);
        avaTaxPath.addQuery("rateTypeId", string4);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ArrayList<String>>(){}, "24.8.2"));
    }

    public FetchResult<LocationQuestionModel> listLocationQuestionsByAddress(String string, String string2, String string3, String string4, String string5, String string6, String string7, BigDecimal bigDecimal, BigDecimal bigDecimal2, String string8, Integer n, Integer n2, String string9) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/locationquestions");
        avaTaxPath.addQuery("line1", string);
        avaTaxPath.addQuery("line2", string2);
        avaTaxPath.addQuery("line3", string3);
        avaTaxPath.addQuery("city", string4);
        avaTaxPath.addQuery("region", string5);
        avaTaxPath.addQuery("postalCode", string6);
        avaTaxPath.addQuery("country", string7);
        avaTaxPath.addQuery("latitude", bigDecimal);
        avaTaxPath.addQuery("longitude", bigDecimal2);
        avaTaxPath.addQuery("$filter", string8);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string9);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<LocationQuestionModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<LocationQuestionModel>> listLocationQuestionsByAddressAsync(String string, String string2, String string3, String string4, String string5, String string6, String string7, BigDecimal bigDecimal, BigDecimal bigDecimal2, String string8, Integer n, Integer n2, String string9) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/locationquestions");
        avaTaxPath.addQuery("line1", string);
        avaTaxPath.addQuery("line2", string2);
        avaTaxPath.addQuery("line3", string3);
        avaTaxPath.addQuery("city", string4);
        avaTaxPath.addQuery("region", string5);
        avaTaxPath.addQuery("postalCode", string6);
        avaTaxPath.addQuery("country", string7);
        avaTaxPath.addQuery("latitude", bigDecimal);
        avaTaxPath.addQuery("longitude", bigDecimal2);
        avaTaxPath.addQuery("$filter", string8);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string9);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<LocationQuestionModel>>(){}, "24.8.2"));
    }

    public FetchResult<SkyscraperStatusModel> listLoginVerifiers(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/filingcalendars/loginverifiers");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SkyscraperStatusModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<SkyscraperStatusModel>> listLoginVerifiersAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/filingcalendars/loginverifiers");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SkyscraperStatusModel>>(){}, "24.8.2"));
    }

    public FetchResult<MarketplaceLocationModel> listMarketplaceLocations(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/marketplacelocations");
        avaTaxPath.addQuery("marketplaceId", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<MarketplaceLocationModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<MarketplaceLocationModel>> listMarketplaceLocationsAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/marketplacelocations");
        avaTaxPath.addQuery("marketplaceId", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<MarketplaceLocationModel>>(){}, "24.8.2"));
    }

    public FetchResult<NexusModel> listNexus(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/nexus");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NexusModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<NexusModel>> listNexusAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/nexus");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NexusModel>>(){}, "24.8.2"));
    }

    public FetchResult<NexusModel> listNexusByAddress(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, Integer n, Integer n2, String string9) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/nexus/byaddress");
        avaTaxPath.addQuery("line1", string);
        avaTaxPath.addQuery("line2", string2);
        avaTaxPath.addQuery("line3", string3);
        avaTaxPath.addQuery("city", string4);
        avaTaxPath.addQuery("region", string5);
        avaTaxPath.addQuery("postalCode", string6);
        avaTaxPath.addQuery("country", string7);
        avaTaxPath.addQuery("$filter", string8);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string9);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NexusModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<NexusModel>> listNexusByAddressAsync(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, Integer n, Integer n2, String string9) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/nexus/byaddress");
        avaTaxPath.addQuery("line1", string);
        avaTaxPath.addQuery("line2", string2);
        avaTaxPath.addQuery("line3", string3);
        avaTaxPath.addQuery("city", string4);
        avaTaxPath.addQuery("region", string5);
        avaTaxPath.addQuery("postalCode", string6);
        avaTaxPath.addQuery("country", string7);
        avaTaxPath.addQuery("$filter", string8);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string9);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NexusModel>>(){}, "24.8.2"));
    }

    public FetchResult<NexusModel> listNexusByCountry(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/nexus/{country}");
        avaTaxPath.applyField("country", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NexusModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<NexusModel>> listNexusByCountryAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/nexus/{country}");
        avaTaxPath.applyField("country", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NexusModel>>(){}, "24.8.2"));
    }

    public FetchResult<NexusModel> listNexusByCountryAndRegion(String string, String string2, String string3, Integer n, Integer n2, String string4) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/nexus/{country}/{region}");
        avaTaxPath.applyField("country", string);
        avaTaxPath.applyField("region", string2);
        avaTaxPath.addQuery("$filter", string3);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string4);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NexusModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<NexusModel>> listNexusByCountryAndRegionAsync(String string, String string2, String string3, Integer n, Integer n2, String string4) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/nexus/{country}/{region}");
        avaTaxPath.applyField("country", string);
        avaTaxPath.applyField("region", string2);
        avaTaxPath.addQuery("$filter", string3);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string4);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NexusModel>>(){}, "24.8.2"));
    }

    public NexusByTaxFormModel listNexusByFormCode(String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/nexus/byform/{formCode}");
        avaTaxPath.applyField("formCode", string);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<NexusByTaxFormModel>(){}, "24.8.2").call();
    }

    public Future<NexusByTaxFormModel> listNexusByFormCodeAsync(String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/nexus/byform/{formCode}");
        avaTaxPath.applyField("formCode", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<NexusByTaxFormModel>(){}, "24.8.2"));
    }

    public FetchResult<NexusModel> listNexusByTaxTypeGroup(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/nexus/bytaxtypegroup/{taxTypeGroup}");
        avaTaxPath.applyField("taxTypeGroup", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NexusModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<NexusModel>> listNexusByTaxTypeGroupAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/nexus/bytaxtypegroup/{taxTypeGroup}");
        avaTaxPath.applyField("taxTypeGroup", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NexusModel>>(){}, "24.8.2"));
    }

    public FetchResult<NexusTaxTypeGroupModel> listNexusTaxTypeGroups(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/nexustaxtypegroups");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NexusTaxTypeGroupModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<NexusTaxTypeGroupModel>> listNexusTaxTypeGroupsAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/nexustaxtypegroups");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NexusTaxTypeGroupModel>>(){}, "24.8.2"));
    }

    public FetchResult<NoticeCustomerFundingOptionModel> listNoticeCustomerFundingOptions(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticecustomerfundingoptions");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeCustomerFundingOptionModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<NoticeCustomerFundingOptionModel>> listNoticeCustomerFundingOptionsAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticecustomerfundingoptions");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeCustomerFundingOptionModel>>(){}, "24.8.2"));
    }

    public FetchResult<NoticeCustomerTypeModel> listNoticeCustomerTypes(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticecustomertypes");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeCustomerTypeModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<NoticeCustomerTypeModel>> listNoticeCustomerTypesAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticecustomertypes");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeCustomerTypeModel>>(){}, "24.8.2"));
    }

    public FetchResult<NoticeFilingTypeModel> listNoticeFilingtypes(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticefilingtypes");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeFilingTypeModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<NoticeFilingTypeModel>> listNoticeFilingtypesAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticefilingtypes");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeFilingTypeModel>>(){}, "24.8.2"));
    }

    public FetchResult<NoticePriorityModel> listNoticePriorities(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticepriorities");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticePriorityModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<NoticePriorityModel>> listNoticePrioritiesAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticepriorities");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticePriorityModel>>(){}, "24.8.2"));
    }

    public FetchResult<NoticeReasonModel> listNoticeReasons(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticereasons");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeReasonModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<NoticeReasonModel>> listNoticeReasonsAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticereasons");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeReasonModel>>(){}, "24.8.2"));
    }

    public FetchResult<NoticeResponsibilityModel> listNoticeResponsibilities(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticeresponsibilities");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeResponsibilityModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<NoticeResponsibilityModel>> listNoticeResponsibilitiesAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticeresponsibilities");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeResponsibilityModel>>(){}, "24.8.2"));
    }

    public FetchResult<NoticeRootCauseModel> listNoticeRootCauses(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticerootcauses");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeRootCauseModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<NoticeRootCauseModel>> listNoticeRootCausesAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticerootcauses");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeRootCauseModel>>(){}, "24.8.2"));
    }

    public FetchResult<NoticeStatusModel> listNoticeStatuses(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticestatuses");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeStatusModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<NoticeStatusModel>> listNoticeStatusesAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticestatuses");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeStatusModel>>(){}, "24.8.2"));
    }

    public FetchResult<NoticeTypeModel> listNoticeTypes(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticetypes");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeTypeModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<NoticeTypeModel>> listNoticeTypesAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/noticetypes");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NoticeTypeModel>>(){}, "24.8.2"));
    }

    public FetchResult<ParameterModel> listParameters(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/parameters");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ParameterModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<ParameterModel>> listParametersAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/parameters");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ParameterModel>>(){}, "24.8.2"));
    }

    public FetchResult<ParameterModel> listParametersByAccount(Integer n, String string, Integer n2, Integer n3, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/accounts/{accountId}/parameters");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ParameterModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<ParameterModel>> listParametersByAccountAsync(Integer n, String string, Integer n2, Integer n3, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/accounts/{accountId}/parameters");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ParameterModel>>(){}, "24.8.2"));
    }

    public FetchResult<ParameterModel> listParametersByItem(String string, String string2, String string3, Integer n, Integer n2, String string4) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/parameters/byitem/{companyCode}/{itemCode}");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("itemCode", string2);
        avaTaxPath.addQuery("$filter", string3);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string4);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ParameterModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<ParameterModel>> listParametersByItemAsync(String string, String string2, String string3, Integer n, Integer n2, String string4) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/parameters/byitem/{companyCode}/{itemCode}");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("itemCode", string2);
        avaTaxPath.addQuery("$filter", string3);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string4);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ParameterModel>>(){}, "24.8.2"));
    }

    public FetchResult<ParameterUsageModel> listParametersUsage(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/parametersusage");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ParameterUsageModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<ParameterUsageModel>> listParametersUsageAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/parametersusage");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ParameterUsageModel>>(){}, "24.8.2"));
    }

    public FetchResult<String> listPermissions(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/permissions");
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<String>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<String>> listPermissionsAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/permissions");
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<String>>(){}, "24.8.2"));
    }

    public FetchResult<PostalCodeModel> listPostalCodes(String string, Integer n, Integer n2, String string2, Boolean bl) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/postalcodes");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        avaTaxPath.addQuery("includeExpiredPostalCodes", bl);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<PostalCodeModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<PostalCodeModel>> listPostalCodesAsync(String string, Integer n, Integer n2, String string2, Boolean bl) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/postalcodes");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        avaTaxPath.addQuery("includeExpiredPostalCodes", bl);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<PostalCodeModel>>(){}, "24.8.2"));
    }

    public FetchResult<PreferredProgramModel> listPreferredPrograms(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/preferredprograms");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<PreferredProgramModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<PreferredProgramModel>> listPreferredProgramsAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/preferredprograms");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<PreferredProgramModel>>(){}, "24.8.2"));
    }

    public FetchResult<ProductClassificationSystemModel> listProductClassificationSystems(String string, Integer n, Integer n2, String string2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/productclassificationsystems");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        avaTaxPath.addQuery("$countryCode", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ProductClassificationSystemModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<ProductClassificationSystemModel>> listProductClassificationSystemsAsync(String string, Integer n, Integer n2, String string2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/productclassificationsystems");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        avaTaxPath.addQuery("$countryCode", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ProductClassificationSystemModel>>(){}, "24.8.2"));
    }

    public FetchResult<ProductClassificationSystemModel> listProductClassificationSystemsByCompany(String string, String string2, Integer n, Integer n2, String string3, String string4) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/productclassificationsystems/bycompany/{companyCode}");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        avaTaxPath.addQuery("$countryCode", string4);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ProductClassificationSystemModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<ProductClassificationSystemModel>> listProductClassificationSystemsByCompanyAsync(String string, String string2, Integer n, Integer n2, String string3, String string4) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/productclassificationsystems/bycompany/{companyCode}");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        avaTaxPath.addQuery("$countryCode", string4);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ProductClassificationSystemModel>>(){}, "24.8.2"));
    }

    public FetchResult<RateTypeModel> listRateTypesByCountry(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/countries/{country}/ratetypes");
        avaTaxPath.applyField("country", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<RateTypeModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<RateTypeModel>> listRateTypesByCountryAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/countries/{country}/ratetypes");
        avaTaxPath.applyField("country", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<RateTypeModel>>(){}, "24.8.2"));
    }

    public FetchResult<RateTypesModel> listRateTypesByCountryTaxTypeTaxSubType(String string, String string2, String string3, String string4, Integer n, Integer n2, String string5) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/countries/{country}/taxtypes/{taxTypeId}/taxsubtypes/{taxSubTypeId}/ratetypes");
        avaTaxPath.applyField("country", string);
        avaTaxPath.applyField("taxTypeId", string2);
        avaTaxPath.applyField("taxSubTypeId", string3);
        avaTaxPath.addQuery("$filter", string4);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string5);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<RateTypesModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<RateTypesModel>> listRateTypesByCountryTaxTypeTaxSubTypeAsync(String string, String string2, String string3, String string4, Integer n, Integer n2, String string5) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/countries/{country}/taxtypes/{taxTypeId}/taxsubtypes/{taxSubTypeId}/ratetypes");
        avaTaxPath.applyField("country", string);
        avaTaxPath.applyField("taxTypeId", string2);
        avaTaxPath.applyField("taxSubTypeId", string3);
        avaTaxPath.addQuery("$filter", string4);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string5);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<RateTypesModel>>(){}, "24.8.2"));
    }

    public FetchResult<IsoRegionModel> listRegions(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/regions");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<IsoRegionModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<IsoRegionModel>> listRegionsAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/regions");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<IsoRegionModel>>(){}, "24.8.2"));
    }

    public FetchResult<IsoRegionModel> listRegionsByCountry(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/countries/{country}/regions");
        avaTaxPath.applyField("country", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<IsoRegionModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<IsoRegionModel>> listRegionsByCountryAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/countries/{country}/regions");
        avaTaxPath.applyField("country", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<IsoRegionModel>>(){}, "24.8.2"));
    }

    public FetchResult<IsoRegionModel> listRegionsByCountryAndTaxTypeAndTaxSubTypeAndRateType(Integer n, String string, String string2, String string3, Integer n2, String string4, Integer n3, Integer n4, String string5) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/companies/{companyId}/countries/{country}/regions/taxtypes/{taxTypeId}/taxsubtypes/{taxSubTypeId}/rateTypeId/{rateTypeId}/jurisdictionTypeId/{jurisdictionTypeId}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("country", string);
        avaTaxPath.applyField("taxTypeId", string2);
        avaTaxPath.applyField("taxSubTypeId", string3);
        avaTaxPath.applyField("rateTypeId", n2);
        avaTaxPath.applyField("jurisdictionTypeId", string4);
        avaTaxPath.addQuery("$top", n3);
        avaTaxPath.addQuery("$skip", n4);
        avaTaxPath.addQuery("$orderBy", string5);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<IsoRegionModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<IsoRegionModel>> listRegionsByCountryAndTaxTypeAndTaxSubTypeAndRateTypeAsync(Integer n, String string, String string2, String string3, Integer n2, String string4, Integer n3, Integer n4, String string5) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/companies/{companyId}/countries/{country}/regions/taxtypes/{taxTypeId}/taxsubtypes/{taxSubTypeId}/rateTypeId/{rateTypeId}/jurisdictionTypeId/{jurisdictionTypeId}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("country", string);
        avaTaxPath.applyField("taxTypeId", string2);
        avaTaxPath.applyField("taxSubTypeId", string3);
        avaTaxPath.applyField("rateTypeId", n2);
        avaTaxPath.applyField("jurisdictionTypeId", string4);
        avaTaxPath.addQuery("$top", n3);
        avaTaxPath.addQuery("$skip", n4);
        avaTaxPath.addQuery("$orderBy", string5);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<IsoRegionModel>>(){}, "24.8.2"));
    }

    public FetchResult<ReturnsParameterUsageModel> listReturnsParametersUsage(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/returns/parametersusage");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ReturnsParameterUsageModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<ReturnsParameterUsageModel>> listReturnsParametersUsageAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/returns/parametersusage");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ReturnsParameterUsageModel>>(){}, "24.8.2"));
    }

    public FetchResult<SecurityRoleModel> listSecurityRoles(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/securityroles");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SecurityRoleModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<SecurityRoleModel>> listSecurityRolesAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/securityroles");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SecurityRoleModel>>(){}, "24.8.2"));
    }

    public FetchResult<SubscriptionTypeModel> listSubscriptionTypes(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/subscriptiontypes");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SubscriptionTypeModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<SubscriptionTypeModel>> listSubscriptionTypesAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/subscriptiontypes");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SubscriptionTypeModel>>(){}, "24.8.2"));
    }

    public FetchResult<TagsModel> listTags(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/tags");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TagsModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<TagsModel>> listTagsAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/tags");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TagsModel>>(){}, "24.8.2"));
    }

    public FetchResult<TaxAuthorityModel> listTaxAuthorities(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/taxauthorities");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxAuthorityModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<TaxAuthorityModel>> listTaxAuthoritiesAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/taxauthorities");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxAuthorityModel>>(){}, "24.8.2"));
    }

    public FetchResult<TaxAuthorityFormModel> listTaxAuthorityForms(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/taxauthorityforms");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxAuthorityFormModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<TaxAuthorityFormModel>> listTaxAuthorityFormsAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/taxauthorityforms");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxAuthorityFormModel>>(){}, "24.8.2"));
    }

    public FetchResult<TaxAuthorityTypeModel> listTaxAuthorityTypes(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/taxauthoritytypes");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxAuthorityTypeModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<TaxAuthorityTypeModel>> listTaxAuthorityTypesAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/taxauthoritytypes");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxAuthorityTypeModel>>(){}, "24.8.2"));
    }

    public FetchResult<TaxCodeModel> listTaxCodes(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/taxcodes");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxCodeModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<TaxCodeModel>> listTaxCodesAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/taxcodes");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxCodeModel>>(){}, "24.8.2"));
    }

    public TaxCodeTypesModel listTaxCodeTypes(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/taxcodetypes");
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<TaxCodeTypesModel>(){}, "24.8.2").call();
    }

    public Future<TaxCodeTypesModel> listTaxCodeTypesAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/taxcodetypes");
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<TaxCodeTypesModel>(){}, "24.8.2"));
    }

    public FetchResult<FormMasterModel> listTaxForms(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/taxforms");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<FormMasterModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<FormMasterModel>> listTaxFormsAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/taxforms");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<FormMasterModel>>(){}, "24.8.2"));
    }

    public FetchResult<TaxSubTypeModel> listTaxSubTypes(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/taxsubtypes");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxSubTypeModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<TaxSubTypeModel>> listTaxSubTypesAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/taxsubtypes");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxSubTypeModel>>(){}, "24.8.2"));
    }

    public FetchResult<TaxSubTypeModel> listTaxSubTypesByCountryAndTaxType(String string, String string2, Integer n, String string3, Integer n2, Integer n3, String string4) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/taxsubtypes/countries/{country}/taxtypes/{taxTypeId}");
        avaTaxPath.applyField("country", string);
        avaTaxPath.applyField("taxTypeId", string2);
        avaTaxPath.addQuery("companyId", n);
        avaTaxPath.addQuery("$filter", string3);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string4);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxSubTypeModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<TaxSubTypeModel>> listTaxSubTypesByCountryAndTaxTypeAsync(String string, String string2, Integer n, String string3, Integer n2, Integer n3, String string4) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/taxsubtypes/countries/{country}/taxtypes/{taxTypeId}");
        avaTaxPath.applyField("country", string);
        avaTaxPath.applyField("taxTypeId", string2);
        avaTaxPath.addQuery("companyId", n);
        avaTaxPath.addQuery("$filter", string3);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string4);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxSubTypeModel>>(){}, "24.8.2"));
    }

    public FetchResult<TaxSubTypeModel> listTaxSubTypesByJurisdictionAndRegion(String string, String string2, String string3, Integer n, Integer n2, String string4) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/taxsubtypes/{jurisdictionCode}/{region}");
        avaTaxPath.applyField("jurisdictionCode", string);
        avaTaxPath.applyField("region", string2);
        avaTaxPath.addQuery("$filter", string3);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string4);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxSubTypeModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<TaxSubTypeModel>> listTaxSubTypesByJurisdictionAndRegionAsync(String string, String string2, String string3, Integer n, Integer n2, String string4) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/taxsubtypes/{jurisdictionCode}/{region}");
        avaTaxPath.applyField("jurisdictionCode", string);
        avaTaxPath.applyField("region", string2);
        avaTaxPath.addQuery("$filter", string3);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string4);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxSubTypeModel>>(){}, "24.8.2"));
    }

    public FetchResult<TaxTypeGroupModel> listTaxTypeGroups(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/taxtypegroups");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxTypeGroupModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<TaxTypeGroupModel>> listTaxTypeGroupsAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/taxtypegroups");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxTypeGroupModel>>(){}, "24.8.2"));
    }

    public FetchResult<TaxTypeModel> listTaxTypesByNexusAndCountry(String string, Integer n, Integer n2, Integer n3, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/taxtypes/countries/{country}");
        avaTaxPath.applyField("country", string);
        avaTaxPath.addQuery("companyId", n);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxTypeModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<TaxTypeModel>> listTaxTypesByNexusAndCountryAsync(String string, Integer n, Integer n2, Integer n3, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/taxtypes/countries/{country}");
        avaTaxPath.applyField("country", string);
        avaTaxPath.addQuery("companyId", n);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxTypeModel>>(){}, "24.8.2"));
    }

    public FetchResult<UnitOfBasisModel> listUnitOfBasisByCountryAndTaxTypeAndTaxSubTypeAndRateType(String string, String string2, String string3, String string4, Integer n, Integer n2, String string5) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/unitofbasis/countries/{country}/taxtypes/{taxTypeId}/taxsubtypes/{taxSubTypeId}");
        avaTaxPath.applyField("country", string);
        avaTaxPath.applyField("taxTypeId", string2);
        avaTaxPath.applyField("taxSubTypeId", string3);
        avaTaxPath.addQuery("rateTypeId", string4);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string5);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<UnitOfBasisModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<UnitOfBasisModel>> listUnitOfBasisByCountryAndTaxTypeAndTaxSubTypeAndRateTypeAsync(String string, String string2, String string3, String string4, Integer n, Integer n2, String string5) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/unitofbasis/countries/{country}/taxtypes/{taxTypeId}/taxsubtypes/{taxSubTypeId}");
        avaTaxPath.applyField("country", string);
        avaTaxPath.applyField("taxTypeId", string2);
        avaTaxPath.applyField("taxSubTypeId", string3);
        avaTaxPath.addQuery("rateTypeId", string4);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string5);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<UnitOfBasisModel>>(){}, "24.8.2"));
    }

    public FetchResult<UomModel> listUnitOfMeasurement(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/unitofmeasurements");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<UomModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<UomModel>> listUnitOfMeasurementAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/unitofmeasurements");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<UomModel>>(){}, "24.8.2"));
    }

    public ArrayList<CompanyDistanceThresholdModel> createDistanceThreshold(Integer n, ArrayList<CompanyDistanceThresholdModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/distancethresholds");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<CompanyDistanceThresholdModel>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<CompanyDistanceThresholdModel>> createDistanceThresholdAsync(Integer n, ArrayList<CompanyDistanceThresholdModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/distancethresholds");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<CompanyDistanceThresholdModel>>(){}, "24.8.2"));
    }

    public ArrayList<ErrorDetail> deleteDistanceThreshold(Integer n, Long l) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/distancethresholds/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", l);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<ErrorDetail>> deleteDistanceThresholdAsync(Integer n, Long l) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/distancethresholds/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2"));
    }

    public CompanyDistanceThresholdModel getDistanceThreshold(Integer n, Long l) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/distancethresholds/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", l);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<CompanyDistanceThresholdModel>(){}, "24.8.2").call();
    }

    public Future<CompanyDistanceThresholdModel> getDistanceThresholdAsync(Integer n, Long l) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/distancethresholds/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<CompanyDistanceThresholdModel>(){}, "24.8.2"));
    }

    public FetchResult<CompanyDistanceThresholdModel> listDistanceThresholds(Integer n, String string, String string2, Integer n2, Integer n3, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/distancethresholds");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CompanyDistanceThresholdModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<CompanyDistanceThresholdModel>> listDistanceThresholdsAsync(Integer n, String string, String string2, Integer n2, Integer n3, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/distancethresholds");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CompanyDistanceThresholdModel>>(){}, "24.8.2"));
    }

    public FetchResult<CompanyDistanceThresholdModel> queryDistanceThresholds(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/distancethresholds");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CompanyDistanceThresholdModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<CompanyDistanceThresholdModel>> queryDistanceThresholdsAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/distancethresholds");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CompanyDistanceThresholdModel>>(){}, "24.8.2"));
    }

    public CompanyDistanceThresholdModel updateDistanceThreshold(Integer n, Long l, CompanyDistanceThresholdModel companyDistanceThresholdModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/distancethresholds/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", l);
        return this.restCallFactory.createRestCall("put", avaTaxPath, companyDistanceThresholdModel, new TypeToken<CompanyDistanceThresholdModel>(){}, "24.8.2").call();
    }

    public Future<CompanyDistanceThresholdModel> updateDistanceThresholdAsync(Integer n, Long l, CompanyDistanceThresholdModel companyDistanceThresholdModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/distancethresholds/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, companyDistanceThresholdModel, new TypeToken<CompanyDistanceThresholdModel>(){}, "24.8.2"));
    }

    public DcvCreationResponse createDcv(DomainNameViewModel domainNameViewModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/domain-control-verifications");
        return this.restCallFactory.createRestCall("post", avaTaxPath, domainNameViewModel, new TypeToken<DcvCreationResponse>(){}, "24.8.2").call();
    }

    public Future<DcvCreationResponse> createDcvAsync(DomainNameViewModel domainNameViewModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/domain-control-verifications");
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, domainNameViewModel, new TypeToken<DcvCreationResponse>(){}, "24.8.2"));
    }

    public ArrayList<DcvViewModel> filterDcv(String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/domain-control-verifications");
        avaTaxPath.addQuery("$filter", string);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ArrayList<DcvViewModel>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<DcvViewModel>> filterDcvAsync(String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/domain-control-verifications");
        avaTaxPath.addQuery("$filter", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ArrayList<DcvViewModel>>(){}, "24.8.2"));
    }

    public DcvViewModel getDcvById(String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/domain-control-verifications/{domainControlVerificationId}");
        avaTaxPath.applyField("domainControlVerificationId", string);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<DcvViewModel>(){}, "24.8.2").call();
    }

    public Future<DcvViewModel> getDcvByIdAsync(String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/domain-control-verifications/{domainControlVerificationId}");
        avaTaxPath.applyField("domainControlVerificationId", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<DcvViewModel>(){}, "24.8.2"));
    }

    public FetchResult<EventMessageResponse> deleteAfcEventNotifications(Boolean bl, EventDeleteMessageModel eventDeleteMessageModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/event-notifications/afc");
        avaTaxPath.addQuery("isDlq", bl);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, eventDeleteMessageModel, new TypeToken<FetchResult<EventMessageResponse>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<EventMessageResponse>> deleteAfcEventNotificationsAsync(Boolean bl, EventDeleteMessageModel eventDeleteMessageModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/event-notifications/afc");
        avaTaxPath.addQuery("isDlq", bl);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, eventDeleteMessageModel, new TypeToken<FetchResult<EventMessageResponse>>(){}, "24.8.2"));
    }

    public FetchResult<EventMessageResponse> deleteEventNotifications(Integer n, EventDeleteMessageModel eventDeleteMessageModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/event-notifications/companies/{companyId}");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, eventDeleteMessageModel, new TypeToken<FetchResult<EventMessageResponse>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<EventMessageResponse>> deleteEventNotificationsAsync(Integer n, EventDeleteMessageModel eventDeleteMessageModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/event-notifications/companies/{companyId}");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, eventDeleteMessageModel, new TypeToken<FetchResult<EventMessageResponse>>(){}, "24.8.2"));
    }

    public FetchResult<EventMessageResponse> getEventNotifications(Integer n) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/event-notifications/companies/{companyId}");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<EventMessageResponse>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<EventMessageResponse>> getEventNotificationsAsync(Integer n) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/event-notifications/companies/{companyId}");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<EventMessageResponse>>(){}, "24.8.2"));
    }

    public FetchResult<EventMessageResponse> listAfcEventNotifications(Boolean bl) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/event-notifications/afc");
        avaTaxPath.addQuery("isDlq", bl);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<EventMessageResponse>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<EventMessageResponse>> listAfcEventNotificationsAsync(Boolean bl) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/event-notifications/afc");
        avaTaxPath.addQuery("isDlq", bl);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<EventMessageResponse>>(){}, "24.8.2"));
    }

    public ECommerceTokenOutputModel createECommerceToken(Integer n, CreateECommerceTokenInputModel createECommerceTokenInputModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/ecommercetokens");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, createECommerceTokenInputModel, new TypeToken<ECommerceTokenOutputModel>(){}, "24.8.2").call();
    }

    public Future<ECommerceTokenOutputModel> createECommerceTokenAsync(Integer n, CreateECommerceTokenInputModel createECommerceTokenInputModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/ecommercetokens");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, createECommerceTokenInputModel, new TypeToken<ECommerceTokenOutputModel>(){}, "24.8.2"));
    }

    public FetchResult<ECommerceTokenOutputModel> refreshECommerceToken(Integer n, RefreshECommerceTokenInputModel refreshECommerceTokenInputModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/ecommercetokens");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("put", avaTaxPath, refreshECommerceTokenInputModel, new TypeToken<FetchResult<ECommerceTokenOutputModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<ECommerceTokenOutputModel>> refreshECommerceTokenAsync(Integer n, RefreshECommerceTokenInputModel refreshECommerceTokenInputModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/ecommercetokens");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, refreshECommerceTokenInputModel, new TypeToken<FetchResult<ECommerceTokenOutputModel>>(){}, "24.8.2"));
    }

    public FirmClientLinkageOutputModel approveFirmClientLinkage(Integer n) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/firmclientlinkages/{id}/approve");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, null, new TypeToken<FirmClientLinkageOutputModel>(){}, "24.8.2").call();
    }

    public Future<FirmClientLinkageOutputModel> approveFirmClientLinkageAsync(Integer n) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/firmclientlinkages/{id}/approve");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, null, new TypeToken<FirmClientLinkageOutputModel>(){}, "24.8.2"));
    }

    public FirmClientLinkageOutputModel createAndLinkNewFirmClientAccount(NewFirmClientAccountRequestModel newFirmClientAccountRequestModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/firmclientlinkages/createandlinkclient");
        return this.restCallFactory.createRestCall("post", avaTaxPath, newFirmClientAccountRequestModel, new TypeToken<FirmClientLinkageOutputModel>(){}, "24.8.2").call();
    }

    public Future<FirmClientLinkageOutputModel> createAndLinkNewFirmClientAccountAsync(NewFirmClientAccountRequestModel newFirmClientAccountRequestModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/firmclientlinkages/createandlinkclient");
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, newFirmClientAccountRequestModel, new TypeToken<FirmClientLinkageOutputModel>(){}, "24.8.2"));
    }

    public FirmClientLinkageOutputModel createFirmClientLinkage(FirmClientLinkageInputModel firmClientLinkageInputModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/firmclientlinkages");
        return this.restCallFactory.createRestCall("post", avaTaxPath, firmClientLinkageInputModel, new TypeToken<FirmClientLinkageOutputModel>(){}, "24.8.2").call();
    }

    public Future<FirmClientLinkageOutputModel> createFirmClientLinkageAsync(FirmClientLinkageInputModel firmClientLinkageInputModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/firmclientlinkages");
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, firmClientLinkageInputModel, new TypeToken<FirmClientLinkageOutputModel>(){}, "24.8.2"));
    }

    public ArrayList<ErrorDetail> deleteFirmClientLinkage(Integer n) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/firmclientlinkages/{id}");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<ErrorDetail>> deleteFirmClientLinkageAsync(Integer n) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/firmclientlinkages/{id}");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2"));
    }

    public FirmClientLinkageOutputModel getFirmClientLinkage(Integer n) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/firmclientlinkages/{id}");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FirmClientLinkageOutputModel>(){}, "24.8.2").call();
    }

    public Future<FirmClientLinkageOutputModel> getFirmClientLinkageAsync(Integer n) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/firmclientlinkages/{id}");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FirmClientLinkageOutputModel>(){}, "24.8.2"));
    }

    public FetchResult<FirmClientLinkageOutputModel> listFirmClientLinkage(String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/firmclientlinkages");
        avaTaxPath.addQuery("$filter", string);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<FirmClientLinkageOutputModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<FirmClientLinkageOutputModel>> listFirmClientLinkageAsync(String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/firmclientlinkages");
        avaTaxPath.addQuery("$filter", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<FirmClientLinkageOutputModel>>(){}, "24.8.2"));
    }

    public FirmClientLinkageOutputModel rejectFirmClientLinkage(Integer n) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/firmclientlinkages/{id}/reject");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, null, new TypeToken<FirmClientLinkageOutputModel>(){}, "24.8.2").call();
    }

    public Future<FirmClientLinkageOutputModel> rejectFirmClientLinkageAsync(Integer n) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/firmclientlinkages/{id}/reject");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, null, new TypeToken<FirmClientLinkageOutputModel>(){}, "24.8.2"));
    }

    public FirmClientLinkageOutputModel resetFirmClientLinkage(Integer n) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/firmclientlinkages/{id}/reset");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, null, new TypeToken<FirmClientLinkageOutputModel>(){}, "24.8.2").call();
    }

    public Future<FirmClientLinkageOutputModel> resetFirmClientLinkageAsync(Integer n) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/firmclientlinkages/{id}/reset");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, null, new TypeToken<FirmClientLinkageOutputModel>(){}, "24.8.2"));
    }

    public FirmClientLinkageOutputModel revokeFirmClientLinkage(Integer n) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/firmclientlinkages/{id}/revoke");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, null, new TypeToken<FirmClientLinkageOutputModel>(){}, "24.8.2").call();
    }

    public Future<FirmClientLinkageOutputModel> revokeFirmClientLinkageAsync(Integer n) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/firmclientlinkages/{id}/revoke");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, null, new TypeToken<FirmClientLinkageOutputModel>(){}, "24.8.2"));
    }

    public FundingStatusModel activateFundingRequest(Integer n, POABusinessUnit pOABusinessUnit, POASubscriptionType pOASubscriptionType) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/fundingrequests/{id}/widget");
        avaTaxPath.applyField("id", n);
        avaTaxPath.addQuery("businessUnit", (Object)pOABusinessUnit);
        avaTaxPath.addQuery("subscriptionType", (Object)pOASubscriptionType);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FundingStatusModel>(){}, "24.8.2").call();
    }

    public Future<FundingStatusModel> activateFundingRequestAsync(Integer n, POABusinessUnit pOABusinessUnit, POASubscriptionType pOASubscriptionType) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/fundingrequests/{id}/widget");
        avaTaxPath.applyField("id", n);
        avaTaxPath.addQuery("businessUnit", (Object)pOABusinessUnit);
        avaTaxPath.addQuery("subscriptionType", (Object)pOASubscriptionType);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FundingStatusModel>(){}, "24.8.2"));
    }

    public FundingStatusModel fundingRequestStatus(Integer n, POABusinessUnit pOABusinessUnit, POASubscriptionType pOASubscriptionType) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/fundingrequests/{id}");
        avaTaxPath.applyField("id", n);
        avaTaxPath.addQuery("businessUnit", (Object)pOABusinessUnit);
        avaTaxPath.addQuery("subscriptionType", (Object)pOASubscriptionType);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FundingStatusModel>(){}, "24.8.2").call();
    }

    public Future<FundingStatusModel> fundingRequestStatusAsync(Integer n, POABusinessUnit pOABusinessUnit, POASubscriptionType pOASubscriptionType) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/fundingrequests/{id}");
        avaTaxPath.applyField("id", n);
        avaTaxPath.addQuery("businessUnit", (Object)pOABusinessUnit);
        avaTaxPath.addQuery("subscriptionType", (Object)pOASubscriptionType);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FundingStatusModel>(){}, "24.8.2"));
    }

    public GLAccountBulkUploadOutputModel bulkUploadGLAccounts(Integer n, GLAccountBulkUploadInputModel gLAccountBulkUploadInputModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyid}/glaccounts/$upload");
        avaTaxPath.applyField("companyid", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, gLAccountBulkUploadInputModel, new TypeToken<GLAccountBulkUploadOutputModel>(){}, "24.8.2").call();
    }

    public Future<GLAccountBulkUploadOutputModel> bulkUploadGLAccountsAsync(Integer n, GLAccountBulkUploadInputModel gLAccountBulkUploadInputModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyid}/glaccounts/$upload");
        avaTaxPath.applyField("companyid", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, gLAccountBulkUploadInputModel, new TypeToken<GLAccountBulkUploadOutputModel>(){}, "24.8.2"));
    }

    public GLAccountSuccessResponseModel createGLAccount(Integer n, GLAccountRequestModel gLAccountRequestModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyid}/glaccounts");
        avaTaxPath.applyField("companyid", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, gLAccountRequestModel, new TypeToken<GLAccountSuccessResponseModel>(){}, "24.8.2").call();
    }

    public Future<GLAccountSuccessResponseModel> createGLAccountAsync(Integer n, GLAccountRequestModel gLAccountRequestModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyid}/glaccounts");
        avaTaxPath.applyField("companyid", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, gLAccountRequestModel, new TypeToken<GLAccountSuccessResponseModel>(){}, "24.8.2"));
    }

    public TaxProfileErrorResponseModel deleteGLAccount(Integer n, Long l) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyid}/glaccounts/{glaccountid}");
        avaTaxPath.applyField("companyid", n);
        avaTaxPath.applyField("glaccountid", l);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<TaxProfileErrorResponseModel>(){}, "24.8.2").call();
    }

    public Future<TaxProfileErrorResponseModel> deleteGLAccountAsync(Integer n, Long l) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyid}/glaccounts/{glaccountid}");
        avaTaxPath.applyField("companyid", n);
        avaTaxPath.applyField("glaccountid", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<TaxProfileErrorResponseModel>(){}, "24.8.2"));
    }

    public GLAccountSuccessResponseModel getGLAccountById(Integer n, Long l) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyid}/glaccounts/{glaccountid}");
        avaTaxPath.applyField("companyid", n);
        avaTaxPath.applyField("glaccountid", l);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<GLAccountSuccessResponseModel>(){}, "24.8.2").call();
    }

    public Future<GLAccountSuccessResponseModel> getGLAccountByIdAsync(Integer n, Long l) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyid}/glaccounts/{glaccountid}");
        avaTaxPath.applyField("companyid", n);
        avaTaxPath.applyField("glaccountid", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<GLAccountSuccessResponseModel>(){}, "24.8.2"));
    }

    public FetchResult<GLAccountSuccessResponseModel> listGLAccountsByCompany(Integer n, String string, String string2, Integer n2, Integer n3, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyid}/glaccounts");
        avaTaxPath.applyField("companyid", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<GLAccountSuccessResponseModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<GLAccountSuccessResponseModel>> listGLAccountsByCompanyAsync(Integer n, String string, String string2, Integer n2, Integer n3, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyid}/glaccounts");
        avaTaxPath.applyField("companyid", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<GLAccountSuccessResponseModel>>(){}, "24.8.2"));
    }

    public GLAccountSuccessResponseModel updateGLAccount(Integer n, Long l, GLAccountRequestModel gLAccountRequestModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyid}/glaccounts/{glaccountid}");
        avaTaxPath.applyField("companyid", n);
        avaTaxPath.applyField("glaccountid", l);
        return this.restCallFactory.createRestCall("put", avaTaxPath, gLAccountRequestModel, new TypeToken<GLAccountSuccessResponseModel>(){}, "24.8.2").call();
    }

    public Future<GLAccountSuccessResponseModel> updateGLAccountAsync(Integer n, Long l, GLAccountRequestModel gLAccountRequestModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyid}/glaccounts/{glaccountid}");
        avaTaxPath.applyField("companyid", n);
        avaTaxPath.applyField("glaccountid", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, gLAccountRequestModel, new TypeToken<GLAccountSuccessResponseModel>(){}, "24.8.2"));
    }

    public ArrayList<AssociatedObjectDeletedErrorDetailsModel> batchDeleteItemClassifications(Integer n, Long l) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/classifications");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<AssociatedObjectDeletedErrorDetailsModel>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<AssociatedObjectDeletedErrorDetailsModel>> batchDeleteItemClassificationsAsync(Integer n, Long l) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/classifications");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<AssociatedObjectDeletedErrorDetailsModel>>(){}, "24.8.2"));
    }

    public ArrayList<AssociatedObjectDeletedErrorDetailsModel> batchDeleteItemParameters(Integer n, Long l) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/parameters");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<AssociatedObjectDeletedErrorDetailsModel>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<AssociatedObjectDeletedErrorDetailsModel>> batchDeleteItemParametersAsync(Integer n, Long l) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/parameters");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<AssociatedObjectDeletedErrorDetailsModel>>(){}, "24.8.2"));
    }

    public ItemBulkUploadOutputModel bulkUploadItems(Integer n, ItemBulkUploadInputModel itemBulkUploadInputModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/upload");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, itemBulkUploadInputModel, new TypeToken<ItemBulkUploadOutputModel>(){}, "24.8.2").call();
    }

    public Future<ItemBulkUploadOutputModel> bulkUploadItemsAsync(Integer n, ItemBulkUploadInputModel itemBulkUploadInputModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/upload");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, itemBulkUploadInputModel, new TypeToken<ItemBulkUploadOutputModel>(){}, "24.8.2"));
    }

    public ArrayList<ItemClassificationOutputModel> createItemClassifications(Integer n, Long l, ArrayList<ItemClassificationInputModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/classifications");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<ItemClassificationOutputModel>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<ItemClassificationOutputModel>> createItemClassificationsAsync(Integer n, Long l, ArrayList<ItemClassificationInputModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/classifications");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<ItemClassificationOutputModel>>(){}, "24.8.2"));
    }

    public ArrayList<ItemParameterModel> createItemParameters(Integer n, Long l, ArrayList<ItemParameterModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/parameters");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<ItemParameterModel>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<ItemParameterModel>> createItemParametersAsync(Integer n, Long l, ArrayList<ItemParameterModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/parameters");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<ItemParameterModel>>(){}, "24.8.2"));
    }

    public ArrayList<ItemModel> createItems(Integer n, Boolean bl, ArrayList<ItemModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("processRecommendationsSynchronously", bl);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<ItemModel>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<ItemModel>> createItemsAsync(Integer n, Boolean bl, ArrayList<ItemModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("processRecommendationsSynchronously", bl);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<ItemModel>>(){}, "24.8.2"));
    }

    public ArrayList<ItemTagDetailOutputModel> createItemTags(Integer n, Integer n2, ArrayList<ItemTagDetailInputModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/tags");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", n2);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<ItemTagDetailOutputModel>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<ItemTagDetailOutputModel>> createItemTagsAsync(Integer n, Integer n2, ArrayList<ItemTagDetailInputModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/tags");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<ItemTagDetailOutputModel>>(){}, "24.8.2"));
    }

    public ItemTaxCodeClassificationRequestOutputModel createTaxCodeClassificationRequest(Integer n, ItemTaxCodeClassificationRequestInputModel itemTaxCodeClassificationRequestInputModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/classificationrequests/taxcode");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, itemTaxCodeClassificationRequestInputModel, new TypeToken<ItemTaxCodeClassificationRequestOutputModel>(){}, "24.8.2").call();
    }

    public Future<ItemTaxCodeClassificationRequestOutputModel> createTaxCodeClassificationRequestAsync(Integer n, ItemTaxCodeClassificationRequestInputModel itemTaxCodeClassificationRequestInputModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/classificationrequests/taxcode");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, itemTaxCodeClassificationRequestInputModel, new TypeToken<ItemTaxCodeClassificationRequestOutputModel>(){}, "24.8.2"));
    }

    public ArrayList<ObjectDeletedErrorModel> deleteCatalogueItem(Integer n, String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/itemcatalogue/{itemCode}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemCode", string);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ObjectDeletedErrorModel>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<ObjectDeletedErrorModel>> deleteCatalogueItemAsync(Integer n, String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/itemcatalogue/{itemCode}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemCode", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ObjectDeletedErrorModel>>(){}, "24.8.2"));
    }

    public ArrayList<ObjectDeletedErrorModel> deleteItem(Integer n, Long l) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", l);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ObjectDeletedErrorModel>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<ObjectDeletedErrorModel>> deleteItemAsync(Integer n, Long l) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ObjectDeletedErrorModel>>(){}, "24.8.2"));
    }

    public ArrayList<ObjectDeletedErrorModel> deleteItemClassification(Integer n, Long l, Long l2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/classifications/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        avaTaxPath.applyField("id", l2);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ObjectDeletedErrorModel>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<ObjectDeletedErrorModel>> deleteItemClassificationAsync(Integer n, Long l, Long l2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/classifications/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        avaTaxPath.applyField("id", l2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ObjectDeletedErrorModel>>(){}, "24.8.2"));
    }

    public ArrayList<ObjectDeletedErrorModel> deleteItemParameter(Integer n, Long l, Long l2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/parameters/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        avaTaxPath.applyField("id", l2);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ObjectDeletedErrorModel>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<ObjectDeletedErrorModel>> deleteItemParameterAsync(Integer n, Long l, Long l2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/parameters/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        avaTaxPath.applyField("id", l2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ObjectDeletedErrorModel>>(){}, "24.8.2"));
    }

    public ArrayList<ObjectDeletedErrorModel> deleteItemTag(Integer n, Long l, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/tags/{itemTagDetailId}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        avaTaxPath.applyField("itemTagDetailId", n2);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ObjectDeletedErrorModel>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<ObjectDeletedErrorModel>> deleteItemTagAsync(Integer n, Long l, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/tags/{itemTagDetailId}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        avaTaxPath.applyField("itemTagDetailId", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ObjectDeletedErrorModel>>(){}, "24.8.2"));
    }

    public ArrayList<AssociatedObjectDeletedErrorDetailsModel> deleteItemTags(Integer n, Long l) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/tags");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<AssociatedObjectDeletedErrorDetailsModel>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<AssociatedObjectDeletedErrorDetailsModel>> deleteItemTagsAsync(Integer n, Long l) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/tags");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<AssociatedObjectDeletedErrorDetailsModel>>(){}, "24.8.2"));
    }

    public ItemModel getItem(Integer n, Long l, String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", l);
        avaTaxPath.addQuery("$include", string);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ItemModel>(){}, "24.8.2").call();
    }

    public Future<ItemModel> getItemAsync(Integer n, Long l, String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", l);
        avaTaxPath.addQuery("$include", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ItemModel>(){}, "24.8.2"));
    }

    public ItemClassificationOutputModel getItemClassification(Integer n, Long l, Long l2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/classifications/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        avaTaxPath.applyField("id", l2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ItemClassificationOutputModel>(){}, "24.8.2").call();
    }

    public Future<ItemClassificationOutputModel> getItemClassificationAsync(Integer n, Long l, Long l2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/classifications/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        avaTaxPath.applyField("id", l2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ItemClassificationOutputModel>(){}, "24.8.2"));
    }

    public ItemParameterModel getItemParameter(Integer n, Long l, Long l2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/parameters/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        avaTaxPath.applyField("id", l2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ItemParameterModel>(){}, "24.8.2").call();
    }

    public Future<ItemParameterModel> getItemParameterAsync(Integer n, Long l, Long l2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/parameters/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        avaTaxPath.applyField("id", l2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ItemParameterModel>(){}, "24.8.2"));
    }

    public FetchResult<ItemTagDetailOutputModel> getItemTags(Integer n, Long l, String string, Integer n2, Integer n3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/tags");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ItemTagDetailOutputModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<ItemTagDetailOutputModel>> getItemTagsAsync(Integer n, Long l, String string, Integer n2, Integer n3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/tags");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ItemTagDetailOutputModel>>(){}, "24.8.2"));
    }

    public ArrayList<TaxCodeRecommendationOutputModel> getItemTaxCodeRecommendations(Integer n, Long l) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/taxcoderecommendations");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ArrayList<TaxCodeRecommendationOutputModel>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<TaxCodeRecommendationOutputModel>> getItemTaxCodeRecommendationsAsync(Integer n, Long l) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/taxcoderecommendations");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ArrayList<TaxCodeRecommendationOutputModel>>(){}, "24.8.2"));
    }

    public ItemPremiumClassificationOutputModel getPremiumClassification(Integer n, String string, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemCode}/premiumClassification/{systemCode}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemCode", string);
        avaTaxPath.applyField("systemCode", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ItemPremiumClassificationOutputModel>(){}, "24.8.2").call();
    }

    public Future<ItemPremiumClassificationOutputModel> getPremiumClassificationAsync(Integer n, String string, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemCode}/premiumClassification/{systemCode}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemCode", string);
        avaTaxPath.applyField("systemCode", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ItemPremiumClassificationOutputModel>(){}, "24.8.2"));
    }

    public FetchResult<ItemRestrictionOutputModel> listImportRestrictions(Integer n, String string, String string2, Integer n2, Integer n3, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemCode}/restrictions/import/{countryOfImport}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemCode", string);
        avaTaxPath.applyField("countryOfImport", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ItemRestrictionOutputModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<ItemRestrictionOutputModel>> listImportRestrictionsAsync(Integer n, String string, String string2, Integer n2, Integer n3, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemCode}/restrictions/import/{countryOfImport}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemCode", string);
        avaTaxPath.applyField("countryOfImport", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ItemRestrictionOutputModel>>(){}, "24.8.2"));
    }

    public FetchResult<ItemClassificationOutputModel> listItemClassifications(Integer n, Long l, String string, Integer n2, Integer n3, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/classifications");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ItemClassificationOutputModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<ItemClassificationOutputModel>> listItemClassificationsAsync(Integer n, Long l, String string, Integer n2, Integer n3, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/classifications");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ItemClassificationOutputModel>>(){}, "24.8.2"));
    }

    public FetchResult<ItemParameterModel> listItemParameters(Integer n, Long l, String string, Integer n2, Integer n3, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/parameters");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ItemParameterModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<ItemParameterModel>> listItemParametersAsync(Integer n, Long l, String string, Integer n2, Integer n3, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/parameters");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ItemParameterModel>>(){}, "24.8.2"));
    }

    public FetchResult<ItemModel> listItemsByCompany(Integer n, String string, String string2, Integer n2, Integer n3, String string3, String string4, String string5, String string6) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        avaTaxPath.addQuery("tagName", string4);
        avaTaxPath.addQuery("itemStatus", string5);
        avaTaxPath.addQuery("taxCodeRecommendationStatus", string6);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ItemModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<ItemModel>> listItemsByCompanyAsync(Integer n, String string, String string2, Integer n2, Integer n3, String string3, String string4, String string5, String string6) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        avaTaxPath.addQuery("tagName", string4);
        avaTaxPath.addQuery("itemStatus", string5);
        avaTaxPath.addQuery("taxCodeRecommendationStatus", string6);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ItemModel>>(){}, "24.8.2"));
    }

    public FetchResult<ParameterModel> listRecommendedParameterByCompanyIdAndItemId(Integer n, Long l, String string, Integer n2, Integer n3, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/companies/{companyId}/items/{itemId}/parameters");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ParameterModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<ParameterModel>> listRecommendedParameterByCompanyIdAndItemIdAsync(Integer n, Long l, String string, Integer n2, Integer n3, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/definitions/companies/{companyId}/items/{itemId}/parameters");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ParameterModel>>(){}, "24.8.2"));
    }

    public FetchResult<ItemModel> queryItems(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/items");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ItemModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<ItemModel>> queryItemsAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/items");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ItemModel>>(){}, "24.8.2"));
    }

    public FetchResult<ItemModel> queryItemsBySystemCode(Integer n, String string, Integer n2, Integer n3, String string2, FilterModel filterModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/internal/bySystemCode/{systemCode}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("systemCode", string);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("post", avaTaxPath, filterModel, new TypeToken<FetchResult<ItemModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<ItemModel>> queryItemsBySystemCodeAsync(Integer n, String string, Integer n2, Integer n3, String string2, FilterModel filterModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/internal/bySystemCode/{systemCode}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("systemCode", string);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, filterModel, new TypeToken<FetchResult<ItemModel>>(){}, "24.8.2"));
    }

    public FetchResult<ItemModel> queryItemsByTag(Integer n, String string, String string2, String string3, Integer n2, Integer n3, String string4) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/bytags/{tag}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("tag", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$include", string3);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string4);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ItemModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<ItemModel>> queryItemsByTagAsync(Integer n, String string, String string2, String string3, Integer n2, Integer n3, String string4) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/bytags/{tag}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("tag", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$include", string3);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string4);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ItemModel>>(){}, "24.8.2"));
    }

    public ItemCatalogueOutputModel syncItemCatalogue(Integer n, ArrayList<ItemCatalogueInputModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/itemcatalogue");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ItemCatalogueOutputModel>(){}, "24.8.2").call();
    }

    public Future<ItemCatalogueOutputModel> syncItemCatalogueAsync(Integer n, ArrayList<ItemCatalogueInputModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/itemcatalogue");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ItemCatalogueOutputModel>(){}, "24.8.2"));
    }

    public SyncItemsResponseModel syncItems(Integer n, SyncItemsRequestModel syncItemsRequestModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/sync");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, syncItemsRequestModel, new TypeToken<SyncItemsResponseModel>(){}, "24.8.2").call();
    }

    public Future<SyncItemsResponseModel> syncItemsAsync(Integer n, SyncItemsRequestModel syncItemsRequestModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/sync");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, syncItemsRequestModel, new TypeToken<SyncItemsResponseModel>(){}, "24.8.2"));
    }

    public ItemModel updateItem(Integer n, Long l, Boolean bl, ItemModel itemModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", l);
        avaTaxPath.addQuery("isRecommendationSelected", bl);
        return this.restCallFactory.createRestCall("put", avaTaxPath, itemModel, new TypeToken<ItemModel>(){}, "24.8.2").call();
    }

    public Future<ItemModel> updateItemAsync(Integer n, Long l, Boolean bl, ItemModel itemModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", l);
        avaTaxPath.addQuery("isRecommendationSelected", bl);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, itemModel, new TypeToken<ItemModel>(){}, "24.8.2"));
    }

    public ItemClassificationOutputModel updateItemClassification(Integer n, Long l, Long l2, ItemClassificationInputModel itemClassificationInputModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/classifications/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        avaTaxPath.applyField("id", l2);
        return this.restCallFactory.createRestCall("put", avaTaxPath, itemClassificationInputModel, new TypeToken<ItemClassificationOutputModel>(){}, "24.8.2").call();
    }

    public Future<ItemClassificationOutputModel> updateItemClassificationAsync(Integer n, Long l, Long l2, ItemClassificationInputModel itemClassificationInputModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/classifications/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        avaTaxPath.applyField("id", l2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, itemClassificationInputModel, new TypeToken<ItemClassificationOutputModel>(){}, "24.8.2"));
    }

    public ItemParameterModel updateItemParameter(Integer n, Long l, Long l2, ItemParameterModel itemParameterModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/parameters/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        avaTaxPath.applyField("id", l2);
        return this.restCallFactory.createRestCall("put", avaTaxPath, itemParameterModel, new TypeToken<ItemParameterModel>(){}, "24.8.2").call();
    }

    public Future<ItemParameterModel> updateItemParameterAsync(Integer n, Long l, Long l2, ItemParameterModel itemParameterModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/items/{itemId}/parameters/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("itemId", l);
        avaTaxPath.applyField("id", l2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, itemParameterModel, new TypeToken<ItemParameterModel>(){}, "24.8.2"));
    }

    public ArrayList<JurisdictionOverrideModel> createJurisdictionOverrides(Integer n, ArrayList<JurisdictionOverrideModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/jurisdictionoverrides");
        avaTaxPath.applyField("accountId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<JurisdictionOverrideModel>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<JurisdictionOverrideModel>> createJurisdictionOverridesAsync(Integer n, ArrayList<JurisdictionOverrideModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/jurisdictionoverrides");
        avaTaxPath.applyField("accountId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<JurisdictionOverrideModel>>(){}, "24.8.2"));
    }

    public ArrayList<ErrorDetail> deleteJurisdictionOverride(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/jurisdictionoverrides/{id}");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<ErrorDetail>> deleteJurisdictionOverrideAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/jurisdictionoverrides/{id}");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2"));
    }

    public JurisdictionOverrideModel getJurisdictionOverride(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/jurisdictionoverrides/{id}");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<JurisdictionOverrideModel>(){}, "24.8.2").call();
    }

    public Future<JurisdictionOverrideModel> getJurisdictionOverrideAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/jurisdictionoverrides/{id}");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<JurisdictionOverrideModel>(){}, "24.8.2"));
    }

    public FetchResult<JurisdictionOverrideModel> listJurisdictionOverridesByAccount(Integer n, String string, String string2, Integer n2, Integer n3, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/jurisdictionoverrides");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<JurisdictionOverrideModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<JurisdictionOverrideModel>> listJurisdictionOverridesByAccountAsync(Integer n, String string, String string2, Integer n2, Integer n3, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/jurisdictionoverrides");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<JurisdictionOverrideModel>>(){}, "24.8.2"));
    }

    public FetchResult<JurisdictionOverrideModel> queryJurisdictionOverrides(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/jurisdictionoverrides");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<JurisdictionOverrideModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<JurisdictionOverrideModel>> queryJurisdictionOverridesAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/jurisdictionoverrides");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<JurisdictionOverrideModel>>(){}, "24.8.2"));
    }

    public JurisdictionOverrideModel updateJurisdictionOverride(Integer n, Integer n2, JurisdictionOverrideModel jurisdictionOverrideModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/jurisdictionoverrides/{id}");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("put", avaTaxPath, jurisdictionOverrideModel, new TypeToken<JurisdictionOverrideModel>(){}, "24.8.2").call();
    }

    public Future<JurisdictionOverrideModel> updateJurisdictionOverrideAsync(Integer n, Integer n2, JurisdictionOverrideModel jurisdictionOverrideModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/jurisdictionoverrides/{id}");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, jurisdictionOverrideModel, new TypeToken<JurisdictionOverrideModel>(){}, "24.8.2"));
    }

    public ArrayList<LocationParameterModel> createLocationParameters(Integer n, Integer n2, ArrayList<LocationParameterModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/locations/{locationId}/parameters");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("locationId", n2);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<LocationParameterModel>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<LocationParameterModel>> createLocationParametersAsync(Integer n, Integer n2, ArrayList<LocationParameterModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/locations/{locationId}/parameters");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("locationId", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<LocationParameterModel>>(){}, "24.8.2"));
    }

    public ArrayList<LocationModel> createLocations(Integer n, ArrayList<LocationModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/locations");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<LocationModel>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<LocationModel>> createLocationsAsync(Integer n, ArrayList<LocationModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/locations");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<LocationModel>>(){}, "24.8.2"));
    }

    public ArrayList<ErrorDetail> deleteLocation(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/locations/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<ErrorDetail>> deleteLocationAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/locations/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2"));
    }

    public ArrayList<ErrorDetail> deleteLocationParameter(Integer n, Integer n2, Long l) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/locations/{locationId}/parameters/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("locationId", n2);
        avaTaxPath.applyField("id", l);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<ErrorDetail>> deleteLocationParameterAsync(Integer n, Integer n2, Long l) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/locations/{locationId}/parameters/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("locationId", n2);
        avaTaxPath.applyField("id", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2"));
    }

    public LocationModel getLocation(Integer n, Integer n2, String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/locations/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        avaTaxPath.addQuery("$include", string);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<LocationModel>(){}, "24.8.2").call();
    }

    public Future<LocationModel> getLocationAsync(Integer n, Integer n2, String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/locations/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        avaTaxPath.addQuery("$include", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<LocationModel>(){}, "24.8.2"));
    }

    public LocationParameterModel getLocationParameter(Integer n, Integer n2, Long l) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/locations/{locationId}/parameters/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("locationId", n2);
        avaTaxPath.applyField("id", l);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<LocationParameterModel>(){}, "24.8.2").call();
    }

    public Future<LocationParameterModel> getLocationParameterAsync(Integer n, Integer n2, Long l) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/locations/{locationId}/parameters/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("locationId", n2);
        avaTaxPath.applyField("id", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<LocationParameterModel>(){}, "24.8.2"));
    }

    public FetchResult<LocationParameterModel> listLocationParameters(Integer n, Integer n2, String string, Integer n3, Integer n4, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/locations/{locationId}/parameters");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("locationId", n2);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n3);
        avaTaxPath.addQuery("$skip", n4);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<LocationParameterModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<LocationParameterModel>> listLocationParametersAsync(Integer n, Integer n2, String string, Integer n3, Integer n4, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/locations/{locationId}/parameters");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("locationId", n2);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n3);
        avaTaxPath.addQuery("$skip", n4);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<LocationParameterModel>>(){}, "24.8.2"));
    }

    public FetchResult<LocationModel> listLocationsByCompany(Integer n, String string, String string2, Integer n2, Integer n3, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/locations");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<LocationModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<LocationModel>> listLocationsByCompanyAsync(Integer n, String string, String string2, Integer n2, Integer n3, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/locations");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<LocationModel>>(){}, "24.8.2"));
    }

    public FetchResult<LocationModel> queryLocations(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/locations");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<LocationModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<LocationModel>> queryLocationsAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/locations");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<LocationModel>>(){}, "24.8.2"));
    }

    public LocationModel updateLocation(Integer n, Integer n2, LocationModel locationModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/locations/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("put", avaTaxPath, locationModel, new TypeToken<LocationModel>(){}, "24.8.2").call();
    }

    public Future<LocationModel> updateLocationAsync(Integer n, Integer n2, LocationModel locationModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/locations/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, locationModel, new TypeToken<LocationModel>(){}, "24.8.2"));
    }

    public LocationParameterModel updateLocationParameter(Integer n, Integer n2, Long l, LocationParameterModel locationParameterModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/locations/{locationId}/parameters/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("locationId", n2);
        avaTaxPath.applyField("id", l);
        return this.restCallFactory.createRestCall("put", avaTaxPath, locationParameterModel, new TypeToken<LocationParameterModel>(){}, "24.8.2").call();
    }

    public Future<LocationParameterModel> updateLocationParameterAsync(Integer n, Integer n2, Long l, LocationParameterModel locationParameterModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/locations/{locationId}/parameters/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("locationId", n2);
        avaTaxPath.applyField("id", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, locationParameterModel, new TypeToken<LocationParameterModel>(){}, "24.8.2"));
    }

    public LocationValidationModel validateLocation(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/locations/{id}/validate");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<LocationValidationModel>(){}, "24.8.2").call();
    }

    public Future<LocationValidationModel> validateLocationAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/locations/{id}/validate");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<LocationValidationModel>(){}, "24.8.2"));
    }

    public MultiDocumentModel adjustMultiDocumentTransaction(String string, DocumentType documentType, String string2, AdjustMultiDocumentModel adjustMultiDocumentModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/multidocument/{code}/type/{type}/adjust");
        avaTaxPath.applyField("code", string);
        avaTaxPath.applyField("type", (Object)documentType);
        avaTaxPath.addQuery("include", string2);
        return this.restCallFactory.createRestCall("post", avaTaxPath, adjustMultiDocumentModel, new TypeToken<MultiDocumentModel>(){}, "24.8.2").call();
    }

    public Future<MultiDocumentModel> adjustMultiDocumentTransactionAsync(String string, DocumentType documentType, String string2, AdjustMultiDocumentModel adjustMultiDocumentModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/multidocument/{code}/type/{type}/adjust");
        avaTaxPath.applyField("code", string);
        avaTaxPath.applyField("type", (Object)documentType);
        avaTaxPath.addQuery("include", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, adjustMultiDocumentModel, new TypeToken<MultiDocumentModel>(){}, "24.8.2"));
    }

    public AuditMultiDocumentModel auditMultiDocumentTransaction(String string, DocumentType documentType) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/multidocument/{code}/type/{type}/audit");
        avaTaxPath.applyField("code", string);
        avaTaxPath.applyField("type", (Object)documentType);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<AuditMultiDocumentModel>(){}, "24.8.2").call();
    }

    public Future<AuditMultiDocumentModel> auditMultiDocumentTransactionAsync(String string, DocumentType documentType) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/multidocument/{code}/type/{type}/audit");
        avaTaxPath.applyField("code", string);
        avaTaxPath.applyField("type", (Object)documentType);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<AuditMultiDocumentModel>(){}, "24.8.2"));
    }

    public MultiDocumentModel commitMultiDocumentTransaction(CommitMultiDocumentModel commitMultiDocumentModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/multidocument/commit");
        return this.restCallFactory.createRestCall("post", avaTaxPath, commitMultiDocumentModel, new TypeToken<MultiDocumentModel>(){}, "24.8.2").call();
    }

    public Future<MultiDocumentModel> commitMultiDocumentTransactionAsync(CommitMultiDocumentModel commitMultiDocumentModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/multidocument/commit");
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, commitMultiDocumentModel, new TypeToken<MultiDocumentModel>(){}, "24.8.2"));
    }

    public MultiDocumentModel createMultiDocumentTransaction(String string, CreateMultiDocumentModel createMultiDocumentModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/multidocument");
        avaTaxPath.addQuery("$include", string);
        return this.restCallFactory.createRestCall("post", avaTaxPath, createMultiDocumentModel, new TypeToken<MultiDocumentModel>(){}, "24.8.2").call();
    }

    public Future<MultiDocumentModel> createMultiDocumentTransactionAsync(String string, CreateMultiDocumentModel createMultiDocumentModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/multidocument");
        avaTaxPath.addQuery("$include", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, createMultiDocumentModel, new TypeToken<MultiDocumentModel>(){}, "24.8.2"));
    }

    public MultiDocumentModel getMultiDocumentTransactionByCodeAndType(String string, DocumentType documentType, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/multidocument/{code}/type/{type}");
        avaTaxPath.applyField("code", string);
        avaTaxPath.applyField("type", (Object)documentType);
        avaTaxPath.addQuery("$include", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<MultiDocumentModel>(){}, "24.8.2").call();
    }

    public Future<MultiDocumentModel> getMultiDocumentTransactionByCodeAndTypeAsync(String string, DocumentType documentType, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/multidocument/{code}/type/{type}");
        avaTaxPath.applyField("code", string);
        avaTaxPath.applyField("type", (Object)documentType);
        avaTaxPath.addQuery("$include", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<MultiDocumentModel>(){}, "24.8.2"));
    }

    public MultiDocumentModel getMultiDocumentTransactionById(Long l, String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/multidocument/{id}");
        avaTaxPath.applyField("id", l);
        avaTaxPath.addQuery("$include", string);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<MultiDocumentModel>(){}, "24.8.2").call();
    }

    public Future<MultiDocumentModel> getMultiDocumentTransactionByIdAsync(Long l, String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/multidocument/{id}");
        avaTaxPath.applyField("id", l);
        avaTaxPath.addQuery("$include", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<MultiDocumentModel>(){}, "24.8.2"));
    }

    public FetchResult<MultiDocumentModel> listMultiDocumentTransactions(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/multidocument");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<MultiDocumentModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<MultiDocumentModel>> listMultiDocumentTransactionsAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/multidocument");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<MultiDocumentModel>>(){}, "24.8.2"));
    }

    public MultiDocumentModel refundMultiDocumentTransaction(String string, DocumentType documentType, String string2, RefundTransactionModel refundTransactionModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/multidocument/{code}/type/{type}/refund");
        avaTaxPath.applyField("code", string);
        avaTaxPath.applyField("type", (Object)documentType);
        avaTaxPath.addQuery("$include", string2);
        return this.restCallFactory.createRestCall("post", avaTaxPath, refundTransactionModel, new TypeToken<MultiDocumentModel>(){}, "24.8.2").call();
    }

    public Future<MultiDocumentModel> refundMultiDocumentTransactionAsync(String string, DocumentType documentType, String string2, RefundTransactionModel refundTransactionModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/multidocument/{code}/type/{type}/refund");
        avaTaxPath.applyField("code", string);
        avaTaxPath.applyField("type", (Object)documentType);
        avaTaxPath.addQuery("$include", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, refundTransactionModel, new TypeToken<MultiDocumentModel>(){}, "24.8.2"));
    }

    public MultiDocumentModel verifyMultiDocumentTransaction(VerifyMultiDocumentModel verifyMultiDocumentModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/multidocument/verify");
        return this.restCallFactory.createRestCall("post", avaTaxPath, verifyMultiDocumentModel, new TypeToken<MultiDocumentModel>(){}, "24.8.2").call();
    }

    public Future<MultiDocumentModel> verifyMultiDocumentTransactionAsync(VerifyMultiDocumentModel verifyMultiDocumentModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/multidocument/verify");
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, verifyMultiDocumentModel, new TypeToken<MultiDocumentModel>(){}, "24.8.2"));
    }

    public MultiDocumentModel voidMultiDocumentTransaction(String string, DocumentType documentType, VoidTransactionModel voidTransactionModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/multidocument/{code}/type/{type}/void");
        avaTaxPath.applyField("code", string);
        avaTaxPath.applyField("type", (Object)documentType);
        return this.restCallFactory.createRestCall("post", avaTaxPath, voidTransactionModel, new TypeToken<MultiDocumentModel>(){}, "24.8.2").call();
    }

    public Future<MultiDocumentModel> voidMultiDocumentTransactionAsync(String string, DocumentType documentType, VoidTransactionModel voidTransactionModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/multidocument/{code}/type/{type}/void");
        avaTaxPath.applyField("code", string);
        avaTaxPath.applyField("type", (Object)documentType);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, voidTransactionModel, new TypeToken<MultiDocumentModel>(){}, "24.8.2"));
    }

    public ArrayList<NexusModel> createNexus(Integer n, ArrayList<NexusModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<NexusModel>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<NexusModel>> createNexusAsync(Integer n, ArrayList<NexusModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<NexusModel>>(){}, "24.8.2"));
    }

    public ArrayList<NexusParameterDetailModel> createNexusParameters(Integer n, Integer n2, ArrayList<NexusParameterDetailModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus/{nexusId}/parameters");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("nexusId", n2);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<NexusParameterDetailModel>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<NexusParameterDetailModel>> createNexusParametersAsync(Integer n, Integer n2, ArrayList<NexusParameterDetailModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus/{nexusId}/parameters");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("nexusId", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<NexusParameterDetailModel>>(){}, "24.8.2"));
    }

    public ArrayList<NexusByAddressModel> declareNexusByAddress(Integer n, ArrayList<DeclareNexusByAddressModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus/byaddress");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<NexusByAddressModel>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<NexusByAddressModel>> declareNexusByAddressAsync(Integer n, ArrayList<DeclareNexusByAddressModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus/byaddress");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<NexusByAddressModel>>(){}, "24.8.2"));
    }

    public ArrayList<ErrorDetail> deleteNexus(Integer n, Integer n2, Boolean bl) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        avaTaxPath.addQuery("cascadeDelete", bl);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<ErrorDetail>> deleteNexusAsync(Integer n, Integer n2, Boolean bl) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        avaTaxPath.addQuery("cascadeDelete", bl);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2"));
    }

    public ArrayList<ErrorDetail> deleteNexusParameter(Integer n, Integer n2, Long l) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus/{nexusId}/parameters/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("nexusId", n2);
        avaTaxPath.applyField("id", l);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<ErrorDetail>> deleteNexusParameterAsync(Integer n, Integer n2, Long l) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus/{nexusId}/parameters/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("nexusId", n2);
        avaTaxPath.applyField("id", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2"));
    }

    public ArrayList<ErrorDetail> deleteNexusParameters(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus/{nexusId}/parameters");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("nexusId", n2);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<ErrorDetail>> deleteNexusParametersAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus/{nexusId}/parameters");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("nexusId", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2"));
    }

    public NexusModel getNexus(Integer n, Integer n2, String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        avaTaxPath.addQuery("$include", string);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<NexusModel>(){}, "24.8.2").call();
    }

    public Future<NexusModel> getNexusAsync(Integer n, Integer n2, String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        avaTaxPath.addQuery("$include", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<NexusModel>(){}, "24.8.2"));
    }

    public NexusByTaxFormModel getNexusByFormCode(Integer n, String string, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus/byform/{formCode}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("formCode", string);
        avaTaxPath.addQuery("$include", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<NexusByTaxFormModel>(){}, "24.8.2").call();
    }

    public Future<NexusByTaxFormModel> getNexusByFormCodeAsync(Integer n, String string, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus/byform/{formCode}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("formCode", string);
        avaTaxPath.addQuery("$include", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<NexusByTaxFormModel>(){}, "24.8.2"));
    }

    public NexusParameterDetailModel getNexusParameter(Integer n, Integer n2, Long l) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus/{nexusId}/parameters/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("nexusId", n2);
        avaTaxPath.applyField("id", l);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<NexusParameterDetailModel>(){}, "24.8.2").call();
    }

    public Future<NexusParameterDetailModel> getNexusParameterAsync(Integer n, Integer n2, Long l) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus/{nexusId}/parameters/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("nexusId", n2);
        avaTaxPath.applyField("id", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<NexusParameterDetailModel>(){}, "24.8.2"));
    }

    public FetchResult<NexusModel> listNexusByCompany(Integer n, String string, String string2, Integer n2, Integer n3, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NexusModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<NexusModel>> listNexusByCompanyAsync(Integer n, String string, String string2, Integer n2, Integer n3, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NexusModel>>(){}, "24.8.2"));
    }

    public FetchResult<NexusModel> listNexusByCompanyAndTaxTypeGroup(Integer n, String string, String string2, String string3, Integer n2, Integer n3, String string4) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus/byTaxTypeGroup/{taxTypeGroup}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("taxTypeGroup", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$include", string3);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string4);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NexusModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<NexusModel>> listNexusByCompanyAndTaxTypeGroupAsync(Integer n, String string, String string2, String string3, Integer n2, Integer n3, String string4) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus/byTaxTypeGroup/{taxTypeGroup}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("taxTypeGroup", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$include", string3);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string4);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NexusModel>>(){}, "24.8.2"));
    }

    public FetchResult<NexusParameterDetailModel> listNexusParameters(Integer n, Integer n2, String string, Integer n3, Integer n4, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus/{nexusId}/parameters");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("nexusId", n2);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n3);
        avaTaxPath.addQuery("$skip", n4);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NexusParameterDetailModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<NexusParameterDetailModel>> listNexusParametersAsync(Integer n, Integer n2, String string, Integer n3, Integer n4, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus/{nexusId}/parameters");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("nexusId", n2);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n3);
        avaTaxPath.addQuery("$skip", n4);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NexusParameterDetailModel>>(){}, "24.8.2"));
    }

    public FetchResult<NexusModel> queryNexus(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/nexus");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NexusModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<NexusModel>> queryNexusAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/nexus");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NexusModel>>(){}, "24.8.2"));
    }

    public NexusModel updateNexus(Integer n, Integer n2, NexusModel nexusModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("put", avaTaxPath, nexusModel, new TypeToken<NexusModel>(){}, "24.8.2").call();
    }

    public Future<NexusModel> updateNexusAsync(Integer n, Integer n2, NexusModel nexusModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, nexusModel, new TypeToken<NexusModel>(){}, "24.8.2"));
    }

    public NexusParameterDetailModel updateNexusParameter(Integer n, Integer n2, Long l, NexusParameterDetailModel nexusParameterDetailModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus/{nexusId}/parameters/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("nexusId", n2);
        avaTaxPath.applyField("id", l);
        return this.restCallFactory.createRestCall("put", avaTaxPath, nexusParameterDetailModel, new TypeToken<NexusParameterDetailModel>(){}, "24.8.2").call();
    }

    public Future<NexusParameterDetailModel> updateNexusParameterAsync(Integer n, Integer n2, Long l, NexusParameterDetailModel nexusParameterDetailModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/nexus/{nexusId}/parameters/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("nexusId", n2);
        avaTaxPath.applyField("id", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, nexusParameterDetailModel, new TypeToken<NexusParameterDetailModel>(){}, "24.8.2"));
    }

    public NoticeResponsibilityModel createNoticeResponsibilityType(CreateNoticeResponsibilityTypeModel createNoticeResponsibilityTypeModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/notices/responsibilities");
        return this.restCallFactory.createRestCall("post", avaTaxPath, createNoticeResponsibilityTypeModel, new TypeToken<NoticeResponsibilityModel>(){}, "24.8.2").call();
    }

    public Future<NoticeResponsibilityModel> createNoticeResponsibilityTypeAsync(CreateNoticeResponsibilityTypeModel createNoticeResponsibilityTypeModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/notices/responsibilities");
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, createNoticeResponsibilityTypeModel, new TypeToken<NoticeResponsibilityModel>(){}, "24.8.2"));
    }

    public NoticeRootCauseModel createNoticeRootCauseType(CreateNoticeRootCauseTypeModel createNoticeRootCauseTypeModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/notices/rootcauses");
        return this.restCallFactory.createRestCall("post", avaTaxPath, createNoticeRootCauseTypeModel, new TypeToken<NoticeRootCauseModel>(){}, "24.8.2").call();
    }

    public Future<NoticeRootCauseModel> createNoticeRootCauseTypeAsync(CreateNoticeRootCauseTypeModel createNoticeRootCauseTypeModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/notices/rootcauses");
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, createNoticeRootCauseTypeModel, new TypeToken<NoticeRootCauseModel>(){}, "24.8.2"));
    }

    public ArrayList<ErrorDetail> deleteNoticeResponsibilityType(Integer n) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/notices/responsibilities/{responsibilityId}");
        avaTaxPath.applyField("responsibilityId", n);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<ErrorDetail>> deleteNoticeResponsibilityTypeAsync(Integer n) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/notices/responsibilities/{responsibilityId}");
        avaTaxPath.applyField("responsibilityId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2"));
    }

    public ArrayList<ErrorDetail> deleteNoticeRootCauseType(Integer n) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/notices/rootcauses/{rootCauseId}");
        avaTaxPath.applyField("rootCauseId", n);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<ErrorDetail>> deleteNoticeRootCauseTypeAsync(Integer n) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/notices/rootcauses/{rootCauseId}");
        avaTaxPath.applyField("rootCauseId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2"));
    }

    public NotificationModel dismissNotification(Long l) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/notifications/{id}/dismiss");
        avaTaxPath.applyField("id", l);
        return this.restCallFactory.createRestCall("put", avaTaxPath, null, new TypeToken<NotificationModel>(){}, "24.8.2").call();
    }

    public Future<NotificationModel> dismissNotificationAsync(Long l) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/notifications/{id}/dismiss");
        avaTaxPath.applyField("id", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, null, new TypeToken<NotificationModel>(){}, "24.8.2"));
    }

    public NotificationModel getNotification(Long l) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/notifications/{id}");
        avaTaxPath.applyField("id", l);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<NotificationModel>(){}, "24.8.2").call();
    }

    public Future<NotificationModel> getNotificationAsync(Long l) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/notifications/{id}");
        avaTaxPath.applyField("id", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<NotificationModel>(){}, "24.8.2"));
    }

    public FetchResult<NotificationModel> listNotifications(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/notifications");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NotificationModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<NotificationModel>> listNotificationsAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/notifications");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<NotificationModel>>(){}, "24.8.2"));
    }

    public NewAccountModel requestNewAccount(NewAccountRequestModel newAccountRequestModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/request");
        return this.restCallFactory.createRestCall("post", avaTaxPath, newAccountRequestModel, new TypeToken<NewAccountModel>(){}, "24.8.2").call();
    }

    public Future<NewAccountModel> requestNewAccountAsync(NewAccountRequestModel newAccountRequestModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/request");
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, newAccountRequestModel, new TypeToken<NewAccountModel>(){}, "24.8.2"));
    }

    public OfferModel requestNewEntitlement(Integer n, String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}/entitlements/{offer}");
        avaTaxPath.applyField("id", n);
        avaTaxPath.applyField("offer", string);
        return this.restCallFactory.createRestCall("post", avaTaxPath, null, new TypeToken<OfferModel>(){}, "24.8.2").call();
    }

    public Future<OfferModel> requestNewEntitlementAsync(Integer n, String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}/entitlements/{offer}");
        avaTaxPath.applyField("id", n);
        avaTaxPath.applyField("offer", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, null, new TypeToken<OfferModel>(){}, "24.8.2"));
    }

    public ArrayList<AccountModel> createAccount(AccountModel accountModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts");
        return this.restCallFactory.createRestCall("post", avaTaxPath, accountModel, new TypeToken<ArrayList<AccountModel>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<AccountModel>> createAccountAsync(AccountModel accountModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts");
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, accountModel, new TypeToken<ArrayList<AccountModel>>(){}, "24.8.2"));
    }

    public ArrayList<NotificationModel> createNotifications(ArrayList<NotificationModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/notifications");
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<NotificationModel>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<NotificationModel>> createNotificationsAsync(ArrayList<NotificationModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/notifications");
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<NotificationModel>>(){}, "24.8.2"));
    }

    public ArrayList<SubscriptionModel> createSubscriptions(Integer n, ArrayList<SubscriptionModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/subscriptions");
        avaTaxPath.applyField("accountId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<SubscriptionModel>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<SubscriptionModel>> createSubscriptionsAsync(Integer n, ArrayList<SubscriptionModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/subscriptions");
        avaTaxPath.applyField("accountId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<SubscriptionModel>>(){}, "24.8.2"));
    }

    public ArrayList<ErrorDetail> deleteAccount(Integer n) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<ErrorDetail>> deleteAccountAsync(Integer n) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2"));
    }

    public ArrayList<ErrorDetail> deleteNotification(Long l) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/notifications/{id}");
        avaTaxPath.applyField("id", l);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<ErrorDetail>> deleteNotificationAsync(Long l) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/notifications/{id}");
        avaTaxPath.applyField("id", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2"));
    }

    public ArrayList<ErrorDetail> deleteSubscription(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/subscriptions/{id}");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<ErrorDetail>> deleteSubscriptionAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/subscriptions/{id}");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2"));
    }

    public FetchResult<SubscriptionTypeModel> listServiceTypes(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/servicetypes/servicetypes");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SubscriptionTypeModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<SubscriptionTypeModel>> listServiceTypesAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/servicetypes/servicetypes");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SubscriptionTypeModel>>(){}, "24.8.2"));
    }

    public String resetPassword(Integer n, Boolean bl, SetPasswordModel setPasswordModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/passwords/{userId}/reset");
        avaTaxPath.applyField("userId", n);
        avaTaxPath.addQuery("isUndoMigrateRequest", bl);
        return this.restCallFactory.createRestCall("post", avaTaxPath, setPasswordModel, new TypeToken<String>(){}, "24.8.2").call();
    }

    public Future<String> resetPasswordAsync(Integer n, Boolean bl, SetPasswordModel setPasswordModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/passwords/{userId}/reset");
        avaTaxPath.applyField("userId", n);
        avaTaxPath.addQuery("isUndoMigrateRequest", bl);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, setPasswordModel, new TypeToken<String>(){}, "24.8.2"));
    }

    public AccountModel updateAccount(Integer n, AccountModel accountModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}");
        avaTaxPath.applyField("id", n);
        return this.restCallFactory.createRestCall("put", avaTaxPath, accountModel, new TypeToken<AccountModel>(){}, "24.8.2").call();
    }

    public Future<AccountModel> updateAccountAsync(Integer n, AccountModel accountModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{id}");
        avaTaxPath.applyField("id", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, accountModel, new TypeToken<AccountModel>(){}, "24.8.2"));
    }

    public NotificationModel updateNotification(Long l, NotificationModel notificationModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/notifications/{id}");
        avaTaxPath.applyField("id", l);
        return this.restCallFactory.createRestCall("put", avaTaxPath, notificationModel, new TypeToken<NotificationModel>(){}, "24.8.2").call();
    }

    public Future<NotificationModel> updateNotificationAsync(Long l, NotificationModel notificationModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/notifications/{id}");
        avaTaxPath.applyField("id", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, notificationModel, new TypeToken<NotificationModel>(){}, "24.8.2"));
    }

    public SubscriptionModel updateSubscription(Integer n, Integer n2, SubscriptionModel subscriptionModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/subscriptions/{id}");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("put", avaTaxPath, subscriptionModel, new TypeToken<SubscriptionModel>(){}, "24.8.2").call();
    }

    public Future<SubscriptionModel> updateSubscriptionAsync(Integer n, Integer n2, SubscriptionModel subscriptionModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/subscriptions/{id}");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, subscriptionModel, new TypeToken<SubscriptionModel>(){}, "24.8.2"));
    }

    public String downloadReport(Long l) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/reports/{id}/attachment");
        avaTaxPath.applyField("id", l);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<String>(){}, "24.8.2").call();
    }

    public Future<String> downloadReportAsync(Long l) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/reports/{id}/attachment");
        avaTaxPath.applyField("id", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<String>(){}, "24.8.2"));
    }

    public ReportModel getReport(Long l) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/reports/{id}");
        avaTaxPath.applyField("id", l);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ReportModel>(){}, "24.8.2").call();
    }

    public Future<ReportModel> getReportAsync(Long l) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/reports/{id}");
        avaTaxPath.applyField("id", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ReportModel>(){}, "24.8.2"));
    }

    public ArrayList<ReportModel> initiateExportDocumentLineReport(Integer n, ExportDocumentLineModel exportDocumentLineModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/reports/exportdocumentline/initiate");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, exportDocumentLineModel, new TypeToken<ArrayList<ReportModel>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<ReportModel>> initiateExportDocumentLineReportAsync(Integer n, ExportDocumentLineModel exportDocumentLineModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/reports/exportdocumentline/initiate");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, exportDocumentLineModel, new TypeToken<ArrayList<ReportModel>>(){}, "24.8.2"));
    }

    public FetchResult<ReportModel> listReports(Integer n, String string, Integer n2, Integer n3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/reports");
        avaTaxPath.addQuery("companyId", n);
        avaTaxPath.addQuery("pageKey", string);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$top", n3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ReportModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<ReportModel>> listReportsAsync(Integer n, String string, Integer n2, Integer n3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/reports");
        avaTaxPath.addQuery("companyId", n);
        avaTaxPath.addQuery("pageKey", string);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$top", n3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<ReportModel>>(){}, "24.8.2"));
    }

    public ArrayList<SettingModel> createSettings(Integer n, ArrayList<SettingModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/settings");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<SettingModel>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<SettingModel>> createSettingsAsync(Integer n, ArrayList<SettingModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/settings");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<SettingModel>>(){}, "24.8.2"));
    }

    public ArrayList<ErrorDetail> deleteSetting(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/settings/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<ErrorDetail>> deleteSettingAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/settings/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2"));
    }

    public SettingModel getSetting(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/settings/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<SettingModel>(){}, "24.8.2").call();
    }

    public Future<SettingModel> getSettingAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/settings/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<SettingModel>(){}, "24.8.2"));
    }

    public FetchResult<SettingModel> listSettingsByCompany(Integer n, String string, String string2, Integer n2, Integer n3, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/settings");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SettingModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<SettingModel>> listSettingsByCompanyAsync(Integer n, String string, String string2, Integer n2, Integer n3, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/settings");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SettingModel>>(){}, "24.8.2"));
    }

    public FetchResult<SettingModel> querySettings(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/settings");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SettingModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<SettingModel>> querySettingsAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/settings");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SettingModel>>(){}, "24.8.2"));
    }

    public SettingModel updateSetting(Integer n, Integer n2, SettingModel settingModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/settings/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("put", avaTaxPath, settingModel, new TypeToken<SettingModel>(){}, "24.8.2").call();
    }

    public Future<SettingModel> updateSettingAsync(Integer n, Integer n2, SettingModel settingModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/settings/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, settingModel, new TypeToken<SettingModel>(){}, "24.8.2"));
    }

    public SubscriptionModel getSubscription(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/subscriptions/{id}");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<SubscriptionModel>(){}, "24.8.2").call();
    }

    public Future<SubscriptionModel> getSubscriptionAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/subscriptions/{id}");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<SubscriptionModel>(){}, "24.8.2"));
    }

    public FetchResult<SubscriptionModel> listSubscriptionsByAccount(Integer n, String string, Integer n2, Integer n3, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/subscriptions");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SubscriptionModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<SubscriptionModel>> listSubscriptionsByAccountAsync(Integer n, String string, Integer n2, Integer n3, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/subscriptions");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SubscriptionModel>>(){}, "24.8.2"));
    }

    public FetchResult<SubscriptionModel> querySubscriptions(String string, Integer n, Integer n2, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/subscriptions");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SubscriptionModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<SubscriptionModel>> querySubscriptionsAsync(String string, Integer n, Integer n2, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/subscriptions");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SubscriptionModel>>(){}, "24.8.2"));
    }

    public ArrayList<TaxCodeModel> createTaxCodes(Integer n, ArrayList<TaxCodeModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxcodes");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<TaxCodeModel>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<TaxCodeModel>> createTaxCodesAsync(Integer n, ArrayList<TaxCodeModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxcodes");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<TaxCodeModel>>(){}, "24.8.2"));
    }

    public ArrayList<ErrorDetail> deleteTaxCode(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxcodes/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<ErrorDetail>> deleteTaxCodeAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxcodes/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2"));
    }

    public TaxCodeModel getTaxCode(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxcodes/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<TaxCodeModel>(){}, "24.8.2").call();
    }

    public Future<TaxCodeModel> getTaxCodeAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxcodes/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<TaxCodeModel>(){}, "24.8.2"));
    }

    public FetchResult<TaxCodeModel> listTaxCodesByCompany(Integer n, String string, String string2, Integer n2, Integer n3, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxcodes");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxCodeModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<TaxCodeModel>> listTaxCodesByCompanyAsync(Integer n, String string, String string2, Integer n2, Integer n3, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxcodes");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxCodeModel>>(){}, "24.8.2"));
    }

    public FetchResult<TaxCodeModel> queryTaxCodes(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/taxcodes");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxCodeModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<TaxCodeModel>> queryTaxCodesAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/taxcodes");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxCodeModel>>(){}, "24.8.2"));
    }

    public TaxCodeModel updateTaxCode(Integer n, Integer n2, TaxCodeModel taxCodeModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxcodes/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("put", avaTaxPath, taxCodeModel, new TypeToken<TaxCodeModel>(){}, "24.8.2").call();
    }

    public Future<TaxCodeModel> updateTaxCodeAsync(Integer n, Integer n2, TaxCodeModel taxCodeModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxcodes/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, taxCodeModel, new TypeToken<TaxCodeModel>(){}, "24.8.2"));
    }

    public String buildTaxContentFile(PointOfSaleDataRequestModel pointOfSaleDataRequestModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/pointofsaledata/build");
        return this.restCallFactory.createRestCall("post", avaTaxPath, pointOfSaleDataRequestModel, new TypeToken<String>(){}, "24.8.2").call();
    }

    public Future<String> buildTaxContentFileAsync(PointOfSaleDataRequestModel pointOfSaleDataRequestModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/pointofsaledata/build");
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, pointOfSaleDataRequestModel, new TypeToken<String>(){}, "24.8.2"));
    }

    public String buildTaxContentFileForLocation(Integer n, Integer n2, Date date, PointOfSaleFileType pointOfSaleFileType, PointOfSalePartnerId pointOfSalePartnerId, Boolean bl) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/locations/{id}/pointofsaledata");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        avaTaxPath.addQuery("date", date);
        avaTaxPath.addQuery("format", (Object)pointOfSaleFileType);
        avaTaxPath.addQuery("partnerId", (Object)pointOfSalePartnerId);
        avaTaxPath.addQuery("includeJurisCodes", bl);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<String>(){}, "24.8.2").call();
    }

    public Future<String> buildTaxContentFileForLocationAsync(Integer n, Integer n2, Date date, PointOfSaleFileType pointOfSaleFileType, PointOfSalePartnerId pointOfSalePartnerId, Boolean bl) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/locations/{id}/pointofsaledata");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        avaTaxPath.addQuery("date", date);
        avaTaxPath.addQuery("format", (Object)pointOfSaleFileType);
        avaTaxPath.addQuery("partnerId", (Object)pointOfSalePartnerId);
        avaTaxPath.addQuery("includeJurisCodes", bl);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<String>(){}, "24.8.2"));
    }

    public String downloadTaxRatesByZipCode(Date date, String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/taxratesbyzipcode/download/{date}");
        avaTaxPath.applyField("date", date);
        avaTaxPath.addQuery("region", string);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<String>(){}, "24.8.2").call();
    }

    public Future<String> downloadTaxRatesByZipCodeAsync(Date date, String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/taxratesbyzipcode/download/{date}");
        avaTaxPath.applyField("date", date);
        avaTaxPath.addQuery("region", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<String>(){}, "24.8.2"));
    }

    public TaxRateModel taxRatesByAddress(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/taxrates/byaddress");
        avaTaxPath.addQuery("line1", string);
        avaTaxPath.addQuery("line2", string2);
        avaTaxPath.addQuery("line3", string3);
        avaTaxPath.addQuery("city", string4);
        avaTaxPath.addQuery("region", string5);
        avaTaxPath.addQuery("postalCode", string6);
        avaTaxPath.addQuery("country", string7);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<TaxRateModel>(){}, "24.8.2").call();
    }

    public Future<TaxRateModel> taxRatesByAddressAsync(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/taxrates/byaddress");
        avaTaxPath.addQuery("line1", string);
        avaTaxPath.addQuery("line2", string2);
        avaTaxPath.addQuery("line3", string3);
        avaTaxPath.addQuery("city", string4);
        avaTaxPath.addQuery("region", string5);
        avaTaxPath.addQuery("postalCode", string6);
        avaTaxPath.addQuery("country", string7);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<TaxRateModel>(){}, "24.8.2"));
    }

    public TaxRateModel taxRatesByPostalCode(String string, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/taxrates/bypostalcode");
        avaTaxPath.addQuery("country", string);
        avaTaxPath.addQuery("postalCode", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<TaxRateModel>(){}, "24.8.2").call();
    }

    public Future<TaxRateModel> taxRatesByPostalCodeAsync(String string, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/taxrates/bypostalcode");
        avaTaxPath.addQuery("country", string);
        avaTaxPath.addQuery("postalCode", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<TaxRateModel>(){}, "24.8.2"));
    }

    public ArrayList<CountryCoefficientsResponseModel> createCountryCoefficients(CountryCoefficientsRequestEntity countryCoefficientsRequestEntity) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/countryCoefficients");
        return this.restCallFactory.createRestCall("put", avaTaxPath, countryCoefficientsRequestEntity, new TypeToken<ArrayList<CountryCoefficientsResponseModel>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<CountryCoefficientsResponseModel>> createCountryCoefficientsAsync(CountryCoefficientsRequestEntity countryCoefficientsRequestEntity) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/countryCoefficients");
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, countryCoefficientsRequestEntity, new TypeToken<ArrayList<CountryCoefficientsResponseModel>>(){}, "24.8.2"));
    }

    public ArrayList<TaxRuleModel> createTaxRules(Integer n, ArrayList<TaxRuleModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxrules");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<TaxRuleModel>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<TaxRuleModel>> createTaxRulesAsync(Integer n, ArrayList<TaxRuleModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxrules");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<TaxRuleModel>>(){}, "24.8.2"));
    }

    public ArrayList<ErrorDetail> deleteTaxRule(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxrules/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<ErrorDetail>> deleteTaxRuleAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxrules/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2"));
    }

    public TaxRuleModel getTaxRule(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxrules/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<TaxRuleModel>(){}, "24.8.2").call();
    }

    public Future<TaxRuleModel> getTaxRuleAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxrules/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<TaxRuleModel>(){}, "24.8.2"));
    }

    public FetchResult<CountryCoefficientsEntity> listCountryCoefficients(String string, String string2, String string3, Integer n, Integer n2, String string4) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/{country}/CountryCoefficients");
        avaTaxPath.applyField("country", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$include", string3);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string4);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CountryCoefficientsEntity>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<CountryCoefficientsEntity>> listCountryCoefficientsAsync(String string, String string2, String string3, Integer n, Integer n2, String string4) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/{country}/CountryCoefficients");
        avaTaxPath.applyField("country", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$include", string3);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string4);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CountryCoefficientsEntity>>(){}, "24.8.2"));
    }

    public FetchResult<TaxRuleModel> listTaxRules(Integer n, String string, String string2, Integer n2, Integer n3, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxrules");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxRuleModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<TaxRuleModel>> listTaxRulesAsync(Integer n, String string, String string2, Integer n2, Integer n3, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxrules");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxRuleModel>>(){}, "24.8.2"));
    }

    public FetchResult<TaxRuleModel> queryTaxRules(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/taxrules");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxRuleModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<TaxRuleModel>> queryTaxRulesAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/taxrules");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TaxRuleModel>>(){}, "24.8.2"));
    }

    public TaxRuleModel updateTaxRule(Integer n, Integer n2, TaxRuleModel taxRuleModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxrules/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("put", avaTaxPath, taxRuleModel, new TypeToken<TaxRuleModel>(){}, "24.8.2").call();
    }

    public Future<TaxRuleModel> updateTaxRuleAsync(Integer n, Integer n2, TaxRuleModel taxRuleModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/taxrules/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, taxRuleModel, new TypeToken<TaxRuleModel>(){}, "24.8.2"));
    }

    public TransactionModel addLines(String string, AddTransactionLineModel addTransactionLineModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/transactions/lines/add");
        avaTaxPath.addQuery("$include", string);
        return this.restCallFactory.createRestCall("post", avaTaxPath, addTransactionLineModel, new TypeToken<TransactionModel>(){}, "24.8.2").call();
    }

    public Future<TransactionModel> addLinesAsync(String string, AddTransactionLineModel addTransactionLineModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/transactions/lines/add");
        avaTaxPath.addQuery("$include", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, addTransactionLineModel, new TypeToken<TransactionModel>(){}, "24.8.2"));
    }

    public TransactionModel adjustTransaction(String string, String string2, DocumentType documentType, String string3, AdjustTransactionModel adjustTransactionModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/adjust");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", (Object)documentType);
        avaTaxPath.addQuery("$include", string3);
        return this.restCallFactory.createRestCall("post", avaTaxPath, adjustTransactionModel, new TypeToken<TransactionModel>(){}, "24.8.2").call();
    }

    public Future<TransactionModel> adjustTransactionAsync(String string, String string2, DocumentType documentType, String string3, AdjustTransactionModel adjustTransactionModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/adjust");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", (Object)documentType);
        avaTaxPath.addQuery("$include", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, adjustTransactionModel, new TypeToken<TransactionModel>(){}, "24.8.2"));
    }

    public AuditTransactionModel auditTransaction(String string, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/audit");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<AuditTransactionModel>(){}, "24.8.2").call();
    }

    public Future<AuditTransactionModel> auditTransactionAsync(String string, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/audit");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<AuditTransactionModel>(){}, "24.8.2"));
    }

    public AuditTransactionModel auditTransactionWithType(String string, String string2, DocumentType documentType) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/types/{documentType}/audit");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.applyField("documentType", (Object)documentType);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<AuditTransactionModel>(){}, "24.8.2").call();
    }

    public Future<AuditTransactionModel> auditTransactionWithTypeAsync(String string, String string2, DocumentType documentType) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/types/{documentType}/audit");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.applyField("documentType", (Object)documentType);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<AuditTransactionModel>(){}, "24.8.2"));
    }

    public BulkLockTransactionResult bulkLockTransaction(BulkLockTransactionModel bulkLockTransactionModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/lock");
        return this.restCallFactory.createRestCall("post", avaTaxPath, bulkLockTransactionModel, new TypeToken<BulkLockTransactionResult>(){}, "24.8.2").call();
    }

    public Future<BulkLockTransactionResult> bulkLockTransactionAsync(BulkLockTransactionModel bulkLockTransactionModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/lock");
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, bulkLockTransactionModel, new TypeToken<BulkLockTransactionResult>(){}, "24.8.2"));
    }

    public TransactionModel changeTransactionCode(String string, String string2, DocumentType documentType, String string3, ChangeTransactionCodeModel changeTransactionCodeModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/changecode");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", (Object)documentType);
        avaTaxPath.addQuery("$include", string3);
        return this.restCallFactory.createRestCall("post", avaTaxPath, changeTransactionCodeModel, new TypeToken<TransactionModel>(){}, "24.8.2").call();
    }

    public Future<TransactionModel> changeTransactionCodeAsync(String string, String string2, DocumentType documentType, String string3, ChangeTransactionCodeModel changeTransactionCodeModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/changecode");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", (Object)documentType);
        avaTaxPath.addQuery("$include", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, changeTransactionCodeModel, new TypeToken<TransactionModel>(){}, "24.8.2"));
    }

    public TransactionModel commitTransaction(String string, String string2, DocumentType documentType, String string3, CommitTransactionModel commitTransactionModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/commit");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", (Object)documentType);
        avaTaxPath.addQuery("$include", string3);
        return this.restCallFactory.createRestCall("post", avaTaxPath, commitTransactionModel, new TypeToken<TransactionModel>(){}, "24.8.2").call();
    }

    public Future<TransactionModel> commitTransactionAsync(String string, String string2, DocumentType documentType, String string3, CommitTransactionModel commitTransactionModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/commit");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", (Object)documentType);
        avaTaxPath.addQuery("$include", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, commitTransactionModel, new TypeToken<TransactionModel>(){}, "24.8.2"));
    }

    public TransactionModel createOrAdjustTransaction(String string, CreateOrAdjustTransactionModel createOrAdjustTransactionModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/createoradjust");
        avaTaxPath.addQuery("$include", string);
        return this.restCallFactory.createRestCall("post", avaTaxPath, createOrAdjustTransactionModel, new TypeToken<TransactionModel>(){}, "24.8.2").call();
    }

    public Future<TransactionModel> createOrAdjustTransactionAsync(String string, CreateOrAdjustTransactionModel createOrAdjustTransactionModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/createoradjust");
        avaTaxPath.addQuery("$include", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, createOrAdjustTransactionModel, new TypeToken<TransactionModel>(){}, "24.8.2"));
    }

    public TransactionModel createTransaction(String string, CreateTransactionModel createTransactionModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/create");
        avaTaxPath.addQuery("$include", string);
        return this.restCallFactory.createRestCall("post", avaTaxPath, createTransactionModel, new TypeToken<TransactionModel>(){}, "24.8.2").call();
    }

    public Future<TransactionModel> createTransactionAsync(String string, CreateTransactionModel createTransactionModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/create");
        avaTaxPath.addQuery("$include", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, createTransactionModel, new TypeToken<TransactionModel>(){}, "24.8.2"));
    }

    public TransactionModel deleteLines(String string, RemoveTransactionLineModel removeTransactionLineModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/transactions/lines/delete");
        avaTaxPath.addQuery("$include", string);
        return this.restCallFactory.createRestCall("post", avaTaxPath, removeTransactionLineModel, new TypeToken<TransactionModel>(){}, "24.8.2").call();
    }

    public Future<TransactionModel> deleteLinesAsync(String string, RemoveTransactionLineModel removeTransactionLineModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/transactions/lines/delete");
        avaTaxPath.addQuery("$include", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, removeTransactionLineModel, new TypeToken<TransactionModel>(){}, "24.8.2"));
    }

    public VarianceResponseModel getAllVarianceReportByCompanyCode(String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/AllVariance");
        avaTaxPath.applyField("companyCode", string);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<VarianceResponseModel>(){}, "24.8.2").call();
    }

    public Future<VarianceResponseModel> getAllVarianceReportByCompanyCodeAsync(String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/AllVariance");
        avaTaxPath.applyField("companyCode", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<VarianceResponseModel>(){}, "24.8.2"));
    }

    public TransactionModel getTransactionByCode(String string, String string2, DocumentType documentType, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", (Object)documentType);
        avaTaxPath.addQuery("$include", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<TransactionModel>(){}, "24.8.2").call();
    }

    public Future<TransactionModel> getTransactionByCodeAsync(String string, String string2, DocumentType documentType, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", (Object)documentType);
        avaTaxPath.addQuery("$include", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<TransactionModel>(){}, "24.8.2"));
    }

    public TransactionModel getTransactionByCodeAndType(String string, String string2, DocumentType documentType, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/types/{documentType}");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.applyField("documentType", (Object)documentType);
        avaTaxPath.addQuery("$include", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<TransactionModel>(){}, "24.8.2").call();
    }

    public Future<TransactionModel> getTransactionByCodeAndTypeAsync(String string, String string2, DocumentType documentType, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/types/{documentType}");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.applyField("documentType", (Object)documentType);
        avaTaxPath.addQuery("$include", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<TransactionModel>(){}, "24.8.2"));
    }

    public TransactionModel getTransactionById(Long l, String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/{id}");
        avaTaxPath.applyField("id", l);
        avaTaxPath.addQuery("$include", string);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<TransactionModel>(){}, "24.8.2").call();
    }

    public Future<TransactionModel> getTransactionByIdAsync(Long l, String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/transactions/{id}");
        avaTaxPath.applyField("id", l);
        avaTaxPath.addQuery("$include", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<TransactionModel>(){}, "24.8.2"));
    }

    public VarianceResponseModel getVarianceReportByCompanyCodeByTransactionId(String string, String string2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionId}/variance");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionId", string2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<VarianceResponseModel>(){}, "24.8.2").call();
    }

    public Future<VarianceResponseModel> getVarianceReportByCompanyCodeByTransactionIdAsync(String string, String string2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionId}/variance");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionId", string2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<VarianceResponseModel>(){}, "24.8.2"));
    }

    public FetchResult<TransactionModel> listTransactionsByCompany(String string, Integer n, String string2, String string3, Integer n2, Integer n3, String string4) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.addQuery("dataSourceId", n);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$filter", string3);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string4);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TransactionModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<TransactionModel>> listTransactionsByCompanyAsync(String string, Integer n, String string2, String string3, Integer n2, Integer n3, String string4) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.addQuery("dataSourceId", n);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$filter", string3);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string4);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<TransactionModel>>(){}, "24.8.2"));
    }

    public TransactionModel lockTransaction(String string, String string2, DocumentType documentType, String string3, LockTransactionModel lockTransactionModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/lock");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", (Object)documentType);
        avaTaxPath.addQuery("$include", string3);
        return this.restCallFactory.createRestCall("post", avaTaxPath, lockTransactionModel, new TypeToken<TransactionModel>(){}, "24.8.2").call();
    }

    public Future<TransactionModel> lockTransactionAsync(String string, String string2, DocumentType documentType, String string3, LockTransactionModel lockTransactionModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/lock");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", (Object)documentType);
        avaTaxPath.addQuery("$include", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, lockTransactionModel, new TypeToken<TransactionModel>(){}, "24.8.2"));
    }

    public TransactionModel refundTransaction(String string, String string2, String string3, DocumentType documentType, Boolean bl, RefundTransactionModel refundTransactionModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/refund");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("$include", string3);
        avaTaxPath.addQuery("documentType", (Object)documentType);
        avaTaxPath.addQuery("useTaxDateOverride", bl);
        return this.restCallFactory.createRestCall("post", avaTaxPath, refundTransactionModel, new TypeToken<TransactionModel>(){}, "24.8.2").call();
    }

    public Future<TransactionModel> refundTransactionAsync(String string, String string2, String string3, DocumentType documentType, Boolean bl, RefundTransactionModel refundTransactionModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/refund");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("$include", string3);
        avaTaxPath.addQuery("documentType", (Object)documentType);
        avaTaxPath.addQuery("useTaxDateOverride", bl);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, refundTransactionModel, new TypeToken<TransactionModel>(){}, "24.8.2"));
    }

    public TransactionModel settleTransaction(String string, String string2, DocumentType documentType, String string3, SettleTransactionModel settleTransactionModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/settle");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", (Object)documentType);
        avaTaxPath.addQuery("$include", string3);
        return this.restCallFactory.createRestCall("post", avaTaxPath, settleTransactionModel, new TypeToken<TransactionModel>(){}, "24.8.2").call();
    }

    public Future<TransactionModel> settleTransactionAsync(String string, String string2, DocumentType documentType, String string3, SettleTransactionModel settleTransactionModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/settle");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", (Object)documentType);
        avaTaxPath.addQuery("$include", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, settleTransactionModel, new TypeToken<TransactionModel>(){}, "24.8.2"));
    }

    public TransactionModel uncommitTransaction(String string, String string2, DocumentType documentType, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/uncommit");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", (Object)documentType);
        avaTaxPath.addQuery("$include", string3);
        return this.restCallFactory.createRestCall("post", avaTaxPath, null, new TypeToken<TransactionModel>(){}, "24.8.2").call();
    }

    public Future<TransactionModel> uncommitTransactionAsync(String string, String string2, DocumentType documentType, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/uncommit");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", (Object)documentType);
        avaTaxPath.addQuery("$include", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, null, new TypeToken<TransactionModel>(){}, "24.8.2"));
    }

    public TransactionModel unvoidTransaction(String string, String string2, DocumentType documentType, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/unvoid");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", (Object)documentType);
        avaTaxPath.addQuery("$include", string3);
        return this.restCallFactory.createRestCall("post", avaTaxPath, null, new TypeToken<TransactionModel>(){}, "24.8.2").call();
    }

    public Future<TransactionModel> unvoidTransactionAsync(String string, String string2, DocumentType documentType, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/unvoid");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", (Object)documentType);
        avaTaxPath.addQuery("$include", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, null, new TypeToken<TransactionModel>(){}, "24.8.2"));
    }

    public VarianceResponseModel varianceReport(String string, ArrayList<VarianceRequestModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/variance");
        avaTaxPath.applyField("companyCode", string);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<VarianceResponseModel>(){}, "24.8.2").call();
    }

    public Future<VarianceResponseModel> varianceReportAsync(String string, ArrayList<VarianceRequestModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/variance");
        avaTaxPath.applyField("companyCode", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<VarianceResponseModel>(){}, "24.8.2"));
    }

    public TransactionModel verifyTransaction(String string, String string2, DocumentType documentType, String string3, VerifyTransactionModel verifyTransactionModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/verify");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", (Object)documentType);
        avaTaxPath.addQuery("$include", string3);
        return this.restCallFactory.createRestCall("post", avaTaxPath, verifyTransactionModel, new TypeToken<TransactionModel>(){}, "24.8.2").call();
    }

    public Future<TransactionModel> verifyTransactionAsync(String string, String string2, DocumentType documentType, String string3, VerifyTransactionModel verifyTransactionModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/verify");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", (Object)documentType);
        avaTaxPath.addQuery("$include", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, verifyTransactionModel, new TypeToken<TransactionModel>(){}, "24.8.2"));
    }

    public TransactionModel voidTransaction(String string, String string2, DocumentType documentType, String string3, VoidTransactionModel voidTransactionModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/void");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", (Object)documentType);
        avaTaxPath.addQuery("$include", string3);
        return this.restCallFactory.createRestCall("post", avaTaxPath, voidTransactionModel, new TypeToken<TransactionModel>(){}, "24.8.2").call();
    }

    public Future<TransactionModel> voidTransactionAsync(String string, String string2, DocumentType documentType, String string3, VoidTransactionModel voidTransactionModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/void");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", (Object)documentType);
        avaTaxPath.addQuery("$include", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, voidTransactionModel, new TypeToken<TransactionModel>(){}, "24.8.2"));
    }

    public ArrayList<UPCModel> createUPCs(Integer n, ArrayList<UPCModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/upcs");
        avaTaxPath.applyField("companyId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<UPCModel>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<UPCModel>> createUPCsAsync(Integer n, ArrayList<UPCModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/upcs");
        avaTaxPath.applyField("companyId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<UPCModel>>(){}, "24.8.2"));
    }

    public ArrayList<ErrorDetail> deleteUPC(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/upcs/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<ErrorDetail>> deleteUPCAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/upcs/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2"));
    }

    public UPCModel getUPC(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/upcs/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<UPCModel>(){}, "24.8.2").call();
    }

    public Future<UPCModel> getUPCAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/upcs/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<UPCModel>(){}, "24.8.2"));
    }

    public FetchResult<UPCModel> listUPCsByCompany(Integer n, String string, String string2, Integer n2, Integer n3, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/upcs");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<UPCModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<UPCModel>> listUPCsByCompanyAsync(Integer n, String string, String string2, Integer n2, Integer n3, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/upcs");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<UPCModel>>(){}, "24.8.2"));
    }

    public FetchResult<UPCModel> queryUPCs(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/upcs");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<UPCModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<UPCModel>> queryUPCsAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/upcs");
        avaTaxPath.addQuery("$filter", string);
        avaTaxPath.addQuery("$include", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<UPCModel>>(){}, "24.8.2"));
    }

    public UPCModel updateUPC(Integer n, Integer n2, UPCModel uPCModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/upcs/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.restCallFactory.createRestCall("put", avaTaxPath, uPCModel, new TypeToken<UPCModel>(){}, "24.8.2").call();
    }

    public Future<UPCModel> updateUPCAsync(Integer n, Integer n2, UPCModel uPCModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/upcs/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, uPCModel, new TypeToken<UPCModel>(){}, "24.8.2"));
    }

    public ArrayList<ErrorDetail> deleteUserDefinedField(Integer n, Long l) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/userdefinedfields/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", l);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<ErrorDetail>> deleteUserDefinedFieldAsync(Integer n, Long l) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/userdefinedfields/{id}");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.applyField("id", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2"));
    }

    public FetchResult<CompanyUserDefinedFieldModel> listUserDefinedFieldsByCompanyId(Integer n, UserDefinedFieldType userDefinedFieldType, Boolean bl) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/userdefinedfields");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("udfType", (Object)userDefinedFieldType);
        avaTaxPath.addQuery("allowDefaults", bl);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CompanyUserDefinedFieldModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<CompanyUserDefinedFieldModel>> listUserDefinedFieldsByCompanyIdAsync(Integer n, UserDefinedFieldType userDefinedFieldType, Boolean bl) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/userdefinedfields");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("udfType", (Object)userDefinedFieldType);
        avaTaxPath.addQuery("allowDefaults", bl);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<CompanyUserDefinedFieldModel>>(){}, "24.8.2"));
    }

    public CompanyUserDefinedFieldModel updateUserDefinedField(Integer n, Long l, CompanyUserDefinedFieldModel companyUserDefinedFieldModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/userdefinedfields");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("id", l);
        return this.restCallFactory.createRestCall("post", avaTaxPath, companyUserDefinedFieldModel, new TypeToken<CompanyUserDefinedFieldModel>(){}, "24.8.2").call();
    }

    public Future<CompanyUserDefinedFieldModel> updateUserDefinedFieldAsync(Integer n, Long l, CompanyUserDefinedFieldModel companyUserDefinedFieldModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyId}/userdefinedfields");
        avaTaxPath.applyField("companyId", n);
        avaTaxPath.addQuery("id", l);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, companyUserDefinedFieldModel, new TypeToken<CompanyUserDefinedFieldModel>(){}, "24.8.2"));
    }

    public String changePassword(PasswordChangeModel passwordChangeModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/passwords");
        return this.restCallFactory.createRestCall("put", avaTaxPath, passwordChangeModel, new TypeToken<String>(){}, "24.8.2").call();
    }

    public Future<String> changePasswordAsync(PasswordChangeModel passwordChangeModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/passwords");
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, passwordChangeModel, new TypeToken<String>(){}, "24.8.2"));
    }

    public ArrayList<UserModel> createUsers(Integer n, ArrayList<UserModel> arrayList) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/users");
        avaTaxPath.applyField("accountId", n);
        return this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<UserModel>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<UserModel>> createUsersAsync(Integer n, ArrayList<UserModel> arrayList) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/users");
        avaTaxPath.applyField("accountId", n);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, arrayList, new TypeToken<ArrayList<UserModel>>(){}, "24.8.2"));
    }

    public ArrayList<ErrorDetail> deleteUser(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/users/{id}");
        avaTaxPath.applyField("id", n);
        avaTaxPath.applyField("accountId", n2);
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2").call();
    }

    public Future<ArrayList<ErrorDetail>> deleteUserAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/users/{id}");
        avaTaxPath.applyField("id", n);
        avaTaxPath.applyField("accountId", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<ArrayList<ErrorDetail>>(){}, "24.8.2"));
    }

    public UserModel getUser(Integer n, Integer n2, String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/users/{id}");
        avaTaxPath.applyField("id", n);
        avaTaxPath.applyField("accountId", n2);
        avaTaxPath.addQuery("$include", string);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<UserModel>(){}, "24.8.2").call();
    }

    public Future<UserModel> getUserAsync(Integer n, Integer n2, String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/users/{id}");
        avaTaxPath.applyField("id", n);
        avaTaxPath.applyField("accountId", n2);
        avaTaxPath.addQuery("$include", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<UserModel>(){}, "24.8.2"));
    }

    public UserEntitlementModel getUserEntitlements(Integer n, Integer n2) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/users/{id}/entitlements");
        avaTaxPath.applyField("id", n);
        avaTaxPath.applyField("accountId", n2);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<UserEntitlementModel>(){}, "24.8.2").call();
    }

    public Future<UserEntitlementModel> getUserEntitlementsAsync(Integer n, Integer n2) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/users/{id}/entitlements");
        avaTaxPath.applyField("id", n);
        avaTaxPath.applyField("accountId", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<UserEntitlementModel>(){}, "24.8.2"));
    }

    public FetchResult<UserModel> listUsersByAccount(Integer n, String string, String string2, Integer n2, Integer n3, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/users");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.addQuery("$include", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<UserModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<UserModel>> listUsersByAccountAsync(Integer n, String string, String string2, Integer n2, Integer n3, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/users");
        avaTaxPath.applyField("accountId", n);
        avaTaxPath.addQuery("$include", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n2);
        avaTaxPath.addQuery("$skip", n3);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<UserModel>>(){}, "24.8.2"));
    }

    public FetchResult<UserModel> queryUsers(String string, String string2, Integer n, Integer n2, String string3) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/users");
        avaTaxPath.addQuery("$include", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<UserModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<UserModel>> queryUsersAsync(String string, String string2, Integer n, Integer n2, String string3) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/users");
        avaTaxPath.addQuery("$include", string);
        avaTaxPath.addQuery("$filter", string2);
        avaTaxPath.addQuery("$top", n);
        avaTaxPath.addQuery("$skip", n2);
        avaTaxPath.addQuery("$orderBy", string3);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<UserModel>>(){}, "24.8.2"));
    }

    public UserModel updateUser(Integer n, Integer n2, UserModel userModel) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/users/{id}");
        avaTaxPath.applyField("id", n);
        avaTaxPath.applyField("accountId", n2);
        return this.restCallFactory.createRestCall("put", avaTaxPath, userModel, new TypeToken<UserModel>(){}, "24.8.2").call();
    }

    public Future<UserModel> updateUserAsync(Integer n, Integer n2, UserModel userModel) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/accounts/{accountId}/users/{id}");
        avaTaxPath.applyField("id", n);
        avaTaxPath.applyField("accountId", n2);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, userModel, new TypeToken<UserModel>(){}, "24.8.2"));
    }

    public SubscriptionModel getMySubscription(String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/utilities/subscriptions/{serviceTypeId}");
        avaTaxPath.applyField("serviceTypeId", string);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<SubscriptionModel>(){}, "24.8.2").call();
    }

    public Future<SubscriptionModel> getMySubscriptionAsync(String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/utilities/subscriptions/{serviceTypeId}");
        avaTaxPath.applyField("serviceTypeId", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<SubscriptionModel>(){}, "24.8.2"));
    }

    public FetchResult<SubscriptionModel> listMySubscriptions() throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/utilities/subscriptions");
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SubscriptionModel>>(){}, "24.8.2").call();
    }

    public Future<FetchResult<SubscriptionModel>> listMySubscriptionsAsync() {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/utilities/subscriptions");
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<FetchResult<SubscriptionModel>>(){}, "24.8.2"));
    }

    public PingResultModel ping() throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/utilities/ping");
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<PingResultModel>(){}, "24.8.2").call();
    }

    public Future<PingResultModel> pingAsync() {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/utilities/ping");
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<PingResultModel>(){}, "24.8.2"));
    }

    public AgeVerifyResult findAgeVerification(AgeVerifyRequest ageVerifyRequest) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/ageverification/store/identity/find");
        return this.restCallFactory.createRestCall("put", avaTaxPath, ageVerifyRequest, new TypeToken<AgeVerifyResult>(){}, "").call();
    }

    public Future<AgeVerifyResult> findAgeVerificationAsync(AgeVerifyRequest ageVerifyRequest) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/ageverification/store/identity/find");
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, ageVerifyRequest, new TypeToken<AgeVerifyResult>(){}, ""));
    }

    public Void storeAgeVerification(StoreAgeVerifyRequest storeAgeVerifyRequest) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/ageverification/store/identity");
        return this.restCallFactory.createRestCall("put", avaTaxPath, storeAgeVerifyRequest, new TypeToken<Void>(){}, "").call();
    }

    public Future<Void> storeAgeVerificationAsync(StoreAgeVerifyRequest storeAgeVerifyRequest) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/ageverification/store/identity");
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, storeAgeVerifyRequest, new TypeToken<Void>(){}, ""));
    }

    public StoreIfVerifiedResult storeIfVerified(String string, AgeVerifyRequest ageVerifyRequest) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/ageverification/store/identity/storeIfVerified");
        avaTaxPath.addQuery("simulatedFailureCode", string);
        return this.restCallFactory.createRestCall("put", avaTaxPath, ageVerifyRequest, new TypeToken<StoreIfVerifiedResult>(){}, "").call();
    }

    public Future<StoreIfVerifiedResult> storeIfVerifiedAsync(String string, AgeVerifyRequest ageVerifyRequest) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/ageverification/store/identity/storeIfVerified");
        avaTaxPath.addQuery("simulatedFailureCode", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, ageVerifyRequest, new TypeToken<StoreIfVerifiedResult>(){}, ""));
    }

    public AgeVerifyResult verifyAge(String string, AgeVerifyRequest ageVerifyRequest) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/ageverification/verify");
        avaTaxPath.addQuery("simulatedFailureCode", string);
        return this.restCallFactory.createRestCall("post", avaTaxPath, ageVerifyRequest, new TypeToken<AgeVerifyResult>(){}, "").call();
    }

    public Future<AgeVerifyResult> verifyAgeAsync(String string, AgeVerifyRequest ageVerifyRequest) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/ageverification/verify");
        avaTaxPath.addQuery("simulatedFailureCode", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("post", avaTaxPath, ageVerifyRequest, new TypeToken<AgeVerifyResult>(){}, ""));
    }

    public Void deregisterShipment(String string, String string2, String string3, String string4, String string5) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/shipment/registration");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", string3);
        if (string4 != null && !string4.trim().isEmpty()) {
            avaTaxPath.addQuery("api-version", string4);
        }
        if (string5 != null && !string5.trim().isEmpty()) {
            avaTaxPath.addHeader("x-avalara-version", string5);
        }
        return this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<Void>(){}, "").call();
    }

    public Future<Void> deregisterShipmentAsync(String string, String string2, String string3, String string4, String string5) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/shipment/registration");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", string3);
        if (string4 != null && !string4.trim().isEmpty()) {
            avaTaxPath.addQuery("api-version", string4);
        }
        if (string5 != null && !string5.trim().isEmpty()) {
            avaTaxPath.addHeader("x-avalara-version", string5);
        }
        return this.threadPool.submit(this.restCallFactory.createRestCall("delete", avaTaxPath, null, new TypeToken<Void>(){}, ""));
    }

    public Void registerShipment(String string, String string2, String string3, String string4, String string5) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/shipment/registration");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", string3);
        if (string4 != null && !string4.trim().isEmpty()) {
            avaTaxPath.addQuery("api-version", string4);
        }
        if (string5 != null && !string5.trim().isEmpty()) {
            avaTaxPath.addHeader("x-avalara-version", string5);
        }
        return this.restCallFactory.createRestCall("put", avaTaxPath, null, new TypeToken<Void>(){}, "").call();
    }

    public Future<Void> registerShipmentAsync(String string, String string2, String string3, String string4, String string5) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/shipment/registration");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", string3);
        if (string4 != null && !string4.trim().isEmpty()) {
            avaTaxPath.addQuery("api-version", string4);
        }
        if (string5 != null && !string5.trim().isEmpty()) {
            avaTaxPath.addHeader("x-avalara-version", string5);
        }
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, null, new TypeToken<Void>(){}, ""));
    }

    public ShippingVerifyResult registerShipmentIfCompliant(String string, String string2, String string3, String string4, String string5) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/shipment/registerIfCompliant");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", string3);
        if (string4 != null && !string4.trim().isEmpty()) {
            avaTaxPath.addQuery("api-version", string4);
        }
        if (string5 != null && !string5.trim().isEmpty()) {
            avaTaxPath.addHeader("x-avalara-version", string5);
        }
        return this.restCallFactory.createRestCall("put", avaTaxPath, null, new TypeToken<ShippingVerifyResult>(){}, "").call();
    }

    public Future<ShippingVerifyResult> registerShipmentIfCompliantAsync(String string, String string2, String string3, String string4, String string5) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/shipment/registerIfCompliant");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", string3);
        if (string4 != null && !string4.trim().isEmpty()) {
            avaTaxPath.addQuery("api-version", string4);
        }
        if (string5 != null && !string5.trim().isEmpty()) {
            avaTaxPath.addHeader("x-avalara-version", string5);
        }
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, null, new TypeToken<ShippingVerifyResult>(){}, ""));
    }

    public ShippingVerifyResult verifyShipment(String string, String string2, String string3, String string4, String string5) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/shipment/verify");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", string3);
        if (string4 != null && !string4.trim().isEmpty()) {
            avaTaxPath.addQuery("api-version", string4);
        }
        if (string5 != null && !string5.trim().isEmpty()) {
            avaTaxPath.addHeader("x-avalara-version", string5);
        }
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ShippingVerifyResult>(){}, "").call();
    }

    public Future<ShippingVerifyResult> verifyShipmentAsync(String string, String string2, String string3, String string4, String string5) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/companies/{companyCode}/transactions/{transactionCode}/shipment/verify");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("transactionCode", string2);
        avaTaxPath.addQuery("documentType", string3);
        if (string4 != null && !string4.trim().isEmpty()) {
            avaTaxPath.addQuery("api-version", string4);
        }
        if (string5 != null && !string5.trim().isEmpty()) {
            avaTaxPath.addHeader("x-avalara-version", string5);
        }
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<ShippingVerifyResult>(){}, ""));
    }

    public Void enqueueBatchDeregistration(String string, String string2, String string3, String string4) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/asv/companies/{companyCode}/batches/{batchCode}/deregister");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("batchCode", string2);
        if (string3 != null && !string3.trim().isEmpty()) {
            avaTaxPath.addQuery("api-version", string3);
        }
        if (string4 != null && !string4.trim().isEmpty()) {
            avaTaxPath.addHeader("x-avalara-version", string4);
        }
        return this.restCallFactory.createRestCall("put", avaTaxPath, null, new TypeToken<Void>(){}, "").call();
    }

    public Future<Void> enqueueBatchDeregistrationAsync(String string, String string2, String string3, String string4) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/asv/companies/{companyCode}/batches/{batchCode}/deregister");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("batchCode", string2);
        if (string3 != null && !string3.trim().isEmpty()) {
            avaTaxPath.addQuery("api-version", string3);
        }
        if (string4 != null && !string4.trim().isEmpty()) {
            avaTaxPath.addHeader("x-avalara-version", string4);
        }
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, null, new TypeToken<Void>(){}, ""));
    }

    public Void enqueueBatchRegistration(String string, String string2, String string3, String string4) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/asv/companies/{companyCode}/batches/{batchCode}/register");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("batchCode", string2);
        if (string3 != null && !string3.trim().isEmpty()) {
            avaTaxPath.addQuery("api-version", string3);
        }
        if (string4 != null && !string4.trim().isEmpty()) {
            avaTaxPath.addHeader("x-avalara-version", string4);
        }
        return this.restCallFactory.createRestCall("put", avaTaxPath, null, new TypeToken<Void>(){}, "").call();
    }

    public Future<Void> enqueueBatchRegistrationAsync(String string, String string2, String string3, String string4) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/asv/companies/{companyCode}/batches/{batchCode}/register");
        avaTaxPath.applyField("companyCode", string);
        avaTaxPath.applyField("batchCode", string2);
        if (string3 != null && !string3.trim().isEmpty()) {
            avaTaxPath.addQuery("api-version", string3);
        }
        if (string4 != null && !string4.trim().isEmpty()) {
            avaTaxPath.addHeader("x-avalara-version", string4);
        }
        return this.threadPool.submit(this.restCallFactory.createRestCall("put", avaTaxPath, null, new TypeToken<Void>(){}, ""));
    }

    public GetBatchesResult getBatchRegistrationData(String string) throws Exception {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/asv/batches");
        avaTaxPath.addQuery("accountId", string);
        return this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<GetBatchesResult>(){}, "").call();
    }

    public Future<GetBatchesResult> getBatchRegistrationDataAsync(String string) {
        AvaTaxPath avaTaxPath = new AvaTaxPath("/api/v2/asv/batches");
        avaTaxPath.addQuery("accountId", string);
        return this.threadPool.submit(this.restCallFactory.createRestCall("get", avaTaxPath, null, new TypeToken<GetBatchesResult>(){}, ""));
    }
}

