/*
 * Decompiled with CFR 0.152.
 */
package net.avalara.avatax.rest.client;

import java.io.IOException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import net.avalara.avatax.rest.client.AvaTaxConstants;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.util.EntityUtils;

public class LogObject {
    private String httpMethod;
    private String headerCorrelationId;
    private String requestDetails;
    private String responseDetails;
    private URI requestURI;
    private long totalExecutionTime;
    private Integer statusCode;
    private String timestamp;
    private String exceptionMessage;
    private static final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");

    public Integer getStatusCode() {
        return this.statusCode;
    }

    public void populateRequestInfo(HttpRequestBase httpRequestBase) throws IOException {
        this.timestamp = formatter.format(new Date());
        this.httpMethod = httpRequestBase.getMethod();
        this.requestURI = httpRequestBase.getURI();
        if (AvaTaxConstants.shouldLogRequestAndResponse) {
            if ("POST".equalsIgnoreCase(this.httpMethod)) {
                this.requestDetails = EntityUtils.toString((HttpEntity)((HttpPost)httpRequestBase).getEntity());
            } else if ("PUT".equalsIgnoreCase(this.httpMethod)) {
                this.requestDetails = EntityUtils.toString((HttpEntity)((HttpPut)httpRequestBase).getEntity());
            }
        }
    }

    public void populateErrorInfo(String string, CloseableHttpResponse closeableHttpResponse, long l) {
        this.populateTotalExecutionTime(l);
        this.populateStatusCode(closeableHttpResponse);
        this.populateHeaderCorrelationId(closeableHttpResponse);
        this.exceptionMessage = string;
    }

    public void populateResponseInfo(CloseableHttpResponse closeableHttpResponse, String string, long l) {
        this.populateTotalExecutionTime(l);
        this.populateStatusCode(closeableHttpResponse);
        this.populateHeaderCorrelationId(closeableHttpResponse);
        if (AvaTaxConstants.shouldLogRequestAndResponse) {
            this.responseDetails = string;
        }
    }

    private void populateStatusCode(CloseableHttpResponse closeableHttpResponse) {
        if (closeableHttpResponse != null && closeableHttpResponse.getStatusLine() != null) {
            this.statusCode = closeableHttpResponse.getStatusLine().getStatusCode();
        }
    }

    private void populateTotalExecutionTime(long l) {
        long l2 = System.currentTimeMillis();
        this.totalExecutionTime = l2 - l;
    }

    private void populateHeaderCorrelationId(CloseableHttpResponse closeableHttpResponse) {
        if (closeableHttpResponse != null && closeableHttpResponse.getHeaders("x-correlation-id") != null && closeableHttpResponse.getHeaders("x-correlation-id").length > 0) {
            this.headerCorrelationId = closeableHttpResponse.getHeaders("x-correlation-id")[0].getValue();
        }
    }

    static {
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

