/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.data.datum.peer.java;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import net.avh4.data.datum.primitives.Id;
import net.avh4.data.datum.primitives.KnownId;
import net.avh4.data.datum.store.DatumStore;
import org.json.JSONArray;
import org.json.JSONException;

class DocumentInvocationHandler
implements InvocationHandler {
    private final String entityId;
    private final DatumStore store;

    public static <T> T getDocument(DatumStore store, Class<T> documentClass, Id entityId) {
        return (T)Proxy.newProxyInstance(documentClass.getClassLoader(), new Class[]{documentClass}, (InvocationHandler)new DocumentInvocationHandler(store, entityId));
    }

    public DocumentInvocationHandler(DatumStore store, Id entityId) {
        this.entityId = entityId.id();
        this.store = store;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> returnType = method.getReturnType();
        String attribute_name = method.getName();
        if (attribute_name.equals("_id")) {
            return new KnownId(this.entityId);
        }
        if (attribute_name.equals("toString")) {
            return "Document:" + this.entityId;
        }
        if (returnType.isArray()) {
            String[] storeValues = this.jsonToArray(this.store.get(this.entityId, attribute_name));
            return this.stringsToObjects(returnType.getComponentType(), storeValues);
        }
        String storedValue = this.store.get(this.entityId, attribute_name);
        return this.toObject(returnType, storedValue);
    }

    private Object toObject(Class<?> clazz, String storedValue) {
        if (clazz.equals(String.class)) {
            return storedValue;
        }
        return DocumentInvocationHandler.getDocument(this.store, clazz, new KnownId(storedValue));
    }

    private Object stringsToObjects(Class<?> itemClass, String[] values) {
        Object a = Array.newInstance(itemClass, values.length);
        for (int i = 0; i < values.length; ++i) {
            Array.set(a, i, this.toObject(itemClass, values[i]));
        }
        return a;
    }

    private String[] jsonToArray(String json) throws JSONException {
        if (json == null) {
            return new String[0];
        }
        JSONArray jsonArray = new JSONArray(json);
        String[] a = new String[jsonArray.length()];
        for (int i = 0; i < jsonArray.length(); ++i) {
            a[i] = jsonArray.getString(i);
        }
        return a;
    }
}

