/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.data.datum.store;

import fj.F;
import fj.Ord;
import fj.data.TreeMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Map;
import net.avh4.data.datum.primitives.TempId;
import net.avh4.data.datum.store.DatumStore;
import net.avh4.util.IteratorIterable;
import net.avh4.util.TransformingIterator;
import net.avh4.util.data.Index;
import net.avh4.util.data.fj.FjSetIndex;

public class MemoryDatumStore
implements DatumStore,
Serializable {
    private final transient TreeMap<String, String> map;
    private final transient TreeMap<String, Index<String, String>> indexes;
    private final long nextId;

    public MemoryDatumStore() {
        this((TreeMap<String, String>)TreeMap.empty((Ord)Ord.stringOrd), 0L, (TreeMap<String, Index<String, String>>)TreeMap.empty((Ord)Ord.stringOrd));
    }

    protected MemoryDatumStore(TreeMap<String, String> map, long nextId, TreeMap<String, Index<String, String>> indexes) {
        this.map = map;
        this.nextId = nextId;
        this.indexes = indexes;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.map.toMutableMap());
        out.writeLong(this.nextId);
        out.writeObject(this.indexes.toMutableMap());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.setFinalField("map", TreeMap.fromMutableMap((Ord)Ord.stringOrd, (Map)((Map)in.readObject())));
            this.setFinalField("nextId", in.readLong());
            this.setFinalField("indexes", TreeMap.fromMutableMap((Ord)Ord.stringOrd, (Map)((Map)in.readObject())));
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private void setFinalField(String fieldName, Object value) throws NoSuchFieldException, IllegalAccessException {
        Field f = MemoryDatumStore.class.getDeclaredField(fieldName);
        f.setAccessible(true);
        f.set(this, value);
    }

    @Override
    public DatumStore createId(TempId id) {
        long nextId = this.nextId;
        id.mapId("MEM-" + nextId++);
        return new MemoryDatumStore(this.map, nextId, this.indexes);
    }

    @Override
    public DatumStore set(String entityId, String action, String value) {
        TreeMap newMap = this.map.set((Object)(entityId + "-" + action), (Object)value);
        return new MemoryDatumStore((TreeMap<String, String>)newMap, this.nextId, this.indexes);
    }

    @Override
    public String get(String entityId, String action) {
        return (String)this.map.get((Object)(entityId + "-" + action)).toNull();
    }

    @Override
    public Iterable<String> iterate(String action, String startKey, String endKey) {
        Index index = (Index)this.indexes.get((Object)action).orSome(new FjSetIndex());
        Iterator itr = index.iterator(startKey, endKey);
        TransformingIterator<Index.IndexEntry<String, String>, String> itr2 = new TransformingIterator<Index.IndexEntry<String, String>, String>(itr, new F<Index.IndexEntry<String, String>, String>(){

            public String f(Index.IndexEntry<String, String> i) {
                return i.value();
            }
        });
        return new IteratorIterable<String>(itr2);
    }

    @Override
    public DatumStore removeIndex(String action, String value, String entity) {
        Index<String, String> index = (Index<String, String>)this.indexes.get((Object)action).orSome(new FjSetIndex());
        index = index.remove(value, entity);
        TreeMap newIndexes = this.indexes.set((Object)action, index);
        return new MemoryDatumStore(this.map, this.nextId, (TreeMap<String, Index<String, String>>)newIndexes);
    }

    @Override
    public DatumStore addIndex(String action, String value, String entity) {
        Index<String, String> index = (Index<String, String>)this.indexes.get((Object)action).orSome(new FjSetIndex());
        index = index.add(value, entity);
        TreeMap newIndexes = this.indexes.set((Object)action, index);
        return new MemoryDatumStore(this.map, this.nextId, (TreeMap<String, Index<String, String>>)newIndexes);
    }
}

