/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.data.datum.store.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import net.avh4.data.datum.store.service.Serializer;

public class FileSerializer<T extends Serializable>
implements Serializer<T> {
    private final File root;
    private T initialValue;

    public FileSerializer(File root, T initialValue) {
        this.root = root;
        this.initialValue = initialValue;
    }

    @Override
    public void writeToDisk(T value) throws IOException {
        File file = new File(this.root, "FileSerializer.data");
        FileOutputStream fos = new FileOutputStream(file);
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        oos.writeObject(value);
    }

    @Override
    public T readLatest() throws IOException {
        File file = new File(this.root, "FileSerializer.data");
        try {
            FileInputStream fos = new FileInputStream(file);
            ObjectInputStream oos = new ObjectInputStream(fos);
            return (T)((Serializable)oos.readObject());
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Couldn't deserialize " + file, e);
        }
        catch (FileNotFoundException e) {
            return this.initialValue;
        }
    }
}

