/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.data.datum.store.service;

import java.io.IOException;
import java.io.Serializable;
import net.avh4.data.datum.store.service.InMemoryRef;
import net.avh4.data.datum.store.service.Serializer;

public class SynchronouslySerializedRef<T extends Serializable>
extends InMemoryRef<T> {
    private final Serializer<T> serializer;

    public SynchronouslySerializedRef(Serializer<T> serializer) throws IOException {
        super(serializer.readLatest());
        this.serializer = serializer;
    }

    @Override
    public T commit(T newValue) throws IOException {
        this.serializer.writeToDisk(newValue);
        return (T)((Serializable)super.commit(newValue));
    }
}

