/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.data.datum.transact;

import java.io.IOException;
import net.avh4.data.datum.store.DatumStore;
import net.avh4.data.datum.store.service.Ref;
import net.avh4.data.datum.transact.Command;
import net.avh4.data.datum.transact.Transaction;
import net.avh4.data.datum.transact.TransactionException;
import net.avh4.data.datum.transact.Transactor;

public class LocalTransactor
implements Transactor {
    private final Ref<DatumStore> storage;

    public LocalTransactor(Ref<DatumStore> storage) {
        this.storage = storage;
    }

    @Override
    public DatumStore transact(Transaction transaction) throws TransactionException {
        DatumStore store = this.storage.get();
        for (Command command : transaction.commands()) {
            store = command.resolveTempIds(store);
            store = command.execute(store);
        }
        try {
            return this.storage.commit(store);
        }
        catch (IOException e) {
            throw new TransactionException("Could not commit transaction", e);
        }
    }
}

