/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.data.datum.transact;

import fj.data.List;
import net.avh4.data.datum.primitives.Id;
import net.avh4.data.datum.transact.Command;
import net.avh4.data.datum.transact.commands.Add;
import net.avh4.data.datum.transact.commands.AddRef;
import net.avh4.data.datum.transact.commands.Increment;
import net.avh4.data.datum.transact.commands.Remove;
import net.avh4.data.datum.transact.commands.RemoveRef;
import net.avh4.data.datum.transact.commands.Set;
import net.avh4.data.datum.transact.commands.SetRef;

public class Transaction {
    private final List<Command> commands;

    public Transaction() {
        this((List<Command>)List.nil());
    }

    protected Transaction(List<Command> commands) {
        this.commands = commands;
    }

    public Transaction and(Command command) {
        return new Transaction((List<Command>)this.commands.cons((Object)command));
    }

    public Iterable<Command> commands() {
        return this.commands;
    }

    public String toString() {
        return "Transaction" + this.commands.toString();
    }

    public Transaction set(Id entity, String action, String value) {
        return this.and(new Set(entity, action, value));
    }

    public Transaction set(Id entity, String attribute, Id ref) {
        return this.and(new SetRef(entity, attribute, ref));
    }

    public Transaction add(Id entity, String action, String value) {
        return this.and(new Add(entity, action, value));
    }

    public Transaction add(Id entity, String attribute, Id ref) {
        return this.and(new AddRef(entity, attribute, ref));
    }

    public Transaction remove(Id entity, String action, String value) {
        return this.and(new Remove(entity, action, value));
    }

    public Transaction remove(Id entity, String attribute, Id ref) {
        return this.and(new RemoveRef(entity, attribute, ref));
    }

    public Transaction inc(Id entity, String attribute) {
        return this.and(new Increment(entity, attribute));
    }
}

