/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.data.datum.transact.commands;

import net.avh4.data.datum.primitives.Id;
import net.avh4.data.datum.store.DatumStore;
import net.avh4.data.datum.transact.Command;
import net.avh4.data.datum.transact.TransactionException;
import org.json.JSONArray;
import org.json.JSONException;

public class Add
implements Command {
    private final Id entity;
    private final String action;
    private final String value;

    public Add(Id entity, String action, String value) {
        this.entity = entity;
        this.action = action;
        this.value = value;
    }

    @Override
    public DatumStore execute(DatumStore store) throws TransactionException {
        String entityId = this.entity.id();
        String oldValue = store.get(entityId, this.action);
        try {
            JSONArray array = oldValue == null ? new JSONArray() : new JSONArray(oldValue);
            array.put((Object)this.value);
            store = store.set(entityId, this.action, array.toString());
            store = store.addIndex(this.action, this.value, entityId);
        }
        catch (JSONException e) {
            throw new RuntimeException("Current value is not a JSON array: " + oldValue);
        }
        return store;
    }

    @Override
    public DatumStore resolveTempIds(DatumStore store) {
        store = this.entity.resolve(store);
        return store;
    }

    public String toString() {
        return "Add(" + this.entity + ", " + this.action + ", " + this.value + ')';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Add add = (Add)o;
        if (this.action != null ? !this.action.equals(add.action) : add.action != null) {
            return false;
        }
        if (this.entity != null ? !this.entity.equals(add.entity) : add.entity != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(add.value) : add.value != null);
    }

    public int hashCode() {
        int result = this.entity != null ? this.entity.hashCode() : 0;
        result = 31 * result + (this.action != null ? this.action.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }
}

