/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.data.datum.transact.commands;

import net.avh4.data.datum.primitives.Id;
import net.avh4.data.datum.store.DatumStore;
import net.avh4.data.datum.transact.Command;
import net.avh4.data.datum.transact.TransactionException;
import org.json.JSONArray;
import org.json.JSONException;

public class AddRef
implements Command {
    private final Id entity;
    private final String action;
    private final Id ref;

    public AddRef(Id entity, String action, Id ref) {
        this.entity = entity;
        this.action = action;
        this.ref = ref;
    }

    @Override
    public DatumStore execute(DatumStore store) throws TransactionException {
        String entityId = this.entity.id();
        String value = this.ref.id();
        String oldValue = store.get(entityId, this.action);
        try {
            JSONArray array = oldValue == null ? new JSONArray() : new JSONArray(oldValue);
            array.put((Object)value);
            store = store.set(entityId, this.action, array.toString());
            store = store.addIndex(this.action, value, entityId);
        }
        catch (JSONException e) {
            throw new RuntimeException("Current value is not a JSON array: " + oldValue);
        }
        return store;
    }

    @Override
    public DatumStore resolveTempIds(DatumStore store) {
        store = this.entity.resolve(store);
        store = this.ref.resolve(store);
        return store;
    }

    public String toString() {
        return "AddRef(" + this.entity + ", " + this.action + ", " + this.ref + ')';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddRef addRef = (AddRef)o;
        if (this.action != null ? !this.action.equals(addRef.action) : addRef.action != null) {
            return false;
        }
        if (this.entity != null ? !this.entity.equals(addRef.entity) : addRef.entity != null) {
            return false;
        }
        return !(this.ref != null ? !this.ref.equals(addRef.ref) : addRef.ref != null);
    }

    public int hashCode() {
        int result = this.entity != null ? this.entity.hashCode() : 0;
        result = 31 * result + (this.action != null ? this.action.hashCode() : 0);
        result = 31 * result + (this.ref != null ? this.ref.hashCode() : 0);
        return result;
    }
}

