/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.data.datum.transact.commands;

import net.avh4.data.datum.primitives.Id;
import net.avh4.data.datum.store.DatumStore;
import net.avh4.data.datum.transact.Command;
import net.avh4.data.datum.transact.TransactionException;

public class Increment
implements Command {
    private final Id entity;
    private final String action;

    public Increment(Id entity, String action) {
        this.entity = entity;
        this.action = action;
    }

    @Override
    public DatumStore execute(DatumStore store) throws TransactionException {
        int v;
        String entityId = this.entity.id();
        String oldValue = store.get(entityId, this.action);
        int n = v = oldValue == null ? 0 : Integer.parseInt(oldValue);
        if (oldValue != null) {
            store = store.removeIndex(this.action, this.formatIndex(v), entityId);
        }
        store = store.set(entityId, this.action, Integer.toString(++v));
        store = store.addIndex(this.action, this.formatIndex(v), entityId);
        return store;
    }

    @Override
    public DatumStore resolveTempIds(DatumStore store) {
        store = this.entity.resolve(store);
        return store;
    }

    private String formatIndex(int v) {
        return String.format("%010d", v);
    }

    public String toString() {
        return "Increment(" + this.entity + ", " + this.action + ')';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Increment increment = (Increment)o;
        if (this.action != null ? !this.action.equals(increment.action) : increment.action != null) {
            return false;
        }
        return !(this.entity != null ? !this.entity.equals(increment.entity) : increment.entity != null);
    }

    public int hashCode() {
        int result = this.entity != null ? this.entity.hashCode() : 0;
        result = 31 * result + (this.action != null ? this.action.hashCode() : 0);
        return result;
    }
}

