/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.data.datum.transact.commands;

import net.avh4.data.datum.primitives.Id;
import net.avh4.data.datum.store.DatumStore;
import net.avh4.data.datum.transact.Command;
import net.avh4.data.datum.transact.TransactionException;
import org.json.JSONArray;
import org.json.JSONException;

public class Remove
implements Command {
    private final Id entity;
    private final String action;
    private final String value;

    public Remove(Id entity, String action, String value) {
        this.entity = entity;
        this.action = action;
        this.value = value;
    }

    @Override
    public DatumStore execute(DatumStore store) throws TransactionException {
        String entityId = this.entity.id();
        String oldValue = store.get(entityId, this.action);
        if (oldValue == null) {
            throw new TransactionException("Array element does not exist: " + this.value);
        }
        try {
            JSONArray array = new JSONArray(oldValue);
            JSONArray newArray = new JSONArray();
            int found = 0;
            for (int i = 0; i < array.length(); ++i) {
                if (array.getString(i).equals(this.value) && ++found <= 1) continue;
                newArray.put((Object)array.getString(i));
            }
            if (found == 0) {
                throw new TransactionException("Array element does not exist: " + this.value);
            }
            store = newArray.length() == 0 ? store.set(entityId, this.action, null) : store.set(entityId, this.action, newArray.toString());
            if (found <= 1) {
                store = store.removeIndex(this.action, this.value, entityId);
            }
        }
        catch (JSONException e) {
            throw new RuntimeException("Not implemented");
        }
        return store;
    }

    @Override
    public DatumStore resolveTempIds(DatumStore store) {
        store = this.entity.resolve(store);
        return store;
    }

    public String toString() {
        return "Remove(" + this.entity + ", " + this.action + ", " + this.value + ')';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Remove remove = (Remove)o;
        if (this.action != null ? !this.action.equals(remove.action) : remove.action != null) {
            return false;
        }
        if (this.entity != null ? !this.entity.equals(remove.entity) : remove.entity != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(remove.value) : remove.value != null);
    }

    public int hashCode() {
        int result = this.entity != null ? this.entity.hashCode() : 0;
        result = 31 * result + (this.action != null ? this.action.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }
}

