/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.data.datum.transact.commands;

import net.avh4.data.datum.primitives.Id;
import net.avh4.data.datum.store.DatumStore;
import net.avh4.data.datum.transact.Command;
import net.avh4.data.datum.transact.TransactionException;
import org.json.JSONArray;
import org.json.JSONException;

public class RemoveRef
implements Command {
    private final Id entity;
    private final String action;
    private final Id ref;

    public RemoveRef(Id entity, String action, Id ref) {
        this.entity = entity;
        this.action = action;
        this.ref = ref;
    }

    @Override
    public DatumStore execute(DatumStore store) throws TransactionException {
        String entityId = this.entity.id();
        String value = this.ref.id();
        String oldValue = store.get(entityId, this.action);
        if (oldValue == null) {
            throw new TransactionException("Array element does not exist: " + value);
        }
        try {
            JSONArray array = new JSONArray(oldValue);
            JSONArray newArray = new JSONArray();
            int found = 0;
            for (int i = 0; i < array.length(); ++i) {
                if (array.getString(i).equals(value) && ++found <= 1) continue;
                newArray.put((Object)array.getString(i));
            }
            if (found == 0) {
                throw new TransactionException("Array element does not exist: " + value);
            }
            store = newArray.length() == 0 ? store.set(entityId, this.action, null) : store.set(entityId, this.action, newArray.toString());
            if (found <= 1) {
                store = store.removeIndex(this.action, value, entityId);
            }
        }
        catch (JSONException e) {
            throw new RuntimeException("Not implemented");
        }
        return store;
    }

    @Override
    public DatumStore resolveTempIds(DatumStore store) {
        store = this.entity.resolve(store);
        store = this.ref.resolve(store);
        return store;
    }

    public String toString() {
        return "RemoveRef(" + this.entity + ", " + this.action + ", " + this.ref + ')';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoveRef removeRef = (RemoveRef)o;
        if (this.action != null ? !this.action.equals(removeRef.action) : removeRef.action != null) {
            return false;
        }
        if (this.entity != null ? !this.entity.equals(removeRef.entity) : removeRef.entity != null) {
            return false;
        }
        return !(this.ref != null ? !this.ref.equals(removeRef.ref) : removeRef.ref != null);
    }

    public int hashCode() {
        int result = this.entity != null ? this.entity.hashCode() : 0;
        result = 31 * result + (this.action != null ? this.action.hashCode() : 0);
        result = 31 * result + (this.ref != null ? this.ref.hashCode() : 0);
        return result;
    }
}

