/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.data.datum.transact.commands;

import net.avh4.data.datum.primitives.Id;
import net.avh4.data.datum.store.DatumStore;
import net.avh4.data.datum.transact.Command;
import net.avh4.data.datum.transact.TransactionException;

public class Set
implements Command {
    private final Id entity;
    private final String action;
    private final String value;

    public Set(Id entity, String action, String value) {
        this.entity = entity;
        this.action = action;
        this.value = value;
    }

    @Override
    public DatumStore execute(DatumStore store) throws TransactionException {
        String entityId = this.entity.id();
        String oldValue = store.get(entityId, this.action);
        store = store.set(entityId, this.action, this.value);
        if (oldValue != null) {
            store = store.removeIndex(this.action, oldValue, entityId);
        }
        store = store.addIndex(this.action, this.value, entityId);
        return store;
    }

    @Override
    public DatumStore resolveTempIds(DatumStore store) {
        store = this.entity.resolve(store);
        return store;
    }

    public String toString() {
        return "Set(" + this.entity + ", " + this.action + ", " + this.value + ')';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Set set = (Set)o;
        if (this.action != null ? !this.action.equals(set.action) : set.action != null) {
            return false;
        }
        if (this.entity != null ? !this.entity.equals(set.entity) : set.entity != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(set.value) : set.value != null);
    }

    public int hashCode() {
        int result = this.entity != null ? this.entity.hashCode() : 0;
        result = 31 * result + (this.action != null ? this.action.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }
}

