/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.data.datum.transact.commands;

import net.avh4.data.datum.primitives.Id;
import net.avh4.data.datum.store.DatumStore;
import net.avh4.data.datum.transact.Command;
import net.avh4.data.datum.transact.TransactionException;

public class SetRef
implements Command {
    private final Id entity;
    private final String action;
    private final Id ref;

    public SetRef(Id entity, String action, Id ref) {
        this.entity = entity;
        this.action = action;
        this.ref = ref;
    }

    @Override
    public DatumStore execute(DatumStore store) throws TransactionException {
        String entityId = this.entity.id();
        String value = this.ref.id();
        String oldValue = store.get(entityId, this.action);
        store = store.set(entityId, this.action, value);
        if (oldValue != null) {
            store = store.removeIndex(this.action, oldValue, entityId);
        }
        store = store.addIndex(this.action, value, entityId);
        return store;
    }

    @Override
    public DatumStore resolveTempIds(DatumStore store) {
        store = this.entity.resolve(store);
        store = this.ref.resolve(store);
        return store;
    }

    public String toString() {
        return "SetRef(" + this.entity + ", " + this.action + ", " + this.ref + ')';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetRef setRef = (SetRef)o;
        if (this.action != null ? !this.action.equals(setRef.action) : setRef.action != null) {
            return false;
        }
        if (this.entity != null ? !this.entity.equals(setRef.entity) : setRef.entity != null) {
            return false;
        }
        return !(this.ref != null ? !this.ref.equals(setRef.ref) : setRef.ref != null);
    }

    public int hashCode() {
        int result = this.entity != null ? this.entity.hashCode() : 0;
        result = 31 * result + (this.action != null ? this.action.hashCode() : 0);
        result = 31 * result + (this.ref != null ? this.ref.hashCode() : 0);
        return result;
    }
}

