/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.util.data.fj;

import fj.Ord;
import java.io.Serializable;
import net.avh4.util.data.Index;

class FjSetIndexEntry<K extends Comparable<K>, V extends Comparable<V>>
implements Index.IndexEntry<K, V>,
Comparable<FjSetIndexEntry<K, V>>,
Serializable {
    private static final long serialVersionUID = -3671914170699792093L;
    private final K key;
    private final V value;
    private final boolean matchEnd;

    public FjSetIndexEntry(K key, V value) {
        this.key = key;
        this.value = value;
        this.matchEnd = false;
    }

    public FjSetIndexEntry(K key, Void value, boolean matchEnd) {
        this.key = key;
        this.value = null;
        this.matchEnd = matchEnd;
    }

    public static <K extends Comparable<K>, V extends Comparable<V>> Ord<FjSetIndexEntry<K, V>> ord() {
        return Ord.comparableOrd();
    }

    @Override
    public K key() {
        return this.key;
    }

    @Override
    public V value() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FjSetIndexEntry that = (FjSetIndexEntry)o;
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "<" + this.key + ":" + this.value + '>';
    }

    @Override
    public int compareTo(FjSetIndexEntry<K, V> b) {
        if (this.key == null && b.key == null && this.matchEnd == b.matchEnd) {
            return 0;
        }
        if (this.key == null && this.matchEnd) {
            return 1;
        }
        if (b.key == null && b.matchEnd) {
            return -1;
        }
        if (this.key == null) {
            return -1;
        }
        if (b.key == null) {
            return 1;
        }
        if (!this.key.equals(b.key)) {
            return this.key.compareTo(b.key);
        }
        if (this.value != null && b.value != null) {
            return this.value.compareTo(b.value);
        }
        if (this.matchEnd && b.matchEnd) {
            return 0;
        }
        if (this.matchEnd) {
            return 1;
        }
        if (b.matchEnd) {
            return -1;
        }
        if (this.value != null) {
            return 1;
        }
        if (b.value != null) {
            return -1;
        }
        return 0;
    }
}

