/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.test.junit;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.junit.Assert;

class InnerClassInstantiator {
    InnerClassInstantiator() {
    }

    public <T> T instantiate(Class<T> aClass) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        ArrayList<Class<?>> classes = this.getNestedClasses(aClass);
        return (T)this.instantiateNestedClasses(classes);
    }

    private Object instantiateNestedClasses(Iterable<Class<?>> classes) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Object[] lastInstance = new Object[]{};
        for (Class<?> aClass : classes) {
            Constructor<?>[] constructors = aClass.getConstructors();
            Assert.assertEquals((long)1L, (long)constructors.length);
            Object instance = constructors[0].newInstance(lastInstance);
            lastInstance = new Object[]{instance};
        }
        return lastInstance[0];
    }

    private ArrayList<Class<?>> getNestedClasses(Class<?> aClass) {
        ArrayList classes = new ArrayList();
        do {
            classes.add(0, aClass);
        } while ((aClass = aClass.getDeclaringClass()) != null);
        return classes;
    }
}

