/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.test.junit;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.List;
import net.avh4.test.junit.InnerClassInstantiator;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.internal.runners.statements.RunAfters;
import org.junit.internal.runners.statements.RunBefores;
import org.junit.rules.RunRules;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

class InnerRunner
extends BlockJUnit4ClassRunner {
    private static final InnerClassInstantiator instantiator = new InnerClassInstantiator();
    private Object test;

    public InnerRunner(Class<?> testClass) throws InitializationError {
        super(testClass);
    }

    protected void collectInitializationErrors(List<Throwable> errors) {
    }

    protected Object createTest() throws Exception {
        if (this.test == null) {
            Class aClass = this.getTestClass().getJavaClass();
            this.test = instantiator.instantiate(aClass);
        }
        return this.test;
    }

    public Description getDescription() {
        Class javaClass = this.getTestClass().getJavaClass();
        Description superDescription = super.getDescription();
        if (javaClass.getDeclaringClass() == null) {
            return superDescription;
        }
        Description description = Description.createSuiteDescription((String)javaClass.getSimpleName(), (Annotation[])new Annotation[0]);
        for (Description childDescription : superDescription.getChildren()) {
            description.addChild(childDescription);
        }
        return description;
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        super.runChild(method, notifier);
    }

    protected Statement methodBlock(FrameworkMethod method) {
        Statement statement = super.methodBlock(method);
        assert (this.test != null);
        Object instance = this.test;
        while ((instance = InnerRunner.nextParent(instance)) != null) {
            statement = this.withOuterBefores(statement, instance);
            statement = this.withOuterAfters(statement, instance);
            statement = this.withOuterRules(statement, instance);
        }
        return statement;
    }

    private static Object nextParent(Object instance) {
        int parentClasses = -1;
        Class<?> cl = instance.getClass();
        while (cl.getDeclaringClass() != null) {
            ++parentClasses;
            cl = cl.getDeclaringClass();
        }
        if (parentClasses == -1) {
            return null;
        }
        try {
            Field f = instance.getClass().getDeclaredField("this$" + parentClasses);
            f.setAccessible(true);
            return f.get(instance);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)"Should have returned null above (parentClasses == -1)");
        }
    }

    private Statement withOuterRules(Statement statement, Object outerInstance) {
        List fieldRules = new TestClass(outerInstance.getClass()).getAnnotatedFieldValues(outerInstance, Rule.class, TestRule.class);
        if (!fieldRules.isEmpty()) {
            statement = new RunRules(statement, (Iterable)fieldRules, null);
        }
        return statement;
    }

    private Statement withOuterAfters(Statement statement, Object outerInstance) {
        List outerAfters = new TestClass(outerInstance.getClass()).getAnnotatedMethods(After.class);
        if (!outerAfters.isEmpty()) {
            statement = new RunAfters(statement, outerAfters, outerInstance);
        }
        return statement;
    }

    private Statement withOuterBefores(Statement statement, Object outerInstance) {
        List outerBefores = new TestClass(outerInstance.getClass()).getAnnotatedMethods(Before.class);
        if (!outerBefores.isEmpty()) {
            statement = new RunBefores(statement, outerBefores, outerInstance);
        }
        return statement;
    }
}

