/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.util.imagecomparison;

import java.awt.image.BufferedImage;
import net.avh4.util.imagecomparison.ImageComparisonResult;

public class SizeMismatchResult
extends ImageComparisonResult {
    private final int actualWidth;
    private final int actualHeight;
    private final int expectedWidth;
    private final int expectedHeight;

    public SizeMismatchResult(BufferedImage actualImage, int actualWidth, int actualHeight, int expectedWidth, int expectedHeight) {
        super(actualImage);
        this.actualWidth = actualWidth;
        this.actualHeight = actualHeight;
        this.expectedWidth = expectedWidth;
        this.expectedHeight = expectedHeight;
    }

    @Override
    public boolean isEqual() {
        return false;
    }

    @Override
    public String getFailureMessage() {
        return String.format("expected %d x %d, but got %d x %d", this.expectedWidth, this.expectedHeight, this.actualWidth, this.actualHeight);
    }

    public String toString() {
        return "SizeMismatchResult{actualImage=" + this.actualImage + ", actualWidth=" + this.actualWidth + ", actualHeight=" + this.actualHeight + ", expectedWidth=" + this.expectedWidth + ", expectedHeight=" + this.expectedHeight + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SizeMismatchResult that = (SizeMismatchResult)o;
        if (this.actualHeight != that.actualHeight) {
            return false;
        }
        if (this.actualWidth != that.actualWidth) {
            return false;
        }
        if (this.expectedHeight != that.expectedHeight) {
            return false;
        }
        if (this.expectedWidth != that.expectedWidth) {
            return false;
        }
        return !(this.actualImage != null ? !this.actualImage.equals(that.actualImage) : that.actualImage != null);
    }

    public int hashCode() {
        int result = this.actualImage != null ? this.actualImage.hashCode() : 0;
        result = 31 * result + this.actualWidth;
        result = 31 * result + this.actualHeight;
        result = 31 * result + this.expectedWidth;
        result = 31 * result + this.expectedHeight;
        return result;
    }
}

