/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.util.reflection;

import java.lang.reflect.Method;
import org.junit.Test;

public abstract class StackUtils {
    public static Class<?> getCallingClass(Class<?> ... alsoSkippable) {
        StackTraceElement callingStackTraceElement = StackUtils.getCallingStackTraceElement(alsoSkippable);
        return StackUtils.getClass(callingStackTraceElement);
    }

    public static Class<?> getClass(StackTraceElement stackTraceElement) {
        Class<?> sourceClass;
        try {
            sourceClass = Class.forName(stackTraceElement.getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not load resources for test class: " + stackTraceElement.getClassName(), e);
        }
        return sourceClass;
    }

    public static StackTraceElement getCallingStackTraceElement(Class<?> ... alsoSkippable) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        int i = 0;
        while (StackUtils.isSkippable(stackTrace[i], alsoSkippable)) {
            ++i;
        }
        ++i;
        while (StackUtils.isSkippable(stackTrace[i], alsoSkippable)) {
            ++i;
        }
        return stackTrace[i];
    }

    private static boolean isSkippable(StackTraceElement stackTraceElement, Class<?> ... alsoSkippable) {
        if (stackTraceElement.getClassName().equals(Thread.class.getCanonicalName())) {
            return true;
        }
        if (stackTraceElement.getClassName().equals(StackUtils.class.getCanonicalName())) {
            return true;
        }
        for (Class<?> skippable : alsoSkippable) {
            if (!stackTraceElement.getClassName().equals(skippable.getCanonicalName())) continue;
            return true;
        }
        return false;
    }

    public static StackTraceElement getCallingTestMethodStackTraceElement() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        int i = 0;
        while (!StackUtils.isTestMethod(stackTrace[i])) {
            ++i;
        }
        return stackTrace[i];
    }

    private static boolean isTestMethod(StackTraceElement stackTraceElement) {
        Class<?> clazz = StackUtils.getClass(stackTraceElement);
        try {
            Method method = clazz.getMethod(stackTraceElement.getMethodName(), new Class[0]);
            return StackUtils.isJUnit4TestMethod(method) || StackUtils.isJUnit3TestMethod(method);
        }
        catch (SecurityException e) {
            throw new RuntimeException("Couldn't read stack trace information", e);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private static boolean isJUnit4TestMethod(Method method) {
        Test annotation = method.getAnnotation(Test.class);
        return annotation != null;
    }

    private static boolean isJUnit3TestMethod(Method method) {
        return method.getName().startsWith("test");
    }
}

