/*
 * Decompiled with CFR 0.152.
 */
package net.axay.kspigot.ipaddress.badipdetectionservices;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import net.axay.kspigot.ipaddress.BadIPDetectionResult;
import net.axay.kspigot.ipaddress.BadIPDetectionService;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0014\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\fH\u0014J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lnet/axay/kspigot/ipaddress/badipdetectionservices/IPHub;", "Lnet/axay/kspigot/ipaddress/BadIPDetectionService;", "apiKey", "", "ifStrict", "", "(Ljava/lang/String;Z)V", "interpreteResult", "Lnet/axay/kspigot/ipaddress/BadIPDetectionResult;", "result", "Lkotlinx/serialization/json/JsonObject;", "requestHeaders", "", "requestString", "ip", "KSpigot"})
public final class IPHub
extends BadIPDetectionService {
    @NotNull
    private final String apiKey;
    private final boolean ifStrict;

    public IPHub(@NotNull String apiKey, boolean ifStrict) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        super("iphub.info");
        this.apiKey = apiKey;
        this.ifStrict = ifStrict;
    }

    public /* synthetic */ IPHub(String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(string, bl);
    }

    @Override
    @NotNull
    protected String requestString(@NotNull String ip2) {
        Intrinsics.checkNotNullParameter((Object)ip2, (String)"ip");
        return "https://v2.api.iphub.info/ip/" + ip2;
    }

    @Override
    @NotNull
    protected Map<String, String> requestHeaders() {
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"X-Key", (Object)this.apiKey));
    }

    @Override
    @NotNull
    protected BadIPDetectionResult interpreteResult(@NotNull JsonObject result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Object object = (JsonElement)result2.get((Object)"block");
        if (object == null || (object = JsonElementKt.getJsonPrimitive((JsonElement)object)) == null || (object = JsonElementKt.getIntOrNull((JsonPrimitive)object)) == null) {
            return BadIPDetectionResult.ERROR;
        }
        int ifBlock = (Integer)object;
        return ifBlock == 1 || this.ifStrict && ifBlock == 2 ? BadIPDetectionResult.GENERAL_BAD : BadIPDetectionResult.GOOD;
    }
}

