/*
 * Decompiled with CFR 0.152.
 */
package net.axay.kspigot.localization;

import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.axay.kspigot.localization.Localization;
import org.apache.commons.lang.text.StrSubstitutor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000fJK\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000f2.\u0010\u0012\u001a\u0018\u0012\u0014\b\u0001\u0012\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00140\u0013\"\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0014\u00a2\u0006\u0002\u0010\u0015J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\u0005H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00050\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lnet/axay/kspigot/localization/Localization;", "", "()V", "bundles", "", "Ljava/util/Locale;", "Ljava/util/ResourceBundle;", "localeProvider", "Lkotlin/Function1;", "Lorg/bukkit/entity/Player;", "getLocaleProvider", "()Lkotlin/jvm/functions/Function1;", "setLocaleProvider", "(Lkotlin/jvm/functions/Function1;)V", "get", "", "locale", "key", "args", "", "Lkotlin/Pair;", "(Ljava/util/Locale;Ljava/lang/String;[Lkotlin/Pair;)Ljava/lang/String;", "getOrLoadBundle", "KSpigot"})
public final class Localization {
    @NotNull
    public static final Localization INSTANCE = new Localization();
    @NotNull
    private static Function1<? super Player, Locale> localeProvider = localeProvider.1.INSTANCE;
    @NotNull
    private static final Map<Locale, ResourceBundle> bundles = new HashMap();

    private Localization() {
    }

    @NotNull
    public final Function1<Player, Locale> getLocaleProvider() {
        return localeProvider;
    }

    public final void setLocaleProvider(@NotNull Function1<? super Player, Locale> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        localeProvider = function1;
    }

    @NotNull
    public final String get(@NotNull Locale locale, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ResourceBundle resourceBundle = this.getOrLoadBundle(locale);
        String string = resourceBundle != null ? resourceBundle.getString(key) : null;
        if (string == null) {
            throw new MissingResourceException("Messages for locale '" + locale + "' not found", "ResourceBundle", key);
        }
        return string;
    }

    @NotNull
    public final String get(@NotNull Locale locale, @NotNull String key, Pair<String, ? extends Object> ... args) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        String string = StrSubstitutor.replace((Object)this.get(locale, key), (Map)MapsKt.mapOf(Arrays.copyOf(args, args.length)), (String)"{", (String)"}");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"replace(...)");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ResourceBundle getOrLoadBundle(Locale locale) {
        ResourceBundle resourceBundle = bundles.get(locale);
        if (resourceBundle == null) {
            PropertyResourceBundle propertyResourceBundle;
            Closeable closeable = this.getClass().getClassLoader().getResourceAsStream("messages_" + locale + ".properties");
            if (closeable == null) {
                return null;
            }
            closeable = new InputStreamReader((InputStream)closeable, StandardCharsets.UTF_8);
            Throwable throwable = null;
            try {
                InputStreamReader it = (InputStreamReader)closeable;
                boolean bl = false;
                PropertyResourceBundle bundle = new PropertyResourceBundle(it);
                bundles.put(locale, bundle);
                propertyResourceBundle = bundle;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            resourceBundle = propertyResourceBundle;
        }
        return resourceBundle;
    }
}

