/*
 * Decompiled with CFR 0.152.
 */
package net.bican.iplib;

import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.bican.iplib.IPAddress;
import net.bican.iplib.LongDiscreteDomain;

public class AddressIterable
implements Iterable<IPAddress>,
Iterator<IPAddress> {
    private IPAddress current;
    private LongDiscreteDomain<IPAddress> domain;
    private Range<IPAddress> range;

    private AddressIterable() {
    }

    public AddressIterable(Range<IPAddress> range) {
        this();
        this.range = range;
        this.domain = ((IPAddress)range.lowerEndpoint()).getDomain();
        this.current = (IPAddress)range.lowerEndpoint();
        if (range.lowerBoundType() == BoundType.OPEN) {
            this.current = this.domain.next(this.current);
        }
    }

    @Override
    public boolean hasNext() {
        return this.current != null;
    }

    @Override
    public Iterator<IPAddress> iterator() {
        return this;
    }

    @Override
    public IPAddress next() {
        IPAddress result = this.current;
        if (result == null) {
            throw new NoSuchElementException();
        }
        IPAddress newCurrent = this.domain.next(this.current);
        this.current = newCurrent == null || !this.range.contains((Comparable)newCurrent) ? null : newCurrent;
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove not supported on continous ranges");
    }

    public BigInteger size() {
        BigInteger result = this.domain.distance((IPAddress)this.range.lowerEndpoint(), (IPAddress)this.range.upperEndpoint());
        result = result.add(BigInteger.ONE);
        if (this.range.upperBoundType() == BoundType.OPEN) {
            result = result.subtract(BigInteger.ONE);
        }
        if (this.range.lowerBoundType() == BoundType.OPEN) {
            result = result.subtract(BigInteger.ONE);
        }
        return result;
    }
}

