/*
 * Decompiled with CFR 0.152.
 */
package net.bican.iplib;

class BitBuffer {
    private boolean[] bits;

    BitBuffer() {
    }

    private static Boolean isBitSet(byte b, int bit) {
        return (b & 1 << bit) != 0;
    }

    public static BitBuffer wrap(byte[] bytes) {
        BitBuffer result = new BitBuffer();
        result.bits = new boolean[bytes.length * 8];
        int c = 0;
        for (byte b : bytes) {
            for (int i = 7; i >= 0; --i) {
                result.bits[c] = BitBuffer.isBitSet(b, i);
                ++c;
            }
        }
        return result;
    }

    public byte[] array() {
        byte[] result = new byte[this.bits.length / 8];
        int resultPos = 0;
        int bit = 7;
        int b = 0;
        for (boolean value : this.bits) {
            b = (byte)(value ? b | 1 << bit : b & ~(1 << bit));
            if (--bit >= 0) continue;
            result[resultPos] = b;
            bit = 7;
            ++resultPos;
            b = 0;
        }
        return result;
    }

    public boolean get(int pos) {
        return this.bits[pos];
    }

    public void put(byte[] bytes, int prefix) {
        int c = 0;
        for (byte b : bytes) {
            for (int i = 7; i >= 0; --i) {
                if (c >= prefix) {
                    return;
                }
                this.bits[c] = BitBuffer.isBitSet(b, i);
                ++c;
            }
        }
    }

    public int size() {
        return this.bits.length;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        for (boolean b : this.bits) {
            result.append(b ? "1" : "0");
        }
        return result.toString();
    }
}

