/*
 * Decompiled with CFR 0.152.
 */
package net.bican.iplib;

import com.google.common.base.Preconditions;
import com.google.common.net.InetAddresses;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import net.bican.iplib.BitBuffer;
import net.bican.iplib.IPAddress;
import net.bican.iplib.Netmask;

public class CIDR {
    private IPAddress ipAddress = null;
    private int prefix = -1;

    public static CIDR fromNetmask(Netmask netmask) {
        CIDR result = new CIDR();
        result.setIpAddress(netmask.getIpAddress());
        result.setPrefix(netmask.toPrefix());
        return result;
    }

    private CIDR() {
    }

    public CIDR(IPAddress ipAddress, int prefix) {
        this();
        Preconditions.checkNotNull((Object)ipAddress, (Object)"IP address cannot be null");
        Preconditions.checkArgument((prefix <= ipAddress.getDomain().maxPrefix() ? 1 : 0) != 0, (Object)"invalid prefix");
        this.ipAddress = ipAddress;
        this.prefix = prefix;
    }

    public CIDR(String cidrString) {
        this();
        Preconditions.checkNotNull((Object)cidrString, (Object)"String cannot be null");
        String[] parts = cidrString.split("/");
        if (parts.length > 2) {
            throw new IllegalArgumentException();
        }
        int cidrPrefix = 0;
        if (parts.length == 2) {
            cidrPrefix = Integer.parseInt(parts[1]);
        }
        this.ipAddress = IPAddress.getInstance(InetAddresses.forString((String)parts[0]));
        this.prefix = cidrPrefix;
    }

    public IPAddress getFirst() {
        return this.getMasked((byte)0);
    }

    public IPAddress getIpAddress() {
        return this.ipAddress;
    }

    public IPAddress getLast() {
        return this.getMasked((byte)-1);
    }

    private IPAddress getMasked(byte mask) {
        byte[] b = this.ipAddress.getAddressInstance().getAddress();
        byte[] resultB = new byte[b.length];
        Arrays.fill(resultB, mask);
        BitBuffer target = BitBuffer.wrap(resultB);
        target.put(b, this.prefix);
        InetAddress result = null;
        try {
            result = InetAddress.getByAddress(target.array());
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        return IPAddress.getInstance(result);
    }

    public int getPrefix() {
        return this.prefix;
    }

    public void setIpAddress(IPAddress ipAddress) {
        Preconditions.checkNotNull((Object)ipAddress, (Object)"IP address cannot be null");
        this.ipAddress = ipAddress;
    }

    public void setPrefix(int prefix) {
        Preconditions.checkArgument((prefix <= this.ipAddress.getDomain().maxPrefix() ? 1 : 0) != 0, (Object)"invalid prefix");
        this.prefix = prefix;
    }

    public String toString() {
        return this.ipAddress + "/" + this.prefix;
    }
}

