/*
 * Decompiled with CFR 0.152.
 */
package net.bican.iplib;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Arrays;
import net.bican.iplib.IPV4AddressRange;
import net.bican.iplib.IPV6AddressRange;
import net.bican.iplib.LongDiscreteDomain;

public class IPAddress
implements Comparable<IPAddress> {
    private InetAddress address;

    public static IPAddress getInstance(InetAddress addr) {
        return new IPAddress(addr);
    }

    private static int unsignedByteToInt(byte b) {
        return b & 0xFF;
    }

    private IPAddress() {
    }

    IPAddress(InetAddress address) {
        this();
        Preconditions.checkNotNull((Object)address, (Object)"address cannot be null");
        this.address = address;
    }

    @Override
    public int compareTo(IPAddress o) {
        byte[] ba2;
        IPAddress adr1 = this;
        IPAddress adr2 = o;
        byte[] ba1 = adr1.getAddress();
        if (ba1.length < (ba2 = adr2.getAddress()).length) {
            return -1;
        }
        if (ba1.length > ba2.length) {
            return 1;
        }
        for (int i = 0; i < ba1.length; ++i) {
            int b2;
            int b1 = IPAddress.unsignedByteToInt(ba1[i]);
            if (b1 == (b2 = IPAddress.unsignedByteToInt(ba2[i]))) continue;
            if (b1 < b2) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        IPAddress o = (IPAddress)obj;
        return o.getAddress() != null ? Arrays.equals(this.getAddress(), o.getAddress()) : this.getAddress() == null;
    }

    public byte[] getAddress() {
        return this.address.getAddress();
    }

    public InetAddress getAddressInstance() {
        return this.address;
    }

    public String getCanonicalHostName() {
        return this.address.getCanonicalHostName();
    }

    public LongDiscreteDomain<IPAddress> getDomain() {
        if (this.address instanceof Inet4Address) {
            return IPV4AddressRange.addresses();
        }
        return IPV6AddressRange.addresses();
    }

    public String getHostAddress() {
        return this.address.getHostAddress();
    }

    public String getHostName() {
        return this.address.getHostName();
    }

    public int hashCode() {
        return this.address.hashCode();
    }

    public boolean isAnyLocalAddress() {
        return this.address.isAnyLocalAddress();
    }

    public boolean isLinkLocalAddress() {
        return this.address.isLinkLocalAddress();
    }

    public boolean isLoopbackAddress() {
        return this.address.isLoopbackAddress();
    }

    public boolean isMCGlobal() {
        return this.address.isMCGlobal();
    }

    public boolean isMCLinkLocal() {
        return this.address.isMCLinkLocal();
    }

    public boolean isMCNodeLocal() {
        return this.address.isMCNodeLocal();
    }

    public boolean isMCOrgLocal() {
        return this.address.isMCOrgLocal();
    }

    public boolean isMCSiteLocal() {
        return this.address.isMCSiteLocal();
    }

    public boolean isMulticastAddress() {
        return this.address.isMulticastAddress();
    }

    public boolean isReachable(int timeout) throws IOException {
        return this.address.isReachable(timeout);
    }

    public boolean isReachable(NetworkInterface netif, int ttl, int timeout) throws IOException {
        return this.address.isReachable(netif, ttl, timeout);
    }

    public boolean isSiteLocalAddress() {
        return this.address.isSiteLocalAddress();
    }

    public String toString() {
        return this.address.getHostAddress();
    }
}

