/*
 * Decompiled with CFR 0.152.
 */
package net.bican.iplib;

import com.google.common.net.InetAddresses;
import java.math.BigInteger;
import java.net.InetAddress;
import net.bican.iplib.IPAddress;

class IPAddressRangeUtil {
    IPAddressRangeUtil() {
    }

    static BigInteger distance(IPAddress start, IPAddress end) {
        BigInteger bi1 = new BigInteger(1, start.getAddress());
        BigInteger bi2 = new BigInteger(1, end.getAddress());
        return bi2.subtract(bi1);
    }

    static IPAddress next(IPAddress endAddress, IPAddress address) {
        if (address.equals(endAddress)) {
            return null;
        }
        try {
            InetAddress result = InetAddresses.increment((InetAddress)address.getAddressInstance());
            return IPAddress.getInstance(result);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    static IPAddress previous(IPAddress startAddress, IPAddress address) {
        if (address.equals(startAddress)) {
            return null;
        }
        try {
            InetAddress result = InetAddresses.decrement((InetAddress)address.getAddressInstance());
            return IPAddress.getInstance(result);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

