/*
 * Decompiled with CFR 0.152.
 */
package net.bican.iplib;

import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import net.bican.iplib.CIDR;
import net.bican.iplib.IPAddress;
import net.bican.iplib.IPAddressRangeComparator;
import net.bican.iplib.LongDiscreteDomain;
import net.bican.iplib.Netmask;

public class IPAddresses {
    static Range<IPAddress> canonical(Range<IPAddress> range, LongDiscreteDomain<IPAddress> domain) {
        if (range.isEmpty()) {
            return null;
        }
        boolean l = range.lowerBoundType() == BoundType.OPEN;
        boolean u = range.upperBoundType() == BoundType.OPEN;
        IPAddress s = (IPAddress)range.lowerEndpoint();
        IPAddress e = (IPAddress)range.upperEndpoint();
        if (l && u) {
            Range.closed((Comparable)domain.next(s), (Comparable)domain.previous(e));
        } else {
            if (l) {
                return Range.closed((Comparable)domain.next(s), (Comparable)e);
            }
            if (u) {
                return Range.closed((Comparable)s, (Comparable)domain.previous(e));
            }
        }
        return range;
    }

    private static Set<Range<IPAddress>> findOneConnected(Set<Range<IPAddress>> intervals) {
        Range<IPAddress> f1 = null;
        Range<IPAddress> f2 = null;
        for (Range<IPAddress> s : intervals) {
            for (Range<IPAddress> s2 : intervals) {
                Range<IPAddress> sc2;
                Range<IPAddress> sc = IPAddresses.canonical(s, ((IPAddress)s.lowerEndpoint()).getDomain());
                if (!sc.equals(sc2 = IPAddresses.canonical(s, ((IPAddress)s2.lowerEndpoint()).getDomain())) && !s.isConnected(s2)) continue;
                f1 = s;
                f2 = s2;
                break;
            }
            if (f1 == null) continue;
            break;
        }
        if (f1 != null) {
            TreeSet<Range<IPAddress>> newIntervals = new TreeSet<Range<IPAddress>>(IPAddressRangeComparator.getComparator());
            newIntervals.addAll(intervals);
            Range f = f1.span(f2);
            newIntervals.remove(f1);
            newIntervals.remove(f2);
            newIntervals.add((Range<IPAddress>)f);
            return newIntervals;
        }
        return intervals;
    }

    public static Range<IPAddress> fromCIDR(CIDR cidr) {
        Preconditions.checkNotNull((Object)cidr, (Object)"cidr cannot be null");
        Range range = Range.closed((Comparable)cidr.getFirst(), (Comparable)cidr.getLast());
        return range;
    }

    private static Set<Range<IPAddress>> fromConnectedInterval(Range<IPAddress> interval) {
        if (interval.isEmpty()) {
            return null;
        }
        LongDiscreteDomain<IPAddress> domain = ((IPAddress)interval.lowerEndpoint()).getDomain();
        for (int prefix = 0; prefix <= domain.maxPrefix(); ++prefix) {
            Set<Range<IPAddress>> results2;
            Range<IPAddress> otherRange;
            Range<IPAddress> thisRange = IPAddresses.canonical(interval, domain);
            if (thisRange.equals(otherRange = IPAddresses.fromCIDR(new CIDR((IPAddress)thisRange.lowerEndpoint(), prefix)))) {
                TreeSet<Range<IPAddress>> result = new TreeSet<Range<IPAddress>>(IPAddressRangeComparator.getComparator());
                result.add(otherRange);
                return result;
            }
            if (!thisRange.encloses(otherRange)) continue;
            TreeSet<Range<IPAddress>> result = new TreeSet<Range<IPAddress>>(IPAddressRangeComparator.getComparator());
            result.add(otherRange);
            Range newRange1 = Range.closedOpen((Comparable)thisRange.lowerEndpoint(), (Comparable)otherRange.lowerEndpoint());
            Range newRange2 = Range.openClosed((Comparable)otherRange.upperEndpoint(), (Comparable)thisRange.upperEndpoint());
            Set<Range<IPAddress>> results1 = IPAddresses.fromConnectedInterval((Range<IPAddress>)newRange1);
            if (results1 != null) {
                result.addAll(results1);
            }
            if ((results2 = IPAddresses.fromConnectedInterval((Range<IPAddress>)newRange2)) != null) {
                result.addAll(results2);
            }
            return result;
        }
        return new TreeSet<Range<IPAddress>>(Collections.singleton(interval));
    }

    private static Set<Range<IPAddress>> fromConnectedInterval(Set<Range<IPAddress>> intervals) {
        TreeSet<Range<IPAddress>> result = new TreeSet<Range<IPAddress>>(IPAddressRangeComparator.getComparator());
        for (Range<IPAddress> interval : intervals) {
            result.addAll(IPAddresses.fromConnectedInterval(interval));
        }
        return result;
    }

    public static Set<Range<IPAddress>> fromInterval(Range<IPAddress> interval) {
        Preconditions.checkNotNull(interval, (Object)"interval cannot be null");
        TreeSet<Range<IPAddress>> sourceRange = new TreeSet<Range<IPAddress>>(IPAddressRangeComparator.getComparator());
        sourceRange.add(interval);
        return IPAddresses.fromInterval(sourceRange);
    }

    static Set<Range<IPAddress>> fromInterval(Set<Range<IPAddress>> intervals) {
        Preconditions.checkNotNull(intervals, (Object)"intervals cannot be null");
        Preconditions.checkArgument((intervals.size() > 0 ? 1 : 0) != 0, (Object)"intervals cannot be an empty set");
        Set<Range<IPAddress>> intervalsCleaned = IPAddresses.removeEmptyIntervals(intervals);
        if (intervalsCleaned.size() > 1) {
            Set<Range<IPAddress>> newIntervals = IPAddresses.findOneConnected(intervalsCleaned);
            if (intervalsCleaned.size() == newIntervals.size()) {
                return IPAddresses.fromConnectedInterval(intervalsCleaned);
            }
            return IPAddresses.fromInterval(newIntervals);
        }
        return IPAddresses.fromConnectedInterval(intervalsCleaned);
    }

    public static Range<IPAddress> fromNetmask(Netmask netmask) {
        Preconditions.checkNotNull((Object)netmask, (Object)"netmask cannot be null");
        CIDR cidr = CIDR.fromNetmask(netmask);
        return IPAddresses.fromCIDR(cidr);
    }

    private static Set<Range<IPAddress>> removeEmptyIntervals(Set<Range<IPAddress>> intervals) {
        TreeSet<Range<IPAddress>> result = new TreeSet<Range<IPAddress>>(IPAddressRangeComparator.getComparator());
        for (Range<IPAddress> i : intervals) {
            if (i.isEmpty()) continue;
            result.add(i);
        }
        return result;
    }

    public static CIDR toCIDR(Range<IPAddress> range) {
        Preconditions.checkNotNull(range, (Object)"range cannot be null");
        if (range.isEmpty()) {
            return null;
        }
        LongDiscreteDomain<IPAddress> domain = ((IPAddress)range.lowerEndpoint()).getDomain();
        Range<IPAddress> addrRange = IPAddresses.canonical(range, domain);
        for (int prefix = 0; prefix <= domain.maxPrefix(); ++prefix) {
            CIDR cidr = new CIDR((IPAddress)addrRange.lowerEndpoint(), prefix);
            Range<IPAddress> a = IPAddresses.fromCIDR(cidr);
            if (!a.equals(addrRange)) continue;
            return cidr;
        }
        return null;
    }
}

