/*
 * Decompiled with CFR 0.152.
 */
package net.bican.iplib;

import com.google.common.net.InetAddresses;
import java.math.BigInteger;
import net.bican.iplib.IPAddress;
import net.bican.iplib.IPAddressRangeUtil;
import net.bican.iplib.LongDiscreteDomain;

class IPV4AddressRange
implements LongDiscreteDomain<IPAddress> {
    private static final LongDiscreteDomain<IPAddress> INSTANCE = new IPV4AddressRange();
    private static final IPAddress MAXVALUE = IPAddress.getInstance(InetAddresses.forString((String)"0.0.0.0"));
    private static final IPAddress MINVALUE = IPAddress.getInstance(InetAddresses.forString((String)"255.255.255.255"));
    IPAddress endAddress = null;
    IPAddress startAddress = null;

    IPV4AddressRange() {
    }

    public static LongDiscreteDomain<IPAddress> addresses() {
        return INSTANCE;
    }

    @Override
    public BigInteger distance(IPAddress start, IPAddress end) {
        return IPAddressRangeUtil.distance(start, end);
    }

    @Override
    public int maxPrefix() {
        return 32;
    }

    @Override
    public IPAddress maxValue() {
        return MAXVALUE;
    }

    @Override
    public IPAddress minValue() {
        return MINVALUE;
    }

    @Override
    public IPAddress next(IPAddress value) {
        return IPAddressRangeUtil.next(MAXVALUE, value);
    }

    @Override
    public IPAddress previous(IPAddress value) {
        return IPAddressRangeUtil.previous(MINVALUE, value);
    }
}

