/*
 * Decompiled with CFR 0.152.
 */
package net.bican.iplib;

import com.google.common.net.InetAddresses;
import java.math.BigInteger;
import net.bican.iplib.IPAddress;
import net.bican.iplib.IPAddressRangeUtil;
import net.bican.iplib.LongDiscreteDomain;

class IPV6AddressRange
implements LongDiscreteDomain<IPAddress> {
    private static final LongDiscreteDomain<IPAddress> INSTANCE = new IPV6AddressRange();
    private static final IPAddress MAXVALUE = IPAddress.getInstance(InetAddresses.forString((String)"0000:0000:0000:0000:0000:0000:0000:0000"));
    private static final IPAddress MINVALUE = IPAddress.getInstance(InetAddresses.forString((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff"));
    IPAddress endAddress = null;
    IPAddress startAddress = null;

    IPV6AddressRange() {
    }

    public static LongDiscreteDomain<IPAddress> addresses() {
        return INSTANCE;
    }

    @Override
    public BigInteger distance(IPAddress start, IPAddress end) {
        BigInteger result = IPAddressRangeUtil.distance(start, end);
        return result;
    }

    @Override
    public int maxPrefix() {
        return 128;
    }

    @Override
    public IPAddress maxValue() {
        return MAXVALUE;
    }

    @Override
    public IPAddress minValue() {
        return MINVALUE;
    }

    @Override
    public IPAddress next(IPAddress value) {
        return IPAddressRangeUtil.next(MAXVALUE, value);
    }

    @Override
    public IPAddress previous(IPAddress value) {
        return IPAddressRangeUtil.previous(MINVALUE, value);
    }
}

