/*
 * Decompiled with CFR 0.152.
 */
package net.bican.iplib;

import com.google.common.net.InetAddresses;
import net.bican.iplib.BitBuffer;
import net.bican.iplib.IPAddress;

public class Netmask {
    private static final IPAddress DEFAULT_NETMASK = new IPAddress(InetAddresses.forString((String)"255.255.255.255"));
    private IPAddress ipAddress;
    private IPAddress netmask;

    private static IPAddress checkValidNetmask(IPAddress address) {
        BitBuffer bb = BitBuffer.wrap(address.getAddress());
        boolean zeroFound = false;
        for (int i = 0; i < bb.size(); ++i) {
            if (zeroFound && bb.get(i)) {
                throw new IllegalArgumentException("invalid netmask");
            }
            if (bb.get(i)) continue;
            zeroFound = true;
        }
        return address;
    }

    private Netmask() {
    }

    public Netmask(IPAddress ipAddress, IPAddress netmask) {
        this();
        this.ipAddress = ipAddress;
        this.netmask = Netmask.checkValidNetmask(netmask);
    }

    public Netmask(String netmaskString) {
        this();
        String[] parts = netmaskString.split("/");
        if (parts.length > 2) {
            throw new IllegalArgumentException();
        }
        IPAddress nm = DEFAULT_NETMASK;
        if (parts.length == 2) {
            nm = Netmask.checkValidNetmask(new IPAddress(InetAddresses.forString((String)parts[1])));
        }
        this.ipAddress = new IPAddress(InetAddresses.forString((String)parts[0]));
        this.netmask = nm;
    }

    public IPAddress getIpAddress() {
        return this.ipAddress;
    }

    public IPAddress getNetmask() {
        return this.netmask;
    }

    public void setIpAddress(IPAddress ipAddress) {
        this.ipAddress = ipAddress;
    }

    public void setNetmask(IPAddress netmask) {
        this.netmask = Netmask.checkValidNetmask(netmask);
    }

    public int toPrefix() {
        int result = 0;
        BitBuffer bb = BitBuffer.wrap(this.netmask.getAddress());
        for (int i = 0; i < bb.size() && bb.get(i); ++i) {
            ++result;
        }
        return result;
    }
}

