/*
 * Decompiled with CFR 0.152.
 */
package net.bican.iplib.sample;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.net.InetAddresses;
import java.util.Set;
import net.bican.iplib.AddressIterable;
import net.bican.iplib.CIDR;
import net.bican.iplib.IPAddress;
import net.bican.iplib.IPAddresses;
import net.bican.iplib.Netmask;

public class Sample {
    public static void main(String[] args) {
        CIDR cidr1 = new CIDR("10.10.10.0/30");
        Range<IPAddress> range1 = IPAddresses.fromCIDR(cidr1);
        Iterables.all((Iterable)new AddressIterable(range1), (Predicate)new Predicate<IPAddress>(){

            public boolean apply(IPAddress input) {
                System.out.println(input);
                return true;
            }
        });
        Netmask netmask1 = new Netmask("10.10.20.0/255.255.255.0");
        Range<IPAddress> range2 = IPAddresses.fromNetmask(netmask1);
        System.out.println("range contains ip: " + range2.contains((Comparable)IPAddress.getInstance(InetAddresses.forString((String)"10.10.20.20"))));
        System.out.println("range contains ip: " + range2.contains((Comparable)IPAddress.getInstance(InetAddresses.forString((String)"10.10.21.20"))));
        Range interval = Range.closed((Comparable)IPAddress.getInstance(InetAddresses.forString((String)"1.0.0.1")), (Comparable)IPAddress.getInstance(InetAddresses.forString((String)"1.0.2.22")));
        Set<Range<IPAddress>> ips = IPAddresses.fromInterval((Range<IPAddress>)interval);
        for (Range<IPAddress> i : ips) {
            System.out.println(i);
        }
    }
}

