/*
 * Decompiled with CFR 0.152.
 */
package net.binggl.ninja.mongodb;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.mongodb.MongoClient;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import java.util.Arrays;
import java.util.List;
import net.binggl.ninja.mongodb.MongoAuthMechanism;
import ninja.utils.NinjaProperties;
import org.apache.commons.lang3.StringUtils;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.Morphia;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MongoDB {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDB.class);
    private static final int DEFAULT_MONGODB_PORT = 27017;
    private static final String DEFAULT_MORPHIA_PACKAGE = "models";
    private static final String DEFAULT_MONGODB_NAME = "MyMongoDb";
    private static final String DEFAULT_MONGODB_HOST = "localhost";
    private static final String DEFAULT_AUTH_MECHANISM = "SCRAM-SHA-1";
    private static final String MONGODB_HOST = "ninja.mongodb.host";
    private static final String MONGODB_PORT = "ninja.mongodb.port";
    private static final String MONGODB_USER = "ninja.mongodb.user";
    private static final String MONGODB_PASS = "ninja.mongodb.pass";
    private static final String MONGODB_AUTH_MECHANISM = "ninja.mongodb.authMechanism";
    private static final String MONGODB_DBNAME = "ninja.mongodb.dbname";
    private static final String MONGODB_AUTHDB = "ninja.mongodb.authdb";
    private static final String MONGODB_CONNECT_ON_STARTUP = "ninja.mongodb.connectonstart";
    private static final String MORPHIA_PACKAGE = "ninja.morphia.package";
    private static final String MORPHIA_INIT = "ninja.morphia.init";
    private Datastore datastore;
    private Morphia morphia;
    private MongoClient mongoClient = null;
    private NinjaProperties ninjaProperties;

    @Inject
    public MongoDB(NinjaProperties ninjaProperties) {
        this.ninjaProperties = ninjaProperties;
        if (this.ninjaProperties.getBooleanWithDefault(MONGODB_CONNECT_ON_STARTUP, Boolean.valueOf(true)).booleanValue()) {
            this.connect();
        }
        if (this.ninjaProperties.getBooleanWithDefault(MONGODB_CONNECT_ON_STARTUP, Boolean.valueOf(true)).booleanValue() && this.ninjaProperties.getBooleanWithDefault(MORPHIA_INIT, Boolean.valueOf(true)).booleanValue()) {
            this.initMorphia();
        }
    }

    public Datastore getDatastore() {
        return this.datastore;
    }

    public Morphia getMorphia() {
        return this.morphia;
    }

    public MongoClient getMongoClient() {
        return this.mongoClient;
    }

    public void connect() {
        String string = this.ninjaProperties.getWithDefault(MONGODB_HOST, DEFAULT_MONGODB_HOST);
        int n = this.ninjaProperties.getIntegerWithDefault(MONGODB_PORT, Integer.valueOf(27017));
        String string2 = this.ninjaProperties.getWithDefault(MONGODB_USER, null);
        String string3 = this.ninjaProperties.getWithDefault(MONGODB_PASS, null);
        String string4 = this.ninjaProperties.getWithDefault(MONGODB_AUTHDB, DEFAULT_MONGODB_NAME);
        MongoAuthMechanism mongoAuthMechanism = MongoAuthMechanism.SCRAM_SHA_1;
        if (StringUtils.isNotBlank((CharSequence)string2)) {
            mongoAuthMechanism = MongoAuthMechanism.fromString(this.ninjaProperties.getWithDefault(MONGODB_AUTH_MECHANISM, DEFAULT_AUTH_MECHANISM));
            if (mongoAuthMechanism == MongoAuthMechanism.MONGO_X509) {
                LOG.info("Will use MONGO-X509 mechanism to authenticate user.");
                this.mongoClient = this.createClient(mongoAuthMechanism, string, n, string2, string3, string4);
                LOG.info("Successfully created MongoClient @ {}:{} with authentication {}/*******", new Object[]{string, n, string2});
            } else {
                if (StringUtils.isBlank((CharSequence)string3) || StringUtils.isBlank((CharSequence)string4)) {
                    throw new IllegalArgumentException("The parameters authdb and password cannot be blank!");
                }
                this.mongoClient = this.createClient(mongoAuthMechanism, string, n, string2, string3, string4);
                LOG.info("Successfully created MongoClient @ {}:{} with authentication {}/*******", new Object[]{string, n, string2});
            }
        } else {
            this.mongoClient = new MongoClient(string, n);
            LOG.info("Successfully created MongoClient @ {}:{}", (Object)string, (Object)n);
        }
    }

    public void disconnect() {
        Preconditions.checkNotNull((Object)this.mongoClient, (Object)"MongoClient was not initialized!");
        this.mongoClient.close();
    }

    public void initMorphia() {
        Preconditions.checkNotNull((Object)this.mongoClient, (Object)"MongoClient was not initialized!");
        String string = this.ninjaProperties.getWithDefault(MORPHIA_PACKAGE, DEFAULT_MORPHIA_PACKAGE);
        String string2 = this.ninjaProperties.getWithDefault(MONGODB_DBNAME, DEFAULT_MONGODB_NAME);
        this.morphia = new Morphia().mapPackage(string);
        this.datastore = this.morphia.createDatastore(this.mongoClient, string2);
        LOG.info("Mapped Morphia models of package '" + string + "' and created Morphia Datastore to database '" + string2 + "'");
    }

    private MongoClient createClient(MongoAuthMechanism mongoAuthMechanism, String string, int n, String string2, String string3, String string4) {
        MongoClient mongoClient = null;
        MongoCredential mongoCredential = null;
        switch (mongoAuthMechanism) {
            case SCRAM_SHA_1: {
                mongoCredential = MongoCredential.createScramSha1Credential((String)string2, (String)string4, (char[])string3.toCharArray());
                break;
            }
            case MONGODB_CR: {
                mongoCredential = MongoCredential.createMongoCRCredential((String)string2, (String)string4, (char[])string3.toCharArray());
                break;
            }
            case MONGO_X509: {
                mongoCredential = MongoCredential.createMongoX509Credential((String)string2);
            }
        }
        mongoClient = new MongoClient(new ServerAddress(string, n), Arrays.asList(mongoCredential));
        return mongoClient;
    }

    public void ensureIndexes(boolean bl) {
        this.datastore.ensureIndexes(bl);
    }

    public void ensureCaps() {
        this.datastore.ensureCaps();
    }

    public <T> T findById(Object object, Class<T> clazz) {
        Preconditions.checkNotNull(clazz, (Object)"Tryed to find an object by id, but given class is null");
        Preconditions.checkNotNull((Object)object, (Object)"Tryed to find an object by id, but given id is null");
        return (T)this.datastore.get(clazz, object instanceof ObjectId ? object : new ObjectId(String.valueOf(object)));
    }

    public <T> List<T> findAll(Class<T> clazz) {
        Preconditions.checkNotNull(clazz, (Object)"Tryed to get all morphia objects of a given object, but given object is null");
        return this.datastore.find(clazz).asList();
    }

    public <T> long countAll(Class<T> clazz) {
        Preconditions.checkNotNull(clazz, (Object)"Tryed to count all a morphia objects of a given object, but given object is null");
        return this.datastore.find(clazz).countAll();
    }

    public void save(Object object) {
        Preconditions.checkNotNull((Object)object, (Object)"Tryed to save a morphia object, but a given object is null");
        this.datastore.save(object);
    }

    public void delete(Object object) {
        Preconditions.checkNotNull((Object)object, (Object)"Tryed to delete a morphia object, but given object is null");
        this.datastore.delete(object);
    }

    public <T> void deleteAll(Class<T> clazz) {
        Preconditions.checkNotNull(clazz, (Object)"Tryed to delete list of mapped morphia objects, but given class is null");
        this.datastore.delete(this.datastore.createQuery(clazz));
    }

    public void dropDatabase() {
        this.datastore.getDB().dropDatabase();
    }
}

