/*
 * Decompiled with CFR 0.152.
 */
package net.biville.florent.sproccompiler.export;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.biville.florent.sproccompiler.export.DsvGroupingStrategy;
import net.biville.florent.sproccompiler.export.DsvSplitStrategy;

public class DsvConfiguration {
    public static final String DOCUMENTATION_ROOT_PATH = "GeneratedDocumentationPath";
    private static final String DOCUMENTATION_FIELD_DELIMITER = "Documentation.FieldDelimiter";
    private static final String DOCUMENTATION_DELIMITED_FIRST_FIELD = "Documentation.DelimitedFirstField";
    private static final String DOCUMENTATION_QUOTED_FIELDS = "Documentation.QuotedFields";
    private static final String DOCUMENTATION_EXPORTED_HEADERS = "Documentation.ExportedHeaders";
    private static final String DOCUMENTATION_EXPORT_GROUPING = "Documentation.ExportGrouping";
    private static final String DOCUMENTATION_EXPORT_SPLIT = "Documentation.ExportSplit";
    private final Optional<Path> rootPath;
    private final String fieldDelimiter;
    private final String rawHeaders;
    private final EnumSet<DsvGroupingStrategy> groupingStrategy;
    private final DsvSplitStrategy splitStrategy;
    private final boolean delimitedFirstField;
    private final boolean quotedFields;

    public DsvConfiguration(Map<String, String> actualOptions) {
        this.rootPath = Optional.ofNullable(actualOptions.getOrDefault(DOCUMENTATION_ROOT_PATH, null)).map(x$0 -> Paths.get(x$0, new String[0]));
        this.fieldDelimiter = actualOptions.getOrDefault(DOCUMENTATION_FIELD_DELIMITER, ",");
        this.delimitedFirstField = Boolean.parseBoolean(actualOptions.getOrDefault(DOCUMENTATION_DELIMITED_FIRST_FIELD, "false"));
        this.quotedFields = Boolean.parseBoolean(actualOptions.getOrDefault(DOCUMENTATION_QUOTED_FIELDS, "true"));
        this.rawHeaders = actualOptions.getOrDefault(DOCUMENTATION_EXPORTED_HEADERS, "*");
        this.groupingStrategy = DsvConfiguration.parseGroupingStrategy(actualOptions.getOrDefault(DOCUMENTATION_EXPORT_GROUPING, "SINGLE").toUpperCase(Locale.ENGLISH), ",");
        this.splitStrategy = DsvSplitStrategy.valueOf(actualOptions.getOrDefault(DOCUMENTATION_EXPORT_SPLIT, "NONE").toUpperCase(Locale.ENGLISH));
    }

    public static Set<String> getSupportedOptions() {
        HashSet<String> options = new HashSet<String>(7);
        options.add(DOCUMENTATION_ROOT_PATH);
        options.add(DOCUMENTATION_EXPORTED_HEADERS);
        options.add(DOCUMENTATION_FIELD_DELIMITER);
        options.add(DOCUMENTATION_QUOTED_FIELDS);
        options.add(DOCUMENTATION_DELIMITED_FIRST_FIELD);
        options.add(DOCUMENTATION_EXPORT_GROUPING);
        options.add(DOCUMENTATION_EXPORT_SPLIT);
        return options;
    }

    private static EnumSet<DsvGroupingStrategy> parseGroupingStrategy(String rawOption, String delimiter) {
        return EnumSet.copyOf(Arrays.stream(rawOption.split(delimiter)).map(String::trim).map(DsvGroupingStrategy::valueOf).collect(Collectors.toList()));
    }

    public Optional<Path> getRootPath() {
        return this.rootPath;
    }

    public String getFieldDelimiter() {
        return this.fieldDelimiter;
    }

    public boolean isFirstFieldDelimited() {
        return this.delimitedFirstField;
    }

    public boolean areFieldsQuoted() {
        return this.quotedFields;
    }

    public String getRawHeaders() {
        return this.rawHeaders;
    }

    public EnumSet<DsvGroupingStrategy> getGroupingStrategies() {
        return this.groupingStrategy;
    }

    public DsvSplitStrategy getSplitStrategy() {
        return this.splitStrategy;
    }
}

